<?PHP
class Sevas_report_access_users_model extends CI_Model 
{
	var $tableName="sevas_report_access_users";
	public function __construct()
	{
		parent::__construct();
	}

	public function getData($id)
	{
		$this->db->where('id',$id);
		$vr=$this->db->get($this->tableName);
		if($vr->num_rows())
			return $vr->row();
		else return 0;
	}

	public function getReportData($access_key,$ashram_id,$sevaType,$items)
	{
		$this->db->where('access_key',$access_key);
		$this->db->where('ashram_id',$ashram_id);
		$this->db->where('seva_type',$sevaType);
		$this->db->where('item_ids_string',$items);
		$this->db->where('status',1);
		$vr=$this->db->get($this->tableName);
		if($vr->num_rows())
			return $vr->row();
		else return 0;
	}

	public function getReportDataByAccessKeyAshramIdSevaType($access_key,$ashram_id,$sevaType)
	{
		$this->db->where('access_key',$access_key);
		$this->db->where('ashram_id',$ashram_id);
		$this->db->where('seva_type',$sevaType);
		$this->db->where('status',1);
		$vr=$this->db->get($this->tableName);
		if($vr->num_rows())
			return $vr->row();
		else return 0;
	}

	public function getReportDataByAccessKey($access_key)
	{
		$this->db->where('access_key',$access_key);
		$this->db->where('status',1);
		$vr=$this->db->get($this->tableName);
		if($vr->num_rows())
			return $vr->row();
		else return 0;
	}

	public function getMaxReportId()
	{
		$this->db->select_max('report_id', 'max');
	    $result = $this->db->get($this->tableName);
	    $row = $result->row_array();
	    $next_id = isset($row['max']) ? ($row['max']+1) : 1;
	    return $next_id;
	}

	public function save($data)
	{
		/*if($this->checkExistUrl($data["ashram_id"],$data["user_id"],$data["seva_type"]) == 1)
		{
			$this->db->where("ashram_id",$data["ashram_id"]);
			$this->db->where("user_id",$data["user_id"]);
			$this->db->update($this->tableName,array("status"=>0,"access_key"=>NULL));
		}*/
		$this->db->insert($this->tableName,$data);
		return $this->db->insert_id();
	}

	public function updateExpireFlag($id)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array("status"=>2));
	}

	public function updateAccessLogs($id,$hits)
	{
		if(!empty($hits) && is_numeric($hits) && $hits >=0)
		{
			$hits = $hits+1;
		}
		else
			$hits = 1;
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array("hits"=>$hits,"last_opened_on"=>date("Y-m-d H:i:s")));
	}

	public function delete($id)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array("status"=>0,"access_key"=>NULL));
	}

	public function checkExistUrl($ashramId,$userId,$sevaType)
	{
		if(is_numeric($ashramId) && $ashramId!='' && is_numeric($userId) && $userId!='')
		{
			$this->db->where("ashram_id",$ashramId);
			$this->db->where('user_id',$userId);
			$this->db->where('seva_type',$sevaType);
			$vr=$this->db->get($this->tableName);
			if($vr->num_rows())
				return 1;
			else return 0;
		}
		else
			return 0;
	}

	public function listAdmin($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}	
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName." as o");

		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if($_POST['wild']=='contains')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nSeva Type:";
		if(isset($_POST['seva_type']) && is_numeric($_POST['seva_type']) && in_array($_POST['seva_type'],array(1,2,3,4)))
		{
			if($_POST['seva_type']==1)
			{
				$query1->where("seva_type",1);
				$preData.=" Poojas";
			}
			else if($_POST['seva_type']==2)
			{
				$query1->where("seva_type",2);
				$preData.=" Donations";
			}
			else if($_POST['seva_type']==4)
			{
				$query1->where("seva_type",4);
				$preData.=" Subscriptions";
			}
			else
			{
				$query1->where("seva_type",3);
				$preData.=" Store";
			}
		}
		else
		{
			$preData.=" All Seva Types";
		}
		$preData.="\nStatus:";
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1,2)))
		{
			if($_POST['status']==1)
			{
				$query1->where("status",1);
				$preData.=" Active";
			}
			else if($_POST['status']==2)
			{
				$query1->where("status",2);
				$preData.=" Expired";
			}
			else if($_POST['status']==0)
			{
				$query1->where("status",0);
				$preData.=" Deleted";
			}
		}
		else
		{
			$preData.=" All Status";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('created_on',$_POST['dir']);
				else
					$query1->order_by('created_on',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","orders/sevas_report_access_users_model",$sql,$this->currentUser,"default",$_POST,"All Grant Access Reports",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('created_on',$dir);
		}
		else
		{
			$query1->order_by('created_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		$ids=array();
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if($row["seva_type"] == 1)
			{
				$rtn['data'][$c]['seva_type'] = "Poojas";
			}
			if($row["seva_type"] == 2)
			{
				$rtn['data'][$c]['seva_type'] = "Donations";
			}
			if($row["seva_type"] == 3)
			{
				$rtn['data'][$c]['seva_type'] = "Store";
			}
			if($row["seva_type"] == 4)
			{
				$rtn['data'][$c]['seva_type'] = "Subscriptions";
			}
			$rtn['data'][$c]['report_url'] = htmlentities($rtn['data'][$c]['report_url']);
			$rtn['data'][$c]['created_on']=date("d M Y",strtotime($rtn['data'][$c]['created_on']));
			$rtn['data'][$c]['report_end_time']=date("d M Y",strtotime($rtn['data'][$c]['report_end_time']));
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Items");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Report Url");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Expiry");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";

			$otype="Poojas";
			if($reportrow->seva_type==2)
				$otype="Donations";
			if($reportrow->seva_type==3)
				$otype="Store";
			if($reportrow->seva_type==4)
				$otype="Subscription";

			$status="Active";
			if($reportrow->status==0)
				$status="Deleted";
			if($reportrow->status==2)
				$status="Expired";

			$ashramData=$this->ashrams_model->ashramData($reportrow->ashram_id);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->user_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$ashramData->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strip_tags($reportrow->item_names_string));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strip_tags($reportrow->report_url));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->report_end_time)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>