<?PHP
class Orders_temp_Model extends CI_Model 
{
    var $tableName="orders_failed";
    var $payment_success_statuses ="";
    var $archivesDb = "";
    var $s_orders_data_table = "";
    var $auth_check = "";
    var $searchAliasNames = [ "email" => "Email ID", "username" => "User ID", "phone" => "Phone", "firstname" => "First Name", "lastname" => "Last Name", "order_number" => "Seva ID", "transaction_id" => "Tx ID", "t.tx" => "Tx ID", "t.note" => "Note", "t.order_id" => "Seva ID", "t.firstname" => "First name", "t.lastname" => "Last name", "t.email" => "Email ID", "t.phone" => "Phone", "t.city" => "City", "t.state" => "State", "o.order_number" => "Seva ID", "o.email" => "Email ID", "o.username" => "User ID", "o.phone" => "Phone", "o.firstname" => "First Name", "o.lastname" => "Last Name" ];
    
    public function __construct()
    {
        parent::__construct();
        $this->archivesDb = $this->load->database("data_archives",true,false);
        $this->auth_check = $this->load->database("sso_auth",true,false);
        $this->payment_success_statuses = array('success','Success','approved','completed','captured','paid','Release Payment');
    }

    public function listAdmin($excel=0)
    {
        $countries=$this->locations_model->getCountries(true);
        if($this->session->userdata("ashramId"))
        {
            $ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
        }   
        $i=0;
        $query1=$this->db;
        if($excel==0)
            $query1->select("count(o.id) as c,sum(o.total_price) as total_sum,currency");

        step1:
        $i++;
        if($i==2 || $excel==1)
        {
            $query1->select("o.*, usr.pan_number as pan_number");
        }
        $query1->where("o.order_number !=",NULL);
        $query1->from($this->tableName." as o");

        if($i==2 || $excel==1)
        {
            $query1->join("users as usr",'usr.id=o.user_id');
        }
        $preData="Ashram: ";
        if($this->session->userdata("ashramId"))
        {
            $query1->where("o.ashram_id",$this->session->userdata("ashramId"));
            $preData.=$ashramData->name;
        }
        else
        {
            $preData.="All Ashrams";
        }
        $preData.="\nSearch Keywords: ";
        
        if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
            in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
        {
            if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
            {
                $preData.=$this->searchAliasNames[$_POST['search_col']];
            }
            $query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
            $preData.=" containing ";
            /* if($_POST['wild']=='contains')
            {
                $query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
                $preData.=" containing ";
            }
            else if($_POST['wild']=='starts')
            {
                $query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'after');
                $preData.=" starting with ";
            }
            else if($_POST['wild']=='ends')
            {
                $query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'before');
                $preData.=" ending with ";
            } */
            $preData.='"'.$_POST['search_text'].'"';
        }

        $preData.="\nSource: ";
        if(isset($_POST['app']) && is_numeric($_POST['app']) && in_array($_POST['app'],array(0,1)))
        {
            $query1->where("o.app",$_POST['app']);
            if($_POST['app']==1)
                $preData.="App";
            else
                $preData.="Website";
        }

        $preData.="\nPayment Status: ";
        if(isset($_POST['payment_status']) && is_numeric($_POST['payment_status']) && in_array($_POST['payment_status'],array(0,1,2)))
        {
            $query1->where("o.payment_status",$_POST['payment_status']);
            if($_POST['payment_status']==1)
                $preData.="Paid";
            else if($_POST['payment_status']==0)
                $preData.="Pending";
            else if($_POST['payment_status']==1)
                $preData.="Partially Paid";
        }

        $preData.="\nPayment Mode: ";
        if(isset($_POST['payment_type']) && is_numeric($_POST['payment_type']) && in_array($_POST['payment_type'],array(0,1)))
        {
            if($_POST['payment_type']==1)
            {
                $query1->where_in("o.payment_alt_mode",array("paypal","payu","razorpay","stripe","authorize.net"));
                $preData.="Online";
            }
            else
            {
                $query1->where("o.payment_alt_mode",'cash');
                $preData.="Offline";
            }
        }

        $preData.="\nPayment Source: ";
        if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
        {
            $query1->where("o.payment_alt_mode",$_POST['payment_mode']);
            if($_POST['payment_mode'] == 'cash')
            {
                $preData.='Offline';
            }
            else
            {
                $preData.=$_POST['payment_mode'];
            }
        }

        $preData.="\nFrom Date: ";
        if(isset($_POST['from_date']) && $_POST['from_date']!='')
        {
            $query1->where("date(o.date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
            $preData.=$_POST['from_date'];
        }
        
        $preData.="\nTo Date: ";
        if(isset($_POST['to_date']) && $_POST['to_date']!='')
        {
            $query1->where("date(o.date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
            $preData.=$_POST['to_date'];
        }

        $preData.="\nCurrency: ";
        if(isset($_POST['currency']) && $_POST['currency']!='')
        {
            $query1->where("o.currency",$_POST['currency']);
            $preData.=strtoupper($_POST['currency']);
        }
        else
        {
            $preData.="All Currencies";
        }
        $preData.="\nCreated By:";
        if(isset($_POST['created_by']) && is_numeric($_POST['created_by']) && in_array($_POST['created_by'],array(0,1,2)))
        {
            if($_POST['created_by']==0)
            {
                $query1->where("o.created_by",0);
                $preData.=" Guest";
            }
            else if($_POST['created_by']==1)
            {
                $query1->where("o.created_by",1);
                $preData.=" Admin";
            }
            else
            {
                $query1->where("o.created_by",2);
                $preData.=" User";
            }
        }
        else
        {
            $preData.=" All";
        }

        $preData.="\nSeva Type:";
        if(isset($_POST['order_type']) && is_numeric($_POST['order_type']) && in_array($_POST['order_type'],array(1,2,3,4)))
        {
            if($_POST['order_type']==1)
            {
                $query1->where("o.order_type",1);
                $preData.=" Poojas";
            }
            else if($_POST['order_type']==2)
            {
                $query1->where("o.order_type",2);
                $preData.=" Donations";
            }
            else if($_POST['order_type']==4)
            {
                $query1->group_start();
                $query1->where("o.order_type",4);
                $query1->or_where("o.subscription_mixed_order",1);
                $query1->group_end();
                $preData.=" Subscriptions";
            }
            else
            {
                $query1->where("o.order_type",3);
                $preData.=" Store";
            }
        }
        else
        {
            $preData.=" All";
        }


        if($excel==1)
        {
            if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
            {
                if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
                    $query1->order_by($_POST['order_by'],$_POST['dir']);
                else
                    $query1->order_by($_POST['order_by'],'desc');
            }
            else
            {
                if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
                    $query1->order_by('date',$_POST['dir']);
                else
                    $query1->order_by('date',"desc");
            }
            $sql=$query1->get_compiled_select();

            if(isset($_POST['pagenum']) && $_POST['pagenum']==13)
            {
                $requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Sevas - Tally report",$preData,$_POST['pagenum']);
            }
            else
            {
                $requestResp=$this->excel_exports_model->makeRequest('default',"model","orders/orders_temp_model",$sql,$this->currentUser,"default",$_POST,"All Failed Sevas",$preData);
            }
            return $requestResp;
        }


        if($i==1)
        {
            $query1->group_by("currency");
            $temp_result = $query1->get()->result();
            $t_total=0;
            foreach ($GLOBALS['currencies'] as $currencyData)
            {
                $t_cur_total[strtolower($currencyData['currency'])]=0;
            }
            foreach ($temp_result as $temp_row)
            {
                $t_total+=$temp_row->c;
                $t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
            }

            $rtn['recordsTotal'] = $t_total;
            $rtn['recordsFiltered'] = $t_total;
            $rtn['total_sum'] = $t_cur_total;
            
            goto step1;
        }

        $dir='desc';

        if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
            $dir=$_POST['order'][0]['dir'];


        $order_by='';
        if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
        {
            $col_num=round(abs($_POST['order'][0]['column']));
            $col_name=$_POST['columns'][$col_num]['name'];
            if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
                $query1->order_by('o.'.$col_name,$dir);
            else
                $query1->order_by('o.date',$dir);
        }
        else
        {
            $query1->order_by('o.date',$dir);
        }

        $start=0;
        $length=10;
        if(isset($_POST['start']) && is_numeric($_POST['start']))
        {
            if(round(abs($_POST['start']))%10==0)
            $start=round(abs($_POST['start']));
        }
        if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
        {
            $length=abs($_POST['length']);
            if(!$length)
                $length=10;
        }
        
        $query1->limit($length,$start);
        $rtn['data']=$query1->get()->result_array();
        /*echo $query1->last_query();
        exit;*/

        $c=0;
        $sno=$start+1;
        $ids=array();
        foreach ($rtn['data'] as $row)
        {
            $rtn['data'][$c]=$row;
            $rtn['data'][$c]['sno']=$sno;
            $rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];
            $rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
            $rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
            $ids[]=$row['id'];
            $sno++;
            $c++;
        }
        return $rtn;
    }

    public function listUser($excel=0)
    {

        if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='')
        {
            $ashramData=$this->ashrams_model->ashramData($_POST['ashram_id']);
        }
        $i=0;
        $query1=$this->db;
        if($excel==0)
        {
            $query1->select("count(id) as c,sum(total_price) as total_sum,currency");
        }

        step1:
        $i++;
        if($i==2)
        {
            $query1->select("id,order_number,order_type,date,user_id,username,total_price,paid,currency,status,payment_status,payment_mode,payment_alt_mode,partial_payments_allowed,
            no_paid_transactions,response_message,ashram_id ");
        }
        if($excel==1)
        {
            $query1->select("id,order_number,subscription_mixed_order,order_type,date,user_id,username,total_price,paid,currency,status,payment_status,payment_mode,payment_alt_mode,partial_payments_allowed,
            no_paid_transactions,response_message");
        }
        $query1->where("user_id",$this->currentUser->id);
        $query1->from($this->tableName);
        $preData="Ashram: ";
        if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='')
        {
            $preData.=$ashramData->name;
        }
        else
        {
            $preData.="All Ashrams";
        }
        $preData.="\nSearch Keywords: ";
        
        if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='')
        {
            if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
            {
                $preData.=$this->searchAliasNames[$_POST['search_col']];
            }
            $query1->like($_POST['search_col'],trim($_POST['search_text']));
            $preData.=" containing ";
           /*  if($_POST['wild']=='contains')
            {
                $query1->like($_POST['search_col'],trim($_POST['search_text']));
                $preData.=" containing ";
            }
            else if($_POST['wild']=='starts')
            {
                $query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
                $preData.=" starting with ";
            }
            else if($_POST['wild']=='ends')
            {
                $query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
                $preData.=" ending with ";
            } */
            $preData.='"'.$_POST['search_text'].'"';
        }

        $preData.="\nFrom Date: ";
        if(isset($_POST['from_date']) && $_POST['from_date']!='')
        {
            $query1->where("date(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
            $preData.=$_POST['from_date'];
        }
        
        $preData.="\nTo Date: ";
        if(isset($_POST['to_date']) && $_POST['to_date']!='')
        {
            $query1->where("date(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
            $preData.=$_POST['to_date'];
        }

        $preData.="\nCurrency: ";
        if(isset($_POST['currency']) && $_POST['currency']!='')
        {
            $query1->where("currency",$_POST['currency']);
            $preData.=strtoupper($_POST['currency']);
        }
        else
        {
            $preData.="All Currencies";
        }

        if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='')
        {
            $query1->where("ashram_id",$_POST['ashram_id']);
        }

        $preData.="\nPayment Source: ";
        if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
        {
            if($_POST['payment_mode'] == "offline")
            {
                $query1->where_in("payment_alt_mode",array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc'));
            }
            else
            {
                $query1->where("payment_alt_mode",$_POST['payment_mode']);
            }
            $preData.=ucfirst($_POST['payment_mode']);
        }

        $preData.="\nPayment Status: ";
        if(isset($_POST['payment_status']) && $_POST['payment_status']!='')
        {
            $query1->where("payment_status",$_POST['payment_status']);

            if($_POST['payment_status']==0)
            {
                $preData.="Pending";
            }
            else if($_POST['payment_status']==1)
            {
                $preData.="Paid";
            }
            else if($_POST['payment_status']==2)
            {
                $preData.="Partially Paid";
            }
        }

        $preData.="\nToken Status:";
        if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
        {
            if($_POST['tokens']==0)
            {
                $query1->where("tokens",0);
                $preData.="Tokens not issued";
            }
            else
            {
                $query1->where("tokens",1);
                $preData.="Tokens issued";
            }
        }
        else
        {
            $preData.=" All Token Status";
        }

        $preData.="\nNo Tx Sevas:";
        if(isset($_POST['no_tx_orders']) && $_POST['no_tx_orders'] != "" && in_array($_POST['no_tx_orders'],array("Yes","No")))
        {
            $query1->where("no_paid_transactions",$_POST['no_tx_orders']);
            $preData.=" No Paid Tx Sevas";
        }
        else
        {
            $preData.=" All Sevas";
        }

        $preData.="\nShipping Status:";
        if(isset($_POST['dispatched']) && is_numeric($_POST['dispatched']) && in_array($_POST['dispatched'],array(0,1)))
        {
            if($_POST['dispatched']==0)
            {
                $query1->where("dispatched",0);
                $preData.="Not dispatched";
            }
            else
            {
                $query1->where("dispatched",1);
                $preData.="Dispatched";
            }
        }

        $preData.="\nSeva Type:";
        if(isset($_POST['order_type']) && is_numeric($_POST['order_type']) && in_array($_POST['order_type'],array(1,2,3,4)))
        {
            if($_POST['order_type']==1)
            {
                $query1->where("order_type",1);
                $preData.=" Poojas";
            }
            else if($_POST['order_type']==2)
            {
                $query1->where("order_type",2);
                $preData.=" Donations";
            }
            else if($_POST['order_type']==4)
            {
                $query1->group_start();
                $query1->where("order_type",4);
                $query1->or_where("subscription_mixed_order",1);
                $query1->group_end();
                $preData.=" Subscriptions";
            }
            else
            {
                $query1->where("order_type",3);
                $preData.=" Store";
            }
        }
        else
        {
            $preData.=" All Seva Types";
        }

        if($excel==1)
        {
            if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
            {
                if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
                    $query1->order_by($_POST['order_by'],$_POST['dir']);
                else
                    $query1->order_by($_POST['order_by'],'desc');
            }
            else
            {
                if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
                    $query1->order_by('date',$_POST['dir']);
                else
                    $query1->order_by('date',"desc");
            }
            $sql=$query1->get_compiled_select();

            $requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_temp_model",$sql,$this->currentUser,"default",$_POST,"My Failed Sevas",$preData);
            return $requestResp;
        }


        if($i==1)
        {
            $query1->group_by("currency");
            $temp_result = $query1->get()->result();
            $t_total=0;
            foreach ($GLOBALS['currencies'] as $currencyData)
            {
                $t_cur_total[strtolower($currencyData['currency'])]=0;
            }
            foreach ($temp_result as $temp_row)
            {
                $t_total+=$temp_row->c;
                $t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
            }

            $rtn['recordsTotal'] = $t_total;
            $rtn['recordsFiltered'] = $t_total;
            $rtn['total_sum'] = $t_cur_total;
            
            goto step1;
        }

        $dir='desc';

        if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
            $dir=$_POST['order'][0]['dir'];


        $order_by='';
        if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
        {
            $col_num=round(abs($_POST['order'][0]['column']));
            $col_name=$_POST['columns'][$col_num]['name'];
            if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
                $query1->order_by($col_name,$dir);
            else
                $query1->order_by('date',$dir);
        }
        else
        {
            $query1->order_by('date',$dir);
        }

        $start=0;
        $length=10;
        if(isset($_POST['start']) && is_numeric($_POST['start']))
        {
            if(round(abs($_POST['start']))%10==0)
            $start=round(abs($_POST['start']));
        }
        if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
        {
            $length=abs($_POST['length']);
            if(!$length)
                $length=10;
        }
        
        $query1->limit($length,$start);
        $rtn['data']=$query1->get()->result_array();

        $c=0;
        $sno=$start+1;
        $ids=array();
        foreach ($rtn['data'] as $row)
        {
            $rtn['data'][$c]=$row;
            $rtn['data'][$c]['sno']=$sno;
            $rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
            $rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
            $ids[]=$row['id'];
            $sno++;
            $c++;
        }

        if(!empty($ids))
        {
            $this->db->select("sum(subscription) as has_subscription,id,order_id");
            $this->db->where_in("order_id",$ids);
            $this->db->from("order_items");
            $this->db->group_by("order_id");
            $oitems=array();
            foreach ($this->db->get()->result() as $key => $oitem)
            {
                $oitems[$oitem->order_id]=$oitem;
            }

            foreach ($rtn['data'] as $key => $row)
            //foreach ($oitems as $key => $oitem)
            {

                if(isset($oitems[$row['id']]) && $oitems[$row['id']]->has_subscription)
                    $rtn['data'][$key]['subscription']=1;
                else 
                    $rtn['data'][$key]['subscription']=0;
            }
        }

        return $rtn;
    }

    public function excelReport($excelData,$objPHPExcel)
    {
        $countries=$this->locations_model->getCountries(true);

        $q=$this->db->query($excelData->query);

        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

        $styleArray = array(
                            'font' => array(
                            'bold' => true
                            )
                        );

        $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

        $objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

        $j=3;
        $pre_data=explode("\n",$excelData->pre_data);
        foreach ($pre_data as $filter)
        {
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
            $j++;
        }

        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

        $requestData=unserialize($excelData->request_data);

        $j=$j+2;

        $alpha="A";
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created By");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Fail Reason");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"App?");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);


        $i=$j+1;
        $sno=1;
        foreach ($q->result() as $reportrow)
        {
            $alpha="A";
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);

            $otype="Poojas";
            if($reportrow->order_type==2)
                $otype="Donations";
            if($reportrow->order_type==3)
                $otype="Store";
            if($reportrow->order_type==4 || $reportrow->subscription_mixed_order==1)
                $otype="Subscription";

            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);

            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);

            $address=$reportrow->address1;
            if($reportrow->address2!='')
                $address.="\n".$reportrow->address2;
            if($reportrow->address3!='')
                $address.="\n".$reportrow->address3;
            $address.="\n".$reportrow->city;
            $address.="\n".$reportrow->state;
            $address.="\n".$reportrow->country;
            if($reportrow->zipcode!='')
            {
                $address.= "\n".$reportrow->zipcode;
            }

            $created_by="Admin";
            if($reportrow->created_by==2)
                $created_by="User";
            if($reportrow->created_by==0)
                $created_by="Guest";
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$created_by);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->response_message);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);

            if($reportrow->app==1)
                $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"Yes");
            else
                $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"No");

            $i++;
            $sno++;
        }
        return $objPHPExcel;
    }

    public function excelReportUser($excelData,$objPHPExcel)
    {
        $q=$this->db->query($excelData->query);

        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

        $styleArray = array(
                            'font' => array(
                            'bold' => true
                            )
                        );

        $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

        $objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

        $j=3;
        $pre_data=explode("\n",$excelData->pre_data);
        foreach ($pre_data as $filter)
        {
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
            $j++;
        }

        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

        $j=$j+2;

        $alpha="A";
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Fail Reason");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $i=$j+1;
        $sno=1;
        foreach ($q->result() as $reportrow)
        {
            $alpha="A";
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->response_message);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

            $otype="Poojas";
            if($reportrow->order_type==2)
                $otype="Donations";
            if($reportrow->order_type==3)
                $otype="Store";
            if($reportrow->order_type==4 || $reportrow->subscription_mixed_order==1)
                $otype="Subscription";
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);

            $i++;
            $sno++;
        }
        return $objPHPExcel;
    }
}
?>