<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MobileNotifications_model extends CI_Model 
{
	var $tableName="notifications";
	var $notification_types = array("liveupdates"=>1,"events"=>2,"speeches"=>3,"calendar"=>4,"poojas"=>5,"donations"=>6);
	function __construct()
	{
        parent::__construct();
    }
	
	public function addNotification($title,$description,$type_id,$service)
	{
		$q = $this->db->insert($this->tableName,
                            array(
								'title' => $title,
								'description' =>$this->general_model->filtertext(trim($description)),
								'type'=>$this->notification_types[$service],
								'type_id'=>$type_id,
								'is_sent'=>0,
								'created_date'=>date("Y:m:d H:i:s"),
							)
							);
			
	}
	public function remove($type_id,$service)
	{
		$this->db->where("type_id",$type_id);
		$this->db->where("type",$this->notification_types[$service]);
		$this->db->delete($this->tableName);
	}

	public function updateSentStatus($id,$onesignal_id){
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array('onesignal_id '=>$onesignal_id,"is_sent"=>1,"notification_date"=>date('Y:m:d H:i:s')));
	}

	public function getNotificationIDBasedOnService($type_id,$service){

		$this->db->select('id,type_id,type,is_sent');
		$this->db->where("type_id",$type_id);
		$this->db->where("type",$this->notification_types[$service]);
		$q = $this->db->get($this->tableName)->row();
		return $q;
	}

	public function getNotificationById($id){

		$this->db->select('*');
		$this->db->where('is_sent',0);
		$this->db->where("id",$id);
		$q = $this->db->get($this->tableName)->row();
		return $q;
	}
}
?>