<?PHP
class Japams_api_model extends CI_Model 
{
	var $tableName="japams";
    function __construct()
    {
        parent::__construct();
        $this->db=$this->load->database("site_services",true,false);
    }
	
    public function getCount()
	{
		return $this->db->get($this->tableName)->num_rows();
	}

	public function getmantraData($id)
	{
		$this->db->where("id",$id);
		$query = $this->db->get($this->tableName);
		return $query->row();
	}

	public function getAllMantras()
	{
		$this->db->select("id,name");
		$this->db->group_start();
            $this->db->group_start();
                $this->db->where("start_date <=",date("Y:m:d"));
                $this->db->where("end_date >=",date("Y:m:d"));
            $this->db->group_end();
            $this->db->or_group_start();
                $this->db->where("start_date",'0000:00:00');
                $this->db->where("end_date",'0000:00:00');
            $this->db->group_end();

            $this->db->or_group_start();
                $this->db->where("start_date <=",date("Y:m:d"));
                $this->db->where("end_date",'0000:00:00');
            $this->db->group_end();

            $this->db->or_group_start();
                $this->db->where("start_date",'0000:00:00');
                $this->db->where("end_date >=",date("Y:m:d"));
            $this->db->group_end();
        $this->db->group_end();
    	$this->db->where("is_user",0);
		$this->db->from($this->tableName);
		$query = $this->db->get();
		if($query->num_rows() > 0)
			return $query->result_array();
		else
			return false;
	}

	public function listAllsummaries($mantra_id = 0)
	{
		$q = $this->db->select("id as all_entries")->from("japam_user")->where("japam_id",$mantra_id)->get()->num_rows();
		
		$q1 = $this->db->select("id as total_records_by_city")->from("japam_user")->where("japam_id",$mantra_id)->group_by("city")->get()->num_rows();

		$q2 = $this->db->select("id as total_records_by_country")->from("japam_user")->where("japam_id",$mantra_id)->group_by("country_id")->get()->num_rows();

		$q3 = $this->db->select("id as total_records_by_date")->from("japam_user")->group_by("DATE_FORMAT(date,'%Y%m%d')")->get()->num_rows();

		$q4 = $this->db->select("id as india_total")->from("japam_user")->where("japam_id",$mantra_id)->where("country_id","IN")->get()->num_rows();

		$q5 = $this->db->select("id as foreign_total")->from("japam_user")->where("japam_id",$mantra_id)->where("country_id!=","IN")->get()->num_rows();

		$data = array();

		$data['all_entries'] 				= $q;
		$data['total_records_by_city'] 		= $q1;
		$data['total_records_by_country'] 	= $q2;
		$data['total_records_by_date'] 		= $q3;
		$data['india_total'] 				= $q4;
		$data['foreign_total'] 				= $q5;

		return $data;
	}

	public function getTotalRecords($mantra_id=0,$limit=0,$offset=0)
	{
		$this->db->select("email,count,phoneno,firstname,middlename,lastname,country_id as country_code,donor_name as performed_by,city,state,user_id as user_id,date as japa_date")->from("japam_user")->where("japam_id",$mantra_id)->order_by("id","desc");
		if(!empty($limit) && ($limit > 0))
			$this->db->limit($limit,$offset);
		$q = $this->db->get();
		if($q->num_rows() > 0)
		{
			$r = $q->result_array();
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getDatabyPhone($phone)
    {
    	$this->db->where("phoneno",$phone);
        $query=$this->db->get($this->tableName);
        if($query->num_rows())
		{
			return $query->row();
        }
        return 0;
    }

	public function phoneCheck($phone)
    {
    	$this->db->where("phone",$phone);
        $query=$this->db->get($this->tableName);
        if($query->num_rows())
		{
			return 1;
        }
        return 0;
    }

	public function getTotalRecordsByCity($mantra_id=0,$limit = 0,$offset = 0)
	{
		$this->db->select("count(id) as submissions,city,country_id as country_code,sum(count) as participants_count")->from("japam_user")->where("japam_id",$mantra_id)->order_by("id","desc");
		
		if(!empty($limit) && ($limit > 0))
			$this->db->limit($limit,$offset);
		
		$q = $this->db->group_by("city")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getTotalRecordsByCountry($mantra_id,$limit = 0,$offset = 0)
	{
		$this->db->select("count(id) as submissions,country_id as country_code,sum(count) as participants_count")->from("japam_user")->where("japam_id",$mantra_id);
		if(!empty($limit) && ($limit > 0))
		{
			$this->db->limit($limit,$offset);
		}
		$q = $this->db->group_by("country_code")->order_by("participants_count","desc")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getTopCities($mantra_id)
	{
		$q = $this->db->select("count(id) as submissions,city,country_id as country_code,sum(count) as participants_count")->from("japam_user")->where("japam_id",$mantra_id)->group_by("city")->order_by("participants_count","desc")->limit(10)->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function gettodaysTotalRecords($mantra_id)
	{
		$q = $this->db->select("firstname,lastname,middlename,phoneno,email,count(id) as submissions,donor_name as performed_by,city,country_id as country_code,sum(count) as participants_count,date as japa_date,updated_on as submission_date")->from("japam_user")->where("japam_id",$mantra_id)->group_by("phoneno")->order_by("participants_count","desc")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getTotalRecordsbyDate($mantra_id)
	{
		$q = $this->db->select("firstname,lastname,middlename,phoneno,email,count(id) as submissions,donor_name as performed_by,city,country_id as country_code,sum(count) as participants_count,date as japa_date,updated_on as submission_date")->from("japam_user")->where("japam_id",$mantra_id)->group_by("DATE_FORMAT(japa_date,'%Y%m%d')")->order_by("japa_date","desc")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}
}
?>