<?PHP
class Greetings_model extends CI_Model 
{
	var $tableName="greetings";
    function __construct()
    {
        parent::__construct();
    }
    public function getAll()
    {
    	//$this->db->order_by("order","asc");
    	$q=$this->db->get($this->tableName);
    	return $q->result();
    }
    public function greetingData($id)
    {
    	$this->db->where("id",$id);
    	$q=$this->db->get($this->tableName);
    	return $q->row();
    }
    public function sendGreeting($greetingData)
    {
    	$subject=trim($_POST['subject']);
    	$message=trim($_POST['message']);
    	$recipients=array_unique(explode(",",trim($_POST['recipients'])));

    	foreach ($recipients as $recipient)
    	{
    		$emailData['greetingData']=$greetingData;
    		$emailData['post']=$_POST;
    		$content=$this->load->view("greetings/user/_greeting_email",$emailData,true);
    		$this->greetings_user_model->insertRecord($this->currentUser->id,$subject,$content,$recipient);

    		$name=explode("@",$recipient);
    		$this->load->library("email_extension");
			$this->email_extension->sendMailGuest("greetings",$name[0],$recipient,$subject,$content,'',1);
    	}
    }

    public function uploadFile()
    {
        $fname=$_FILES['files']['name'][0];
        $ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);
        $newname="greeting_".substr(md5(mt_rand()), 0, 16).".".$ext;
        $tempPath=$_FILES['files']['tmp_name'][0];
        $tempName=basename($_FILES['files']['tmp_name'][0]);
        $thumbName="thumb_".$fname;
        $thumbPath=str_replace($tempName, $thumbName, $tempPath);
        $this->general_model->create_thumb_150($tempPath,$thumbPath);

        $this->load->helper("image");
        $image = new SimpleImage();
        $image->load($tempPath);
        $img_width=$image->getWidth();
        $img_height=$image->getHeight();
        $ratio=$img_width/$img_height;
      
        if($ratio>=1)
        {
            if($img_width>1000)
                $image->resizeToWidth(1000);
        }
        else
        {
            if($img_height>1000)
                $image->resizeToHeight(1000);
        }
        $image->save($tempPath);

        $this->load->library("s3",array("accessKey"=>aws_s3_access_key,
                                            "secretKey"=>aws_s3_secret_key,
                                            "useSSL"=>false,
                                            "endpoint"=>"s3.amazonaws.com"));
        $amazonUri="content/greetings/";
        $this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
        $this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUri."thumb_".$newname,S3::ACL_PUBLIC_READ, array(), array());
        $fileSize=filesize($tempPath);
        $this->db->insert($this->tableName,
                        array(
                                "filename"=>$newname,
                                'size'=>$fileSize
                            ));

        $data['fileid']=$this->db->insert_id();
        $data['filename']=$newname;
        return $data;
    }
    public function delete($greetingData)
    {
        
        $this->load->library("s3",array("accessKey"=>aws_s3_access_key,
                                            "secretKey"=>aws_s3_secret_key,
                                            "useSSL"=>false,
                                            "endpoint"=>"s3.amazonaws.com"));

        $amazonUri="content/greetings/".$greetingData->filename;
        $amazonThumbUri="content/greetings/thumb_".$greetingData->filename;
        $this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
        $this->s3->deleteObject(aws_s3_bucket_name,$amazonThumbUri);

        $this->db->where("id",$greetingData->id);
        $this->db->delete($this->tableName);
        return 1;
    }
}
?>