<?PHP
class Birthday_greetings_model extends CI_Model 
{
	var $tableName="birthday_greetings";
    function __construct()
    {
        parent::__construct();
    }
    public function getAll()
    {
    	$q=$this->db->get($this->tableName);
    	return $q->result();
    }
    private function greetingData($id)
    {
    	$this->db->where("id",$id);
    	$q=$this->db->get($this->tableName);
    	return $q->row();
    }
    public function sendGreeting($user)
    {

        $greetingCheck=$this->birthday_mails_model->checkGreetingSent($user->id);
        if($greetingCheck)
        {
            return;
        }
        $image=$this->getGreeting();
        
        $path=aws_s3_base_url."content/birthday_greetings/".$image->filename;
        
        $eData['user']=$user;
        $eData['path']=$path;
        $content=$this->load->view("greetings/admin/_birthday_greeting_email",$eData,true);

        $subject="Happy Birthday ".$user->firstname." ".$user->lastname;

        $this->load->library("email_extension");
        $this->email_extension->sendMailGuest("birthday_greetings",$user->firstname." ".$user->lastname,$user->email,$subject,$content,'',1);

        $this->birthday_mails_model->insertRecord($user->id,$user->email,$subject,$content);
    }

    public function getGreeting()
    {
        $this->db->order_by("used",'asc');
        $this->db->limit(1);
        $q=$this->db->get($this->tableName);
        $grow= $q->row();


        $this->db->where("id",$grow->id);
        $this->db->update($this->tableName,array("used"=>($grow->used+1)));

        return $grow;
    }

    public function uploadFile()
    {
        $fname=$_FILES['files']['name'][0];
        $ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);
        $newname="birthday_greeting_".md5(mt_rand() . microtime()).".".$ext;
        $tempPath=$_FILES['files']['tmp_name'][0];
        $tempName=basename($_FILES['files']['tmp_name'][0]);
        $thumbName="thumb_".$fname;
        $thumbPath=str_replace($tempName, $thumbName, $tempPath);
        $this->general_model->create_thumb_150($tempPath,$thumbPath);

        $this->load->helper("image");
        $image = new SimpleImage();
        $image->load($tempPath);
        $img_width=$image->getWidth();
        $img_height=$image->getHeight();
        $ratio=$img_width/$img_height;
      
        if($ratio>=1)
        {
            if($img_width>1000)
                $image->resizeToWidth(1000);
        }
        else
        {
            if($img_height>1000)
                $image->resizeToHeight(1000);
        }
        $image->save($tempPath);

        $this->load->library("s3",array("accessKey"=>aws_s3_access_key,
                                            "secretKey"=>aws_s3_secret_key,
                                            "useSSL"=>false,
                                            "endpoint"=>"s3.amazonaws.com"));
        $amazonUri="content/birthday_greetings/";
        $this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
        $this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUri."thumb_".$newname,S3::ACL_PUBLIC_READ, array(), array());
        $fileSize=filesize($tempPath);
        $this->db->insert($this->tableName,
                        array(
                                "filename"=>$newname,
                                'size'=>$fileSize
                            ));

        $data['fileid']=$this->db->insert_id();
        $data['filename']=$newname;
        return $data;
    }
    public function delete($greetingData)
    {
        
        $this->load->library("s3",array("accessKey"=>aws_s3_access_key,
                                            "secretKey"=>aws_s3_secret_key,
                                            "useSSL"=>false,
                                            "endpoint"=>"s3.amazonaws.com"));

        $amazonUri="content/birthday_greetings/".$greetingData->filename;
        $amazonThumbUri="content/birthday_greetings/thumb_".$greetingData->filename;
        $this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
        $this->s3->deleteObject(aws_s3_bucket_name,$amazonThumbUri);

        $this->db->where("id",$greetingData->id);
        $this->db->delete($this->tableName);
        return 1;
    }
}
?>