<?PHP
class General_newsletters_model extends CI_Model 
{
	var $tableName="general_newsletters";
	var $emailDb='';
	var $smsDb='';
	var $siteServicesDb="";
	public function __construct()
	{
		parent::__construct();
		$this->emailDb=$this->load->database("emails",true,false);
		$this->smsDb=$this->load->database("sms",true,false);
		$this->siteServicesDb = $this->load->database("site_services",true,false);
	}
	public function newsletterData($id)
	{
		$this->siteServicesDb->where("id",$id);
		$query = $this->siteServicesDb->get($this->tableName);
		return $query->row();
	}
	public function listNewsletters($excel=0)
	{

		$i=0;
		$query1=$this->siteServicesDb;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);

		$preData="Newsletter List: ";
        if(isset($_POST['nsl_list_id']) && $_POST['nsl_list_id'] !="")
        {
            $listData = $this->general_newsletter_lists_model->getListById($_POST['nsl_list_id']);
            $query1->where('list_id', $_POST['nsl_list_id']);
            $preData.='"'.$listData->list_name.'"';
        }

        $preData.="\nSearch Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nStatus: ";

		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(1,2)))
		{
			$query1->where("status",$_POST['status']);
			if($_POST['status']==1)
			{
				$preData.="Created";
			}
			else
			{
				$preData.="Sent";
			}
		}
		else
		{
			$preData.="All Status";
		}

		$preData.="\nNewsletter Type: ";

		if(isset($_POST['type']) && is_numeric($_POST['type']) && in_array($_POST['type'],array(1,2)))
		{
			$query1->where("type",$_POST['type']);
			if($_POST['type']==1)
			{
				$preData.="Email";
			}
			else
			{
				$preData.="SMS";
			}
		}
		else
		{
			$preData.="All Types";
		}

		/*if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(created_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(created_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
		}*/

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('created_on',$_POST['dir']);
				else
					$query1->order_by('created_on',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","general_newsletters/general_newsletters_model",$sql,$this->currentUser,"site_services",$_POST,"All General Newsletters",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('created_on',$dir);
		}
		else
		{
			$query1->order_by('created_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['created_on']));
			if($rtn['data'][$c]['sent_on'])
				$rtn['data'][$c]['sent_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['sent_on']));
			else
				$rtn['data'][$c]['sent_on']="N/A";
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function save($id)
	{
		// echo '<pre>'; print_r($_POST); die();
		if($this->input->post("nsl_list_id")=='' || $this->input->post("nsl_list_id")==0)
		{
			return 0;
		}
		$nsl_list_id = $this->input->post("nsl_list_id");
		$countries='';
		if(is_array($this->input->post("countries")))
		{
			$countries=implode(",",$this->input->post("countries"));
		}
		else
		{
			$countries=$this->input->post("countries");
		}

		if(is_array($this->input->post("groupids")))
		{
			$groupids=implode(",",$this->input->post("groupids"));
		}
		else
		{
			$groupids=$this->input->post("groupids");
		}

		$userids='';
		if(is_array($this->input->post("userids")))
		{
			$userids=implode(",",$this->input->post("userids"));
		}
		else
		{
			$userids=$this->input->post("userids");
		}

		$content='';
		if($this->input->post("type")==1)
			$content=$this->general_model->filtertext(trim($this->input->post("content")));

		if($this->input->post("type")==2)
			$content=$this->input->post("message");

		if(!$id)
		{
			$q=$this->siteServicesDb->insert($this->tableName,
                                array(
                                	'subject' =>$this->general_model->filtertext(trim($_POST["subject"])),
									'content' =>$content,
									'created_on' => date("Y:m:d H:i:s"),
									'created_by'=>$this->currentUser->id,
									'list_id'=>$nsl_list_id,
									'field_userids'=>$userids,
									'field_country'=>$countries,
									'field_groups'=>$groupids,
									'type'=>$this->input->post("type")
								)
								);
			$idd=$this->siteServicesDb->insert_id();
			$nid="GNL-".date("Ymd")."-".$idd;
			$this->siteServicesDb->where('id', $idd);
			$q=$this->siteServicesDb->update($this->tableName,
                                array("unique_id"=>$nid));
		}
		else
		{
			$this->siteServicesDb->where('id', $id);
			$q=$this->siteServicesDb->update($this->tableName,
                                array(
                                	'subject' =>$this->general_model->filtertext(trim($_POST["subject"])),
									'content' =>$content,
									'modified_on' => date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id,
									'list_id'=>$nsl_list_id,
									'field_userids'=>$userids,
									'field_groups'=>$groupids,
									'field_country'=>$countries,
									'type'=>$this->input->post("type")
								)
							);
			
			$idd=$id;
		}

		$this->load->helper("simple_html_dom");
		$dom=new simple_html_dom();
		$tempContent=trim($_POST['content']);
		$contentDom=$dom->load($tempContent);
		$images=$contentDom->find('img');
		if(count($images))
		{
			if($id)
			{
				$existingImages=$this->general_newsletters_images_model->getImagesByNewsletterId($id);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$eArray[$eimage->filename]=$eimage->id;
				}
				$editorImages=[];
				foreach ($images as $img_dom) 
				{
					$pathText=$img_dom->attr['src'];
					if(preg_match('/amazon/i',$pathText))
					{
						$editorImages[basename($pathText)]=basename($pathText);
					}
				}
				$diff=array_diff_key($eArray,$editorImages);

				if(count($diff))
				{
					foreach($diff as $ikey)
					$this->general_newsletters_images_model->deleteImage($id,$ikey);
				}

			}

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="content/general_newsletter/";
			foreach ($images as $img_dom) 
			{
				$pathText=$img_dom->attr['src'];
				if(preg_match('/amazon/i',$pathText))
					continue;

				$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
				if(file_exists($path))
				{
					$fname=basename($path);
					$newFileName=$idd."_".$fname;
					$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
					$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
					unlink($path);

					$imageData=array('filename' => $newFileName,
									'newsletter_id' =>$idd,
									'created_on' =>date("Y:m:d H:i:s")
									);
					$this->general_newsletters_images_model->insert($imageData);
				}
			}
			$this->siteServicesDb->where("id",$idd);
			$this->siteServicesDb->update($this->tableName,array("content"=>$tempContent));
		}
		else
		{
			if($id)
			{
				$existingImages=$this->general_newsletters_images_model->getImagesByNewsletterId($id);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$this->general_newsletters_images_model->deleteImage($id,$eimage->id);
				}
			}
		}

		if($q) return $idd;
		else return 0;
	}
	public function sendNewsletter($id)
	{
		$newsletterData=$this->newsletterData($id);

		$listData = $this->general_newsletter_lists_model->getListById($newsletterData->list_id);
		if(empty($listData))
		{
			return 21;
		}

		if( ($newsletterData->type==1 && $listData->email_table_name=='') || ($newsletterData->type==2 && $listData->sms_table_name=='') )
		{
			return 22;
		}

		if($newsletterData->type==2)//SMS
		{
			$countries=$this->locations_model->getCountries(true);
		}
		$userIdsArray=array();
		
		if($newsletterData->type==2 && $newsletterData->field_country!='')
		{
			$this->siteServicesDb->where_in("country_code",explode(",",$newsletterData->field_country));
		}
		if($newsletterData->field_userids!='')
		{
			$this->siteServicesDb->where_in("id",explode(",",$newsletterData->field_userids));
		}
		if($newsletterData->field_groups!='')
		{
			$grpids = explode(",",$newsletterData->field_groups);
			if($grpids)
			{
				$wq = "(";
				$k=0;
			    foreach($grpids as $value)
			    {
			    	if($k++)
			    		$wq.= " OR FIND_IN_SET('$value', group_id) != 0";
			    	else
			    		$wq.= "FIND_IN_SET('$value', group_id) != 0";
			    }
			    $wq.=")";
			    $this->siteServicesDb->where($wq);
			}
		}
		
		$this->siteServicesDb->select("*");
		$this->siteServicesDb->where("unsubscribe","0");
		if($newsletterData->type==1)
		{
			$this->siteServicesDb->where("email_verified",1);
			$subscribers=$this->siteServicesDb->get($listData->email_table_name);
		}
		else if($newsletterData->type==2)
		{
			$this->siteServicesDb->where("phone_verified",1);
			$subscribers=$this->siteServicesDb->get($listData->sms_table_name);
		}
		
		$cnt=0;
		if($subscribers->num_rows())
		{
			if($newsletterData->type==1)//Email
			{
				$this->session->set_flashdata("newsletter_subject", $newsletterData->subject);
			}
			if($newsletterData->type==2)//SMS
			{
				$this->session->set_flashdata("newsletter_subject", $newsletterData->content);
			}
			
			$sent=0;
			
			$fail=0;

			$emailTableName = "mail_track_general_newsletter_".date('Y');
			$smsTableName = "sms_track_general_newsletter_".date('Y');
			foreach($subscribers->result() as $recipient)
			{
				if($newsletterData->type==1)//Email
				{
					if($this->emailDb->table_exists($emailTableName))
					{
				        // table exists (Your query)
				    } 
				    else
				    {
				        $sql1="
				            CREATE TABLE IF NOT EXISTS `".$emailTableName."` (
				              `id` int(11) NOT NULL AUTO_INCREMENT,
				              `mail_to` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `date` datetime NOT NULL,
							  `sent_on` datetime DEFAULT NULL,
							  `sent_by` int(11) DEFAULT 0,
							  `newsletter_id` int(11) NOT NULL DEFAULT 0,
							  `delivered` int(11) NOT NULL DEFAULT 0,
							  `viewed` int(11) DEFAULT 0,
							  `bounced` int(4) NOT NULL DEFAULT 0,
							  `status` int(11) DEFAULT 0,
							  `fail_reason` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `user_id` int(11) DEFAULT 0,
							  `resent` int(11) DEFAULT 0,
							  `resent_id` int(11) NOT NULL DEFAULT 0,
							  `message_id` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `reads` int(11) NOT NULL DEFAULT 0,
							  `clicked` int(11) NOT NULL DEFAULT 0,
							  `debug` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
				              PRIMARY KEY (`id`)
				            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
				        ";
				        $this->emailDb->query($sql1);      
				    }
				    if($GLOBALS['site_settings']['email_service']==1)
			    	{
						$nData=array('mail_to' => $recipient->email,
										'mail_subject' => "[General Newsletter] - ".$newsletterData->subject,
										'date' => date("Y:m:d H:i:s"),
										'newsletter_id' => $newsletterData->id
									);
						$this->emailDb->insert($emailTableName,$nData);
					}
				}
				else
				{
					if($this->smsDb->table_exists($smsTableName))
					{
				        // table exists (Your query)
				    } 
				    else
				    {
				        $sql1="
				            CREATE TABLE IF NOT EXISTS `".$smsTableName."` (
				              `id` int(11) NOT NULL AUTO_INCREMENT,
				              `to` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `isd_code` int(11) DEFAULT 0,
							  `from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `message` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `date` datetime NOT NULL,
							  `sent_on` datetime DEFAULT NULL,
							  `sent_by` int(11) DEFAULT 0,
							  `newsletter_id` int(11) NOT NULL DEFAULT 0,
							  `status` int(11) DEFAULT 0,
							  `fail_reason` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `user_id` int(11) DEFAULT 0,
							  `username` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `resent` int(11) DEFAULT 0,
							  `resent_id` int(11) NOT NULL DEFAULT 0,
							  `message_id` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
				              PRIMARY KEY (`id`)
				            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
				        ";
				        $this->smsDb->query($sql1);      
				    }
					if(!isset($countries[$recipient->country_code]))
						continue;
					$recipient_to=$countries[$recipient->country_code]->isd_code.$recipient->phone;
					if($GLOBALS['site_settings']['sms_service']==1)
			    	{
						$nData=array('to' => $recipient_to,
											'date' => date("Y:m:d H:i:s"),
											'newsletter_id' => $newsletterData->id,
											'isd_code'=>$countries[$recipient->country_code]->isd_code
										);
						$this->smsDb->insert($smsTableName,$nData);
						$sent_id=$this->smsDb->insert_id();
					}
				}
				$cnt++;
			}
			$this->session->set_flashdata("newsletter_recipients", $cnt);
		}
		else
			$this->session->set_flashdata("newsletter_recipients_no",1);


		$updateNslData = array(
							'sent_on' =>date("Y:m:d H:i:s"),
							'status'=>2,
							'total_recipients'=>$cnt
						);
		if($newsletterData->type==1)//Email
		{
			$updateNslData['email_table_name'] = $emailTableName;
		}

		if($newsletterData->type==2)//Email
		{
			$updateNslData['sms_table_name'] = $smsTableName;
		}

		$this->siteServicesDb->where("id",$id);
		$this->siteServicesDb->update($this->tableName,$updateNslData);
		return 20;
	}
	public function delete($id,$newsletterData)
	{
		$existingImages=$this->general_newsletters_images_model->getImagesByNewsletterId($id);
		$eArray=[];
		foreach ($existingImages as $eimage)
		{
			$this->general_newsletters_images_model->deleteImage($id,$eimage->id);
		}
		$this->siteServicesDb->where("id",$id);
		$query = $this->siteServicesDb->delete($this->tableName);
		if($query) return 1;
		else return 0;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->siteServicesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Newsletter ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subject");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"To (Email IDs)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Created");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Sent");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->unique_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->subject);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,abs($reportrow->total_recipients));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));
			if($reportrow->sent_on!='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->sent_on)));
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			
			$status="Created";
			if($reportrow->status==2)
				$status="Sent";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>