<?PHP
class General_newsletters_email_model extends CI_Model 
{
	// var $tableName="newsletters_email";
	var $siteServicesDb = "";
    function __construct()
    {
        parent::__construct();
        $this->siteServicesDb = $this->load->database("site_services",true,false);
        $this->load->model('general_newsletters/general_newsletter_groups_model');
        $this->load->model('general_newsletters/general_newsletter_lists_model');
    }
    public function newsletterEmailData($tableName,$id)
    {
    	if($tableName!='' && $id>0)
    	{
    		$this->siteServicesDb->where("id",$id);
	    	$q=$this->siteServicesDb->get($tableName);
	    	return $q->row();
    	}
    	else {
    		return (object)[];
    	}
    }
    public function unsubscribenewsletter($vars)
    {
    	$this->siteServicesDb->select("unsubscribe,id");
    	$this->siteServicesDb->where("email",$vars['subscribe_email']);
		$q=$this->siteServicesDb->get($this->tableName);
		if(!$q->num_rows())
		{
			return 0;
		}
		if($q->num_rows())
		{
			$r = $q->row();
			if($r->unsubscribe == "1")
				return 2;
		}
		$check = $this->siteServicesDb->where("id",$r->id)->update($this->tableName,array( 'unsubscribe'=>"1",'country_code'=>!empty($vars['country_code'])?$vars['country_code']:"", 'name' => $vars['subscribe_name1'] ));
		if($check)
		{
			$token=urlencode(base64_encode(openssl_encrypt($vars['subscribe_email'], open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv)));
			$eData['name']=$vars['subscribe_name1'];
			$eData['email']=$vars['subscribe_email'];
			$eData['token']=$token;
			$subject=short_ashram_name." - Notifications - Unsubscribed from ".site_name_string1;
			$content=$this->load->view("common/templates/_email_unsubscription_confirm",$eData,true);
			$this->email_extension->sendMailGuest($this->service,$vars['subscribe_name1'],$vars['subscribe_email'],$subject,$content,'',1);
		}
		return 1;
    }
    public function get_by_email($email)
    {
    	$this->siteServicesDb->where("email",$email);
    	$q=$this->siteServicesDb->get($this->tableName);
    	return $q->row();
    }
    public function unsubscribe($email)
	{
		$this->unsubscribe_log_model->add($email,5);
		$this->siteServicesDb->where("email",$email);
    	$this->siteServicesDb->delete($this->tableName);
	}
    public function activate($email)
	{
		$this->siteServicesDb->where('email',$email);
		$r=$this->siteServicesDb->get($this->tableName)->row();
		if(!empty($r))
		{
			if($r->email_verified==1)
			{
				return 2;
			}
			else
			{
				$this->siteServicesDb->where('email',$email);
				$this->siteServicesDb->update($this->tableName,
                                array('email_verified'=>1));
				return 1;
			}
		}
		return 0;
	}

	public function deactivate($email)
	{
		$this->siteServicesDb->where('email',$email);
		$r=$this->siteServicesDb->get($this->tableName)->row();
		if(!empty($r))
		{
			if($r->email_verified==0)
			{
				return 2;
			}
			else
			{
				$this->siteServicesDb->where('email',$email);
				$this->siteServicesDb->update($this->tableName,
                                array('email_verified'=>0));
				return 1;
			}
		}
		return 0;
	}

	public function update($old_email,$new_email)
	{
		$this->siteServicesDb->where('email',$old_email);
		$this->siteServicesDb->update($this->tableName,
                        array('email_verified'=>0,"email"=>$new_email));
	}

	public function update_name($email,$name)
	{
		$this->siteServicesDb->where('email',$email);
		$this->siteServicesDb->update($this->tableName,
                        array('name'=>$name));
	}

    public function subscribe($vars,$flag=1)
	{
		$email_table_name = $vars['email_table_name'];
		$this->siteServicesDb->select('id,unsubscribe');
		$this->siteServicesDb->where("email",$vars['subscribe_email']);
		$q=$this->siteServicesDb->get($email_table_name);
		if($q->num_rows())
		{
			$r = $q->row();
			if(!empty($r) && $r->unsubscribe == "1")
			{
				$status = $this->updateUnsubscribestatus($r->id,$vars);
				return $status;
			}
			return 0;
		}
		$app=0;
		if(isset($GLOBALS['app']) && $GLOBALS['app']==1)
		{
			$app=1;
		}
		$group_ids='';
		if(isset($vars['group_ids']) && $vars['group_ids']!=0)
		{
			$group_ids=$vars['group_ids'];
		}

		$email_verify = 0;
		if(isset($vars['email_verify']) && $vars['email_verify']!=0)
		{
			$email_verify = 1;
		}
		$this->siteServicesDb->insert($email_table_name,
                                array(
                                	'country_code'=>!empty($vars['country_code1'])?$vars['country_code1']:"",
                                	'city'=>!empty($vars['subscribe_city1'])?$vars['subscribe_city1']:"",
                                	'name' => $vars['subscribe_name1'],
									'email' => strtolower($vars['subscribe_email']),
									'list_id' => ($vars['list_id'])?$vars['list_id']:0,
									'date' =>date("Y:m:d H:i:s"),
									'group_id'=>$group_ids,
									'app'=>$app,
									'email_verified'=>$email_verify
								)
								);
		// if($flag==1)
		// {
		// 	$token=urlencode(base64_encode(openssl_encrypt($vars['subscribe_email'], open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv)));
		// 	$eData['name']=$vars['subscribe_name1'];
		// 	$eData['token']=$token;
		// 	$subject=short_ashram_name." - Notifications - Confirm Email - ".site_name_string1;
		// 	$content=$this->load->view("common/templates/_email_subscription_confirm",$eData,true);
		// 	$this->email_extension->sendMailGuest($this->service,$vars['subscribe_name1'],$vars['subscribe_email'],$subject,$content,'',1);
		// }
		return 1;
	}
	public function updateUnsubscribestatus($id,$vars)
	{
		if($id)
		{
			$email_table_name = $vars['email_table_name'];
			$data = array('unsubscribe'=>"0",'country_code'=>!empty($vars['country_code1'])?$vars['country_code1']:"", 'city'=>!empty($vars['subscribe_city1'])?$vars['subscribe_city1']:"", 'name' => $vars['subscribe_name1']);
			$this->siteServicesDb->where("id",$id);
	    	$this->siteServicesDb->update($email_table_name,$data);
	    	if($this->siteServicesDb->affected_rows() > 0)
	    	{
	   //  		$token=urlencode(base64_encode(openssl_encrypt($vars['subscribe_email'], open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv)));
				// $eData['name']=$vars['subscribe_name1'];
				// $eData['token']=$token;

				// $subject=short_ashram_name." - Confirm Email - ".site_name_string1;
				// $content=$this->load->view("common/templates/_email_subscription_confirm",$eData,true);
				// $this->email_extension->sendMailGuest($this->service,$vars['subscribe_name1'],$vars['subscribe_email'],$subject,$content,'',1);
				return 1;
	    	}
	    	return 0;
		}
		else
		{
			return 0;
		}
	}
	public function delete_by_email($email)
	{
		$this->siteServicesDb->where("email",$email);
    	$this->siteServicesDb->delete($this->tableName);
	}
	public function delete($tableName, $id)
	{
		if($tableName!='' && $id>0)
        {
            $this->siteServicesDb->where("id",$id);
    		$this->siteServicesDb->delete($tableName);
            return true;
        }
        else
        {
            return false;
        }
		
	}
	public function getList($excel=0)
	{
		$gNames = "";
	   	if(isset($_POST['group_name']) && $_POST['group_name'] !="" && $excel==1)
	   	{
	   		$gNames = $this->general_newsletter_groups_model->getGroupNames(implode(",", $_POST['group_name']));
	   	}

	   	$preData="Newsletter List: ";
	   	$emailTableName = "";
        if(isset($_POST['nsl_email_list_id']) && $_POST['nsl_email_list_id'] !="")
        {
            $listData = $this->general_newsletter_lists_model->getListById($_POST['nsl_email_list_id']);
            if(isset($listData->email_table_name) && $listData->email_table_name!='')
            {
                $emailTableName = $listData->email_table_name;
            }
            $preData.='"'.$listData->list_name.'"';
        }

		$i=0;
		$query1=$this->siteServicesDb;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($emailTableName);

		$preData.="\nSearch Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if($_POST['search_col'] == "email")
				$preData.= " Email ID";
			if($_POST['search_col'] == "name")
				$preData.= " Name";
			if($_POST['search_col'] == "city")
				$preData.= " City";

			$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
			$preData.=" containing ";

			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nCountry: ";
		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$query1->where('country_code',$_POST['country']);
			$preData.= $_POST['country'];
		}

		$preData.="\nGroups: ";

		if(isset($_POST['group_name']) && $_POST['group_name']!='' && count($_POST['group_name'])>0)
		{
			$wq = "(";
			$k=0;
		    foreach($_POST['group_name'] as $value)
		    {
		    	if($k++)
		    		$wq.= " OR FIND_IN_SET('$value', group_id) != 0";
		    	else
		    		$wq.= "FIND_IN_SET('$value', group_id) != 0";
		    }
		    $wq.=")";
		   	$query1->where($wq);
		   	
		   	$preData.='"'.$gNames.'"';
		}

		$preData.="\nAll Sources: ";
		if(isset($_POST['app']) && is_numeric($_POST['app']) && in_array($_POST['app'],array(0,1)))
		{
			$query1->where("app",$_POST['app']);
			if($_POST['app']==1)
				$preData.="App";
			else
				$preData.="Website";
		}

		$preData.="\nAll Subscribe Status: ";
		if(isset($_POST['subscribe_status']) && is_numeric($_POST['subscribe_status']) && in_array($_POST['subscribe_status'],array("0","1")))
		{
			$query1->where("unsubscribe",$_POST['subscribe_status']);
			if($_POST['subscribe_status']=="1")
				$preData.="UnSubscribed";
			else
				$preData.="Subscribed";
		}

		$preData.="\nEmail Verified: ";
		if(isset($_POST['email_verified']) && is_numeric($_POST['email_verified']) && in_array($_POST['email_verified'],array(0,1)))
		{
			$query1->where('email_verified',$_POST['email_verified']);
			if($_POST['email_verified']==1)
				$preData.="Yes";
			else
				$preData.="No";
		}
		
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();
			
			$requestResp=$this->excel_exports_model->makeRequest('default',"model","general_newsletters/General_newsletters_email_model",$sql,$this->currentUser,"site_services",$_POST,"All List Emails",$preData);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('date',$dir);
		}
		else
		{
			$query1->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if($rtn['data'][$c]['group_id'])
				$rtn['data'][$c]['group_names'] = $this->general_newsletter_groups_model->getGroupNames($rtn['data'][$c]['group_id']);
			else
				$rtn['data'][$c]['group_names'] = "";
			if($rtn['data'][$c]['city'])
				$rtn['data'][$c]['city'] = $rtn['data'][$c]['city'];
			else
				$rtn['data'][$c]['city'] = "";
			if($rtn['data'][$c]['country_code'])
				$rtn['data'][$c]['country_code'] = $rtn['data'][$c]['country_code'];
			else
				$rtn['data'][$c]['country_code'] = "";
			$rtn['data'][$c]['date']=date("d M Y h:i A",strtotime($rtn['data'][$c]['date']));
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function searchAll($string)
	{
		$tobeReturnArray = [];
		if($this->session->userdata("generalNewsletterId") && $this->session->userdata("generalNewsletterId")>0)
		{
			$listData = $this->general_newsletter_lists_model->getListById($this->session->userdata("generalNewsletterId"));
			if(isset($listData->email_table_name) && $listData->email_table_name!='')
			{
				$this->siteServicesDb->select("*");
				$this->siteServicesDb->from($listData->email_table_name);
				$this->siteServicesDb->group_start();
				$this->siteServicesDb->like("name",$string,'match');
				$this->siteServicesDb->or_like("email",$string,'match');
				$this->siteServicesDb->group_end();
				$this->siteServicesDb->where("email_verified",1);
				$this->siteServicesDb->where("unsubscribe","0");
				$this->siteServicesDb->limit(10);
				$tobeReturnArray = $this->siteServicesDb->get()->result_array();
			}
		}
		return $tobeReturnArray;
	}
	public function getByIds($ids, $tableName='')
	{
		if($tableName!='')
		{
			$this->siteServicesDb->select("*");
			$this->siteServicesDb->from($tableName);
			$this->siteServicesDb->where_in("id",$ids);
			return $this->siteServicesDb->get()->result();
		}
		else
		{
			return (object)[];
		}
	}
	public function getUsersByIds($ids)
	{
		$this->db->select("*");
		$this->db->from('users');
		$this->db->where_in("id",$ids);
		return $this->db->get()->result();
	}
	public function searchbyGroupAll($string)
	{
		$tobeReturnArray = [];
		if($this->session->userdata("generalNewsletterId") && $this->session->userdata("generalNewsletterId")>0)
		{
			$listData = $this->general_newsletter_lists_model->getListById($this->session->userdata("generalNewsletterId"));
			if(isset($listData->email_table_name) && $listData->email_table_name!='')
			{
				$this->siteServicesDb->select("*");
				$this->siteServicesDb->from($listData->email_table_name." as s");
				$this->siteServicesDb->like("group_name",$string,'match');
				$this->siteServicesDb->join("general_nl_groups as gnlg","FIND_IN_SET(gnlg.id, s.group_id)");
				$this->siteServicesDb->where("email_verified",1);
				if(isset($_POST['list_id']) && $_POST['list_id'] !="")
	   			{
	   				$this->siteServicesDb->where("gnlg.list_id", $_POST['list_id']);
	   			}
				$this->siteServicesDb->group_by('group_name');
				$this->siteServicesDb->limit(10);
				$tobeReturnArray = $this->siteServicesDb->get()->result_array();
			}
		}
		return $tobeReturnArray;
	}

	public function searchbyListAll($string)
	{
		$this->siteServicesDb->select("*");
		$this->siteServicesDb->from($this->tableName." as s");
		$this->siteServicesDb->like("group_name",$string,'match');
		$this->siteServicesDb->join("general_nl_groups as gnlg","FIND_IN_SET(gnlg.id, s.group_id)");
		$this->siteServicesDb->where("email_verified",1);
		$this->siteServicesDb->group_by('group_name');
		$this->siteServicesDb->limit(10);
		return $this->siteServicesDb->get()->result_array();
	}
	public function appendGroup($newGrouparr,$exGrouparr)
	{
		$merge = array_merge($newGrouparr,$exGrouparr);
		$final_value = array_unique($merge, SORT_REGULAR);
		return implode(",", $final_value);
	}

	public function checkGroups($id='',$groupsstring,$tableName)
	{
		$q = $this->siteServicesDb->select('group_id')->from($tableName)->where('id',$id)->get();
		if($q->num_rows() > 0)
		{
			$existedGroup = $q->result()[0]->group_id;
			if($existedGroup != "")
				return $this->appendGroup(explode(",",$groupsstring),explode(",",$existedGroup));
			else
				return $groupsstring;
		}
	}

	public function updategroups($data='',$where='',$flag=0, $updateTableName)
	{
		if($data && $where)
		{
			if($flag == 1)
			{
				$data = implode(",", $data);
				$data = array('group_id' => $data);
			}
			$this->siteServicesDb->where("id",$where);
    		$this->siteServicesDb->update($updateTableName,$data);
    		return true;
		}
	}

	public function emailCheck($email,$id,$emailTable) 
    {
    	$this->load->model("emails_sns_notifications_model");
    	$bounceCheck = $this->emails_sns_notifications_model->checkExistBounceMail($email);
    	if($emailTable!='')
    	{
	    	$this->siteServicesDb->where("email",$email);
	    	$this->siteServicesDb->where("id != ",$id);
	        $query=$this->siteServicesDb->get($emailTable);
	        if($query->num_rows())
			{
				return 1;
	        }
	        if($bounceCheck["status"] == 1)
	        {
	        	return 1;
	        }
	    }
        return 0;
    }

    public function excelReport($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->siteServicesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Group(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$reportrow->group_name = "";
			if($reportrow->group_id)
				$reportrow->group_name = $this->general_newsletter_groups_model->getGroupNames($reportrow->group_id);
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country_code);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->group_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function searchCountries($string)
	{
		$location=$this->load->database("location",true,false);
		$tobeReturnArray = [];
		if($this->session->userdata("generalNewsletterId") && $this->session->userdata("generalNewsletterId")>0)
		{
			$listData = $this->general_newsletter_lists_model->getListById($this->session->userdata("generalNewsletterId"));
			if(isset($listData->email_table_name) && $listData->email_table_name!='')
			{
				$this->siteServicesDb->select("l.country_code as country_code,country_name,l.isd_code as isd_code");
				$this->siteServicesDb->from($listData->email_table_name." as s");
				$this->siteServicesDb->join($location->database.".countries_list as l","l.country_code=s.country_code");
				$this->siteServicesDb->group_by("s.country_code");
				$this->siteServicesDb->like("l.country_name",$string,'match');
				$this->siteServicesDb->where("s.country_code !=",'');
				$this->siteServicesDb->where("l.country_code !=",'');
				$this->siteServicesDb->limit(10);
				$tobeReturnArray = $this->siteServicesDb->get()->result_array();
			}
		}
		return $tobeReturnArray;
	}

	public function updateUnsubscribeEmailStatus($tableName, $id, $status)
	{
		if($tableName!='' && $id>0 && ($status==0 || $status==1) )
        {
        	$this->siteServicesDb->where('id',$id);
			$this->siteServicesDb->update($tableName, array('unsubscribe'=>$status));
            return true;
        }
        else
        {
            return false;
        }
		
	}

	public function getMemberByNewsletterId($tableName, $email)
	{
		if($tableName!='' && $email!='')
		{
			$this->siteServicesDb->where("email",$email);
	    	$q=$this->siteServicesDb->get($tableName);
	    	return $q->row();
		}
	}

}
?>