<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Files_Model extends CI_Model 
{
	var $tableName="files";
	var $siteServivcesDb = "";
    function __construct() 
	{
   		parent::__construct();
   		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	function getFiles()
	{
		$this->siteServivcesDb->where("user_id",$this->currentUser->id);
		$this->siteServivcesDb->order_by("date",'desc');
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}
	public function getCount()
	{
		return $this->siteServivcesDb->get($this->tableName)->num_rows();
	}
	function getSharedFiles()
	{
		$this->siteServivcesDb->where("FIND_IN_SET(".$this->currentUser->id.",shared_user_ids) >",0);
		$this->siteServivcesDb->where("shared_user_ids !=",null);
		$this->siteServivcesDb->order_by("date",'desc');
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}
	public function fileData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
	}
	public function uploadFile()
	{
		$fname=$_FILES['files']['name'][0];
		$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);
		
		$newname="admin_files_".substr(md5(mt_rand()), 0, 16).".".$ext;
		$tempPath=$_FILES['files']['tmp_name'][0];
		$tempName=basename($_FILES['files']['tmp_name'][0]);

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		$amazonUri="adminfiles/".md5($this->currentUser->id)."/";
		$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PRIVATE, array(), array());

		$this->siteServivcesDb->insert($this->tableName,
						array(
								"filename"=>$newname,
								'date'=>date("Y:m:d H:i:s"),
								'description'=>$fname,
								'user_id'=>$this->currentUser->id
							));
		$data['fileid']=$this->siteServivcesDb->insert_id();
		$data['filename']=$newname;
		$data['description']=$fname;
		return $data;
	}
	public function delete($fileData)
	{
		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$amazonUri="adminfiles/".md5($this->currentUser->id)."/".$fileData->filename;
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
		$this->siteServivcesDb->where("id",$fileData->id);
		$this->siteServivcesDb->delete($this->tableName);
		return 1;
	}
	public function updateDescription($id,$value)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array('description'=>$value));
	}
	public function share($userIds,$fileData)
	{
		$tempUserIds=$userIds;
		$temp=array_filter(explode(",",$userIds));
		$userIds=array();
		foreach ($temp as $tempUserId)
		{
			if(!in_array($tempUserId,$userIds) && $this->currentUser->id!=$tempUserId)
			{
				$userIds[]=$tempUserId;
			}
		}
		$prevUserIds=$fileData->shared_user_ids;
		$prevTemp=explode(",",$prevUserIds);

		$removed=array();
		foreach ($prevTemp as $prevUserId)
		{
			if(!in_array($prevUserId,$userIds))
			{
				$removed[]=$prevUserId;
			}
		}
		
		$newUserIds=array();
		foreach ($userIds as $newUserId)
		{
			if(!in_array($newUserId,$prevTemp))
			{
				$newUserIds[]=$newUserId;
				$notificationMessage=$this->currentUser->firstname." ".$this->currentUser->lastname." shared a file with you";
				$notificationLink="myfiles";
				$this->notifications_model->addNotification($newUserId,$notificationMessage,$notificationLink,$this->service);
			}
		}
		if(!empty($userIds))
		{
			$updateArray=array("shared_user_ids"=>implode(",",$userIds));
		}
		else
		{
			$updateArray=array("shared_user_ids"=>'');
		}
		$this->siteServivcesDb->where("id",$fileData->id);
		$this->siteServivcesDb->update($this->tableName,$updateArray);
	}
}
?>