<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Videos_Model extends CI_Model 
{
	var $tableName="videos";
	var $siteServivcesDb = "";
    function __construct() 
	{
   		parent::__construct();
   		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}

	public function listPublic($type,$albumId=0)
	{
		$i=0;

		$query1=$this->siteServivcesDb;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		
		$query1->from($this->tableName);
		$query1->where("type",$type);
		if(is_numeric($this->input->post('ashram_id')) && $this->input->post('ashram_id'))
		{
			$query1->where("ashram_id",$this->input->post('ashram_id'));
		}
		else if(is_numeric($this->input->post('satsang_id')) && $this->input->post('satsang_id'))
		{
			$query1->where("satsang_id",$this->input->post('satsang_id'));
		}
		else
		{
			$query1->where("satsang_id",0);
			$query1->where("ashram_id",0);
		}
		
		if($albumId)
		{
			$query1->where("album_id",$albumId);
		}

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->like("title",$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
		}
		
		
		$per_page=12;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("order","asc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();

		$ii=0;
		$ids=array();
		foreach ($rtn['res'] as $key=> $row)
		{
			if($ii==5)
				$ii=0;
			$ii++;
		}

		return $rtn;
	}

	public function getAlbumThumbs($ids)
	{
		if(!empty($ids))
		$this->siteServivcesDb->where_in("album_id",$ids);
		$this->siteServivcesDb->group_by("album_id");
		$q=$this->siteServivcesDb->get($this->tableName);
		$res=array();
		foreach ($ids as $key => $id)
		{
			$row=$q->row($key);
			$res[$id]=$row->thumb;
		}
		return $res;
	}

	public function listAdmin($albumId)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$query1->where("album_id",$albumId);

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns'])
		 /*&& in_array($_POST['wild'],$GLOBALS['current_acl']['wild'])*/)
		{
			/*if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),"after");
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),'before');
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
			}*/
			$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
		}
		
		if(isset($_POST['type']) && is_numeric($_POST['type']) && in_array($_POST['type'],array(1,2)))
		{
			$query1->where("type",$_POST['type']);
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('order',$dir);
		}
		else
		{
			$query1->order_by('order',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}

		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function addVideo($albumData)
	{
		if($_POST['type']==1)
		{
			$yApiKey=youtube_api_key;
			$videoIds=array_filter(explode(",",$_POST['video_id']));
			$added=0;
			foreach ($videoIds as $videoId)
			{
				$videoData=$this->videos_model->videoDataById($videoId,$albumData['album']->id);
				if(!empty($videoData))
				{
					continue;
				}
				$added++;

				$url = "https://www.googleapis.com/youtube/v3/videos?id=".$videoId."&key=".$yApiKey."&part=snippet,contentDetails,statistics";
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_URL,$url);
				curl_setopt($ch, CURLOPT_REFERER, base_url);
				$output=curl_exec($ch);
				$response = json_decode($output, TRUE);
				curl_close($ch);
				/*print_r($response);
				exit;*/

				if(!isset($response['items']) || count($response['items'])==0)
				{
					return 0;
				}

				$title=$response['items'][0]['snippet']['title'];
				if(isset($response['items'][0]['snippet']['thumbnails']['high']['url']))
					$thumb=$response['items'][0]['snippet']['thumbnails']['high']['url'];
				else
					$thumb='';
				if(isset($response['items'][0]['contentDetails']['duration']))
				{
					$duration=$response['items'][0]['contentDetails']['duration'];
					$str1=str_replace("PT","",$duration);
					if(preg_match("/h/i",$str1))
					{
						$hh=explode("H",$str1);
						$hours=$hh[0];
						$mm=explode("M",$hh[1]);
						$minutes=$mm[0];
						$seconds=abs($mm[1]);

						$duration=sprintf('%02d:%02d:%02d', $hours,$minutes,$seconds);
					}
					else
					{
						$a1=explode("M",$str1);
						$minutes=$a1[0];
						$seconds=abs($a1[1]);
						$duration=sprintf('%02d:%02d', $minutes,$seconds);
					}
				}
				else
					$duration='00:00';

				$this->siteServivcesDb->insert($this->tableName,
					array(
							"video_id"=>$videoId,
							"title"=>$title,
							"duration"=>$duration,
							'thumb'=>$thumb,
							'album_id'=>$albumData['album']->id,
							'type'=>$_POST['type']
						));
			}
			$this->siteServivcesDb->where("album_id",$albumData['album']->id);
			$qc=$this->siteServivcesDb->get($this->tableName);
			$this->videos_albums_model->updateCount($albumData['album']->id,$qc->num_rows());
		}
		else
		{
			$vToken=vimeo_access_token;
			$videoIds=array_filter(explode(",",$_POST['video_id']));
			$added=0;
			foreach ($videoIds as $videoId)
			{
				$videoData=$this->videos_model->videoDataById($videoId,$albumData['album']->id);
				if(!empty($videoData))
				{
					continue;
				}
				$added++;

				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, "https://api.vimeo.com/videos/".$videoId."?fields=name,duration,pictures");
				curl_setopt($ch, CURLOPT_HTTPHEADER,
								array(
										'Authorization: Bearer '.$vToken,
										'Content-Type: application/json',
				    					'Accept: application/json'
									)
								);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				$output = curl_exec($ch);
				curl_close($ch);
				$response=json_decode($output,true);

				if(isset($response['error']))
				{
					return 0;
				}

				//print_r($response);
				$title=$response['name'];

				$t = round($response['duration']);
				if(round($t/3600,0)==0)
				{
					$duration=sprintf('%02d:%02d', ($t/60%60), $t%60);
				}
				else
				{
	  				$duration=sprintf('%02d:%02d:%02d', ($t/3600),($t/60%60), $t%60);
				}

				$thumb='';
				if(isset($response['pictures']['sizes']))
				{
					$imgData=$response['pictures']['sizes'][0]['link'];
					$thumb=str_replace("?r=pad","",$imgData);
					$ext=pathinfo($thumb,PATHINFO_EXTENSION);
					$tempThumbName=explode("_",$thumb);
					$newThumbName=$tempThumbName[0]."_640x480.".$ext;
					$thumb=$newThumbName;
				}

				$ashram_id=$this->session->userdata('ashramId');
				if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
				{
					if($this->currentUser->ashram_id)
						$ashram_id=$this->currentUser->ashram_id;
					else if($this->currentUser->satsang_id)
						$ashram_id=$this->currentUser->satsang_id;
				}
				$ashram_id = isset($ashram_id)?$ashram_id:0;

				$this->siteServivcesDb->insert($this->tableName,
					array(
							"video_id"=>$videoId,
							"title"=>$title,
							"duration"=>$duration,
							'thumb'=>$thumb,
							'album_id'=>$albumData['album']->id,
							'type'=>$_POST['type'],
							'created_by'=>$this->currentUser->id,
							'ashram_id'=>$ashram_id
						));

			}
			$this->siteServivcesDb->where("album_id",$albumData['album']->id);
			$qc=$this->siteServivcesDb->get($this->tableName);
			$this->videos_albums_model->updateCount($albumData['album']->id,$qc->num_rows());
		}
		return $added;
	}

	public function videoData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
	}
	public function videoDataById($id,$albumId)
	{
		$this->siteServivcesDb->where("video_id",$id);
		$this->siteServivcesDb->where("album_id",$albumId);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
	}
	
	public function delete($videoData)
	{
		$this->siteServivcesDb->where("id",$videoData->id);
		$this->siteServivcesDb->delete($this->tableName);
		$albumData=$this->videos_albums_model->albumData($videoData->album_id);
		$this->videos_albums_model->updateCount($videoData->album_id,$albumData['album']->count-1);
		return 1;
	}
	public function deleteByAlbumId($albumId)
	{
		$this->siteServivcesDb->where("album_id",$albumId);
		$this->siteServivcesDb->delete($this->tableName);
		return 1;
	}
	public function updateOrder($id,$value)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array('order'=>$value));
	}

}
?>