<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Videos_albums_Model extends CI_Model 
{
	var $tableName="videos_albums";
	var $siteServivcesDb = "";
    function __construct() 
	{
   		 parent::__construct();
   		 $this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	function albumData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$query = $this->siteServivcesDb->get($this->tableName);
		$result['album']=$query->row();
		
		return $result;
	}

	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->siteServivcesDb->where('ashram_id',$this->currentUser->ashram_id);
		}
		return $this->siteServivcesDb->get($this->tableName)->num_rows();
	}

	public function updateCount($id,$count)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array("count"=>$count));
	}

	public function listPublic()
	{
		$i=0;

		$query1=$this->siteServivcesDb;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		
		$query1->from($this->tableName);
		if(is_numeric($this->input->post('ashram_id')) && $this->input->post('ashram_id'))
		{
			$query1->where("ashram_id",$this->input->post('ashram_id'));
		}
		else if(is_numeric($this->input->post('satsang_id')) && $this->input->post('satsang_id'))
		{
			$query1->where("satsang_id",$this->input->post('satsang_id'));
		}
		else
		{
			$query1->where("satsang_id",0);
			$query1->where("ashram_id",0);
		}

		$query1->where("count >",0);

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->like("name",$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
		}
		
		
		$per_page=12;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("name","asc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();

		$ids=array();
		foreach ($rtn['res'] as $key=> $row) 
		{
			$ids[]=$row->id;
		}

		$thumbs=$this->videos_model->getAlbumThumbs($ids);

		$rtn['thumbs']=$thumbs;
		return $rtn;
	}

	public function listAdmin($ashramId)
	{
		$ashramData = "";
		if($ashramId)
			$ashramData=$this->ashrams_model->ashramData($ashramId);
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$query1->where("ashram_id",$ashramId);
		/*if($this->currentUser->roles!=1)
		{
			$query1->where("created_by",$this->currentUser->id);
		}*/
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),"after");
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),'before');
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
			} */
		}
		
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(created_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(created_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('created_on',$dir);
		}
		else
		{
			$query1->order_by('created_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['ashram_name'] = "N/A";
			if($rtn['data'][$c]['ashram_id'] > 0)
			{
				$rtn['data'][$c]['ashram_name'] = $ashramData->name;
			}
			$rtn['data'][$c]['created_on']=date("d M Y",strtotime($row['created_on']));
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['tooltiptitle']=htmlentities($row['name']);
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	function saveAlbum($id)
	{	
		$slug=strtolower(url_title($this->general_model->filtertext(trim($_POST["album_name"]))));
		if(!$id)
		{
			//$ashram_id=$this->session->userdata('ashramId');
			$ashram_id=$_POST["ashram_id"];
			if($this->currentUser->roles!=1)
			{
				if($this->currentUser->ashram_id)
					$ashram_id=$this->currentUser->ashram_id;
				else if($this->currentUser->satsang_id)
					$ashram_id=$this->currentUser->satsang_id;

			}

			$query=$this->siteServivcesDb->insert($this->tableName,
                            array('name' =>$this->general_model->filtertext(trim($_POST["album_name"])),
                                  'description' =>$this->general_model->filtertext(trim($_POST["description"])),
								  'created_on' => date("Y:m:d H:i:s"),
								  'created_by' => $this->session->userdata("id"),
								  'slug'=>$slug,
								  'ashram_id'=>$ashram_id
								  )
                        );
			$albumId=$this->siteServivcesDb->insert_id();
			$unique_id="ALB-".date("Ymd")."-".$albumId;
		}
		else
		{
			$this->siteServivcesDb->where("id",$id);
			$query=$this->siteServivcesDb->update($this->tableName,
								array(
								"name"=>$this->general_model->filtertext(trim($_POST['album_name'])),
								"description"=>$this->general_model->filtertext(trim($_POST['description'])),
								'slug'=>$slug
								)
							);
			$albumId=$id;
			
		}

		/*$slug=strtolower(url_title($this->input->post('album_name'),'-',true));
		$seqNum=0;

		check:
		$seqNum++;
		$this->siteServivcesDb->where("slug",$slug);
		$this->siteServivcesDb->where("id !=",$albumId);
		$check=$this->siteServivcesDb->get($this->tableName);
		if($check->num_rows())
		{
			$slug.="-".$seqNum;
			goto check;
		}
*/

		/*if(!$id)
		{
			//$updateData['unique_id']=$unique_id;
			$updateData['slug']=$slug;
			$this->siteServivcesDb->where("id",$albumId);
			$result=$this->siteServivcesDb->update($this->tableName,$updateData);
		}*/
		if($query) return $albumId;
		else return 0;
	}
	public function delete($albumData)
	{
		$this->videos_model->deleteByAlbumId($albumData['album']->id);
		$this->siteServivcesDb->where("id",$albumData['album']->id);
		$this->siteServivcesDb->delete($this->tableName);
		return 1;
	}

	public function checkName($name,$id)
	{
		$error=0;

		$slug=url_title($name);

		$this->siteServivcesDb->where("name",$name);
		$this->siteServivcesDb->where("id !=",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		$this->siteServivcesDb->where("slug",$slug);
		$this->siteServivcesDb->where("id !=",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}
}
?>