<?PHP
class Pages_Model extends CI_Model 
{
	var $tableName="pages";
	var $siteServivcesDb = "";
	var $pagesList=array();
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function fetchPages()
	{
		$this->siteServivcesDb->select("id, parent_link, slug, name,published_on");
		$this->siteServivcesDb->where("date(published_on) <=",date("Y:m:d"));
		$this->siteServivcesDb->order_by("parent_link, name");
		$q=$this->siteServivcesDb->get($this->tableName);

        $this->pagesList = array(
            'pages' => array(),
            'parent_pages' => array()
        );
 
        foreach ($q->result() as $row) 
        {
            $this->pagesList['pages'][$row->id] = $row;
            $this->pagesList['pages'][$row->slug] = $row;
            $this->pagesList['parent_pages'][$row->parent_link][] = $row->id;
        }
	}
	public function pageData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		$result['page']=$q->row();
		$result['attachments']=array();
		if($q->num_rows())
		{
			$result['attachments']=$this->page_attachments_model->getAttachments($id);
		}
		return $result;
	}
	public function pageDataBySlug($slug)
	{
		//$this->siteServivcesDb->cache_on();
		$this->siteServivcesDb->where("slug",$slug);
		$query = $this->siteServivcesDb->get($this->tableName);
		//$this->siteServivcesDb->cache_off();
		$result['page']=$query->row();
		$result['attachments']=array();
		if($query->num_rows())
		{
			$result['attachments']=$this->page_attachments_model->getAttachments($result['page']->id);
		}
		return $result;
	}

	public function getCount()
	{
		return $this->siteServivcesDb->get($this->tableName)->num_rows();
	}

	public function updateReadCount($pageId,$count)
	{
		$this->siteServivcesDb->where("id",$pageId);
		$this->siteServivcesDb->update($this->tableName,array("reads"=>$count));
		//$this->siteServivcesDb->cache_delete("page","view");
		
	}
	public function getChildren($id)
	{
		$this->siteServivcesDb->where("parent_link",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}
	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(published_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(published_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nCategory: ";
		if(isset($_POST['category']) && is_numeric($_POST['category']))
		{
			$query1->where("FIND_IN_SET(".$_POST['category'].",categories) >",0);
			$preData.=$this->categories_model->categoriesList['categories'][$_POST['category']]->category;
		}
		else
		{
			$preData.="All Categories";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('published_on',$_POST['dir']);
				else
					$query1->order_by('published_on',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/pages_model",$sql,$this->currentUser,"site_services",$_POST,"All Pages",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('published_on',$dir);
		}
		else
		{
			$query1->order_by('published_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$rtn['cols']=array("S. No.","Page ID");

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['published_on']=date("d M Y",strtotime($rtn['data'][$c]['published_on']));
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id,$pageData)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->delete($this->tableName);

		//Delete Categories
		$this->pages_category_model->remove($id);

		//Delete attachments
		if(!empty($pageData['attachments']))
		{
			foreach ($pageData['attachments'] as $attachmentData)
			{
				$this->page_attachments_model->delete($pageData,$attachmentData);
			}
		}
		return 1;
	}

	public function deleteCategory($categoryId)
	{
		$this->siteServivcesDb->where("FIND_IN_SET(".$categoryId.",categories) >",0);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			foreach ($q->result() as $pageRow)
			{
				$categories=explode(',',$pageRow->categories);
				if(($key = array_search($categoryId, $categories)) !== false)
				{
			 		unset($categories[$key]);
				}
				$newCategories=implode(",",$categories);
				$this->siteServivcesDb->where("id",$pageRow->id);
				$this->siteServivcesDb->update($this->tableName,array("categories"=>$newCategories));
			}
		}
	}
	public function save($id,$pageData)
	{
		$oldCats=array();
		$newCats=array();
		$parentId=0;
		if(isset($_POST['parent_id']) && is_numeric($_POST['parent_id']))
			$parentId=$_POST['parent_id'];

		if(isset($_POST['categories']))
			$newCats=$_POST['categories'];

		$categories=implode(",",$newCats);

		$pageSlug=strtolower(url_title($this->general_model->filtertext(trim($_POST["name"]))));
		if(!$id)
		{
			$q=$this->siteServivcesDb->insert($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
                                	'slug'=>$pageSlug,
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'published_on' => date("Y:m:d 00:00:00",strtotime($_POST["published_on"])),
									'seo_keywords' => $this->general_model->filtertext(trim($_POST["seo_keywords"])),
									'seo_description' => $this->general_model->filtertext(trim($_POST["seo_description"])),
									'year'=>date("Y",strtotime($_POST["published_on"])),
									'month'=>date("m",strtotime($_POST["published_on"])),
									'parent_link'=>$parentId,
									'categories'=>$categories,
									'created_on'=>date("Y:m:d H:i:s"),
									'created_by'=>$this->currentUser->id
								)
								);
			$idd=$this->siteServivcesDb->insert_id();
		}
		else
		{
			
			$this->siteServivcesDb->where('id', $id);
			$q=$this->siteServivcesDb->update($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
                                	'slug'=>$pageSlug,
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'published_on' => date("Y:m:d 00:00:00",strtotime($_POST["published_on"])),
									'seo_keywords' => $this->general_model->filtertext(trim($_POST["seo_keywords"])),
									'seo_description' => $this->general_model->filtertext(trim($_POST["seo_description"])),
									'year'=>date("Y",strtotime($_POST["published_on"])),
									'month'=>date("m",strtotime($_POST["published_on"])),
									'parent_link'=>$parentId,
									'categories'=>$categories,
									'modified_on'=>date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id
								)
								);
			$idd=$id;
		}


		$this->load->helper("simple_html_dom");
		$dom=new simple_html_dom();
		$tempContent=$this->general_model->filtertext(trim($_POST["description"]));
		$contentDom=$dom->load($tempContent);
		$images=$contentDom->find('img');
		if(count($images))
		{
			if($idd)
			{
				$existingImages=$this->page_images_model->getImagesByPageId($idd);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$eArray[$eimage->filename]=$eimage->id;
				}
				$editorImages=[];
				foreach ($images as $img_dom) 
				{
					$pathText=$img_dom->attr['src'];
					if(preg_match('/amazon/i',$pathText))
					{
						$editorImages[basename($pathText)]=basename($pathText);
					}
				}
				$diff=array_diff_key($eArray,$editorImages);

				if(count($diff))
				{
					foreach($diff as $ikey)
					$this->page_images_model->deleteImage($idd,$ikey);
				}

			}

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="content/page_images/".$idd."/";
			foreach ($images as $img_dom) 
			{
				$pathText=$img_dom->attr['src'];
				if(preg_match('/amazon/i',$pathText))
					continue;

				$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
				if(file_exists($path))
				{
					$fname=basename($path);
					$extn=pathinfo ($fname,PATHINFO_EXTENSION);
					$newFileName = $idd."_".substr(md5(mt_rand() . microtime()), 0, 16).".".$extn;
					$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
					$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
					unlink($path);

					$imageData=array('filename' => $newFileName,
									'page_id' =>$idd
									);
					$this->page_images_model->insert($imageData);
				}
			}
			$this->siteServicesDb = $this->load->database("site_services",true,false);
			$this->siteServicesDb->where("id",$idd);
			$this->siteServicesDb->update($this->tableName,array("description"=>$tempContent));
		}
		else
		{
			$existingImages=$this->page_images_model->getImagesByPageId($id);
			$eArray=[];
			foreach ($existingImages as $eimage)
			{
				$this->page_images_model->deleteImage($id,$eimage->id);
			}
		}



		if($id)
		{
			$oldCats=array_filter(explode(",",$pageData['page']->categories));
			$catsToBeDeleted=array_diff($oldCats,$newCats);
			if(!empty($catsToBeDeleted))
				$this->pages_category_model->remove($idd,$catsToBeDeleted);
		}
		$catsToBeInserted=array_diff($newCats,$oldCats);
		if(!empty($catsToBeInserted))
			$this->pages_category_model->insert($idd,$catsToBeInserted);

		//$this->siteServivcesDb->cache_delete("page","view");

		if($q)
			return $idd;
		else
			return 0;
	}

	public function checkpageName($name,$id)
	{
		$error=0;

		$slug=url_title($name);

		$this->siteServivcesDb->where("name",$name);
		$this->siteServivcesDb->where("id !=",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		$this->siteServivcesDb->where("slug",$slug);
		$this->siteServivcesDb->where("id !=",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	public function listPublicByCategory($categoryId)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("categories,name,published_on,slug");
		}
		$query1->from($this->tableName);

		$this->siteServivcesDb->where("date(published_on) <=",date("Y:m:d"));

		if($categoryId)
			$query1->where("FIND_IN_SET(".$categoryId.",categories) >",0);

		if(isset($_POST['search_text']) && $_POST['search_text']!='')
		{
			$query1->group_start();
			$query1->like("name",$_POST['search_text']);
			$query1->or_like("description",$_POST['search_text']);
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('published_on',"desc");

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['published_on']=date("d M Y",strtotime($rtn['data'][$c]['published_on']));
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function listReport($excel=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(p1.id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("p1.id as pid,p1.name as ename,p1.slug as eslug,p2.slug as pslug,p1.categories as ecategories");
		}
		$query1->from($this->tableName." as p1");
		$query1->join($this->tableName." as p2","p1.parent_link=p2.id","left");

		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(p1.published_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(p1.published_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nCategory: ";
		if(isset($_POST['category']) && is_numeric($_POST['category']))
		{
			$query1->where("FIND_IN_SET(".$_POST['category'].",p1.categories) >",0);
			$preData.=$this->categories_model->categoriesList['categories'][$_POST['category']]->category;
		}
		else
		{
			$preData.="All Categories";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('p1.published_on',$_POST['dir']);
				else
					$query1->order_by('p1.published_on',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/pages_model",$sql,$this->currentUser,"site_services",$_POST,"Pages Report",$preData,2);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('p1.published_on',$dir);
		}
		else
		{
			$query1->order_by('p1.published_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['link']=base_url."page/view/".$row['eslug'];
			if($row['pslug']!='')
				$rtn['data'][$c]['plink']=base_url."page/view/".$row['pslug'];
			else
				$rtn['data'][$c]['plink']='';
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->pagesExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Page ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Page Title");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Page Link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Categories");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Publish Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SEO Keywords");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SEO Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Views");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,base_url."page/view/".$reportrow->slug);

			$cats=array_filter(explode(",",$reportrow->categories));
			$catString='';
			foreach ($cats as $catId)
			{
				if($catString!='') $catString.=", ";

				if(isset($this->categories_model->categoriesList['categories'][$catId]))
				$catString.=$this->categories_model->categoriesList['categories'][$catId]->category;
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$catString);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->published_on)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->seo_keywords);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->seo_description);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->reads);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function pagesExcelReport($excelData,$objPHPExcel)
	{
		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Page ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Page Title");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Page Link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Categories");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Parent Link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pid);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ename);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,base_url."page/view/".$reportrow->eslug);

			$cats=array_filter(explode(",",$reportrow->ecategories));
			$catString='';
			foreach ($cats as $catId)
			{
				if($catString!='') $catString.=", ";
				if(isset($this->categories_model->categoriesList['categories'][$catId]))
				$catString.=$this->categories_model->categoriesList['categories'][$catId]->category;
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$catString);
			if($reportrow->pslug!='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,base_url."page/view/".$reportrow->pslug);
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>