<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Knowledgebase_model extends CI_Model
{
	var $tableName="knowledgebase";
	var $kbList=array();
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
		$this->fetchKb(1);
		$this->fetchKb(2);
		$this->fetchKb(3);
	}
	private function fetchKb($type)
	{
		$this->siteServivcesDb->select("*");
		$this->siteServivcesDb->where("type",$type);
		$this->siteServivcesDb->order_by("parent, order");
		$q=$this->siteServivcesDb->get($this->tableName);

        $this->kbList[$type] = array(
            'kbs' => array(),
            'parent_kbs' => array()
        );
 
        //build the array lists with data from the kb table
        foreach ($q->result() as $row) 
        {
            //creates entry into kbs array with current category id ie. $kbs['kbs'][1]
            $this->kbList[$type]['kbs'][$row->id] = $row;
            //$this->kbList['kbs'][$row->slug] = $row;
            //creates entry into parent_kbs array. parent_kbs array contains a list of all kbs with children
            $this->kbList[$type]['parent_kbs'][$row->parent][] = $row->id;
        }

        /*print_r($this->kbList[1]['parent_kbs']);
        exit;*/
	}
	public function buildKbAdminDropdown($parent,$level,$type=1,$id,$selectValue)
	{
        if (isset($this->kbList[$type]['parent_kbs'][$parent]))
        {
            foreach ($this->kbList[$type]['parent_kbs'][$parent] as $kbId) 
            {
            	if($id==$kbId) continue;

        		$kbData=$this->kbList[$type]['kbs'][$kbId];
            	?>
            	<option value="<?PHP echo $kbId; ?>"
            		<?PHP
            			if($selectValue==$kbId) echo "selected";
            		?>
            	>
            		<?PHP echo str_repeat("&nbsp;&#45;", $level)." ". htmlentities($kbData->title); ?>
            	</option>
            	<?PHP
                if (isset($this->kbList[$type]['parent_kbs'][$kbId]))
                {
	                $nextLevel=$level+1;
	                $this->buildKbAdminDropdown($kbId,$nextLevel,$type,$id,$selectValue);
            	}
            }
        }
    }
    public function kbData($id)
    {
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
    }
    public function checkUrl($id,$url)
    {
		$this->siteServivcesDb->where("id !=",$id);
		$this->siteServivcesDb->where("source_url",$url);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->num_rows();
    }
    function saveKb($id,$type)
	{
		
		if($id==0)
		{
			$query=$this->siteServivcesDb->insert($this->tableName,
	                                array(
	                                	'title' =>$this->general_model->filtertext(trim($_POST['title'])),
										'source_url' => trim($_POST["source_url"]),
										'description' =>$this->general_model->filtertext(trim($_POST['description'])),
										'kb_url' => "kb/".$_POST['source_url'],
										'created_on' =>date("Y:m:d H:i:s"),
										'created_by'=>$this->currentUser->id,
										"type"=>$type,
										"parent"=>$_POST['parent']
									)
								);
			$kbId=$this->siteServivcesDb->insert_id();
		}
		else
		{
			$this->siteServivcesDb->where('id', $id);
			$query=$this->siteServivcesDb->update($this->tableName,
                                array(
                                		'title' =>$this->general_model->filtertext(trim($_POST['title'])),
										'source_url' => trim($_POST["source_url"]),
										'description' =>$this->general_model->filtertext(trim($_POST['description'])),
										'kb_url' => "kb/".$_POST['source_url'],
										'modified_on' =>date("Y:m:d H:i:s"),
										'modified_by'=>$this->currentUser->id,
										"parent"=>$_POST['parent']
									)
								);
				
			$kbId=$id;
		}
		if($query)
		{
			return $kbId;
		}
		else return 0;
	}
	public function listKb($excel=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($excel==1 || $i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);

		$preData="Search Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nKB Type: ";
		if(isset($_POST['type']) && is_numeric($_POST['type']) && in_array($_POST['type'],array(1,2,3)))
		{
			$query1->where("type",$_POST['type']);
			if($_POST['type']==1)
			{
				$preData.="Admin KB";
			}
			if($_POST['type']==2)
			{
				$preData.="User KB";
			}
			if($_POST['type']==3)
			{
				$preData.="Guest KB";
			}
		}
		else
		{
			$preData.="All KB";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('order',$_POST['dir']);
				else
					$query1->order_by('order',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/knowledgebase_model",$sql,$this->currentUser,"site_services",$_POST,"All KB",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('order',$dir);
		}
		else
		{
			$query1->order_by('order',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	function delete($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$query = $this->siteServivcesDb->delete($this->tableName);

		$this->siteServivcesDb->where("parent",$id);
		$this->siteServivcesDb->update($this->tableName,array("parent"=>0));

		if($query) return 1;
		else return 0;
	}
	public function updateOrder($id,$value)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array('order'=>$value));
	}
	//=======================PUBLIC =======================================================///

    public function kbDataBySlug($slug)
    {
		$this->siteServivcesDb->where("source_url",$slug);
		$this->siteServivcesDb->where("status",1);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
    }

    public function searchKb($searchText,$type)
    {
    	$where=" (title like '%".$searchText."%' or description like '%".$searchText."%') ";
    	$this->siteServivcesDb->where($where, NULL, FALSE);
		//$this->siteServivcesDb->like("title",$searchText,"both");
		//$this->siteServivcesDb->or_like("description",$searchText,"both");
		$this->siteServivcesDb->where("status",1);
		if($type==2)
			$this->siteServivcesDb->where_in("type",array(2,3));
		if($type==3)
			$this->siteServivcesDb->where("type",3);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
    }

    public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Title");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Source URL");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"KB URL");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$type="Admin KB";
			if($reportrow->type==2)
				$type="User KB";
			if($reportrow->type==3)
				$type="Guest KB";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$type);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->title);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,base_url.$reportrow->source_url);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,base_url.$reportrow->kb_url);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>