<?PHP
class Events_Model extends CI_Model 
{
	var $tableName="events";
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function eventData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		$result['event']=$q->row();
		$result['images']=array();
		$result['attachments']=array();
		if($q->num_rows())
		{
			$result['images']=$this->events_images_model->getImages($id);
			$result['attachments']=$this->event_attachments_model->getAttachments($id);
		}
		return $result;
	}
	public function checkEventId($id,$ashram_id)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->where("ashram_id",$ashram_id);
		$q=$this->siteServivcesDb->get($this->tableName);
		$result['event']=$q->row();
		return $result;
	}
	public function eventDataBySlug($slug)
	{
		//$this->siteServivcesDb->cache_on();
		$this->siteServivcesDb->where("slug",$slug);
		$query = $this->siteServivcesDb->get($this->tableName);
		//$this->siteServivcesDb->cache_off();
		$result['event']=$query->row();
		$result['images']=array();
		$result['attachments']=array();
		$result['children']=array();
		if($query->num_rows())
		{
			$result['images']=$this->events_images_model->getImages($result['event']->id);
			$result['attachments']=$this->event_attachments_model->getAttachments($result['event']->id);

			$this->siteServivcesDb->select("year,name,slug,start_date,end_date");
			$this->siteServivcesDb->where("parent_link",$result['event']->id);
			$qc = $this->siteServivcesDb->get($this->tableName);
			$result['children']=$qc->result();
		}

		return $result;
	}
	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->siteServivcesDb->where('ashram_id',$this->currentUser->ashram_id);
		}
		return $this->siteServivcesDb->get($this->tableName)->num_rows();
	}
	public function changeStatus($id,$status)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array("status"=>$status));
		return 1;
	}
	public function changenotifyStatus($id,$status)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array("mobile_notification"=>$status));
		return 1;
	}
	public function getYearMonths($ashramId=0,$satsangId=0)
	{
		$this->siteServivcesDb->select("year,month");
		$this->siteServivcesDb->group_by("year, month");
		$this->siteServivcesDb->order_by("year","desc");
		$this->siteServivcesDb->order_by("month","asc");
		if($ashramId)
		{
			$this->siteServivcesDb->where("ashram_id",$ashramId);
		}
		if($satsangId)
		{
			$this->siteServivcesDb->where("satsang_id",$satsangId);
		}
		$q=$this->siteServivcesDb->get($this->tableName);
		$result['years']=array();
		$result['months']=array();
		foreach ($q->result() as $row)
		{
			if(!in_array($row->year,$result['years']))
			{
				$result['years'][]=$row->year;
			}
			$result['months'][$row->year][]=$row->month;
		}
		return $result;
	}
	public function updateReadCount($eventId,$count)
	{
		$this->siteServivcesDb->where("id",$eventId);
		$this->siteServivcesDb->update($this->tableName,array("reads"=>$count));
		//$this->siteServivcesDb->cache_delete("event","view");
		
	}
	public function getChildren($id)
	{
		$this->siteServivcesDb->where("parent_link",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}
	public function listAdmin($ashramId,$excel=0)
	{
		$ashramData = "";
		if(is_numeric($ashramId) && $ashramId!=0)
			$ashramData=$this->ashrams_model->ashramData($ashramId);

		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("id,name,ashram_id,description,start_date,end_date,location,year,month,slug,categories,reads,status,seo_keywords,seo_description,mobile_notification");
		}
		if(is_numeric($ashramId) && $ashramId!=0) $query1->where("ashram_id",$ashramId);
		$query1->from($this->tableName);

		/*if($this->currentUser->roles!=1)
		{
			$query1->where("created_by",$this->currentUser->id);
		}*/
		
		if(is_numeric($ashramId) && $ashramId!=0)
			$preData="Ashram: ".$ashramData->name;
		else
			$preData="Ashram: N/A";

		$preData.="\nSearch Keywords: ";
		
		if($this->input->post('search_text')!='' &&
			in_array($this->input->post('search_col'),$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$this->input->post('search_col')];
			$query1->like($this->input->post('search_col'),trim($this->input->post('search_text')));
				$preData.=" containing ";
			/* if($this->input->post('wild')=='starts')
			{
				$query1->like($this->input->post('search_col'),trim($this->input->post('search_text')),'after');
				$preData.=" starting with ";
			}
			else if($this->input->post('wild')=='ends')
			{
				$query1->like($this->input->post('search_col'),trim($this->input->post('search_text')),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($this->input->post('search_col'),trim($this->input->post('search_text')));
				$preData.=" containing ";
			} */
			$preData.='"'.$this->input->post('search_text').'"';
		}

		
		$preData.="\nFrom Date: ";
		if($this->input->post('from_date')!='')
		{
			$query1->where("DATE(start_date) >=",date("Y-m-d",strtotime($this->input->post('from_date'))));
			$preData.=$this->input->post('from_date');
		}
		
		$preData.="\nTo Date: ";
		if($this->input->post('to_date')!='')
		{
			$query1->where("DATE(start_date) <=",date("Y-m-d",strtotime($this->input->post('to_date'))));
			$preData.=$this->input->post('to_date');
		}

		$preData.="\nCategory: ";
		if(is_numeric($this->input->post('category')))
		{
			$query1->where("FIND_IN_SET(".$this->input->post('category').",categories) >",0);
			$preData.=$this->categories_model->categoriesList['categories'][$this->input->post('category')]->category;
		}
		else
		{
			$preData.="All Categories";
		}

		if($excel==1)
		{
			if(in_array($this->input->post('order_by'),$GLOBALS['current_acl']['sort_columns']))
			{
				if(in_array($this->input->post('dir'),$GLOBALS['current_acl']['dir']))
					$query1->order_by($this->input->post('order_by'),$this->input->post('dir'));
				else
					$query1->order_by($this->input->post('order_by'),'desc');
			}
			else
			{
				if(in_array($this->input->post('dir'),$GLOBALS['current_acl']['dir']))
					$query1->order_by('start_date',$this->input->post('dir'));
				else
					$query1->order_by('start_date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","content/events_model",$sql,$this->currentUser,"site_services",$_POST,"All Events",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(in_array($this->input->post('order')[0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$this->input->post('order')[0]['dir'];


		$order_by='';
		if(is_numeric($this->input->post('order')[0]['column']))
		{
			$col_num=round(abs($this->input->post('order')[0]['column']));
			$col_name=$this->input->post('columns')[$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('start_date',$dir);
		}
		else
		{
			$query1->order_by('start_date',$dir);
		}

		$start=0;
		$length=10;
		if(is_numeric($this->input->post('start')))
		{
			if(round(abs($this->input->post('start')))%10==0)
			$start=round(abs($this->input->post('start')));
		}
		if(is_numeric($this->input->post('length')) && in_array($this->input->post('length'),array(10,20,50,100)))
		{
			$length=abs($this->input->post('length'));
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			foreach ($row as $key => $value)
			{
				$row[$key]=htmlentities($value);
			}

			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['ashram_name'] = "N/A";
			$ashramData2=$this->ashrams_model->ashramData($row['ashram_id']);
			if(!empty($ashramData2)) $rtn['data'][$c]['ashram_name'] = $ashramData2->name;
			if($rtn['data'][$c]['ashram_id'] > 0 && !empty($ashramData))
			{
				$rtn['data'][$c]['ashram_name'] = $ashramData->name;
			}
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_date']=date("d M Y",strtotime($rtn['data'][$c]['end_date']));
			$rtn['data'][$c]['cssclass']='';
			if($row['status']==0)
				$rtn['data'][$c]['cssclass']='event-hidden';

			//getting notification data
			$notificationData = $this->mobileNotifications_model->getNotificationIDBasedOnService($row['id'],'events');
			$rtn['data'][$c]['notification_id'] = -1;
			if(!empty($notificationData)){
				$rtn['data'][$c]['notification_id'] = 0;
				if($notificationData->is_sent == 0){
					$rtn['data'][$c]['notification_id'] = $notificationData->id;
				}
			}
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id,$eventData)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->delete($this->tableName);

		//Delete Categories
		$this->events_category_model->remove($id);

		//Delete images
		if(!empty($eventData['images']))
		{
			foreach ($eventData['images'] as $imageData)
			{
				$this->events_images_model->delete($eventData,$imageData);
			}
		}

		//Delete attachments
		if(!empty($eventData['attachments']))
		{
			foreach ($eventData['attachments'] as $attachmentData)
			{
				$this->event_attachments_model->delete($eventData,$attachmentData);
			}
		}

		return 1;
	}

	public function deleteCategory($categoryId)
	{
		$this->siteServivcesDb->where("FIND_IN_SET(".$categoryId.",categories) >",0);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			foreach ($q->result() as $eventRow)
			{
				$categories=explode(',',$eventRow->categories);
				if(($key = array_search($categoryId, $categories)) !== false)
				{
			 		unset($categories[$key]);
				}
				$newCategories=implode(",",$categories);
				$this->siteServivcesDb->where("id",$eventRow->id);
				$this->siteServivcesDb->update($this->tableName,array("categories"=>$newCategories));
			}
		}
	}
	public function save($id,$eventData)
	{

		$oldCats=array();
		$newCats=array();
		$parentId=0;
		if($this->input->post('categories'))
			$newCats=$this->input->post('categories');

		if(is_numeric($this->input->post('parent_id')))
			$parentId=$this->input->post('parent_id');


		$categories=implode(",",$newCats);
		$eventSlug=strtolower(url_title($this->general_model->filtertext(trim($this->input->post("name")))));
		if(!$id)
		{

			$ashram_id=$this->session->userdata('ashramId');
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($this->currentUser->ashram_id)
					$ashram_id=$this->currentUser->ashram_id;
				else if($this->currentUser->satsang_id)
					$ashram_id=$this->currentUser->satsang_id;
			}
			$ashram_id = isset($ashram_id)?$ashram_id:0;
			
			$q=$this->siteServivcesDb->insert($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($this->input->post("name"))),
                                	'slug'=>$eventSlug,
                                	'location' => $this->general_model->filtertext(trim($this->input->post("location"))),
									'description' => $this->general_model->filtertext(trim($this->input->post("description",false))),
									'start_date' => date("Y:m:d 00:00:00",strtotime($this->input->post("start_date"))),
									'end_date' => date("Y:m:d 00:00:00",strtotime($this->input->post("end_date"))),
									'seo_keywords' => $this->general_model->filtertext(trim($this->input->post("seo_keywords"))),
									'seo_description' => $this->general_model->filtertext(trim($this->input->post("seo_description"))),
									'year'=>date("Y",strtotime($this->input->post("start_date"))),
									'month'=>abs(date("m",strtotime($this->input->post("start_date")))),
									'parent_link'=>$parentId,
									'categories'=>$categories,
									'created_on'=>date("Y:m:d H:i:s"),
									'created_by'=>$this->currentUser->id,
									'ashram_id'=>$ashram_id,
									'mobile_notification'=>0
								)
								);
			$idd=$this->siteServivcesDb->insert_id();
			//saving live updates content for notifications
			$this->mobileNotifications_model->addNotification('Events',$this->general_model->filtertext(trim($_POST['name'])),$idd,'events');
		}
		else
		{
			
			$this->siteServivcesDb->where('id', $id);
			$q=$this->siteServivcesDb->update($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($this->input->post("name"))),
                                	'slug'=>$eventSlug,
                                	'location' => $this->general_model->filtertext(trim($this->input->post("location"))),
									'description' => $this->general_model->filtertext(trim($this->input->post("description",false))),
									'start_date' => date("Y:m:d 00:00:00",strtotime($this->input->post("start_date"))),
									'end_date' => date("Y:m:d 00:00:00",strtotime($this->input->post("end_date"))),
									'seo_keywords' => $this->general_model->filtertext(trim($this->input->post("seo_keywords"))),
									'seo_description' => $this->general_model->filtertext(trim($this->input->post("seo_description"))),
									'year'=>date("Y",strtotime($this->input->post("start_date"))),
									'month'=>abs(date("m",strtotime($this->input->post("start_date")))),
									'parent_link'=>$parentId,
									'categories'=>$categories,
									'modified_on'=>date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id
								)
								);
			$idd=$id;
		}




		$this->load->helper("simple_html_dom");
		$dom=new simple_html_dom();
		$tempContent=$this->general_model->filtertext(trim($this->input->post("description",false)));
		$contentDom=$dom->load($tempContent);
		$images=$contentDom->find('img');
		if(count($images))
		{
			if($idd)
			{
				$existingImages=$this->events_description_images_model->getImagesByEventId($idd);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$eArray[$eimage->filename]=$eimage->id;
				}
				$editorImages=[];
				foreach ($images as $img_dom) 
				{
					$pathText=$img_dom->attr['src'];
					if(preg_match('/amazon/i',$pathText))
					{
						$editorImages[basename($pathText)]=basename($pathText);
					}
				}
				$diff=array_diff_key($eArray,$editorImages);

				if(count($diff))
				{
					foreach($diff as $ikey)
					$this->events_description_images_model->deleteImage($idd,$ikey);
				}

			}

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="content/events_images/".$idd."/";
			foreach ($images as $img_dom) 
			{
				$pathText=$img_dom->attr['src'];
				if(preg_match('/amazon/i',$pathText))
					continue;

				$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
				if(file_exists($path))
				{
					$fname=basename($path);
					$extn=pathinfo ($fname,PATHINFO_EXTENSION);
					$newFileName = $idd."_".substr(md5(mt_rand() . microtime()), 0, 16).".".$extn;
					$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
					$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
					unlink($path);

					$imageData=array('filename' => $newFileName,
									'event_id' =>$idd
									);
					$this->events_description_images_model->insert($imageData);
				}
			}
			$this->siteServicesDb = $this->load->database("site_services",true,false);
			$this->siteServicesDb->where("id",$idd);
			$this->siteServicesDb->update($this->tableName,array("description"=>$tempContent));
		}
		else
		{
			$existingImages=$this->events_description_images_model->getImagesByEventId($id);
			$eArray=[];
			foreach ($existingImages as $eimage)
			{
				$this->events_description_images_model->deleteImage($id,$eimage->id);
			}
		}





		if($id)
		{
			$oldCats=array_filter(explode(",",$eventData['event']->categories));
			$catsToBeDeleted=array_diff($oldCats,$newCats);
			if(!empty($catsToBeDeleted))
				$this->events_category_model->remove($idd,$catsToBeDeleted);
		}
		$catsToBeInserted=array_diff($newCats,$oldCats);
		if(!empty($catsToBeInserted))
			$this->events_category_model->insert($idd,$catsToBeInserted);

		$this->latestEventsRender();

		if($q)
			return $idd;
		else
			return 0;
	}

	public function checkEventName($name,$id)
	{
		$ashram_id=$this->session->userdata('ashramId');
		if($this->currentUser->ashram_id)
			$ashram_id=$this->currentUser->ashram_id;
		else if($this->currentUser->satsang_id)
			$ashram_id=$this->currentUser->satsang_id;

		$ashram_id = !empty($ashram_id)?$ashram_id:0;

		$error=0;

		$slug=url_title($name);
		$this->siteServivcesDb->where('ashram_id',$ashram_id);
		$this->siteServivcesDb->where("name",$name);
		$this->siteServivcesDb->where("id !=",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		$this->siteServivcesDb->where('ashram_id',$ashram_id);
		$this->siteServivcesDb->where("slug",$slug);
		$this->siteServivcesDb->where("id !=",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	public function listPublicByCategory($categoryId,$ashramId='')
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("categories,name,start_date,slug,year");
		}
		$query1->from($this->tableName);
		$query1->where("status",1);

		if($ashramId)
			$query1->where("ashram_id",$ashramId);
		else
			$query1->where("ashram_id",0);
		
		if($categoryId)
			$query1->where("FIND_IN_SET(".$categoryId.",categories) >",0);

		if($this->input->post('search_text')!='')
		{
			$query1->group_start();
			$query1->like("name",$this->input->post('search_text'));
			$query1->or_like("description",$this->input->post('search_text'));
			$query1->or_like("location",$this->input->post('search_text'));
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('start_date',"desc");

		$start=0;
		$length=10;
		if(is_numeric($this->input->post('start')))
		{
			if(round(abs($this->input->post('start')))%10==0)
			$start=round(abs($this->input->post('start')));
		}
		if(is_numeric($this->input->post('length')) && in_array($this->input->post('length'),array(10,20,50)))
		{
			$length=abs($this->input->post('length'));
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			//$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function listPublic()
	{
		$i=0;

		$query1=$this->siteServivcesDb;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("id,name,description,start_date,end_date,location,month,year,slug");
		}
		
		$query1->from($this->tableName);
		$query1->where("status",1);
		if(is_numeric($this->input->post('ashram_id')) && $this->input->post('ashram_id'))
		{
			$query1->where("ashram_id",$this->input->post('ashram_id'));
		}
		else if(is_numeric($this->input->post('satsang_id')) && $this->input->post('satsang_id'))
		{
			$query1->where("satsang_id",$this->input->post('satsang_id'));
		}
		else
		{
			$query1->where("satsang_id",0);
			$query1->where("ashram_id", default_ashram_id);
		}

		if(is_numeric($this->input->post('month')) && in_array($this->input->post('month'),array(1,2,3,4,5,6,7,8,9,10,11,12)))
		{
			$query1->where("month",trim($this->input->post('month')));
		}

		if(is_numeric($this->input->post('year')))
		{
			$query1->where("year",trim($this->input->post('year')));
		}
		
		if(trim($this->input->post('search_text'))!='')
		{
			$query1->group_start();
			$query1->like("name",$this->input->post('search_text'));
			$query1->or_like("description",$this->input->post('search_text'));
			$query1->or_like("location",$this->input->post('search_text'));
			$query1->group_end();
		}

		if(is_numeric($this->input->post('category')))
		{
			$query1->where("FIND_IN_SET(".$this->input->post('category').",categories) >",0);
		}
		
		
		$per_page=10;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if($this->input->post('per_page'))
				$_GET['per_page']=$this->input->post('per_page');

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			
			goto step1;
		}
		
		if(is_numeric($this->input->post('per_page')) && $this->input->post('per_page'))
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($this->input->post('per_page')))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($this->input->post('per_page'))==0)
				$n=0;
				else
				$n=(abs($this->input->post('per_page'))-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("start_date","desc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();
		$colors=array("red","blue","orange","green","purple");
		$ii=0;
		$ids=array();
		foreach ($rtn['res'] as $key=> $row) 
		{
			$ids[]=$row->id;
		}
		if(!empty($ids))
		{
			$resImages=array();
			$eImages=$this->events_images_model->getImageByIds($ids);
			foreach ($eImages as $iRow)
			{
				$resImages[$iRow->event_id]=$iRow->filename;
			}

			foreach ($rtn['res'] as $key=> $row) 
			{
				if($ii==5)
					$ii=0;
				$rtn['res'][$key]->start_date_raw=date("d M Y",strtotime($rtn['res'][$key]->start_date));
				$rtn['res'][$key]->end_date_raw=date("d M Y",strtotime($row->end_date));
				$rtn['res'][$key]->start_date=date("d M Y (D)",strtotime($rtn['res'][$key]->start_date));
				
				$rtn['res'][$key]->end_date=date("d M Y (D)",strtotime($rtn['res'][$key]->end_date));
				$rtn['res'][$key]->color=$colors[$ii];
				if(isset($resImages[$row->id]))
				{
					$rtn['res'][$key]->thumb=$resImages[$row->id];
					$rtn['res'][$key]->thumb_url=aws_s3_base_url."content/event_images/".$row->id."/thumb_".$resImages[$row->id];
				}
				else
				{
					$rtn['res'][$key]->thumb='';
					$rtn['res'][$key]->thumb_url='';
				}
				$rtn['res'][$key]->aws_s3_base_url=aws_s3_base_url;
				$ii++;
			}
		}

		return $rtn;
	}
	//==========================FB read Crons =================================================

	public function getFBPosts()
	{
		$fb_config = array(
			'appId'  =>fb_app_id,
			'secret' => fb_app_secret
		);
		$CI=&get_instance();
		$CI->load->library('facebook',$fb_config);

		$CI->facebook->setAccessToken(fb_access_token);

		$this->siteServivcesDb->where("album_id",0);
		$this->siteServivcesDb->order_by("id","desc");
		$this->siteServivcesDb->limit(1);
		$q1=$this->siteServivcesDb->get("event_fb_pagination");
		$r1=$q1->row();
		$params=$r1->value;
		$res['count']=0;

		$db_operation=1;

		$page_info = $CI->facebook->api("/".fb_page_id."/feed".$params,array(
               'fields' => 'id,name,description,attachments,link,type,story,picture,message,status_type,updated_time,created_time'
           ));

		$cnt=0;

		foreach($page_info['data'] as $key=>$post)
		{
			//if($album['name']=='Timeline Photos') continue;
			if(isset($post['story']))
			if(preg_match('/to the album/i', $post['story']))
				continue;

			$this->siteServivcesDb->where("fb_id",$post['id']);
			$q2=$this->siteServivcesDb->get("events_fb_map");
			if($q2->num_rows())
			{
				continue;
			}

			$this->siteServivcesDb->where("fb_id",$post['id']);
			$q3=$this->siteServivcesDb->get("events");
			if($q3->num_rows())
			{
				continue;
			}
			
			if(!isset($post['message']))
			{
				continue;
			}

			$event_name="FB-".$post['created_time'];
			$slug=strtolower(url_title($event_name));

			$this->siteServivcesDb->where("slug",$slug);
			$q4=$this->siteServivcesDb->get("events");
			if($q4->num_rows())
			{
				continue;
			}
			
			if(isset($album['location']))
			{
				$loc=$album['location'];
			}
			else
			{
				$loc='';
			}

			if(isset($post['status_type']))
			{
				$stype=$post['status_type'];
			}
			else
			{
				$stype='';
			}

			if(isset($post['description']))
			{
				$description=$post['description'];
			}
			else
			{
				$description='';
			}

			if(isset($post['link']))
			{
				$link=$post['link'];
			}
			else
			{
				$link='';
			}
			
			try
			{
				$data=array(
								"name"=>$event_name,
								'slug'=>$slug,
								'start_date'=>date("Y:m:d H:i:s",strtotime($post['created_time'])),
								'end_date'=>date("Y:m:d H:i:s",strtotime($post['created_time'])),
								'year'=>date("Y",strtotime($post['created_time'])),
								'created_by'=>1,
								'modified_by'=>1,
								'description'=>$post['message'],
								'seo_keywords'=>substr($post['message'],0,500),
								'seo_description'=>substr($post['message'],0,500),
								'location'=>$loc,
								'fb_id'=>$post['id'],
								'fb_data'=>serialize($post),
								'fb_status_type'=>$stype,
								'fb_link'=>$link,
								'import_from_fb'=>1,
								'status'=>0,
								'created_on'=>date("Y:m:d H:i:s")
								);

				if($db_operation==1)
				{
					$this->siteServivcesDb->insert("events",$data);
					$eid=$this->siteServivcesDb->insert_id();
				}
			}
			catch(Exception $e)
			{
				continue;
			}

			if($db_operation==1)
			{
				$this->siteServivcesDb->insert("events_fb_map",
								array(
										'event_id'=>$eid,
										'fb_id'=>$post['id']
									));
				
				$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
				$path=$_SERVER['DOCUMENT_ROOT']."/temp/";
				$amazonUri="content/event_images/".$eid."/";
			}
			if(isset($post['type']))
			{
				if($post['type']=="photo")
				{
					$sub=1;
				}
			}
			$ord=0;
			
			if(isset($post['attachments']) && isset($post['attachments']['data'][0]['subattachments']))
			{
				if(isset($post['attachments']))
				foreach($post['attachments']['data'][0]['subattachments']['data'] as $imgkey=>$img)
				{
					
					$bname=basename($img['media']['image']['src']);

					$temp=explode("?",$bname);
					$fname=$temp[0];
					$ext=pathinfo ($fname,PATHINFO_EXTENSION);

					if(strtolower($ext)=='jpg')
					{
					
						if(isset($img['name']))
							$name=$img['name'];
						else
							$name=$bname;
					
						if($db_operation==1)
						{
							$newname='event_'.$eid."_".substr(md5(mt_rand()), 0, 16).".".$ext;

							file_put_contents($path.$newname, file_get_contents($img['media']['image']['src']));
							
							//echo $path.$newname;
							
							$this->general_model->create_thumb_150($path.$newname,$path."thumb_".$newname); //thumbnail creating
							

							$this->s3->putObjectFile($path.$newname,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
										
							$this->s3->putObjectFile($path."thumb_".$newname,aws_s3_bucket_name,$amazonUri."thumb_".$newname,S3::ACL_PUBLIC_READ, array(), array());
							
							list($iWidth,$iHeight) = getimagesize($path.$newname);
							unlink($path.$newname);
							unlink($path."thumb_".$newname);
										
							$this->siteServivcesDb->insert("events_images",
											array(
												'event_id'=>$eid,
												'filename'=>$newname,
												'width'=>$iWidth,
												'height'=>$iHeight,
												'created_on'=>date("Y:m:d H:i:s",strtotime($post['created_time'])),
												'description'=>$newname,
												'order'=>$ord
											));
						}
					}
					$ord++;				
				}
			}
			else
			{
				if(isset($post['attachments']))
				foreach($post['attachments']['data'] as $imgkey=>$img)
				{
					if(isset($img['media']) && isset($img['media']['image']['src']))
					{

						$bname=basename($img['media']['image']['src']);

						//echo $bname;
						$temp=explode("?",$bname);
						$fname=$temp[0];
						$ext=pathinfo ($fname,PATHINFO_EXTENSION);

						if(strtolower($ext)=='jpg')
						{
						
							if(isset($img['name']))
							$name=$img['name'];
							else
							$name=$bname;

							

							if($db_operation==1)
							{
								
								$newname='event_'.$eid."_".substr(md5(mt_rand()), 0, 16).".".$ext;

								file_put_contents($path.$newname, file_get_contents($img['media']['image']['src']));
								
								$this->general_model->create_thumb_150($path.$newname,$path."thumb_".$newname); //thumbnail creating
								
								$this->s3->putObjectFile($path.$newname,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
											
								$this->s3->putObjectFile($path."thumb_".$newname,aws_s3_bucket_name,$amazonUri."thumb_".$newname, 
											S3::ACL_PUBLIC_READ, array(), array());
								
								list($iWidth,$iHeight) = getimagesize($path.$newname);
								unlink($path.$newname);
								unlink($path."thumb_".$newname);
											
								$this->siteServivcesDb->insert("events_images",
													array(
														'event_id'=>$eid,
														'filename'=>$newname,
														'width'=>$iWidth,
														'height'=>$iHeight,
														'created_on'=>date("Y:m:d H:i:s",strtotime($post['created_time'])),
														'description'=>$fname,
														'order'=>$ord
													));
							}
						}
					}
					$ord++;				
				}
			}
			$cnt++;
		}
		$res['count']=$cnt;
		if($db_operation==1)
		{
			if($cnt>0 && isset($page_info['paging']['next']))
			{
				$temp=explode("?", $page_info['paging']['next']);
				$this->siteServivcesDb->where("album_id",0);
				$this->siteServivcesDb->update("event_fb_pagination",
				array("value"=>"?".$temp[1]));
			}
			else
			{
				$this->siteServivcesDb->where("album_id",0);
				$this->siteServivcesDb->update("event_fb_pagination",
				array("value"=>'?limit=25'));
			}
		}
		echo json_encode($res);
	}

	public function getFBAlbums()
	{
		$fb_config = array(
			'appId'  =>fb_app_id,
			'secret' => fb_app_secret
		);
		$CI=&get_instance();
		$CI->load->library('facebook',$fb_config);

		$CI->facebook->setAccessToken(fb_access_token);

		$this->siteServivcesDb->where("album_id",1);
		$this->siteServivcesDb->order_by("id","desc");
		$this->siteServivcesDb->limit(1);
		$q1=$this->siteServivcesDb->get("event_fb_pagination");
		$r1=$q1->row();
		$params=$r1->value;

		$page_info = $this->facebook->api("/".fb_page_id."/albums".$params,array(
               'fields' => 'id,name,description,location,link,photos.fields(id,name,images,description)'
           ));
		$excluded=array("10151550988573450","10150175175158450");

		$cnt=0;
		$res['count']=0;
		$res['album_data']=array();
		foreach($page_info['data'] as $key=>$album)
		{
			$res['album_data']['id']=$album['id'];
			if(in_array($album['id'], $excluded))
			{
				continue;
			}

			$this->siteServivcesDb->where("fb_id",$album['id']);
			$q2=$this->siteServivcesDb->get("events_fb_map");
			if($q2->num_rows())
			{
				continue;
			}

			$this->siteServivcesDb->where("fb_id",$album['id']);
			$q3=$this->siteServivcesDb->get("events");
			if($q3->num_rows())
			{
				continue;
			}
			
			$event_name=$album['name']."-FB-".$album['created_time'];
			$event_slug=substr($album['name'],0,30)."-FB-".$album['created_time'];
			$slug=strtolower(url_title(trim($event_slug)));

			if(isset($album['location']))
			{
				$loc=$album['location'];
			}
			else
			{
				$loc='';
			}

			if(isset($album['description']))
			{
				$description=$album['description'];
			}
			else
			{
				$description='';
			}

			if(isset($album['link']))
			{
				$link=$album['link'];
			}
			else
			{
				$link='';
			}
			
			$this->siteServivcesDb->insert("events",
								array(
									"name"=>$event_name,
									'slug'=>$slug,
									'start_date'=>date("Y:m:d H:i:s",strtotime($album['created_time'])),
									'end_date'=>date("Y:m:d H:i:s",strtotime($album['created_time'])),
									'year'=>date("Y",strtotime($album['created_time'])),
									'created_by'=>1,
									'modified_by'=>1,
									'seo_keywords'=>$album['name'],
									'seo_description'=>$album['name'],
									'description'=>$description,
									'location'=>$loc,
									'fb_id'=>$album['id'],
									'fb_data'=>serialize($album),
									'fb_status_type'=>'album',
									'fb_link'=>$link,
									'import_from_fb'=>1,
									'status'=>0,
									'created_on'=>date("Y:m:d H:i:s")
								)
							);
						
			$eid=$this->siteServivcesDb->insert_id();
			
			$this->siteServivcesDb->insert("events_fb_map",
								array(
									'event_id'=>$eid,
									'fb_id'=>$album['id']
									));
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			$amazonUri="content/event_images/".$eid."/";

			$path=$_SERVER['DOCUMENT_ROOT']."/temp/";
			
			$ord=0;

			foreach($album['photos']['data'] as $imgkey=>$img)
			{
				
				$bname=basename($img['images'][0]['source']);
				$temp=array_filter(explode("?",$bname));
				$fname=$temp[0];
				
				if(isset($img['name']))
					$name=$img['name'];
				else
					$name=$bname;
				
				$ext=pathinfo ($fname,PATHINFO_EXTENSION);
				$newname='dattapeetham_'.md5(mt_rand() . microtime()).".".$ext;
				
				file_put_contents($path.$newname, file_get_contents($img['images'][0]['source']));
				
				$this->general_model->create_thumb_150($path.$newname,$path."thumb_".$newname); //thumbnail creating
				
				$this->s3->putObjectFile($path.$newname,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
							
				$this->s3->putObjectFile($path."thumb_".$newname,aws_s3_bucket_name,$amazonUri."thumb_".$newname, 
											S3::ACL_PUBLIC_READ, array(), array());
				
				list($iWidth,$iHeight) = getimagesize($path.$newname);
				unlink($path.$newname);
				unlink($path."thumb_".$newname);
				
				$this->siteServivcesDb->insert("events_images",
										array(
										'event_id'=>$eid,
										'fb_id'=>$img['id'],
										'width'=>$iWidth,
										'height'=>$iHeight,
										'filename'=>$newname,
										'created_on'=>date("Y:m:d H:i:s",strtotime($album['created_time'])),
										'description'=>$newname,
										'order'=>$ord
								));
				$ord++;				
			}
			
			$res['album_data']['name']=$event_name;
			$res['album_data']['photos']=$ord;
			$cnt++;
		}

		$res['count']=$cnt;
		$res['flag']=1;
		if(in_array($album['id'], $excluded) && $cnt==0)
		{
			$temp=explode("?", $page_info['paging']['next']);
			$this->siteServivcesDb->where("album_id",1);
			$this->siteServivcesDb->update("event_fb_pagination",
			array("value"=>"?".$temp[1]));
		}
		else if($cnt>0 && isset($page_info['paging']['next']))
		{
			$temp=explode("?", $page_info['paging']['next']);
			$this->siteServivcesDb->where("album_id",1);
			$this->siteServivcesDb->update("event_fb_pagination",
			array("value"=>"?".$temp[1]));
		}
		else
		{
			$res['flag']=0;
			$this->siteServivcesDb->where("album_id",1);
			$this->siteServivcesDb->update("event_fb_pagination",
			array("value"=>'?limit=1'));
		}
		echo json_encode($res);
	}

	//==========================Excel reports =================================================
	public function listReport($excel=0,$ashramId)
	{
		$ashramData = "";
		if($ashramId)
			$ashramData=$this->ashrams_model->ashramData($ashramId);
		
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(e1.id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("e1.id as eid,e1.name as ename,e1.slug as eslug,e1.year as eyear,e2.slug as pslug,e2.year as pyear,e1.categories as ecategories,e1.ashram_id");
		}
		$query1->from($this->tableName." as e1");
		$query1->join($this->tableName." as e2","e1.parent_link=e2.id","left");

		$query1->where("e1.ashram_id",$ashramId);

		if($ashramId)
			$preData="Ashram: ".$ashramData->name;
		else
			$preData="Ashram: N/A";

		$preData.="\nSearch Keywords: ";
		
		if($this->input->post('search_text')!='' &&
			in_array($this->input->post('search_col'),$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$this->input->post('search_col')];
			$query1->like($this->input->post('search_col'),trim($this->input->post('search_text')));
				$preData.=" containing ";
			/* if($this->input->post('wild')=='starts')
			{
				$query1->like($this->input->post('search_col'),trim($this->input->post('search_text')),'after');
				$preData.=" starting with ";
			}
			else if($this->input->post('wild')=='ends')
			{
				$query1->like($this->input->post('search_col'),trim($this->input->post('search_text')),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($this->input->post('search_col'),trim($this->input->post('search_text')));
				$preData.=" containing ";
			} */
			$preData.='"'.$this->input->post('search_text').'"';
		}

		
		$preData.="\nFrom Date: ";
		if($this->input->post('from_date')!='')
		{
			$query1->where("DATE(e1.start_date) >=",date("Y-m-d",strtotime($this->input->post('from_date'))));
			$preData.=$this->input->post('from_date');
		}
		
		$preData.="\nTo Date: ";
		if($this->input->post('to_date')!='')
		{
			$query1->where("DATE(e1.start_date) <=",date("Y-m-d",strtotime($this->input->post('to_date'))));
			$preData.=$this->input->post('to_date');
		}

		$preData.="\nCategory: ";
		if( is_numeric($this->input->post('category')))
		{
			$query1->where("FIND_IN_SET(".$this->input->post('category').",e1.categories) >",0);
			$preData.=$this->categories_model->categoriesList['categories'][$this->input->post('category')]->category;
		}
		else
		{
			$preData.="All Categories";
		}

		if($excel==1)
		{
			if(in_array($this->input->post('order_by'),$GLOBALS['current_acl']['sort_columns']))
			{
				if(in_array($this->input->post('dir'),$GLOBALS['current_acl']['dir']))
					$query1->order_by($this->input->post('order_by'),$this->input->post('dir'));
				else
					$query1->order_by($this->input->post('order_by'),'desc');
			}
			else
			{
				if(in_array($this->input->post('dir'),$GLOBALS['current_acl']['dir']))
					$query1->order_by('e1.start_date',$this->input->post('dir'));
				else
					$query1->order_by('e1.start_date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/events_model",$sql,$this->currentUser,"site_services",$_POST,"Events Report",$preData,2);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(in_array($this->input->post('order')[0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$this->input->post('order')[0]['dir'];


		$order_by='';
		if(is_numeric($this->input->post('order')[0]['column']))
		{
			$col_num=round(abs($this->input->post('order')[0]['column']));
			$col_name=$this->input->post('columns')[$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('e1.start_date',$dir);
		}
		else
		{
			$query1->order_by('e1.start_date',$dir);
		}

		$start=0;
		$length=10;
		if(is_numeric($this->input->post('start')))
		{
			if(round(abs($this->input->post('start')))%10==0)
			$start=round(abs($this->input->post('start')));
		}
		if(is_numeric($this->input->post('length')) && in_array($this->input->post('length'),array(10,20,50,100)))
		{
			$length=abs($this->input->post('length'));
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;

			if($row['ashram_id'])
			{
				$rtn['data'][$c]['ashram_name']=$ashramData->name;
				$rtn['data'][$c]['link']=base_url.'ashrams/'.$ashramData->slug.'/events/'.$row['eyear'].'/'.$row['eslug'];
			}
			else
			{
				$rtn['data'][$c]['ashram_name']="N/A";
				$rtn['data'][$c]['link']=base_url."events/".$row['eyear']."/".$row['eslug'];
			}
			if($row['pyear'])
				$rtn['data'][$c]['plink']=base_url."events/".$row['pyear']."/".$row['pslug'];
			else
				$rtn['data'][$c]['plink']='';
			$sno++;
			$c++;
		}
		return $rtn;
	}


	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->eventsExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Event ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Event Title");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Event Link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Categories");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Start Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"End Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Location");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SEO Keywords");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SEO Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Views");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{

			$reportrow->ashram_name = "N/A";
			$publicUrl=base_url."events/".$reportrow->year."/".$reportrow->slug;
			if($reportrow->ashram_id > 0)
			{
				$ashramData=$this->ashrams_model->ashramData($reportrow->ashram_id);
				$reportrow->ashram_name = $ashramData->name;
				$publicUrl=base_url.'ashrams/'.$ashramData->slug.'/events/'.$reportrow->year.'/'.$reportrow->year;
			}
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ashram_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$publicUrl);

			$cats=array_filter(explode(",",$reportrow->categories));
			$catString='';
			foreach ($cats as $catId)
			{
				if($catString!='') $catString.=", ";

				if(isset($this->categories_model->categoriesList['categories'][$catId]))
				$catString.=$this->categories_model->categoriesList['categories'][$catId]->category;
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$catString);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->start_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->end_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->location);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->seo_keywords);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->seo_description);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->reads);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
	public function eventsExcelReport($excelData,$objPHPExcel)
	{
		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Event ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Event Title");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Event Link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Categories");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Parent Link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{

			$reportrow->ashram_name = "N/A";
			$publicUrl=base_url."events/".$reportrow->eyear."/".$reportrow->eslug;
			if($reportrow->ashram_id > 0)
			{
				$ashramData=$this->ashrams_model->ashramData($reportrow->ashram_id);
				$reportrow->ashram_name = $ashramData->name;
				$publicUrl=base_url.'ashrams/'.$ashramData->slug.'/events/'.$reportrow->eyear.'/'.$reportrow->eslug;
			}

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->eid);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ashram_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ename);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$publicUrl);

			$cats=array_filter(explode(",",$reportrow->ecategories));
			$catString='';
			foreach ($cats as $catId)
			{
				if($catString!='') $catString.=", ";
				if(isset($this->categories_model->categoriesList['categories'][$catId]))
				$catString.=$this->categories_model->categoriesList['categories'][$catId]->category;
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$catString);
			if($reportrow->pyear)
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,base_url."events/".$reportrow->pyear."/".$reportrow->pslug);
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function latestEventsRender()
	{
		$this->siteServivcesDb->where("status",1);
		$this->siteServivcesDb->order_by("start_date","desc");
		$this->siteServivcesDb->limit(5);
		$q=$this->siteServivcesDb->get($this->tableName);
		ob_start();
		foreach ($q->result() as $eRow)
		{
			$imageUrl=aws_s3_base_url."images/site_assets/global_site_images/others/dattapeetham_logo.jpg";
			$images=$this->events_images_model->getImages($eRow->id);
			if(count($images))
			{
				$imageUrl=aws_s3_base_url."content/event_images/".$eRow->id."/thumb_".$images[0]->filename;
			}
			$eData['eventData']=$eRow;
			$eData['imageUrl']=$imageUrl;
			$this->load->view("events/public/_latest_events_template",$eData);
		}
		$template=ob_get_clean();
		$filePath=APPPATH."views/common/public/site_".global_site_flag."/_latest_events.php";
		if(file_exists($filePath))
		{
			unlink($filePath);
		}
		file_put_contents($filePath,$template);
	}

	public function listPublicSearchEvents()
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("name,slug,year");
		}
		$query1->from($this->tableName);
		$query1->where("status",1);

		if($this->input->post('search_text')!='')
		{
			$query1->group_start();
			$query1->like("name",$this->input->post('search_text'));
			$query1->or_like("description",$this->input->post('search_text'));
			$query1->or_like("location",$this->input->post('search_text'));
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('start_date',"desc");

		$start=0;
		$length=10;
		if(is_numeric($this->input->post('start')))
		{
			if(round(abs($this->input->post('start')))%10==0)
			$start=round(abs($this->input->post('start')));
		}
		if(is_numeric($this->input->post('length')) && in_array($this->input->post('length'),array(10,20,50)))
		{
			$length=abs($this->input->post('length'));
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		return $rtn;
	}
}
?>