<?PHP
class Dailypost_types_Model extends CI_Model 
{
	var $tableName="dailypost_types";
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function typeData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		$result=$q->row();
		return $result;
	}
	public function typeDataBySlug($slug)
	{
		$this->siteServivcesDb->where("slug",$slug);
		$q=$this->siteServivcesDb->get($this->tableName);
		$result=$q->row();
		return $result;
	}

	public function getTypeList()
	{
		$q=$this->siteServivcesDb->get($this->tableName);
		$result=$q->result();
		return $result;
	}
	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}


		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('name',$_POST['dir']);
				else
					$query1->order_by('name',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/dailypost_types_model",$sql,$this->currentUser,"site_services",$_POST,"All Daily Post Types",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('name',$dir);
		}
		else
		{
			$query1->order_by('name',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if($row['description']!='')
			{
				$rtn['data'][$c]['description']=substr($row['description'],0,100);
				if(strlen($row['description'])>100)
					$rtn['data'][$c]['description'].="...";
			}
			else
			{
				$rtn['data'][$c]['description']='-';
			}
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id,$typeData)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->delete($this->tableName);
		return 1;
	}
	public function save($id,$typeData)
	{

		$typeSlug=strtolower(url_title($this->general_model->filtertext(trim($_POST["name"]))));

		if(!$id)
		{
			$q=$this->siteServivcesDb->insert($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
                                	'slug'=>$typeSlug,
									'description' => $this->general_model->filtertext(trim($_POST["description"]))
								)
								);
			$idd=$this->siteServivcesDb->insert_id();
		}
		else
		{
			
			$this->siteServivcesDb->where('id', $id);
			$q=$this->siteServivcesDb->update($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
                                	'slug'=>$typeSlug,
									'description' => $this->general_model->filtertext(trim($_POST["description"]))
								)
								);
			$idd=$id;
		}

		if($q)
			return $idd;
		else
			return 0;
	}

	public function checkName($name,$id)
	{
		$error=0;

		$slug=url_title($name);

		$this->siteServivcesDb->where("name",$name);
		$this->siteServivcesDb->where("id !=",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		$this->siteServivcesDb->where("slug",$slug);
		$this->siteServivcesDb->where("id !=",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$typesArray=array();
		$types=$this->dailypost_types_model->getTypeList();
		foreach ($types as $typerow)
		{
			$typesArray[$typerow->id]=$typerow;
		}

		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S. No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Post Type ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Post Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Slug");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->slug);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->description);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>