<?PHP
class Calendar_Model extends CI_Model 
{
	var $tableName="calendar";
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function getCount()
	{
		return $this->siteServivcesDb->get($this->tableName)->num_rows();
	}
	public function calendarData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
	}
	public function getYearMonths()
	{
		$this->siteServivcesDb->select("year,month");
		$this->siteServivcesDb->group_by("year, month");
		$this->siteServivcesDb->order_by("year","desc");
		$this->siteServivcesDb->order_by("month","asc");
		$q=$this->siteServivcesDb->get($this->tableName);
		$result['years']=array();
		$result['months']=array();
		foreach ($q->result() as $row)
		{
			if(!in_array($row->year,$result['years']))
			{
				$result['years'][]=$row->year;
			}
			$result['months'][$row->year][]=$row->month;
		}
		return $result;
	}
	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nCalendar Type: ";
		if(isset($_POST['type']) && is_numeric($_POST['type']) && in_array($_POST['type'],array(1,2,3)))
		{
			if($_POST['type']==1)
			{
				$query1->where("swamiji",1);
				$preData.="Swamiji Calendar";
			}
			if($_POST['type']==2)
			{
				$query1->where("balaswamiji",1);
				$preData.="Bala Swamiji Calendar";
			}
			if($_POST['type']==3)
			{
				$query1->where("dattapeetham",1);
				$preData.="Datta Peetham Calendar";
			}
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(start_date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(start_date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('start_date',$_POST['dir']);
				else
					$query1->order_by('start_date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/calendar_model",$sql,$this->currentUser,"site_services",$_POST,"All Calendar Events",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('start_date',$dir);
		}
		else
		{
			$query1->order_by('start_date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_date']=date("d M Y",strtotime($rtn['data'][$c]['end_date']));
			//getting notification data
			$notificationData = $this->mobileNotifications_model->getNotificationIDBasedOnService($row['id'],'calendar');
			$rtn['data'][$c]['notification_id'] = -1;
			if(!empty($notificationData)){
				$rtn['data'][$c]['notification_id'] = 0;
				if($notificationData->is_sent == 0){
					$rtn['data'][$c]['notification_id'] = $notificationData->id;
				}
			}
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->delete($this->tableName);
		return $q;
	}
	public function save($id)
	{
		$swamiji=0;
		$balaswamiji=0;
		$dattapeetham=0;
		if(isset($_POST['swamiji']))
			$swamiji=1;
		
		if(isset($_POST['balaswamiji']))
			$balaswamiji=1;
		
		if(isset($_POST['dattapeetham']))
			$dattapeetham=1;
		
		if(!$id)
		{
			$q=$this->siteServivcesDb->insert($this->tableName,
                                array(
                                	'event_name' => $this->general_model->filtertext(trim($_POST["event_name"])),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'start_date' => date("Y:m:d H:i:s",strtotime($_POST["start_date"])),
									'end_date' => date("Y:m:d H:i:s",strtotime($_POST["end_date"])),
									'year'=>date("Y",strtotime($_POST["start_date"])),
									'month'=>abs(date("m",strtotime($_POST["start_date"]))),
									'created_on'=>date("Y:m:d H:i:s"),
									'created_by'=>$this->currentUser->id,
									'modified_on'=>date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id,
									'swamiji'=>$swamiji,
									'balaswamiji'=>$balaswamiji,
									'dattapeetham'=>$dattapeetham
								)
								);
			$idd=$this->siteServivcesDb->insert_id();
			//saving live updates content for notifications
			$this->mobileNotifications_model->addNotification('Calendar',$this->general_model->filtertext(trim($_POST['event_name'])),$idd,'calendar');
			
		}
		else
		{
			
			$this->siteServivcesDb->where('id', $id);
			$q=$this->siteServivcesDb->update($this->tableName,
                                array(
                                	'event_name' => $this->general_model->filtertext(trim($_POST["event_name"])),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'start_date' => date("Y:m:d H:i:s",strtotime($_POST["start_date"])),
									'end_date' => date("Y:m:d H:i:s",strtotime($_POST["end_date"])),
									'year'=>date("Y",strtotime($_POST["start_date"])),
									'month'=>abs(date("m",strtotime($_POST["start_date"]))),
									'modified_on'=>date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id,
									'swamiji'=>$swamiji,
									'balaswamiji'=>$balaswamiji,
									'dattapeetham'=>$dattapeetham
								)
								);
			$idd=$id;
		}
		if($q)
			return $idd;
		else
			return 0;
	}
	public function listPublic()
	{
		$years=$this->getYearMonths();

		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("start_date,end_date,event_name,swamiji,balaswamiji,dattapeetham,description");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->group_start();
			$query1->like("event_name",trim($_POST['search_text']));
			$query1->or_like("description",$_POST['search_text']);
			$query1->group_end();
		}

		if(isset($_POST['calendar']) && is_numeric($_POST['calendar']) && in_array($_POST['calendar'],array(1,2,3)))
		{
			if($_POST['calendar']==1)
			{
				$query1->where("swamiji",1);
			}
			if($_POST['calendar']==2)
			{
				$query1->where("balaswamiji",1);
			}
			if($_POST['calendar']==3)
			{
				$query1->where("dattapeetham",1);
			}
		}

		if(isset($_POST['year']) && is_numeric($_POST['year']))
		{
			$query1->where("year",$_POST['year']);
		}
		else
		{
			if(isset($years['years'][0]))
				$query1->where("year",$years['years'][0]);
			else
				$query1->where("year",date("Y"));
		}

		if(isset($_POST['month']) && is_numeric($_POST['month']))
		{
			$query1->where("month",$_POST['month']);
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num'] = $temp_result->c;
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('start_date','asc');

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			//$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_date']=date("d M Y",strtotime($rtn['data'][$c]['end_date']));
			$rtn['data'][$c]['start_day']=date("l",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_day']=date("l",strtotime($rtn['data'][$c]['end_date']));
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Calendar ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Calendar Event");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Calendar Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"From Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"To Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->event_name);

			$cType='';
			if($reportrow->swamiji==1)
			{
				$cType="Swamiji Calendar";
			}
			if($reportrow->balaswamiji==1)
			{
				if($cType!='') $cType.="\n";
				$cType.="Bala Swamiji Calendar";
			}
			if($reportrow->dattapeetham==1)
			{
				if($cType!='') $cType.="\n";
				$cType.="Dattepeetham Calendar";
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$cType);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->start_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->end_date)));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function listPublicSearchCalendars()
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("year,month,start_date,end_date,event_name,swamiji,balaswamiji,dattapeetham,description");
		}
		$query1->from($this->tableName);
		
		if(isset($_POST['search_text']) && $_POST['search_text']!='')
		{
			$query1->group_start();
			$query1->like("event_name",trim($_POST['search_text']));
			$query1->or_like("description",$_POST['search_text']);
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('start_date','asc');
		$query1->group_by('id');

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$sno=$start+1;
		foreach ($rtn['data']  as $key=> $row)
		{
			$searchType = "";
			if($row['swamiji'] == 1)
			{
				$searchType = "swamiji_calendar";
			}
			if($row['balaswamiji'] == 1)
			{
				$searchType = "bala_swamiji_calendar";
			}
			if($row['dattapeetham'] == 1)
			{
				$searchType = "website_calendar";
			}
			$searchYear = "";
			if($row['year']>0)
			{
				$searchYear = $row['year'];
			}
			$searchMonth = "";
			if($row['month']>0)
			{
				$searchMonth = $row['month'];
			}
			$rtn['data'][$key]=$row;
			$rtn['data'][$key]['sno']=$sno;
			$rtn['data'][$key]['calendar_url']=base_url."calendar?type=".$searchType."&year=".$searchYear."&month=".$searchMonth."&text=".$row['event_name'];

			$sno++;
		}
		return $rtn;		
	}
}
?>