<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Bhajans_Model extends CI_Model 
{
	var $tableName="bhajans";
	var $siteServivcesDb = "";
    function __construct() 
	{
   		 parent::__construct();
   		 $this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function getKeyData($filekey)
	{
		$this->siteServivcesDb->where("key",$filekey);
		$qk=$this->siteServivcesDb->get("bhajans_key");
		return $qk->row();
	}
	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->siteServivcesDb->where('ashram_id',$this->currentUser->ashram_id);
		}
		return $this->siteServivcesDb->get($this->tableName)->num_rows();
	}
	public function listPublic()
	{
		$i=0;

		$query1=$this->siteServivcesDb;
		
		$query1->select("*,GROUP_CONCAT(filename) as files,GROUP_CONCAT(size) as sizes");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*,GROUP_CONCAT(filename) as files,GROUP_CONCAT(size) as sizes");
		}
		
		$query1->from($this->tableName);
		$query1->group_by("key");

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->like("description",$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
		}

		if(isset($_POST['category']) && is_numeric($_POST['category']) && in_array($_POST['category'],array(1,2,3,4,5,6,7,8,9,10,11,12)))
		{
			$query1->where("category_id",$_POST['category']);
		}
		
		
		$per_page=20;
		if($i==1)
		{
			$temp_result = $query1->get();
			$rtn['num']=$temp_result->num_rows();
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("description","asc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();
		$colors=array("red","blue","orange","green","purple");
		$ii=0;
		$ids=array();
		foreach ($rtn['res'] as $key=> $row) 
		{
			if($ii==5)
				$ii=0;
			$rtn['res'][$key]->color=$colors[$ii];

			$sizes=explode(",",$row->sizes);
			$nsizes=array();
			foreach ($sizes as $size)
			{
				$nsizes[]=$this->general_model->fileSizeConvert($size);
			}
			$rtn['res'][$key]->sizes=implode(",",$nsizes);
			$rtn['res'][$key]->category=$this->cats[$row->category_id];

			$ii++;
		}
		$rtn['aws_s3_base_url']=aws_s3_base_url;

		return $rtn;
	}
	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("*,GROUP_CONCAT(filename) as files,GROUP_CONCAT(size) as sizes");
		step1:
		$i++;
		if($excel==1 || $i==2)
		{
			$query1->select("*,GROUP_CONCAT(filename) as files,GROUP_CONCAT(size) as sizes");
		}
		$query1->from($this->tableName);
		$query1->group_by("key");

		$preData="Search Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		if(isset($_POST['category']) && is_numeric($_POST['category']) && in_array($_POST['category'],array(1,2,3,4,5,6,7,8,9,10,11,12)))
		{
			$query1->where("category_id",$_POST['category']);
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('filename',$_POST['dir']);
				else
					$query1->order_by('filename',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/bhajans_model",$sql,$this->currentUser,"default",$_POST,"All Bhajans",$preData);
			return $requestResp;
		}
		
		
		if($i==1)
		{
			$temp_result = $query1->get();

			$rtn['recordsTotal'] = $temp_result->num_rows();
			$rtn['recordsFiltered'] = $temp_result->num_rows();
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('filename',$dir);
		}
		else
		{
			$query1->order_by('filename',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$rtn['q']=$query1->last_query();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['aws_s3_base_url']=aws_s3_base_url;
			
			$sizes=explode(",",$row['sizes']);
			$nsizes=array();
			foreach ($sizes as $size)
			{
				$nsizes[]=$this->general_model->fileSizeConvert($size);
			}
			$rtn['data'][$c]['sizes']=implode(",",$nsizes);
			if(isset($this->cats[$row['category_id']]))
				$rtn['data'][$c]['category']=$this->cats[$row['category_id']];
			else
				$rtn['data'][$c]['category']='';
			$sno++;
			$c++;
		}
		$rtn['aws_s3_base_url']=aws_s3_base_url;
		$rtn['page_records']=$c;
		return $rtn;
	}
	function getFiles()
	{
		$this->siteServivcesDb->where("user_id",$this->currentUser->id);
		$this->siteServivcesDb->order_by("date",'desc');
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}
	
	public function bhajanData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
	}
	public function uploadFile()
	{
		$fname=$_FILES['files']['name'][0];
		$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);
		
		$str=explode("_",$fname);
		$len=count($str);
		unset($str[$len-1]);
		$key=implode("_",$str);

		$newname=$fname;"bhajan_".$key."_".substr(md5(mt_rand()), 0, 16).".".$ext;
		$tempPath=$_FILES['files']['tmp_name'][0];
		$tempName=basename($_FILES['files']['tmp_name'][0]);

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		$amazonUri="content/bhajans/";
		$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());

		$this->siteServivcesDb->where("key",$key);
		$qk=$this->siteServivcesDb->get("bhajans_key");
		if($qk->num_rows())
		{
			$keyRow=$qk->row();
			$desc=$keyRow->description;
			$catId=$keyRow->category_id;
		}
		else
		{
			$desc=$fname;
			$catId=0;
			$this->siteServivcesDb->insert("bhajans_key",array("key"=>$key,"description"=>$desc));
		}

		$fileSize=filesize($tempPath);
		$this->siteServivcesDb->insert($this->tableName,
						array(
								"filename"=>$newname,
								'description'=>$desc,
								'size'=>$fileSize,
								'category_id'=>$catId,
								'key'=>$key
							));
		$data['fileid']=$this->siteServivcesDb->insert_id();
		$data['filename']=$newname;
		$data['description']=$fname;
		return $data;
	}
	public function delete($filekey)
	{
		$this->siteServivcesDb->where("key",$filekey);
		$q=$this->siteServivcesDb->get($this->tableName);
		$c=0;
		foreach ($q->result() as $row)
		{

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			$amazonUri="content/bhajans/".$row->filename;
			$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
			$this->siteServivcesDb->where("id",$row->id);
			$this->siteServivcesDb->delete($this->tableName);
			$c++;
		}

		$this->siteServivcesDb->where("key",$filekey);
		$this->siteServivcesDb->delete('bhajans_key');
		return $c;
	}
	public function updateDescription($id,$value)
	{
		$this->siteServivcesDb->where("key",$id);
		$this->siteServivcesDb->update($this->tableName,array('description'=>$value));

		$this->siteServivcesDb->where("key",$id);
		$this->siteServivcesDb->update("bhajans_key",array('description'=>$value));
	}

	public function updateCategory($id,$value)
	{
		$this->siteServivcesDb->where("key",$id);
		$this->siteServivcesDb->update($this->tableName,array('category_id'=>$value));

		$this->siteServivcesDb->where("key",$id);
		$this->siteServivcesDb->update("bhajans_key",array('category_id'=>$value));
	}
	public function checkKey($key)
	{
		$this->siteServivcesDb->where("key",$key);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
			return true;
		else
			return false;
	}

	public function listPublicSearchBhajans()
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("*,GROUP_CONCAT(filename) as files,GROUP_CONCAT(size) as sizes");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*,GROUP_CONCAT(filename) as files,GROUP_CONCAT(size) as sizes");
		}
		$query1->from($this->tableName);
		$query1->group_by("key");
		if(isset($_POST['search_text']) && $_POST['search_text']!='')
		{
			$query1->group_start();
			$query1->like("description",$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get();

			$rtn['recordsTotal'] = $temp_result->num_rows();
			$rtn['recordsFiltered'] = $temp_result->num_rows();
			goto step1;
		}

		$query1->order_by('description','asc');

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$rtn['q']=$query1->last_query();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['aws_s3_base_url']=aws_s3_base_url;
			
			$sizes=explode(",",$row['sizes']);
			$nsizes=array();
			foreach ($sizes as $size)
			{
				$nsizes[]=$this->general_model->fileSizeConvert($size);
			}
			$rtn['data'][$c]['sizes']=implode(",",$nsizes);
			$sno++;
			$c++;
		}
		$rtn['aws_s3_base_url']=aws_s3_base_url;
		$rtn['page_records']=$c;
		return $rtn;		
	}
}
?>