<?PHP
class Ashramcenters_Model extends CI_Model 
{
	var $tableName="ashramcenters";
	public function __construct()
	{
		parent::__construct();
	}
	public function ashramcenterData($id)
	{
		$this->db->where("id",$id);
		$q=$this->db->get($this->tableName);
		$result=$q->row();
		return $result;
	}

	public function getCount()
	{
		return $this->db->get($this->tableName)->num_rows();
	}
	
	public function ashramcenterDataBySlug($slug)
	{
		$this->db->where("slug",$slug);
		$q=$this->db->get($this->tableName);
		$result=$q->row();
		return $result;
	}
	public function getCountries()
	{
		$this->db->from($this->tableName." as a");
		$this->db->select("a.country_id as country_id,a.country_name as country_name,loc.isd_code as isd_code");
		$this->db->group_by("country_id");
		$this->db->join(db_prefix."locations.countries_list as loc","a.country_id=loc.country_code");
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}
	public function listPublic()
	{
		$i=0;

		$query1=$this->db;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		
		$query1->from($this->tableName);

		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$query1->where("country_id",$_POST['country']);
			}
		}

		if(isset($_POST['category']) && $_POST['category']!='')
		{
			$query1->where("FIND_IN_SET('".$_POST['category']."',categories) !=","0");
		}
		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->group_start();
			$query1->like("name",trim($_POST['search_text']));
			$query1->or_like("contact_person",$_POST['search_text']);
			$query1->or_like("state_name",$_POST['search_text']);
			$query1->or_like("city",$_POST['search_text']);
			$query1->or_like("address",$_POST['search_text']);
			$query1->group_end();
		}
		
		
		$per_page=10;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("name","asc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();
		$colors=array("red","blue","orange","green","purple");
		$ii=0;
		$ids=array();
		foreach ($rtn['res'] as $key=> $row) 
		{
			if($ii==5)
				$ii=0;
			$rtn['res'][$key]->color=$colors[$ii];
			$rtn['res'][$key]->location='';
			if($row->city!='')
				$rtn['res'][$key]->location.=$row->city;
			if($row->state_name!='')
			{
				if($rtn['res'][$key]->location!='') $rtn['res'][$key]->location.=", ";
				$rtn['res'][$key]->location.=$row->state_name;
			}
			if($rtn['res'][$key]->location!='') $rtn['res'][$key]->location.=", ";
			$rtn['res'][$key]->location.=$row->country_name;
			$rtn['res'][$key]->address=nl2br($row->address);
			$ii++;
		}

		return $rtn;
	}

	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && 
			isset($_POST['wild']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']) && 
			in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nCountry: ";
		if(isset($_POST['country']))
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$query1->where("country_id",$_POST['country']);
				$preData.=$countryData->country_name;
			}
			else
				$preData.="All Countries";
		}
		else
		{
			$preData.="All Countries";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('name',$_POST['dir']);
				else
					$query1->order_by('name',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/ashramcenters_model",$sql,$this->currentUser,"default",$_POST,"All Ashram Centers",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('name',$dir);
		}
		else
		{
			$query1->order_by('name',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id,$ashramcenterData)
	{
		$this->db->where("id",$id);
		$this->db->delete($this->tableName);
		return 1;
	}
	public function save($id,$ashramcenterData)
	{
		$slug=strtolower(url_title($_POST['name']));
		$countryData=$this->locations_model->getCountryByCode($_POST['country_id']);
		if(!$id)
		{
			$q=$this->db->insert($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
                                	'address' => $this->general_model->filtertext(trim($_POST["address"])),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'country_id' => $_POST["country_id"],
									'country_name'=>$countryData->country_name,
									'state_name' => $this->general_model->filtertext(trim($_POST["state_name"])),
									'city' => $this->general_model->filtertext(trim($_POST["city"])),
									'contact_person' => $this->general_model->filtertext(trim($_POST["contact_person"])),
									'contact_email' => $this->general_model->filtertext(trim($_POST["contact_email"])),
									'contact_phone' => $this->general_model->filtertext(trim($_POST["contact_phone"])),
									'slug'=>$slug,
									'created_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$this->db->insert_id();
		}
		else
		{
			
			$this->db->where('id', $id);
			$q=$this->db->update($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
									'address' => $this->general_model->filtertext(trim($_POST["address"])),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'country_id' => $_POST["country_id"],
									'country_name'=>$countryData->country_name,
									'state_name' => $this->general_model->filtertext(trim($_POST["state_name"])),
									'city' => $this->general_model->filtertext(trim($_POST["city"])),
									'contact_person' => $this->general_model->filtertext(trim($_POST["contact_person"])),
									'contact_email' => $this->general_model->filtertext(trim($_POST["contact_email"])),
									'contact_phone' => $this->general_model->filtertext(trim($_POST["contact_phone"])),
									'slug'=>$slug,
									'modified_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$id;
		}

		if($q)
			return $idd;
		else
			return 0;
	}

	public function savePage($id)
	{
		$categories = "";
		$google_map_link = "";
		if(isset($_POST['categories']) && !empty($_POST['categories']))
		{
			$categories = implode(',', $_POST['categories']);
		}
		if(isset($_POST['google_map_link']) && $_POST['google_map_link']!="")
		{
			$google_map_link = $_POST['google_map_link'];
		}
		$this->db->where('id', $id);
		$q=$this->db->update($this->tableName,
                            array
                            	(
                            		'content' => $this->general_model->filtertext(trim($_POST["content"])),
                            		'categories' => $categories,
                            		'google_map_link' => trim($google_map_link),
								)
							);

		$this->load->helper("simple_html_dom");
		$dom=new simple_html_dom();
		$tempContent=trim($_POST['content']);
		$contentDom=$dom->load($tempContent);
		$images=$contentDom->find('img');
		if(count($images))
		{
			if($id)
			{
				$existingImages=$this->ashramcenterpage_images_model->getImagesByDycId($id);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$eArray[$eimage->filename]=$eimage->id;
				}
				$editorImages=[];
				foreach ($images as $img_dom) 
				{
					$pathText=$img_dom->attr['src'];
					if(preg_match('/amazon/i',$pathText))
					{
						$editorImages[basename($pathText)]=basename($pathText);
					}
				}
				$diff=array_diff_key($eArray,$editorImages);
				//$keys=array_keys($diff);

				if(count($diff))
				{
					foreach($diff as $ikey)
					$this->ashramcenterpage_images_model->deleteImage($ashramId,$ikey);
				}

			}

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="content/ashramcenters_images/".$id."/";
			foreach ($images as $img_dom) 
			{
				$pathText=$img_dom->attr['src'];
				if(preg_match('/amazon/i',$pathText))
					continue;

				$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
				if(file_exists($path))
				{
					$fname=basename($path);
					$extn=pathinfo ($fname,PATHINFO_EXTENSION);
					$newFileName = $id."_".substr(md5(mt_rand() . microtime()), 0, 16).".".$extn;
					$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
					$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
					unlink($path);

					$imageData=array('filename' => $newFileName,
									'ashram_id' =>$id
									);
					$this->ashramcenterpage_images_model->insert($imageData);
				}
			}
			$this->db->where("id",$id);
			$this->db->update($this->tableName,array("content"=>$tempContent));
		}
		else
		{
			$existingImages=$this->ashramcenterpage_images_model->getImagesByDycId($id);
			$eArray=[];
			foreach ($existingImages as $eimage)
			{
				$this->ashramcenterpage_images_model->deleteImage($id,$eimage->id);
			}
		}

		if($id)
		{
			$ashramCenterDetails = $this->ashramcenterData($id);
			if($ashramCenterDetails->image!='' && !isset($_POST['imgupl']))
			{
				$this->db->where("id",$id);
				$this->db->update($this->tableName,array('image'=>''));
				$path=aws_s3_base_url."/images/ashramcenter_images/".$ashramCenterDetails->image;
				if(file_exists($path))
					unlink($path);
				$thumbPath=aws_s3_base_url."/images/ashramcenter_images/thumb_".$ashramCenterDetails->image;
				if(file_exists($thumbPath))
					unlink($thumbPath);
			}
		}

		if(isset($_FILES['ashramcenter_image']))
		if($_FILES['ashramcenter_image']['name']!='')
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$name=$_FILES['ashramcenter_image']['name'];
			$ext=pathinfo ($_FILES['ashramcenter_image']['name'],PATHINFO_EXTENSION);			
			
			$newName="ashramcenter_".$id."_".substr(md5(mt_rand()), 0, 16).".".$ext;
			$tempPath=$_FILES['ashramcenter_image']['tmp_name'];
			$tempName=basename($_FILES['ashramcenter_image']['tmp_name']);
			$thumbName="thumb_".$newName;
			$thumbPath=str_replace($tempName, $thumbName, $tempPath);
			$this->general_model->create_thumb_150($tempPath,$thumbPath);
			
			$image = new SimpleImage();
			$image->load($tempPath);
			$img_width=$image->getWidth();
	    	$img_height=$image->getHeight();
	    	$ratio=$img_width/$img_height;
	      
			if($ratio>=1)
			{
				if($img_width>800)
					$image->resizeToWidth(800);
			}
			else
			{
				if($img_height>800)
					$image->resizeToHeight(800);
			}
			$image->save($tempPath);
			
			$amazonUri="images/ashramcenter_images/";
			$amazonUriThumb="images/ashramcenter_images/thumb_".$newName;
			$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newName,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());

			$this->db->where("id",$id);
			$this->db->update($this->tableName,array('image'=>$newName));
		}
	}

	public function checkName($name,$id)
	{
		$error=0;

		$slug=strtolower(url_title($name));

		$this->db->where("name",$name);
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		$this->db->where("slug",$slug);
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}
		return $error;
	}

	public function excelReport($excelData,$objPHPExcel)
	{

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram Center Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Contact Person");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Contact Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Contact Email");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_person);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function listPublicSearchAshramcenters()
	{
		$i=0;
		$query1=$this->db;
		$query1->select("count(ac.id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("name,slug");
		}
		$query1->from($this->tableName." as ac");
		
		if(isset($_POST['search_text']) && $_POST['search_text']!='')
		{
			$query1->group_start();
			$query1->like("ac.name",trim($_POST['search_text']));
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('ac.name','asc');
		$query1->group_by('ac.id');

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		return $rtn;
	}
}
?>