<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Ashramcenterpage_images_model extends CI_Model
{
	var $tableName="ashramcenterpage_images";
	public function __construct()
	{
		parent::__construct();
	}
	public function insert($data)
	{
		$this->db->insert($this->tableName,$data);
	}
	
	public function getImagesByDycId($ashramcenterId,$multiple=false,$columns=array())
	{
		if(empty($columns))
			$this->db->select("*");
		else
			$this->db->select(implode(",", $columns));
		$this->db->from($this->tableName);
		if($multiple==true)
			$this->db->where_in("ashramcenter_id",$ashramcenterId);
		else
		$this->db->where("ashramcenter_id",$ashramcenterId);
		$q=$this->db->get();
		return $q->result();
	}
	public function deleteImage($ashramcenterId,$imageId)
	{
		$this->db->where(array("id"=>$imageId,"ashramcenter_id"=>$ashramcenterId));
		$query = $this->db->get($this->tableName);
		if($query->num_rows())
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$r=$query->row();
			$file=$r->filename;
			$amazonUri="content/ashramcenters_images/".$ashramcenterId."/";
			$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri.$r->filename);

			$this->db->where(array("id"=>$imageId,"ashramcenter_id"=>$ashramcenterId));
			$this->db->delete($this->tableName);
			return 1;
		}
		else
			return 0;
	}
}
?>