<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Album_images_Model extends CI_Model 
{
	var $tableName="album_images";
	var $siteServivcesDb = "";
    function __construct() 
	{
   		 parent::__construct();
   		 $this->siteServivcesDb = $this->load->database("site_services",true,false);
	}

	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->siteServivcesDb->where('ashram_id',$this->currentUser->ashram_id);
		}
		return $this->siteServivcesDb->get($this->tableName)->num_rows();
	}

	public function listPublic($albumId=0)
	{
		$i=0;

		$query1=$this->siteServivcesDb;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		
		$query1->from($this->tableName);
		if(is_numeric($this->input->post('ashram_id')))
		{
			$query1->where("ashram_id",$this->input->post('ashram_id'));
		}
		if(is_numeric($this->input->post('satsang_id')))
		{
			$query1->where("satsang_id",$this->input->post('satsang_id'));
		}

		if($albumId)
		{
			$query1->where("album_id",$albumId);
		}

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->like("description",$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
		}
		
		
		$per_page=12;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("order","asc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();

		foreach ($rtn['res'] as $key=> $row) 
		{
			$imageURL=aws_s3_base_url."content/photos/".$row->album_id."/".$row->filename;
			list($iWidth,$iHeight) = getimagesize($imageURL);
			$rtn['res'][$key]->dimensions=$iWidth."x".$iHeight;
		}

		$rtn['aws_s3_base_url']=aws_s3_base_url;
		return $rtn;
	}

	function getImages($albumId)
	{
		$this->siteServivcesDb->where("album_id",$albumId);
		$this->siteServivcesDb->order_by("order",'asc');
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}
	public function imageData($id,$albumId)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->where("album_id",$albumId);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
	}
	public function uploadFile($albumData)
	{
		$fname=$_FILES['files']['name'][0];
		$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);
		$newname="album_image_".$albumData['album']->id."_".substr(md5(mt_rand()), 0, 16).".".$ext;
		$tempPath=$_FILES['files']['tmp_name'][0];
		$tempName=basename($_FILES['files']['tmp_name'][0]);
		$thumbName="thumb_".$fname;
		$thumbPath=str_replace($tempName, $thumbName, $tempPath);
		$this->general_model->create_thumb_150($tempPath,$thumbPath);

		$this->load->helper("image");
		$image = new SimpleImage();
		$image->load($tempPath);
		$img_width=$image->getWidth();
    	$img_height=$image->getHeight();
    	$ratio=$img_width/$img_height;
      
		if($ratio>=1)
		{
			if($img_width>1000)
				$image->resizeToWidth(1000);
		}
		else
		{
			if($img_height>1000)
				$image->resizeToHeight(1000);
		}
		$image->save($tempPath);

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$amazonUri="content/photos/".$albumData['album']->id."/";
		$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
		$this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUri."thumb_".$newname,S3::ACL_PUBLIC_READ, array(), array());

		list($iWidth,$iHeight) = getimagesize($tempPath);


		$ashram_id=0;
		if($this->currentUser->roles!=1)
		{
			if($this->currentUser->ashram_id)
				$ashram_id=$this->currentUser->ashram_id;
			else if($this->currentUser->satsang_id)
				$ashram_id=$this->currentUser->satsang_id;

		}

		$this->siteServivcesDb->insert($this->tableName,
						array(
								"filename"=>$newname,
								'created_on'=>date("Y:m:d H:i:s"),
								'album_id'=>$albumData['album']->id,
								'width'=>$iWidth,
								'height'=>$iHeight,
								'description'=>$fname,
								'created_by' => $this->currentUser->id,
								'ashram_id'=>$ashram_id
							));

		$data['fileid']=$this->siteServivcesDb->insert_id();
		$data['filename']=$newname;
		$data['title']=$fname;
		$this->album_model->updateCount($albumData['album']->id,$albumData['album']->count+1);
		unlink($tempPath);
		return $data;
	}

	public function getAlbumThumbs($ids)
	{
		$this->siteServivcesDb->where_in("album_id",$ids);
		$this->siteServivcesDb->group_by("album_id");
		$q=$this->siteServivcesDb->get($this->tableName);
		$res=array();
		foreach ($q->result() as $row)
		{
			$res[$row->album_id]=$row->filename;
		}
		return $res;
	}

	public function delete($albumData,$imageData)
	{
		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$amazonUri="content/photos/".$albumData['album']->id."/".$imageData->filename;
		$amazonThumbUri="content/photos/".$albumData['album']->id."/thumb_".$imageData->filename;
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonThumbUri);
		$this->siteServivcesDb->where("id",$imageData->id);
		$this->siteServivcesDb->delete($this->tableName);
		$this->album_model->updateCount($albumData['album']->id,$albumData['album']->count-1);
		return 1;
	}
	public function updateInfo($id,$colName,$value)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array($colName=>$value));
	}
}
?>