<?PHP
class Store_types_model extends CI_Model 
{
	var $tableName="store_types";
	public function __construct()
	{
		parent::__construct();
	}
	public function typeData($id)
	{
		$this->db->select("t.id as id,t.name as name,t.order as order,t.created_on as created_on,t.modified_on as modified_on,count(s.id) as in_use");
		$this->db->from($this->tableName." as t");
		$this->db->join("store as s","s.category=t.id","left");
		$this->db->where("t.id",$id);
		$q=$this->db->get();
		$result=$q->row();
		return $result;
	}
	
	public function getList()
	{
		$this->db->order_by("name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}
	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('order',$dir);
		}
		else
		{
			$query1->order_by('order',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($row['created_on']));
			$rtn['data'][$c]['modified_on']=date("d M Y h:i A",strtotime($row['modified_on']));
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function updateOrder($id,$value)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array('order'=>$value));
	}
	public function delete($id,$typeData)
	{
		$this->db->where("id",$id);
		$this->db->delete($this->tableName);
		return 1;
	}
	public function save($id,$typeData)
	{
		if(!$id)
		{
			$q=$this->db->insert($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($this->input->post("name"))),
                                	'created_on'=>date("Y:m:d H:i:s"),
                                	'modified_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$this->db->insert_id();
		}
		else
		{
			
			$this->db->where('id', $id);
			$q=$this->db->update($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($this->input->post("name"))),
                                	'modified_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$id;
		}

		if($q)
			return $idd;
		else
			return 0;
	}

	public function checkName($name,$id)
	{
		$error=0;

		$slug=url_title($name);

		$this->db->where("name",$name);
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}
}
?>