<?PHP
class Store_Model extends CI_Model 
{
	var $tableName="store";
	public function __construct()
	{
		parent::__construct();
	}
	public function getByAshramId($ashramId)
	{
		$this->db->where("ashram_id",$ashramId);
		$this->db->order_by('status','desc');
		$this->db->order_by("item_name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function getAshramIDforMultiStore($store_ids)
	{
		$q = $this->db->select("ashram_id")->from("store")->where_in("id",$store_ids)->group_by("ashram_id")->get();
		if($q->num_rows() > 0)
		{
			$r = $q->result();
			return $r;
		}
		return false;
	}

	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->db->where('ashram_id',$this->currentUser->ashram_id);
		}
		return $this->db->where('status',1)->get($this->tableName)->num_rows();
	}

	public function itemData($id)
	{
		$this->db->select("a.*, b.name as ashram_name");
		$this->db->from($this->tableName." as a");
		$this->db->join("ashrams as b","b.id=a.ashram_id","left");
		$this->db->where("a.id",$id);
		$q=$this->db->get();
		$result['item']=$q->row();
		$result['photos']=array();
		$result['files']=array();
		if($q->num_rows())
		{
			$result['photos']=$this->store_cover_photos_model->getImages($id);
			$result['files']=$this->store_files_model->getFiles($id);
		}
		return $result;
	}

	public function getmultistoreItems($store_ids)
	{
		$this->db->where_in("id",$store_ids);
		$this->db->order_by('status','desc');
		$this->db->order_by("item_name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function getRandomItems($categoryId=0)
	{
		if(!$categoryId)
		{
			return array();
		}
		$this->db->from("store as s");
		$this->db->select("*,s.id as iid,s.description as description");
		$this->db->join("store_cover_photos as c","s.id=c.item_id");
		$this->db->where("status",1);
		$this->db->where("s.category",$categoryId);
		$this->db->where("ashram_id",$this->session->userdata("storeCartAshramIdSelection"));
		$this->db->group_by("s.id");
		$this->db->order_by("RAND()");
		$this->db->limit(10);
		$q=$this->db->get();
		return $q->result();
	}

	public function listAdmin($ashramId,$excel=0)
	{
		if(isset($_POST['item_type']) && is_numeric($_POST['item_type']))
		{
			$typeData=$this->store_types_model->typeData($this->input->post("item_type"));
		}
		if(isset($_POST['category']) && is_numeric($_POST['category']))
		{
			$categoryData=$this->store_categories_model->categoryData($this->input->post("category"));
		}

		$storeCategories=$this->store_categories_model->getList();
		$categories=array();
		foreach ($storeCategories as $storeCategory)
		{
			$categories[$storeCategory->id]=$storeCategory;
		}

		$ashramData=$this->ashrams_model->ashramData($ashramId);

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(s.id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*,s.id as id");
		}
		$query1->where("ashram_id",$ashramId);
		$query1->from($this->tableName." as s");
		$query1->join("store_types as t","t.id=s.item_type");
		
		$preData="Ashram Name: ".$ashramData->name;

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nItem Status:";
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1)))
		{
			if($_POST['status']==0)
			{
				$query1->where("status",0);
				$preData.="Inactive";
			}
			else
			{
				$query1->where("status",1);
				$preData.="Active";
			}
		}

		$preData.="\nShipping Status:";
		if(isset($_POST['shipping']) && is_numeric($_POST['shipping']) && in_array($_POST['shipping'],array(0,1)))
		{
			if($_POST['shipping']==0)
			{
				$query1->where("shipping",0);
				$preData.="No";
			}
			else
			{
				$query1->where("shipping",1);
				$preData.="Yes";
			}
		}

		$preData.="\nItem Type:";
		if(isset($_POST['item_type']) && is_numeric($_POST['item_type']))
		{
			if(!empty($typeData))
			{
				$query1->where("item_type",$_POST['item_type']);
				$preData.=$typeData->name;
			}
		}
		else
		{
			$preData.="All Types";
		}

		$preData.="\Category:";
		if(isset($_POST['category']) && is_numeric($_POST['category']))
		{
			if(!empty($categoryData))
			{
				$query1->where("category",$_POST['category']);
				$preData.=$categoryData->name;
			}
		}
		else
		{
			$preData.="All Categories";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('item_name',$_POST['dir']);
				else
					$query1->order_by('item_name',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ashrams/store_model",$sql,$this->currentUser,"default",$_POST,"All Store Items",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('item_name',$dir);
		}
		else
		{
			$query1->order_by('item_name',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['item_type']=$row['name'];

			if($row['category'])
			{
				$rtn['data'][$c]['category_name']=$categories[$row['category']]->name;
			}

			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id,$itemData)
	{
		$this->db->where("id",$id);
		$this->db->delete($this->tableName);

		foreach ($itemData['photos'] as $imageData)
		{
			$this->store_cover_photos_model->delete($imageData);
		}

		foreach ($itemData['files'] as $fileData)
		{
			$this->store_files_model->delete($fileData);
		}

		return 1;
	}

	public function checkstatus($id)
	{
		$itemData=$this->itemData($id);
		if($itemData['item']->shipping==0)
		{
			if(empty($itemData['files']) || empty($itemData['photos']))
			{
				$this->changeStatus($id,0);
				return 0;
			}
			else
			{
				$this->changeStatus($id,1);
				return 1;
			}
		}
		else
		{
			if(empty($itemData['photos']))
			{
				$this->changeStatus($id,0);
				return 0;
			}
			else
			{
				$this->changeStatus($id,1);
				return 1;
			}
		}
	}

	public function changeStatus($id,$status)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array("status"=>$status));
	}

	public function save($id,$itemData)
	{
		$external_link='';
		if($this->input->post("is_external_link")==1)
		{
			$external_link=$this->input->post('external_link');
		}

		$is_secret = 0;
	    if(isset($_POST['is_secret']) && trim($_POST['is_secret']) == 1)
	    {
	        $is_secret = trim($_POST['is_secret']);
	    }
	    $secret_key = NULL;
	    if(isset($_POST['s_key']) && trim($_POST['s_key']) != '' && $is_secret==1)
	    {
	        $secret_key = trim($_POST['s_key']);
	    }
	    $item_key = NULL;
	    if(isset($_POST['item_key']) && trim($_POST['item_key']) != '')
	    {
	        $item_key = trim($_POST['item_key']);
	    }

	    $is_public_display = 1;
	    if(isset($_POST['is_public_display']) && trim($_POST['is_public_display']) == 0)
	    {
	        $is_public_display = trim($_POST['is_public_display']);
	    }

	    $only_for_admin = 0;
	    if(isset($_POST['only_for_admin']) && trim($_POST['only_for_admin']) == 1)
	    {
	        $only_for_admin = trim($_POST['only_for_admin']);
	        $is_public_display = 0;
	    }

	    $only_for_admin = 0;
	    if(isset($_POST['only_for_admin']) && trim($_POST['only_for_admin']) == 1)
	    {
	        $only_for_admin = trim($_POST['only_for_admin']);
	        $is_public_display = 0;
	    }

	    $display_only_popup = 0;
	    if(isset($_POST['display_only_popup']) && trim($_POST['display_only_popup']) == 1)
	    {
	        $display_only_popup = trim($_POST['display_only_popup']);
	    }

	    $popup_content = '';
	    if(isset($_POST['popup_content']) && trim($_POST['popup_content']) != '')
	    {
	        $popup_content = $this->general_model->filtertext(trim($_POST['popup_content']));
	    }

	    $having_custom_email = 0;
	    if(isset($_POST['having_custom_email']) && trim($_POST['having_custom_email']) == 1)
	    {
	        $having_custom_email = trim($_POST['having_custom_email']);
	    }

	    $custom_email_text = '';
	    if(isset($_POST['custom_email_text']) && trim($_POST['custom_email_text']) != '')
	    {
	        $custom_email_text = $this->general_model->filtertext(trim($_POST['custom_email_text']));
	    }

	    $having_custom_sms = 0;
	    if(isset($_POST['having_custom_sms']) && trim($_POST['having_custom_sms']) == 1)
	    {
	        $having_custom_sms = trim($_POST['having_custom_sms']);
	    }

	    $custom_sms_text = '';
	    if(isset($_POST['custom_sms_text']) && trim($_POST['custom_sms_text']) != '')
	    {
	        $custom_sms_text = $this->general_model->filtertext(trim($_POST['custom_sms_text']));
	    }

		if(!$id)
		{
			$qss=$this->db->insert($this->tableName,
                                array(
                                	'item_name' => $this->general_model->filtertext(trim($_POST["item_name"])),
                                	'category'=>$this->input->post('category'),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'item_type'=>$_POST['item_type'],
									'ashram_id' => $this->session->userdata("ashramId"),
									'status'=>1,
									'shipping'=>$this->input->post("shipping"),
									'is_external_link'=>$this->input->post('is_external_link'),
									'is_public_display'=>$is_public_display,
									'have_personal_note'=>$this->input->post('have_personal_note'),
									'partial_payments_allowed'=>$this->input->post('partial_payments_allowed'),
									'external_link'=>$external_link,
									'is_secret'=>$is_secret,
									's_key'=>$secret_key,
									'item_key'=>$item_key,
									'only_for_admin'=>$only_for_admin,
									'display_only_popup'=>$display_only_popup,
									'popup_content'=>$popup_content,
									'having_custom_email'=>$having_custom_email,
									'custom_email_text'=>$custom_email_text,
									'having_custom_sms'=>$having_custom_sms,
									'custom_sms_text'=>$custom_sms_text,
								)
								);
			$idd=$this->db->insert_id();
		}
		else
		{
			
			$this->db->where('id', $id);
			$qss=$this->db->update($this->tableName,
                                array(
                                	'item_name' => $this->general_model->filtertext(trim($_POST["item_name"])),
                                	'category'=>$this->input->post('category'),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'item_type'=>$_POST['item_type'],
									'status'=>1,
									'shipping'=>$this->input->post("shipping"),
									'is_external_link'=>$this->input->post('is_external_link'),
									'is_public_display'=>$is_public_display,
									'have_personal_note'=>$this->input->post('have_personal_note'),
									'partial_payments_allowed'=>$this->input->post('partial_payments_allowed'),
									'external_link'=>$external_link,
									'is_secret'=>$is_secret,
									's_key'=>$secret_key,
									'item_key'=>$item_key,
									'only_for_admin'=>$only_for_admin,
									'display_only_popup'=>$display_only_popup,
									'popup_content'=>$popup_content,
									'having_custom_email'=>$having_custom_email,
									'custom_email_text'=>$custom_email_text,
									'having_custom_sms'=>$having_custom_sms,
									'custom_sms_text'=>$custom_sms_text,
								)
								);
			$idd=$id;
		}


		$updateData=array();
		foreach ($GLOBALS['currencies'] as $currencyData)
		{
			$priceCol='price_'.strtolower($currencyData['currency']);
			$displayCol=strtolower($currencyData['currency'])."_display";
			$updateData[$priceCol]=$_POST[$priceCol];
			$shipDomestic='shipping_domestic_'.strtolower($currencyData['currency']);
			$shipInternational='shipping_international_'.strtolower($currencyData['currency']);

			if($this->input->post($displayCol)!='')
			{
				$updateData[$displayCol]=1;
			}
			else
			{
				$updateData[$displayCol]=0;	
			}

			if($this->input->post("shipping")==1)
			{
				$updateData[$shipDomestic]=$_POST[$shipDomestic];
				$updateData[$shipInternational]=$_POST[$shipInternational];
			}
			else
			{
				$updateData[$shipDomestic]=0;
				$updateData[$shipInternational]=0;
			}
		}

		$this->db->where("id",$idd);
		$this->db->update($this->tableName,$updateData);

		$this->checkstatus($idd);

		if($qss)
			return $idd;
		else
			return 0;
	}

	public function checkItemName($name,$id)
	{
		$error=0;

		$this->db->where("item_name",$name);
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	//============================================================================================================================

	public function listPublic($ashramId,$admindata,$userdata)
	{
		if($this->session->userdata("defaultCurrency")=='')
		{
			$emptyRtn['total']=0;
			$emptyRtn['categories']=array();
			$emptyRtn['categories_items']=array();
			return $emptyRtn;
			exit;
		}
		
		$typeData=array();
		if(isset($_POST['item_type']) && is_numeric($_POST['item_type']))
		{
			$typeData=$this->store_types_model->typeData($this->input->post("item_type"));
		}

		$priceString='';
		foreach ($GLOBALS['currencies'] as $cData)
		{
			if($priceString!='') $priceString.=",";
			$priceString.='price_'.strtolower($cData['currency']);
		}
		$query1=$this->db;
		$query1->select("s.id as id,filename,item_name,s.description as description,item_type,name as category_name,sc.description as category_description,sc.allow_public_display as category_description_display,external_link,is_external_link,sc.id as cid,".$priceString.",shipping, s.display_only_popup, s.popup_content");


		if(isset($userdata) || (isset($admindata) && $admindata->roles !=1 && $admindata->roles !=3 && $admindata->roles !=4) || (empty($admindata) && empty($userdata)))
			$query1->where("is_public_display",1);

		$query1->where("ashram_id",$ashramId);
		if(!empty($this->session->userdata("cart_items_from_seva_details")) && $this->session->userdata("cart_items_from_seva_details")["order_type"] == 3 && $this->session->userdata("cart_items_from_seva_details")["user_id"] && ($this->session->userdata("defaultCurrency") == $this->session->userdata("cart_items_from_seva_details")["currency"]) && ($this->session->userdata("storeCartAshramIdSelection") == $this->session->userdata("cart_items_from_seva_details")["ashram_id"]))
        {
        	$query1->where("partial_payments_allowed",0);
        }
		$query1->where("status",1);
		$query1->from($this->tableName." as s");
		$query1->join("store_cover_photos as c",'s.id=c.item_id','left');
		$query1->join("store_categories as sc","sc.id=s.category","left");
		$query1->group_by("s.id");

		$displayCol=strtolower($this->session->userdata("defaultCurrency"))."_display";
		$query1->where($displayCol,1);


		if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("only_for_admin",0);
		}

		if(isset($_GET['s_key']) && $_GET['s_key']!='')
		{
			$query1->where("s_key",$_GET['s_key']);
		}
		else if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("s_key",null);
		}

		if(isset($_GET['item_key']) && $_GET['item_key']!='')
		{
			$query1->where("item_key",$_GET['item_key']);
		}

		if(isset($_POST['item_type']) && !empty($typeData))
		{
			$query1->where("item_type",$_POST['item_type']);
		}
		
		$dir='asc';

		$query1->order_by('sc.order','asc');
		$query1->order_by('item_name','asc');

		$rtn['data']=$query1->get()->result_array();

		$categories_items=[];
		$categories=[];
		$temp_cats=[];

		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$rtn['data'][$c][$priceCol];
			if($rtn['data'][$c]['filename']=='')
				$rtn['data'][$c]['image']=aws_s3_base_url."images/pooja_images/sample-store.jpg";
			else
				$rtn['data'][$c]['image']=aws_s3_base_url."images/store_images/".$row['id']."/thumb_".$rtn['data'][$c]['filename'];

			$categories_items[$row['cid']][]=$rtn['data'][$c];
			if(empty(trim($row['category_description'])))
			{
				$d_category = "";
			}
			else
			{
				$d_category = $row['category_description'];
			}
			if(!in_array($row['cid'],$temp_cats))
			{
				$categories[]=array("id"=>$row['cid'],"category"=>$row['category_name'],"category_description"=>$d_category,"category_description_display"=>$row['category_description_display']);
				$temp_cats[]=$row['cid'];
			}

			$c++;
		}
		unset($rtn['data']);
		$rtn['total']=$c;
		$rtn['categories']=$categories;
		$rtn['categories_items']=$categories_items;
		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$storeCategories=$this->store_categories_model->getList();
		$categories=array();
		foreach ($storeCategories as $storeCategory)
		{
			$categories[$storeCategory->id]=$storeCategory;
		}

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		foreach ($GLOBALS['currencies'] as $currencyData)
		{
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,
										"Price (".strtoupper($currencyData['currency'])." ".$currencyData['symbol'].")");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		}

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item can be shipped?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		foreach ($GLOBALS['currencies'] as $currencyData)
		{
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,
										"Shipping Charges with in India (".strtoupper($currencyData['currency'])." ".$currencyData['symbol'].")");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,
										"Shipping Charges outside of India (".strtoupper($currencyData['currency'])." ".$currencyData['symbol'].")");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		}

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Category");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Public Display");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->description)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$priceCol="price_".strtolower($currencyData['currency']);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->$priceCol);
			}
			$shipping="No";
			if($reportrow->shipping==1)
				$shipping="Yes";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$shipping);

			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$shipCol1="shipping_domestic_".strtolower($currencyData['currency']);
				$shipCol2="shipping_international_".strtolower($currencyData['currency']);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->$shipCol1);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->$shipCol2);
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$categories[$reportrow->category]->name);

			$is_public_display="Yes";
			if($reportrow->is_public_display==0)
				$is_public_display="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$is_public_display);

			$status="Inactive";
			if($reportrow->status==1)
				$status="Active";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function checkStoreItemKeyExists($name,$id)
	{
		$error=0;

		$this->db->where("item_key",$name);
		$this->db->where("id !=",$id);
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	public function checkStoreSecretKeyExists($name,$id)
	{
		$error=0;

		$this->db->where("s_key",$name);
		$this->db->where("id !=",$id);
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	public function listPublicSearchStoreItems()
	{
		$i=0;
		$query1=$this->db;
		$query1->select("count(si.id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("item_name,ashram_id");
		}
		$query1->from($this->tableName." as si");
		$query1->join("ashrams as a","si.ashram_id = a.id");
		$query1->where("a.is_public_display",1);
		$query1->where("si.status",1);
		$query1->where("si.only_for_admin",0);
		$query1->where("si.is_public_display",1);
		$query1->where("si.s_key",null);
		if(isset($_POST['search_text']) && $_POST['search_text']!='')
		{
			$query1->group_start();
			$query1->like("si.item_name",$_POST['search_text']);
			$query1->or_like("si.description",$_POST['search_text']);
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('si.item_name','asc');
		$query1->group_by('si.id');

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		return $rtn;
	}

	//get poojas ashram_id,category from poojas table
	public function getByAshramCategoryId($ashramId,$categoryId)
	{
		$this->db->where("ashram_id",$ashramId);
		if($categoryId != 'null' && $categoryId != NULL && $categoryId > 0)
			$this->db->where("category",$categoryId);
		$this->db->order_by("status","desc");
		$this->db->order_by("item_name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}
}
?>