<?PHP
class Store_files_model extends CI_Model 
{
	var $tableName="store_files";
	public function __construct()
	{
		parent::__construct();
	}
	public function getFiles($itemId)
	{
		$this->db->where("item_id",$itemId);
		$this->db->order_by("order","asc");
		$q=$this->db->get($this->tableName);
		return $q->result();
	}

	public function fileData($id,$itemId)
	{
		$this->db->where("id",$id);
		$this->db->where("item_id",$itemId);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}

	public function uploadFile($itemData)
	{
		$fname=$_FILES['files']['name'][0];
		$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);
		$newname="store_".$itemData['item']->id."_".substr(md5(mt_rand()), 0, 16).".".$ext;
		$tempPath=$_FILES['files']['tmp_name'][0];
		$tempName=basename($_FILES['files']['tmp_name'][0]);

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		$amazonUri="private_files/store/".$itemData['item']->id."/";
		$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PRIVATE, array(), array());
		$fileSize=filesize($tempPath);
		$this->db->insert($this->tableName,
						array(
								"filename"=>$newname,
								'created_on'=>date("Y:m:d H:i:s"),
								'item_id'=>$itemData['item']->id,
								'description'=>$fname,
								'title'=>$fname,
								'size'=>$fileSize
							));
		$data['fileid']=$this->db->insert_id();
		$data['filename']=$newname;
		$data['description']=$fname;
		return $data;
	}

	public function delete($fileData)
	{
		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$amazonUri="private_files/store/".$fileData->item_id."/".$fileData->filename;
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
		$this->db->where("id",$fileData->id);
		$this->db->delete($this->tableName);
		return 1;
	}
	public function updateInfo($id,$colName,$value)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array($colName=>$value));
	}
}
?>