<?PHP
class Seva_item_blocked_dates extends CI_Model 
{
	var $tableName="seva_item_blocked_dates";
	public function __construct()
	{
		parent::__construct();
	}

	//getting user blocked dates for donations
	public function getBlockedDatesByUserAndItem($item_id,$dates,$seva_type){
		$this->db->select("id,user_id,item_id,row_id,selected_dates,expiry_date");
		$this->db->from($this->tableName);
		$this->db->where("item_id",$item_id);
		$this->db->where("order_type",$seva_type);
		$this->db->where_in("DATE_FORMAT(STR_TO_DATE(selected_dates,'%Y-%m-%d'),'%d %b %Y')",$dates);
		$q=$this->db->get();
		$result=$q->result();
		//echo $this->db->last_query(); exit;
		return $result;
	}

	public function getBlockedDatesByUserAndItemAndDate($item_id,$user_id,$month,$year,$seva_type){
		$this->db->select("id,user_id,row_id,item_id,selected_dates,expiry_date");
		$this->db->from($this->tableName);
		$this->db->where("item_id",$item_id);
		//$this->db->where("row_id",$row_id);
		$this->db->where("order_type",$seva_type);
		$this->db->where("MONTH(selected_dates)",$month);
		$this->db->where("YEAR(selected_dates)",$year);
		$q=$this->db->get();
		$result=$q->result();
		//echo $this->db->last_query(); exit;
		return $result;
	}

	//inseting user selected dates in table
	public function saveDates($dates,$user_id,$item_id,$row_id,$seva_type){
		$data = array();
		foreach($dates as $date){
			$data[] = array("user_id"=>$user_id,"item_id"=>$item_id,"selected_dates"=>date('Y-m-d',strtotime($date)),"expiry_date"=>date('Y-m-d H:i:s',strtotime("+15 min")),"created_date"=>date('Y-m-d H:i:s'),"order_type"=>$seva_type,"row_id"=>$row_id);
		}
		$this->db->insert_batch($this->tableName, $data); 
	}
	//deleting user selected dates in table
	public function deleteDates($user_id,$item_id,$row_id,$seva_type){
		$this->db->where("user_id",$user_id);
		$this->db->where("item_id",$item_id);
		$this->db->where("row_id",$row_id);
		$this->db->where("order_type",$seva_type);
		$this->db->delete($this->tableName);
	}

	//deleting user selected dates in table
	public function deleteAfterExpiry($item_id){
		$this->db->where_in("id",$item_id);
		$this->db->delete($this->tableName);
	}

	//get item by dates
	public function getItemByDates($item_id,$dates,$row_id,$seva_type){
		$this->db->select("id,user_id,item_id,selected_dates,expiry_date");
		$this->db->from($this->tableName);
		$this->db->where("item_id",$item_id);
		$this->db->where("order_type",$seva_type);
		$this->db->where_in("selected_dates",$dates);
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}

	//delete all user item from table
	public function ClearCart($user_id){
		$this->db->where("user_id",$user_id);
		$this->db->delete($this->tableName);
	}

	//delete by rowid
	public function deleteByRowId($row_id){
		$this->db->where("row_id",$row_id);
		$this->db->delete($this->tableName);
	}
}
?>