<?PHP
class Poojas_categories_model extends CI_Model 
{
	var $tableName="poojas_categories";
	public function __construct()
	{
		parent::__construct();
	}
	public function categoryData($id)
	{
		$this->db->select("c.id as id,c.description as description,c.allow_public_display as allow_public_display,c.name as name,c.order as order,c.created_on as created_on,c.modified_on as modified_on, c.category_ashram_id, a.name as category_ashram_name, count(p.id) as in_use");
		$this->db->from($this->tableName." as c");
		$this->db->join("poojas as p","p.category=c.id","left");
		$this->db->join("ashrams as a","a.id=c.category_ashram_id","left");
		$this->db->where("c.id",$id);
		$q=$this->db->get();
		$result=$q->row();
		return $result;
	}
	
	public function getList()
	{
		$this->db->order_by("name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function getCategoriesListByAshramId($ashramId=0)
	{
		$this->db->order_by("name","asc");
		$this->db->where("category_ashram_id",$ashramId);
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function listAdmin($ashramId,$excel=0)
	{
		$ashramData=$this->ashrams_model->ashramData($ashramId);

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->where("category_ashram_id",$ashramId);
		$query1->from($this->tableName);
		$preData="Ashram Name: ".$ashramData->name;
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}


		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('name',$_POST['dir']);
				else
					$query1->order_by('name',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ashrams/poojas_categories_model",$sql,$this->currentUser,"default",$_POST,"All Pooja Categories",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('order',$dir);
		}
		else
		{
			$query1->order_by('order',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if(empty(trim($row['description'])))
			{
				$rtn['data'][$c]['description']="N/A";
			}
			else
			{
				$rtn['data'][$c]['description']=nl2br($row['description']);
			}
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($row['created_on']));
			$rtn['data'][$c]['modified_on']=date("d M Y h:i A",strtotime($row['modified_on']));
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function updateOrder($id,$value)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array('order'=>$value));
	}
	public function delete($id,$typeData)
	{
		$this->db->where("id",$id);
		$this->db->delete($this->tableName);
		return 1;
	}
	public function save($id,$typeData)
	{
		if(!$id)
		{
			$q=$this->db->insert($this->tableName,
                                array(
                                	'category_ashram_id' => $this->session->userdata("ashramId"),
									'name' => $this->general_model->filtertext(trim($this->input->post("name"))),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'allow_public_display' => $_POST["allow_public_display"],
                                	'created_on'=>date("Y:m:d H:i:s"),
                                	'modified_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$this->db->insert_id();
		}
		else
		{
			
			$this->db->where('id', $id);
			$q=$this->db->update($this->tableName,
                                array(
									'name' => $this->general_model->filtertext(trim($this->input->post("name"))),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'allow_public_display' => $_POST["allow_public_display"],
                                	'modified_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$id;
		}

		if($q)
			return $idd;
		else
			return 0;
	}

	public function checkName($name,$id)
	{
		$error=0;

		$slug=url_title($name);
		if($id>0)
		{
			$categoryData = $this->poojas_categories_model->categoryData($id);
			if(isset($categoryData->category_ashram_id) && $categoryData->category_ashram_id>0)
			{
				$this->db->where("category_ashram_id",$categoryData->category_ashram_id);
			}
		} else {
			$this->db->where("category_ashram_id",$this->session->userdata("ashramId"));
		}
		$this->db->where("name",$name);
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	public function excelReport($excelData,$objPHPExcel)
	{

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S. No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Category Id");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Category Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Public Display");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created On");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Modified On");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if($reportrow->allow_public_display == 0){
				$reportrow->allow_public_display = "No";
			} else {
				$reportrow->allow_public_display = "Yes";
			}

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->description)));			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->allow_public_display);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->modified_on)));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>