<?PHP
class Donations_Model extends CI_Model 
{
	var $tableName="donations";
	public function __construct()
	{
		parent::__construct();
	}
	public function donationData($id)
	{
		$this->db->select("a.*, b.name as ashram_name");
		$this->db->from($this->tableName." as a");
		$this->db->join("ashrams as b","b.id=a.ashram_id","left");
		$this->db->where("a.id",$id);
		$q=$this->db->get();
		$result=$q->row();
		if($result)
		{
			$result->include_dates_txt = '';
			if(isset($result->include_dates) && $result->include_dates !='' && $result->include_dates != NULL)
			{
				$includeDts = explode(',', $result->include_dates);
				usort($includeDts, array($this,'sortDatesByAscendingorder'));
				foreach($includeDts as $thisIncludeDt)
				{
					if($result->include_dates_txt == '')
					{
						$result->include_dates_txt .= date('j M Y (l)', strtotime($thisIncludeDt));
					} else {
						$result->include_dates_txt .= '<br>'.date('j M Y (l)', strtotime($thisIncludeDt));
					}
				}
			}
			$result->exclude_dates_txt = '';
			if(isset($result->exclude_dates) && $result->exclude_dates !='' && $result->exclude_dates != NULL)
			{
				$excludeDts = explode(',', $result->exclude_dates);
				usort($excludeDts, array($this,'sortDatesByAscendingorder'));
				foreach($excludeDts as $thisexcludeDt)
				{
					if($result->exclude_dates_txt == '')
					{
						$result->exclude_dates_txt .= date('j M Y (l)', strtotime($thisexcludeDt));
					} else {
						$result->exclude_dates_txt .= '<br>'.date('j M Y (l)', strtotime($thisexcludeDt));
					}
				}
			}
		}
		return $result;
	}

	public function getmultiDonations($donation_ids)
	{
		$this->db->where_in("id",$donation_ids);
		$this->db->order_by("status","desc");
		$this->db->order_by("donation_name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function getDonationsByCategory($category_id)
	{
		$this->db->select("d.*,dg.name as group_name");
		$this->db->from($this->tableName." as d");
		$this->db->join("donations_groups as dg","dg.id=d.group_id","left");
		$this->db->where("d.category",$category_id);
		$this->db->order_by("d.order","asc");
		$this->db->order_by("dg.name","asc");
		$this->db->order_by("d.donation_name","asc");
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}

	public function getDonationsByGroup($group_id)
	{
		$this->db->select("d.*");
		$this->db->from($this->tableName." as d");
		$this->db->where("d.group_id",$group_id);
		$this->db->order_by("d.order","asc");
		$this->db->order_by("d.donation_name","asc");
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}

	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->db->where('ashram_id',$this->currentUser->ashram_id);
		}
		$this->db->where("status",1);
		return $this->db->get($this->tableName)->num_rows();
	}

	public function getAshramIDforMultiDonations($donation_ids)
	{
		$q = $this->db->select("ashram_id")->from("donations")->where_in("id",$donation_ids)->group_by("ashram_id")->get();
		if($q->num_rows() > 0)
		{
			$r = $q->result();
			return $r;
		}
		return false;
	}

	public function getByAshramId($ashramId)
	{
		$this->db->where("ashram_id",$ashramId);
		$this->db->order_by("status","desc");
		$this->db->order_by("donation_name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}
	public function getSubscriptionsByAshramId($ashramId)
	{
		$this->db->where("ashram_id",$ashramId);
		$this->db->where("subscription",1);
		$this->db->order_by("status","desc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function getSubscriptionsCount($startDate,$id)
	{
		$donationData=$this->donationData($id);
		$start=strtotime($startDate);
        $frequency=$donationData->frequency;
        $expiration_method=$donationData->expiration_method;
        $expiry_date=strtotime($donationData->expiry_date);
        $period=$donationData->period;
        $num_of_payments=$donationData->num_of_payments;

        $hard_date=strtotime("+5 years",$start);
        $i=1;
		while(1)
        {
            $start=strtotime("+".$frequency." ".$period,$start);

            if($expiration_method==1) // No of payments
            {
            	if($i==$num_of_payments)
            	{
            		break;
            	}
            }
            else if($expiration_method==2)
            {
	            if($start>$expiry_date)
	            {
	                break;
	            }
	        }
	        else
	        {
	        	if($start>$hard_date)
	        	{
	        		break;
	        	}
	        }
	        if($start>$hard_date)
        	{
        		break;
        	}
            $i++;
		}
		return $i;
	}

	public function updateOrder($id,$value)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array('order'=>$value));
	}

	public function listAdmin($ashramId,$excel=0)
	{
		if(isset($_POST['category']) && is_numeric($_POST['category']))
		{
			$categoryData=$this->donations_categories_model->categoryData($this->input->post("category"));
		}
		$donationCategories=$this->donations_categories_model->getList();

		$categories=array();
		foreach ($donationCategories as $donationCategory)
		{
			$categories[$donationCategory->id]=$donationCategory;
		}

		if(isset($_POST['group']) && is_numeric($_POST['group']))
		{
			$groupData=$this->donations_groups_model->groupData($this->input->post("group"));
		}
		$donationGroups=$this->donations_groups_model->getList();

		$groups=array();
		foreach ($donationGroups as $donationgroup)
		{
			$groups[$donationgroup->id]=$donationgroup;
		}

		$ashramData=$this->ashrams_model->ashramData($ashramId);

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->where("ashram_id",$ashramId);
		$query1->from($this->tableName);
		
		$preData="Ashram Name: ".$ashramData->name;

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nDonation status:";
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1)))
		{
			if($_POST['status']==0)
			{
				$query1->where("status",0);
				$preData.="Inactive";
			}
			else
			{
				$query1->where("status",1);
				$preData.="Active";
			}
		}

		$preData.="\nDonation Type:";
		if(isset($_POST['donation_type']) && is_numeric($_POST['donation_type']) && in_array($_POST['donation_type'],array(0,1)))
		{
			if($_POST['donation_type'] == 0)
			{
				$query1->where("subscription",1);
				$preData.="Subscription";
			} else if($_POST['donation_type'] == 1){
				$query1->where("subscription",0);
				$preData.="One Time";
			}
		}

		$preData.="\nHave Prasadam:";
		if(isset($_POST['shipping']) && is_numeric($_POST['shipping']) && in_array($_POST['shipping'],array(0,1)))
		{
			if($_POST['shipping']==0)
			{
				$query1->where("shipping",0);
				$preData.="No";
			}
			else
			{
				$query1->where("shipping",1);
				$preData.="Yes";
			}
		}

		$preData.="\nPartial Payments Allowed:";
		if(isset($_POST['partial_payments_allowed']) && is_numeric($_POST['partial_payments_allowed']) && in_array($_POST['partial_payments_allowed'],array(0,1)))
		{
			if($_POST['partial_payments_allowed']==0)
			{
				$query1->where("partial_payments_allowed",0);
				$preData.="No";
			}
			else
			{
				$query1->where("partial_payments_allowed",1);
				$preData.="Yes";
			}
		}

		$preData.="\nPrice Fixed:";
		if(isset($_POST['is_price_fixed']) && is_numeric($_POST['is_price_fixed']) && in_array($_POST['is_price_fixed'],array(0,1)))
		{
			if($_POST['is_price_fixed']==0)
			{
				$query1->where("is_price_fixed",0);
				$preData.="No";
			}
			else
			{
				$query1->where("is_price_fixed",1);
				$preData.="Yes";
			}
		}

		$preData.="\nBundle:";
		if(isset($_POST['is_bundle']) && is_numeric($_POST['is_bundle']) && in_array($_POST['is_bundle'],array(0,1)))
		{
			if($_POST['is_bundle']==0)
			{
				$query1->where("is_bundle",0);
				$preData.="No";
			}
			else
			{
				$query1->where("is_bundle",1);
				$preData.="Yes";
			}
		}

		$preData.="\nPet status:";
		if(isset($_POST['assign_pet']) && is_numeric($_POST['assign_pet']) && in_array($_POST['assign_pet'],array(0,1)))
		{
			if($_POST['assign_pet']==0)
			{
				$query1->where("assign_pet",0);
				$preData.="No";
			}
			else
			{
				$query1->where("assign_pet",1);
				$preData.="Yes";
			}
		}

		$preData.="\nDonation categories:";
		if(isset($_POST['category']) && is_numeric($_POST['category']))
		{
			if(!empty($categoryData))
			{
				$query1->where("category",$_POST['category']);
				$preData.=$categoryData->name;
			}
		}
		else
		{
			$preData.="All Categories";
		}

		$preData.="\nDonation groups:";
		if(isset($_POST['group']) && is_numeric($_POST['group']))
		{
			if(!empty($groupData))
			{
				$query1->where("group_id",$_POST['group']);
				$preData.=$groupData->name;
			}
		}
		else
		{
			$preData.="All Groups";
		}


		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('donation_name',$_POST['dir']);
				else
					$query1->order_by('donation_name',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ashrams/donations_model",$sql,$this->currentUser,"default",$_POST,"All Donations",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('order',$dir);
		}
		else
		{
			$query1->order_by('order',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['category_name']="-";
			$rtn['data'][$c]['group_name']="-";
			if($row['category'])
			{
				$rtn['data'][$c]['category_name']=$categories[$row['category']]->name;
			}
			if($row['group_id'])
			{
				$rtn['data'][$c]['group_name']=$groups[$row['group_id']]->name;
			}
			$rtn['data'][$c]['subscription'] = "N/A";
			if($row['subscription'] == 1)
			{
				if($row['expiry_date'])
					$dates = date('d M Y',strtotime($row['expiry_date']));
				else 
					$dates = "N/A";

				if($row['expiration_method'])
					$ex_method = $row['expiration_method'];
				else 
					$ex_method = "N/A";

				$rtn['data'][$c]['subscription']= 	"<span style='font-weight:bold;'>One-Time INR: ".$row['onetime_charge_inr']."</span><br> <span style='font-weight:bold;color:red;'>One-Time USD: ".$row['onetime_charge_usd']."</span><br> Period: ".$row['period']."<br> Frequency: ".$row['frequency']."<br>Payments Count: ".$row['num_of_payments']."<br>Expiry Date: ".$dates."<br>";
			}
			$rtn['data'][$c]['pet_status'] ="N/A";
			if($row['assign_pet'] == 1)
			{
				$rtn['data'][$c]['pet_status'] ="Yes";
			} 
			if($row['subscription'] == 1){
				$rtn['data'][$c]['donation_type'] ="Subscription";
			} else if($row['subscription'] == 0 && ($row['onetime_charge_inr'] >= 0 || $row['onetime_charge_usd'] >= 0)){
				$rtn['data'][$c]['donation_type'] ="One Time";
			}
			$rtn['data'][$c]['bundle'] ="No";
			if($row['is_bundle'] == 1)
			{
				$rtn['data'][$c]['bundle'] ="Yes";
			}
			$rtn['data'][$c]['partial_payments'] ="No";
			if($row['partial_payments_allowed'] == 1)
			{
				$rtn['data'][$c]['partial_payments'] ="Yes";
			}
			$rtn['data'][$c]['price_fixed'] ="No";
			if($row['is_price_fixed'] == 1)
			{
				$rtn['data'][$c]['price_fixed'] ="Yes";
			}
			$rtn['data'][$c]['prasadam'] ="No";
			if($row['shipping'] == 1)
			{
				$rtn['data'][$c]['prasadam'] ="Yes";
			}
			//getting notification data
			$notificationData = $this->mobileNotifications_model->getNotificationIDBasedOnService($row['id'],'donations');
			$rtn['data'][$c]['notification_id'] = -1;
			if(!empty($notificationData)){
				$rtn['data'][$c]['notification_id'] = 0;
				if($notificationData->is_sent == 0){
					$rtn['data'][$c]['notification_id'] = $notificationData->id;
				}
			}
			$sno++;
			$c++;

		}
		return $rtn;
	}
	public function delete($id,$donationData)
	{
		$this->db->where("id",$id);
		$this->db->delete($this->tableName);

		if($donationData->image!='')
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
                                            "secretKey"=>aws_s3_secret_key,
                                            "useSSL"=>false,
                                            "endpoint"=>"s3.amazonaws.com"));
			$path="images/donation_images/".$donationData->image;
			$tpath="images/donation_images/thumb_".$donationData->image;
			$this->s3->deleteObject(aws_s3_bucket_name,$path);
			$this->s3->deleteObject(aws_s3_bucket_name,$tpath);
		}
		return 1;
	}

	public function changeStatus($id,$status)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array("status"=>$status));
	}

	public function save($id,$donationData)
	{
		$external_link='';
		$subscription=0;
		$is_bundle=0;
		$assign_pet=0;
		$includedates = '';
		$excludedates = '';
		$week_days=array('0'=>'Sunday','1'=>'Monday','2'=>'Tuesday','3'=>'Wednesday','4'=>'Thursday','5'=>'Friday','6'=>'Saturday');
		if(isset($_POST['days']))
		{
			$days=implode(",",$_POST['days']);
		}
		else
		{
			$days=implode(",",$week_days);
		}

		if(trim($_POST['include_exclude_dates']) == 'IncludeDates')
		{
			$includedates = trim($_POST['include_dates']);
		}
		if(trim($_POST['include_exclude_dates']) == 'ExcludeDates')
		{
			$excludedates = trim($_POST['exclude_dates']);
		}
		if($this->input->post("is_external_link")==1)
		{
			$external_link=$this->input->post('external_link');
		}
		if($this->input->post("subscription")=='on')
		{
			$subscription=1;
		}
		if($this->input->post("is_bundle")=='on')
		{
			$is_bundle=1;
		}
		if($this->input->post("assign_pet")=='on')
		{
			$assign_pet=1;
		}
		$max_family_members = 'All family members';
		if(isset($_POST['max_family_members']) && trim($_POST['max_family_members']) >= 1)
		{
			$max_family_members = trim($_POST['max_family_members']);
		}

		$display_suggested_amount = 0;
	    if(isset($_POST['display_suggested_amount']) && trim($_POST['display_suggested_amount']) == 1)
	    {
	        $display_suggested_amount = trim($_POST['display_suggested_amount']);
	    }

		$display_suggested_text = 0;
	    if(isset($_POST['display_suggested_text']) && trim($_POST['display_suggested_text']) == 1)
	    {
	        $display_suggested_text = trim($_POST['display_suggested_text']);
	    }
	    $suggested_text = "";
	    if(isset($_POST['suggested_text']) && trim($_POST['suggested_text']) != '' && $display_suggested_text==1)
	    {
	        $suggested_text = trim($_POST['suggested_text']);
	    }
		$is_secret = 0;
	    if(isset($_POST['is_secret']) && trim($_POST['is_secret']) == 1)
	    {
	        $is_secret = trim($_POST['is_secret']);
	    }
	    $allow_one_user_per_day_per_seva = 0;
	    if(isset($_POST['allow_one_user_per_day_per_seva']) && trim($_POST['allow_one_user_per_day_per_seva']) == 1)
	    {
	        $allow_one_user_per_day_per_seva = trim($_POST['allow_one_user_per_day_per_seva']);
	    }
	    $secret_key = NULL;
	    if(isset($_POST['s_key']) && trim($_POST['s_key']) != '' && $is_secret==1)
	    {
	        $secret_key = trim($_POST['s_key']);
	    }
	    $item_key = NULL;
	    if(isset($_POST['item_key']) && trim($_POST['item_key']) != '')
	    {
	        $item_key = trim($_POST['item_key']);
	    }

	    $is_public_display = 1;
	    if(isset($_POST['is_public_display']) && trim($_POST['is_public_display']) == 0)
	    {
	        $is_public_display = trim($_POST['is_public_display']);
	    }

	    $only_for_admin = 0;
	    if(isset($_POST['only_for_admin']) && trim($_POST['only_for_admin']) == 1)
	    {
	        $only_for_admin = trim($_POST['only_for_admin']);
	        $is_public_display = 0;
	    }

	    $only_for_admin = 0;
	    if(isset($_POST['only_for_admin']) && trim($_POST['only_for_admin']) == 1)
	    {
	        $only_for_admin = trim($_POST['only_for_admin']);
	        $is_public_display = 0;
	    }

	    $display_only_popup = 0;
	    if(isset($_POST['display_only_popup']) && trim($_POST['display_only_popup']) == 1)
	    {
	        $display_only_popup = trim($_POST['display_only_popup']);
	    }

	    $popup_content = '';
	    if(isset($_POST['popup_content']) && trim($_POST['popup_content']) != '')
	    {
	        $popup_content = $this->general_model->filtertext(trim($_POST['popup_content']));
	    }

	    $group_id = 0;
	    if(isset($_POST['group_id']) && trim($_POST['group_id']) > 0)
	    {
	        $group_id = trim($_POST['group_id']);
	    }

	    $limit_days_per_item = 'All available days';
		if(isset($_POST['limit_days_per_item']) && trim($_POST['limit_days_per_item']) >= 1)
		{
			$limit_days_per_item = trim($_POST['limit_days_per_item']);
		}

		$having_custom_email = 0;
	    if(isset($_POST['having_custom_email']) && trim($_POST['having_custom_email']) == 1)
	    {
	        $having_custom_email = trim($_POST['having_custom_email']);
	    }

	    $custom_email_text = '';
	    if(isset($_POST['custom_email_text']) && trim($_POST['custom_email_text']) != '')
	    {
	        $custom_email_text = $this->general_model->filtertext(trim($_POST['custom_email_text']));
	    }

	    $having_custom_sms = 0;
	    if(isset($_POST['having_custom_sms']) && trim($_POST['having_custom_sms']) == 1)
	    {
	        $having_custom_sms = trim($_POST['having_custom_sms']);
	    }

	    $custom_sms_text = '';
	    if(isset($_POST['custom_sms_text']) && trim($_POST['custom_sms_text']) != '')
	    {
	        $custom_sms_text = $this->general_model->filtertext(trim($_POST['custom_sms_text']));
	    }

		if(!$id)
		{
			$dData=array(
                    	'donation_name' => $this->general_model->filtertext(trim($_POST["donation_name"])),
                    	'donation_alias_name' => $this->general_model->filtertext(trim($_POST["donation_alias_name"])),
						'description' => $this->general_model->filtertext(trim($_POST["description"])),
						'shipping'=>$this->input->post("shipping"),
						'ashram_id' => $this->session->userdata("ashramId"),
						'category'=>$this->input->post('category'),
						'group_id'=>$group_id,
						'status'=>1,
						'is_external_link'=>$this->input->post('is_external_link'),
						'is_public_display'=>$is_public_display,
						'have_personal_note'=>$this->input->post('have_personal_note'),
						'days'=>$days,
						'include_exclude_dates'=>trim($_POST['include_exclude_dates']),
						'exclude_dates'=>$excludedates,
						'include_dates'=>$includedates,
						'is_price_fixed'=>$this->input->post('is_price_fixed'),
						'partial_payments_allowed'=>$this->input->post('partial_payments_allowed'),
						'max_family_members'=>$max_family_members,
						'limit_days_per_item'=>$limit_days_per_item,
						'external_link'=>$external_link,
						'subscription'=>$subscription,
						'is_bundle'=>$is_bundle,
						'assign_pet'=>$assign_pet,
						'is_secret'=>$is_secret,
						'allow_one_user_per_day_per_seva'=>$allow_one_user_per_day_per_seva,
						's_key'=>$secret_key,
						'item_key'=>$item_key,
						'only_for_admin'=>$only_for_admin,
						'display_only_popup'=>$display_only_popup,
						'popup_content'=>$popup_content,
						'display_suggested_text'=>$display_suggested_text,
						'display_suggested_amount'=>$display_suggested_amount,
						'suggested_text'=>$suggested_text,
						'having_custom_email'=>$having_custom_email,
						'custom_email_text'=>$custom_email_text,
						'having_custom_sms'=>$having_custom_sms,
						'custom_sms_text'=>$custom_sms_text,
					);
			if($subscription==1)
			{
				$dData['period']=$this->input->post('period');
				$dData['frequency']=$this->input->post('frequency');
				
				$dData['expiration_method']=$this->input->post('expiration_method');
				if($this->input->post('expiration_method')==1)
				{
					$dData['num_of_payments']=$this->input->post('num_of_payments');
					$dData['expiry_date']=null;
				}
				else if($this->input->post('expiration_method')==2)
				{
					$dData['num_of_payments']=0;
					$dData['expiry_date']=date("Y:m:d",strtotime($this->input->post('expiry_date')));
				}
				else
				{
					$dData['num_of_payments']=0;
					$dData['expiry_date']=null;
				}

				foreach ($GLOBALS['currencies'] as $currencyData)
				{
					$priceCol='onetime_charge_'.strtolower($currencyData['currency']);
					$dData[$priceCol]=$this->input->post($priceCol);
				}
			}
			$q=$this->db->insert($this->tableName,$dData);
			$idd=$this->db->insert_id();
			//saving live updates content for notifications
			$this->mobileNotifications_model->addNotification('Donations',$this->general_model->filtertext(trim($_POST['donation_name'])),$idd,'donations');
		}
		else
		{
			$dData=array(
	                    	'donation_name' => $this->general_model->filtertext(trim($_POST["donation_name"])),
	                    	'donation_alias_name' => $this->general_model->filtertext(trim($_POST["donation_alias_name"])),
							'description' => $this->general_model->filtertext(trim($_POST["description"])),
							'shipping'=>$this->input->post("shipping"),
							'category'=>$this->input->post('category'),
							'group_id'=>$group_id,
							'status'=>1,
							'is_external_link'=>$this->input->post('is_external_link'),
							'is_public_display'=>$is_public_display,
							'have_personal_note'=>$this->input->post('have_personal_note'),
							'days'=>$days,
							'include_exclude_dates'=>trim($_POST['include_exclude_dates']),
							'exclude_dates'=>$excludedates,
							'include_dates'=>$includedates,
							'is_price_fixed'=>$this->input->post('is_price_fixed'),
							'partial_payments_allowed'=>$this->input->post('partial_payments_allowed'),
							'max_family_members'=>$max_family_members,
							'limit_days_per_item'=>$limit_days_per_item,
							'external_link'=>$external_link,
							'subscription'=>$subscription,
							'is_bundle'=>$is_bundle,
							'assign_pet'=>$assign_pet,
							'is_secret'=>$is_secret,
							'allow_one_user_per_day_per_seva'=>$allow_one_user_per_day_per_seva,
							's_key'=>$secret_key,
							'item_key'=>$item_key,
							'only_for_admin'=>$only_for_admin,
							'display_only_popup'=>$display_only_popup,
							'popup_content'=>$popup_content,
							'display_suggested_text'=>$display_suggested_text,
							'display_suggested_amount'=>$display_suggested_amount,
							'suggested_text'=>$suggested_text,
							'having_custom_email'=>$having_custom_email,
							'custom_email_text'=>$custom_email_text,
							'having_custom_sms'=>$having_custom_sms,
							'custom_sms_text'=>$custom_sms_text,
						);
			if($subscription==1)
			{
				$dData['period']=$this->input->post('period');
				$dData['frequency']=$this->input->post('frequency');
				
				$dData['expiration_method']=$this->input->post('expiration_method');
				if($this->input->post('expiration_method')==1)
				{
					$dData['num_of_payments']=$this->input->post('num_of_payments');
					$dData['expiry_date']=null;
				}
				else if($this->input->post('expiration_method')==2)
				{
					$dData['num_of_payments']=0;
					$dData['expiry_date']=date("Y:m:d",strtotime($this->input->post('expiry_date')));
				}
				else
				{
					$dData['num_of_payments']=0;
					$dData['expiry_date']=null;
				}
				
				foreach ($GLOBALS['currencies'] as $currencyData)
				{
					$priceCol='onetime_charge_'.strtolower($currencyData['currency']);
					$dData[$priceCol]=$this->input->post($priceCol);
				}
			}
			else
			{
				$dData['expiry_date']=null;
				$dData['period']=null;
				$dData['frequency']=0;
				foreach ($GLOBALS['currencies'] as $currencyData)
				{
					$priceCol='onetime_charge_'.strtolower($currencyData['currency']);
					$dData[$priceCol]=0;
				}
			}

			$this->db->where('id', $id);
			$q=$this->db->update($this->tableName,$dData);
			$idd=$id;
		}

		$updateData=array();
		foreach ($GLOBALS['currencies'] as $currencyData)
		{
			if($this->input->post("is_price_fixed")==0)
			{
				$minPriceCol='min_price_'.strtolower($currencyData['currency']);
				$updateData[$minPriceCol]=$_POST[$minPriceCol];
			}
			$priceCol='price_'.strtolower($currencyData['currency']);
			$displayCol=strtolower($currencyData['currency'])."_display";
			$updateData[$priceCol]=$_POST[$priceCol];
			$shipDomestic='shipping_domestic_'.strtolower($currencyData['currency']);
			$shipInternational='shipping_international_'.strtolower($currencyData['currency']);
			if($this->input->post($displayCol)!='')
			{
				$updateData[$displayCol]=1;
			}
			else
			{
				$updateData[$displayCol]=0;	
			}
			if($this->input->post("shipping")==1)
			{	
				$updateData[$shipDomestic]=$_POST[$shipDomestic];
				$updateData[$shipInternational]=$_POST[$shipInternational];
			}
			else
			{
				$updateData[$shipDomestic]=0;
				$updateData[$shipInternational]=0;
			}
		}
		
		$this->db->where("id",$idd);
		$this->db->update($this->tableName,$updateData);

		if($is_bundle==1 && $this->input->post("donation_ids")!='')
		{
			$this->donations_bundle_model->update($idd,$this->input->post("donation_ids"));
		}
		else
		{
			$this->donations_bundle_model->remove($idd);
		}

		if($id && $donationData->image!='' && !isset($_POST['imgupl']))
		{
			$this->db->where("id",$id);
			$this->db->update($this->tableName,array('image'=>''));
			$path=aws_s3_base_url."/images/donation_images/thumb_".$donationData->image;
			if(file_exists($path))
				unlink($path);
		}
		
		if(isset($_FILES['donation_image']))
		if($_FILES['donation_image']['name']!='')
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			$this->load->helper('image');
			$name=$_FILES['donation_image']['name'];
			$ext=pathinfo ($_FILES['donation_image']['name'],PATHINFO_EXTENSION);			
			
			$newName="donation_".$idd."_".substr(md5(mt_rand()), 0, 16).".".$ext;
			$tempPath=$_FILES['donation_image']['tmp_name'];
			$tempName=basename($_FILES['donation_image']['tmp_name']);
			$thumbName="thumb_".$newName;
			$thumbPath=str_replace($tempName, $thumbName, $tempPath);
			$this->general_model->create_thumb_150($tempPath,$thumbPath);
			
			$image = new SimpleImage();
			$image->load($tempPath);
			$img_width=$image->getWidth();
	    	$img_height=$image->getHeight();
	    	$ratio=$img_width/$img_height;
	      
			if($ratio>=1)
			{
				if($img_width>800)
					$image->resizeToWidth(800);
			}
			else
			{
				if($img_height>800)
					$image->resizeToHeight(800);
			}
			$image->save($tempPath);
			$amazonUri="images/donation_images/";
			$amazonUriThumb="images/donation_images/thumb_".$newName;
			$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newName,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());
			
			$this->db->where("id",$idd);
			$this->db->update($this->tableName,array('image'=>$newName));
			
		}

		if($q)
			return $idd;
		else
			return 0;
	}

	public function checkDonationName($name,$id)
	{
		$error=0;

		$this->db->where("donation_name",$name);
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	//============================================================================================================================

	public function listPublic($ashramId,$admindata,$userdata)
	{
		$priceString='';
		foreach ($GLOBALS['currencies'] as $cData)
		{
			if($priceString!='') $priceString.=",";
			$priceString.='price_'.strtolower($cData['currency']);
			$priceString.=',d.min_price_'.strtolower($cData['currency']);
			$priceString.=',onetime_charge_'.strtolower($cData['currency']);
		}
		$query1=$this->db;
		$query1->select("d.id as id,donation_name,d.description,subscription,image,c.name as category_name,c.description as category_description,c.allow_public_display as category_description_display,external_link, ,days, include_exclude_dates, exclude_dates, include_dates, is_external_link, is_price_fixed,c.id as cid,period, frequency, expiry_date, expiration_method, num_of_payments, assign_pet,".$priceString.", d.display_only_popup, d.popup_content, d.display_suggested_text, d.display_suggested_amount, d.suggested_text, d.group_id, g.name as group_name, g.description as group_description,g.allow_public_display as group_description_display,g.allow_public_display as group_allow_public_display, d.donation_alias_name");

		$query1->where("ashram_id",$ashramId);
		if(!empty($this->session->userdata("cart_items_from_seva_details")) && $this->session->userdata("cart_items_from_seva_details")["order_type"] == 2 && $this->session->userdata("cart_items_from_seva_details")["user_id"] && ($this->session->userdata("defaultCurrency") == $this->session->userdata("cart_items_from_seva_details")["currency"]) && ($this->session->userdata("donationCartAshramIdSelection") == $this->session->userdata("cart_items_from_seva_details")["ashram_id"]))
        {
        	$query1->where("partial_payments_allowed",0);
        }
		$query1->where("subscription",0);
		$query1->where("status",1);
		
		if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("only_for_admin",0);
		}

		if(isset($_GET['s_key']) && $_GET['s_key']!='')
		{
			$query1->where("s_key",$_GET['s_key']);
		}
		else if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("s_key",null);
		}

		if(isset($_GET['item_key']) && $_GET['item_key']!='')
		{
			$query1->where("item_key",$_GET['item_key']);
		}

		if(isset($_GET['group_key']) && $_GET['group_key']!='')
		{
			$query1->where("g.group_key",$_GET['group_key']);
		}

		if(isset($userdata) || (isset($admindata) && $admindata->roles !=1 && $admindata->roles !=3 && $admindata->roles !=4) || (empty($admindata) && empty($userdata)))
		{
			// $query1->where("d.is_public_display",1);
			$groupAllowWhere = "( 
				                  CASE 
				                  WHEN d.group_id > 0 THEN
				                    d.is_public_display=1 AND g.allow_public_display=1
				                  ELSE
				                    d.is_public_display=1 
				                  END
				                )";
			$query1->where($groupAllowWhere);
		}
		
		$query1->from($this->tableName." as d");
		$query1->join("donations_categories as c","c.id=d.category","left");
		$query1->join("donations_groups as g","g.id=d.group_id","left");

		$displayCol=strtolower($this->session->userdata("defaultCurrency"))."_display";
		$query1->where($displayCol,1);

		//$query1->order_by('price_'.strtolower($this->session->userdata("defaultCurrency")),'desc');

		$query1->order_by('c.order','asc');
		$query1->order_by('d.order','asc');


		$rtn['data']=$query1->get()->result_array();
		$categories_donations=[];
		$categories=[];
		$temp_cats=[];
		$groups=[];
		$temp_groups=[];

		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$days=array_filter(explode(",",$row['days']));
			$priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));
			$oneTimePriceCol='onetime_charge_'.strtolower($this->session->userdata("defaultCurrency"));
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['expiry_date']=date("d M Y",strtotime($row['expiry_date']));
			$rtn['data'][$c]['price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$rtn['data'][$c][$priceCol];
			$rtn['data'][$c]['price_num']=$rtn['data'][$c][$priceCol];
			$rtn['data'][$c]['onetime_charge']=strtoupper($this->session->userdata("defaultCurrency"))." ".$rtn['data'][$c][$oneTimePriceCol];
			$rtn['data'][$c]['onetime_charge_num']=$rtn['data'][$c][$oneTimePriceCol];
			if($rtn['data'][$c]['image']=='')
				$rtn['data'][$c]['image']=aws_s3_base_url."images/donation_images/sample-donation.jpg";
			else
				$rtn['data'][$c]['image']=aws_s3_base_url."images/donation_images/thumb_".$rtn['data'][$c]['image'];

			if(count($days)==0 || count($days)==7)
			{
				$rtn['data'][$c]['days']='';
			}
			else
			{
				$rtn['data'][$c]['days']='(<b style="color:red;">Only on</b> ';
				$di=0;
				foreach ($days as $weekday)
				{
					if($di) $rtn['data'][$c]['days'].=", ";
					$rtn['data'][$c]['days'].=substr($weekday,0,3);
					$di++;
				}
				$rtn['data'][$c]['days'].=")";
			}
			
			$rtn['data'][$c]['include_dates_txt'] = '';
			if(isset($row['include_dates']) && $row['include_dates'] !='' && $row['include_dates'] != NULL)
			{
				$includeDts = explode(',', $row['include_dates']);
				usort($includeDts, array($this,'sortDatesByAscendingorder'));
				foreach($includeDts as $thisIncludeDt)
				{
					if($rtn['data'][$c]['include_dates_txt'] == '')
					{
						$rtn['data'][$c]['include_dates_txt'] .= date('j M Y (D)', strtotime($thisIncludeDt));
					} else {
						$rtn['data'][$c]['include_dates_txt'] .= '<br>'.date('j M Y (D)', strtotime($thisIncludeDt));
					}
				}
			}
			$rtn['data'][$c]['exclude_dates_txt'] = '';
			if(isset($row['exclude_dates']) && $row['exclude_dates'] !='' && $row['exclude_dates'] != NULL)
			{
				$excludeDts = explode(',', $row['exclude_dates']);
				usort($excludeDts, array($this,'sortDatesByAscendingorder'));
				foreach($excludeDts as $thisexcludeDt)
				{
					if($rtn['data'][$c]['exclude_dates_txt'] == '')
					{
						$rtn['data'][$c]['exclude_dates_txt'] .= date('j M Y (D)', strtotime($thisexcludeDt));
					} else {
						$rtn['data'][$c]['exclude_dates_txt'] .= '<br>'.date('j M Y (D)', strtotime($thisexcludeDt));
					}
				}
			}

			$categoryGroups = [];
			if($row['group_id']>0)
			{
				// $categories_donations[$row['cid']]['groups'][]=$rtn['data'][$c];
			}
			else
			{
				$categories_donations[$row['cid']][]=$rtn['data'][$c];
			}
			if(empty(trim($row['category_description'])))
			{
				$d_category = "";
			}
			else
			{
				$d_category = $row['category_description'];
			}
			if(!in_array($row['cid'],$temp_cats))
			{
				$categories[]=array("id"=>$row['cid'],"category"=>$row['category_name'],"category_description"=>$d_category,"category_description_display"=>$row['category_description_display']);
				$temp_cats[]=$row['cid'];
			}

			if($row['group_id']>0)
			{
				if(empty(trim($row['group_description'])))
				{
					$d_group = "";
				}
				else
				{
					$d_group = $row['group_description'];
				}
				if(!isset($temp_groups[$row['cid']]))
				{
					$groups[$row['cid']] = [];
					$temp_groups[$row['cid']] = [];
					$categories_donations[$row['cid']]['groups'] = [];
				}
				if(!in_array($row['group_id'],$temp_groups[$row['cid']]))
				{
					$categories_donations[$row['cid']]['groups'][$row['group_id']]['group_details']=array("id"=>$row['group_id'],"group_name"=>$row['group_name'],"group_description"=>$d_group,"group_description_display"=>$row['group_description_display']);
					$temp_groups[$row['cid']][]=$row['group_id'];
				}
				$categories_donations[$row['cid']]['groups'][$row['group_id']]['group_donations'][]=$rtn['data'][$c];
			}

			$c++;
		}
		unset($rtn['data']);
		$rtn['total']=$c;
		$rtn['categories']=$categories;
		$rtn['categories_donations']=$categories_donations;
		return $rtn;
	}

	public function listPublicS($ashramId,$admindata,$userdata)
	{
		if($this->session->userdata("defaultCurrency")=='')
		{
			$emptyRtn['total']=0;
			$emptyRtn['categories']=array();
			$emptyRtn['categories_donations']=array();
			return $emptyRtn;
			exit;
		}
		$priceString='';
		foreach ($GLOBALS['currencies'] as $cData)
		{
			if($priceString!='') $priceString.=",";
			$priceString.='price_'.strtolower($cData['currency']);
			$priceString.=',onetime_charge_'.strtolower($cData['currency']);
		}
		$query1=$this->db;
		$query1->select("d.id as id,donation_name,d.description,subscription,image,name as category_name,c.description as category_description,c.allow_public_display as category_description_display,external_link,is_external_link,is_price_fixed,c.id as cid,period,frequency,expiry_date,expiration_method,num_of_payments,assign_pet,".$priceString);

		$query1->where("ashram_id",$ashramId);
		$query1->where("subscription",1);
		$query1->where("status",1);
		if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("only_for_admin",0);
		}

		if(isset($_GET['s_key']) && $_GET['s_key']!='')
		{
			$query1->where("s_key",$_GET['s_key']);
		}
		else if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("s_key",null);
		}

		if(isset($_GET['item_key']) && $_GET['item_key']!='')
		{
			$query1->where("item_key",$_GET['item_key']);
		}

		if(isset($userdata) || (isset($admindata) && $admindata->roles !=1 && $admindata->roles !=3 && $admindata->roles !=4) || (empty($admindata) && empty($userdata)))
			$query1->where("is_public_display",1);
		
		$query1->from($this->tableName." as d");
		$query1->join("donations_categories as c","c.id=d.category","left");

		$displayCol=strtolower($this->session->userdata("defaultCurrency"))."_display";
		$query1->where($displayCol,1);

		//$query1->order_by('price_'.strtolower($this->session->userdata("defaultCurrency")),'desc');

		$query1->order_by('c.order','asc');
		$query1->order_by('d.order','asc');


		$rtn['data']=$query1->get()->result_array();
		$categories_donations=[];
		$categories=[];
		$temp_cats=[];

		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));
			$oneTimePriceCol='onetime_charge_'.strtolower($this->session->userdata("defaultCurrency"));
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['expiry_date']=date("d M Y",strtotime($row['expiry_date']));
			$rtn['data'][$c]['price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$rtn['data'][$c][$priceCol];
			$rtn['data'][$c]['price_num']=$rtn['data'][$c][$priceCol];
			$rtn['data'][$c]['onetime_charge']=strtoupper($this->session->userdata("defaultCurrency"))." ".$rtn['data'][$c][$oneTimePriceCol];
			$rtn['data'][$c]['onetime_charge_num']=$rtn['data'][$c][$oneTimePriceCol];
			if($rtn['data'][$c]['image']=='')
				$rtn['data'][$c]['image']=aws_s3_base_url."images/donation_images/sample-donation.jpg";
			else
				$rtn['data'][$c]['image']=aws_s3_base_url."images/donation_images/thumb_".$rtn['data'][$c]['image'];

			$categories_donations[$row['cid']][]=$rtn['data'][$c];
			if(empty(trim($row['category_description'])))
			{
				$d_category = "";
			}
			else
			{
				$d_category = $row['category_description'];
			}
			if(!in_array($row['cid'],$temp_cats))
			{
				$categories[]=array("id"=>$row['cid'],"category"=>$row['category_name'],"category_description"=>$d_category,"category_description_display"=>$row['category_description_display']);
				$temp_cats[]=$row['cid'];
			}
			$c++;
		}
		unset($rtn['data']);
		$rtn['total']=$c;
		$rtn['categories']=$categories;
		$rtn['categories_donations']=$categories_donations;
		return $rtn;
	}

	public function listPublicApi($ashramId,$currency)
	{
		$priceString='';
		foreach ($GLOBALS['currencies'] as $cData)
		{
			if($priceString!='') $priceString.=",";
			$priceString.='price_'.strtolower($cData['currency']);
			$priceString.=',onetime_charge_'.strtolower($cData['currency']);
		}
		$query1=$this->db;
		$query1->select("d.id as id,donation_name,d.description,subscription,image,name as category_name,external_link,is_external_link,is_price_fixed,c.id as cid,period,frequency,expiry_date,expiration_method,num_of_payments,assign_pet,".$priceString);

		$query1->where("ashram_id",$ashramId);
		$query1->where("status",1);
		if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("only_for_admin",0);
		}

		if(isset($_GET['s_key']) && $_GET['s_key']!='')
		{
			$query1->where("s_key",$_GET['s_key']);
		}
		else if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("s_key",null);
		}
		if(isset($_GET['item_key']) && $_GET['item_key']!='')
		{
			$query1->where("item_key",$_GET['item_key']);
		}
		
		$query1->from($this->tableName." as d");
		$query1->join("donations_categories as c","c.id=d.category","left");

		$displayCol=strtolower($currency)."_display";
		$query1->where($displayCol,1);

		//$query1->order_by('price_'.strtolower($this->session->userdata("defaultCurrency")),'desc');

		$query1->order_by('c.order','asc');
		$query1->order_by('d.order','asc');


		$rtn['data']=$query1->get()->result_array();
		$categories_donations=[];
		$categories=[];
		$temp_cats=[];

		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$priceCol='price_'.strtolower($currency);
			$oneTimePriceCol='onetime_charge_'.strtolower($currency);
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['expiry_date']=date("d M Y",strtotime($row['expiry_date']));
			$rtn['data'][$c]['price']=strtoupper($currency)." ".$rtn['data'][$c][$priceCol];
			$rtn['data'][$c]['price_num']=$rtn['data'][$c][$priceCol];
			$rtn['data'][$c]['onetime_charge']=strtoupper($currency)." ".$rtn['data'][$c][$oneTimePriceCol];
			$rtn['data'][$c]['onetime_charge_num']=$rtn['data'][$c][$oneTimePriceCol];
			if($rtn['data'][$c]['image']=='')
				$rtn['data'][$c]['image']=aws_s3_base_url."images/donation_images/sample-donation.jpg";
			else
				$rtn['data'][$c]['image']=aws_s3_base_url."images/donation_images/thumb_".$rtn['data'][$c]['image'];

			$categories_donations[$row['cid']][]=$rtn['data'][$c];
			if(!in_array($row['cid'],$temp_cats))
			{
				$categories[]=array("id"=>$row['cid'],"category"=>$row['category_name']);
				$temp_cats[]=$row['cid'];
			}
			$c++;
		}
		unset($rtn['data']);
		$rtn['total']=$c;
		$rtn['categories']=$categories;
		$rtn['categories_donations']=$categories_donations;
		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$donationsCategories=$this->donations_categories_model->getList();
		$categories=array();
		foreach ($donationsCategories as $donationsCategory)
		{
			$categories[$donationsCategory->id]=$donationsCategory;
		}

		$donationsGroups=$this->donations_groups_model->getList();
		$groups=array();
		foreach ($donationsGroups as $donationsGroup)
		{
			$groups[$donationsGroup->id]=$donationsGroup;
		}

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donation Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		foreach ($GLOBALS['currencies'] as $currencyData)
		{
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,
										"Price (".strtoupper($currencyData['currency'])." ".$currencyData['symbol'].")");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		}

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Category");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Group");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donatio Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subscription");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pet Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bundle");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Partial Pay");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Public Display");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Price Fixed");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Prasadam");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if($reportrow->subscription == 1)
			{
				if($reportrow->expiry_date)
					$dates = date('d M Y',strtotime($reportrow->expiry_date));
				else 
					$dates = "N/A";

				if($reportrow->expiration_method)
					$ex_method = $reportrow->expiration_method;
				else 
					$ex_method = "N/A";

				$reportrow->subscription_text= 	"One-Time INR: ".$reportrow->onetime_charge_inr."<br> One-Time USD: ".$reportrow->onetime_charge_usd."<br> Period: ".$reportrow->period."<br> Frequency: ".$reportrow->frequency."<br>Payments Count: ".$reportrow->num_of_payments."<br>Expiry Date: ".$dates."<br>";
			} else {
				$reportrow->subscription_text = "N/A";
			}
			$reportrow->pet_status ="N/A";
			if($reportrow->assign_pet == 1)
			{
				$reportrow->pet_status ="Yes";
			}
			if($reportrow->subscription == 1){
				$reportrow->donation_type ="Subscription";
			} else if($reportrow->subscription == 0 && ($reportrow->onetime_charge_inr >= 0 || $reportrow->onetime_charge_usd >= 0)){
				$reportrow->donation_type ="One Time";
			}
			$reportrow->bundle ="No";
			if($reportrow->is_bundle == 1)
			{
				$reportrow->bundle ="Yes";
			}
			$reportrow->partial_payments ="No";
			if($reportrow->partial_payments_allowed == 1)
			{
				$reportrow->partial_payments ="Yes";
			}
			$reportrow->price_fixed ="No";
			if($reportrow->is_price_fixed == 1)
			{
				$reportrow->price_fixed ="Yes";
			}
			$reportrow->prasadam ="No";
			if($reportrow->shipping == 1)
			{
				$reportrow->prasadam ="Yes";
			}
			if($reportrow->is_public_display == 0){
				$reportrow->is_public_display = "No";
			} else {
				$reportrow->is_public_display = "Yes";
			}
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->donation_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->description)));
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$priceCol="price_".strtolower($currencyData['currency']);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->$priceCol);
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$categories[$reportrow->category]->name);

			$group_name = "";
			if($reportrow->group_id>0)
			{
				$group_name = $groups[$reportrow->group_id]->name;
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$group_name);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->donation_type);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->subscription_text)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pet_status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bundle);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->partial_payments);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->is_public_display);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->price_fixed);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->prasadam);
			
			$status="Inactive";
			if($reportrow->status==1)
				$status="Active";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function searchDonations($string,$flag=0)
	{
		$this->db->select("*");
		$this->db->from($this->tableName);
		$this->db->like("donation_name",$string);
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$this->db->limit(10);
		return $this->db->get()->result();
	}

	public function sortDatesByAscendingorder($a, $b)
	{
	 	$a = date('Y-m-d', strtotime($a));
	    $b = date('Y-m-d', strtotime($b));

	    if ($a == $b) {
	        return 0;
	    }
	    return ($a < $b) ? -1 : 1;
	}

	public function checkDonationItemKeyExists($name,$id)
	{
		$error=0;

		$this->db->where("item_key",$name);
		$this->db->where("id !=",$id);
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	public function checkDonationSecretKeyExists($name,$id)
	{
		$error=0;

		$this->db->where("s_key",$name);
		$this->db->where("id !=",$id);
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	public function listPublicSearchDonations()
	{
		$i=0;
		$query1=$this->db;
		$query1->select("count(d.id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("donation_name,ashram_id");
		}
		$query1->from($this->tableName." as d");
		$query1->join("ashrams as a","d.ashram_id = a.id");
		$query1->where("a.is_public_display",1);
		$query1->where("d.status",1);
		$query1->where("d.only_for_admin",0);
		$query1->where("d.is_public_display",1);
		$query1->where("d.s_key",null);
		if(isset($_POST['search_text']) && $_POST['search_text']!='')
		{
			$query1->group_start();
			$query1->like("d.donation_name",$_POST['search_text']);
			$query1->or_like("d.description",$_POST['search_text']);
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('d.order','asc');
		$query1->group_by('d.id');

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		return $rtn;
	}

	
	//get poojas ashram_id,category from poojas table
	public function getByAshramCategoryId($ashramId,$categoryId)
	{
		$this->db->where("ashram_id",$ashramId);
		if($categoryId != 'null' && $categoryId != NULL && $categoryId > 0)
			$this->db->where("category",$categoryId);
		$this->db->order_by("status","desc");
		$this->db->order_by("donation_name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}
}
?>