<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Donations_bundle_model extends CI_Model
{
	var $tableName='donations_bundle';
	function __construct() 
	{
		parent::__construct();
    }
    public function getByDonation($donationId)
    {
    	$this->db->where("donation_id",$donationId);
    	$this->db->from($this->tableName." as db");
    	$this->db->join("donations as d","d.id=db.bundle_id");
    	return $this->db->get()->result();
    }
    public function remove($donationId)
    {
    	$this->db->where("donation_id",$donationId);
    	return $this->db->delete($this->tableName);
    }
    public function update($donationId,$bundleIds)
    {
    	$bundleIds=array_filter(explode(",",$bundleIds));

    	$this->db->where("donation_id",$donationId);
    	$existing=$this->db->get($this->tableName)->result();
    	$existingIds=array();
    	if(!empty($existing))
    	{
    		foreach ($existing as $bundleItem)
    		{
    			if(!in_array($bundleItem->bundle_id,$existingIds))
    				$existingIds[]=$bundleItem->bundle_id;
    		}
    	}

    	foreach ($existingIds as $existingId)
    	{
    		if(!in_array($existingId,$bundleIds))
    		{
    			//Delete
    			$this->db->where("donation_id",$donationId);
    			$this->db->where("bundle_id",$existingId);
    			$this->db->delete($this->tableName);
    		}
    	}

    	foreach ($bundleIds as $bundleId)
    	{
    		if(!in_array($bundleId,$existingIds))
    		{
    			//Insert
    			$this->db->insert($this->tableName,
    									array(
    											"donation_id"=>$donationId,
    											"bundle_id"=>$bundleId
    									)
    								);
    		}
    	}
    }
}
?>