<?PHP
class Ashrams_Model extends CI_Model 
{
	var $tableName="ashrams";
	public function __construct()
	{
		parent::__construct();
	}
	public function ashramData($id)
	{
		$this->db->where("id",$id);
		$q=$this->db->get($this->tableName);
		$result=$q->row();
		return $result;
	}
	public function getCount()
	{
		return $this->db->get($this->tableName)->num_rows();
	}
	public function ashramDataBySlug($slug)
	{
		$this->db->where("slug",$slug);
		$q=$this->db->get($this->tableName);
		$result=$q->row();
		return $result;
	}
	public function updateOrder($id,$value)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array('sort_order'=>$value));
	}
	public function getCountries()
	{
		$this->db->from($this->tableName." as a");
		$this->db->select("a.country_id as country_id,a.country_name as country_name,loc.isd_code as isd_code");
		$this->db->group_by("country_id");
		$this->db->join(db_prefix."locations.countries_list as loc","a.country_id=loc.country_code");
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}
	public function getList()
	{
		$this->db->select("*");
		$this->db->order_by("sort_order",'asc');
		
		if(!$this->currentUser)
			$this->db->where("is_public_display",1);
		
		if($this->currentUser && $this->currentUser->roles !=1 && $this->currentUser->roles !=3 && $this->currentUser->roles !=4 && $this->currentUser->roles !=7 && $this->currentUser->roles !=6 && $this->currentUser->roles !=8 && $this->currentUser->roles !=9)
		{
			$this->db->where("is_public_display",1);
		}

		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function getUserPaidOrdersAshramsByUserIdByModuleId($userId,$ModuleId=0, $noTx='No')
	{
		$this->db->from($this->tableName." as a");
		$this->db->join("orders as b","b.ashram_id = a.id");
		$this->db->select("a.*");
		$this->db->where("b.user_id",$userId);
		if($ModuleId>0)
		{
			$this->db->where("b.order_type",$ModuleId);
		}
		if($noTx=='Yes')
		{
			$this->db->where("b.no_paid_transactions",'Yes');
		}
		$this->db->order_by("a.sort_order",'asc');
		$this->db->group_by("a.id");
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}

	public function getUserFailedSubscriptionsAshramsByUserIdByModuleId($userId,$ModuleId=0)
	{
		$this->db->select("a.*");
		$this->db->from($this->tableName." as a");
		$this->db->join("orders as o","o.ashram_id = a.id");
		$this->db->join("subscription_payments as sp","sp.order_id = o.id");
		$this->db->where("sp.status",1);
		$this->db->where("o.user_id",$userId);
		$this->db->where("o.is_cancelled!=",1);

		if($ModuleId>0)
		{
			$this->db->where("b.order_type",$ModuleId);
		}
		$this->db->order_by("a.sort_order",'asc');
		$this->db->group_by("a.id");
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}

	public function getUserFailedOrdersAshramsByUserIdByModuleId($userId,$ModuleId='')
	{
		$this->db->from($this->tableName." as a");
		$this->db->join("orders_failed as b","b.ashram_id = a.id");
		$this->db->select("a.*");
		$this->db->where("b.user_id",$userId);
		if($ModuleId>0)
		{
			$this->db->where("b.order_type",$ModuleId);
		}
		$this->db->order_by("a.sort_order",'asc');
		$this->db->group_by("a.id");
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}

	public function listPublic($admindata,$userdata)
	{
		$i=0;

		$query1=$this->db;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		
		$query1->from($this->tableName);

		if(isset($userdata) || (isset($admindata) && $admindata->roles !=1 && $admindata->roles !=3 && $admindata->roles !=4) || (empty($admindata) && empty($userdata)))
			$query1->where("is_public_display",1);

		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$query1->where("country_id",$_POST['country']);
			}
		}
		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->group_start();
			$query1->like("name",trim($_POST['search_text']));
			$query1->or_like("contact_person",$_POST['search_text']);
			$query1->or_like("state_name",$_POST['search_text']);
			$query1->or_like("city",$_POST['search_text']);
			$query1->or_like("address",$_POST['search_text']);
			$query1->group_end();
		}
		
		$per_page=10;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("sort_order","asc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();
		$colors=array("red","blue","orange","green","purple");
		$ii=0;
		$ids=array();
		foreach ($rtn['res'] as $key=> $row) 
		{
			if($ii==5)
				$ii=0;
			$rtn['res'][$key]->color=$colors[$ii];
			$rtn['res'][$key]->location='';
			if($row->city!='')
				$rtn['res'][$key]->location.=$row->city;
			if($row->state_name!='')
			{
				if($rtn['res'][$key]->location!='') $rtn['res'][$key]->location.=", ";
				$rtn['res'][$key]->location.=$row->state_name;
			}
			if($rtn['res'][$key]->location!='') $rtn['res'][$key]->location.=", ";
			$rtn['res'][$key]->location.=$row->country_name;
			$rtn['res'][$key]->address=nl2br($row->address);
			$ii++;
		}

		return $rtn;
	}
	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nCountry: ";
		if(isset($_POST['country']))
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$query1->where("country_id",$_POST['country']);
				$preData.=$countryData->country_name;
			}
			else
				$preData.="All Countries";
		}
		else
		{
			$preData.="All Countries";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('name',$_POST['dir']);
				else
					$query1->order_by('name',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ashrams/ashrams_model",$sql,$this->currentUser,"default",$_POST,"All Ashrams",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('name',$dir);
		}
		else
		{
			$query1->order_by('name',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			
			$rtn['data'][$c]['sort_order'] = $rtn['data'][$c]['sort_order'];
			if(empty($rtn['data'][$c]['sort_order']))
				$rtn['data'][$c]['sort_order'] = "";

			if(!$rtn['data'][$c]['image'])
				$rtn['data'][$c]['ashram_image'] = aws_s3_base_url."images/site_assets/global_site_images/no-image.png";
			else
				$rtn['data'][$c]['ashram_image'] = aws_s3_base_url."images/ashrams/ashram_images/thumb_".$rtn['data'][$c]['image'];
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function listUser()
	{
		$i=0;
		$query1=$this->db;

		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("id,name,city,state_name,country_name,contact_person");
		}
		$query1->from($this->tableName);


		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
			/* if($_POST['wild']=='contains')
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
			else if($_POST['wild']=='starts')
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
			else if($_POST['wild']=='ends')
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before'); */
		}

		$preData.="\nCountry: ";
		if(isset($_POST['country']))
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$query1->where("country_id",$_POST['country']);
				$preData.=$countryData->country_name;
			}
			else
				$preData.="All Countries";
		}
		else
		{
			$preData.="All Countries";
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('name',$dir);
		}
		else
		{
			$query1->order_by('name',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$ashramIds=array();

		foreach ($rtn['data'] as $row)
		{
			if(!in_array($row['id'],$ashramIds))
			{
				$ashramIds[]=$row['id'];
			}
		}
		if(!empty($ashramIds))
		$subscribes=$this->ashram_members_model->byId($ashramIds,$this->currentUser->id);
		$newslettersubscribes=$this->ashram_members_model->receiveNewslettersbyId($ashramIds,$this->currentUser->id);

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['subscribe']=0;
			$rtn['data'][$c]['receive_newsletters']=0;
			if(isset($subscribes[$row['id']]) && $subscribes[$row['id']]==1)
			{
				$rtn['data'][$c]['subscribe']=1;
			}
			if(isset($newslettersubscribes[$row['id']]) && $newslettersubscribes[$row['id']]==1)
			{
				$rtn['data'][$c]['receive_newsletters']=1;
			}
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id,$ashramData)
	{
		$this->db->where("id",$id);
		$this->db->delete($this->tableName);
		return 1;
	}
	public function save($id,$ashramData)
	{
		$countryData=$this->locations_model->getCountryByCode($_POST['country_id']);
		$slug=strtolower(url_title($_POST['name']));
		$is_pan_required_for_inr = 0;
		$declaration_type = 'Donation';
		$gift_inr_templates = "";
		$gift_usd_templates = "";
		if(isset($_POST['is_pan_required_for_inr']) && $_POST['is_pan_required_for_inr']==1)
		{
			$is_pan_required_for_inr = 1;
		}
		if(isset($_POST['declaration_type']) && $_POST['declaration_type']=='Gift')
		{
			$declaration_type = 'Gift';
			if(isset($_POST['gift_inr_templates']) && $_POST['gift_inr_templates']!='')
			{
				$gift_inr_templates = $_POST['gift_inr_templates'];
			}
			if(isset($_POST['gift_usd_templates']) && $_POST['gift_usd_templates']!='')
			{
				$gift_usd_templates = $_POST['gift_usd_templates'];
			}
		}
		if(!$id)
		{
			$insertData = array(
                            	'name' => $this->general_model->filtertext(trim($_POST["name"])),
                            	'alias_name' => $this->general_model->filtertext(trim($_POST["alias_name"])),
								'show_alias_name_as_ashram_name'=>$this->input->post('show_alias_name_as_ashram_name'),
                            	'address' => $this->general_model->filtertext(trim($_POST["address"])),
								'description' => $this->general_model->filtertext(trim($_POST["description"])),
								'country_id' => $_POST["country_id"],
								'country_name'=>$countryData->country_name,
								'state_name' => $this->general_model->filtertext(trim($_POST["state_name"])),
								'city' => $this->general_model->filtertext(trim($_POST["city"])),
								'contact_person' => $this->general_model->filtertext(trim($_POST["contact_person"])),
								'contact_email' => $this->general_model->filtertext(trim($_POST["contact_email"])),
								'contact_phone' => $this->general_model->filtertext(trim($_POST["contact_phone"])),
								'slug'=>$slug,
								'is_public_display'=>$this->input->post('is_public_display'),
								'is_pan_required_for_inr'=>$is_pan_required_for_inr,
								'declaration_type'=>$declaration_type,
								'gift_inr_templates'=>$gift_inr_templates,
								'gift_usd_templates'=>$gift_usd_templates,
								'is_poojas_report_email'=>$this->input->post('is_poojas_report_email'),
								'poojas_report_emails'=>$this->input->post('poojas_report_emails'),
								'is_donations_report_email'=>$this->input->post('is_donations_report_email'),
								'donations_report_emails'=>$this->input->post('donations_report_emails'),
								'is_store_report_email'=>$this->input->post('is_store_report_email'),
								'store_report_emails'=>$this->input->post('store_report_emails'),
								'is_subscriptions_report_email'=>$this->input->post('is_subscriptions_report_email'),
								'subscriptions_report_emails'=>$this->input->post('subscriptions_report_emails'),
								'created_on'=>date("Y:m:d H:i:s")
							);
			$q=$this->db->insert($this->tableName, $insertData);
			$idd=$this->db->insert_id();
			$adminUsername="ashramadmin".$idd;
			$this->users_model->createAdmin($adminUsername,"Ashram","Admin",3,$idd);
			$adminUsername="officeadmin".$idd;
			$this->users_model->createAdmin($adminUsername,"Office","Admin",4,$idd);
			
			$this->ashrams_trust_accounts_model->createTrustsForAshram($idd);

			$this->currencies_model->addByAshram($idd);

			//Create email settings row
			$this->db->insert('email_settings',
                                array(
                                		'service_slug'=>"newsletter_a_".$idd,
                                		'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                		'smtp_host'=>base_domain,
                                		'smtp_port'=>'587',
                                		'email_template'=>'email_template',
                                		'ashram_id'=>$idd
                                	)
                               );
			$this->db->insert('email_settings',
                                array(
                                		'service_slug'=>"payments_".$idd."_inr",
                                		'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                		'smtp_host'=>base_domain,
                                		'smtp_port'=>'587',
                                		'email_template'=>'email_template',
                                		'ashram_id'=>$idd
                                	)
                               );
			$this->db->insert('email_settings',
                                array(
                                		'service_slug'=>"payments_".$idd."_usd",
                                		'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                		'smtp_host'=>base_domain,
                                		'smtp_port'=>'587',
                                		'email_template'=>'email_template',
                                		'ashram_id'=>$idd
                                	)
                               );
			$this->db->insert('email_settings',
                                array(
                                		'service_slug'=>"subs_card_exp_alerts_".$idd."_usd",
                                		'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                		'smtp_host'=>base_domain,
                                		'smtp_port'=>'587',
                                		'email_template'=>'email_template',
                                		'ashram_id'=>$idd
                                	)
                               );
			$this->db->insert('email_settings',
                                array(
                                		'service_slug'=>"subs_card_exp_alerts_".$idd."_inr",
                                		'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                		'smtp_host'=>base_domain,
                                		'smtp_port'=>'587',
                                		'email_template'=>'email_template',
                                		'ashram_id'=>$idd
                                	)
                               );
			$this->db->insert('email_settings',
                                array(
                                    'service_slug'=>"tx_failing_email_report_".$idd."_inr",
                                    'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                    'from_email'=>"noreply-payments",
                                    'from_name'=>"SGS Ashrama - Payments",
                                    "signature"=>"Kind Regards,<br>Office Accounts<br>SGS Ashrama<br>Mysore, India",
                                    'smtp_host'=>base_domain,
                                    'smtp_port'=>0,
                                    'email_template'=>'email_template',
                                    'ashram_id'=>$idd
                                  )
                               );

			$this->db->insert('email_settings',
                                array(
                                    'service_slug'=>"tx_failing_email_report_".$idd."_usd",
                                    'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                    'smtp_host'=>base_domain,
                                    'from_email'=>"noreply-dycusa-payments",
                                    'from_name'=>"DYC USA - Payments",
                                    'smtp_port'=>0,
                                    "signature"=>"Kind Regards,<br>DYC USA<br>",
                                    'email_template'=>'email_template',
                                    'ashram_id'=>$idd
                                  )
                               );

			$this->db->insert('email_settings',
                                array(
                                    'service_slug'=>"orders_no_tx_email_report_".$idd."_usd",
                                    'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                    'smtp_host'=>base_domain,
                                    'from_email'=>"noreply-dycusa-payments",
                                    'from_name'=>"DYC USA - Payments",
                                    'smtp_port'=>0,
                                    "signature"=>"Kind Regards,<br>DYC USA<br>",
                                    'email_template'=>'email_template',
                                    'ashram_id'=>$idd
                                  )
                               );

			$this->db->insert('email_settings',
                                array(
                                    'service_slug'=>"orders_no_tx_email_report_".$idd."_inr",
                                    'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                    'from_email'=>"noreply-payments",
                                    'from_name'=>"SGS Ashrama - Payments",
                                    "signature"=>"Kind Regards,<br>Office Accounts<br>SGS Ashrama<br>Mysore, India",
                                    'smtp_host'=>base_domain,
                                    'smtp_port'=>0,
                                    'email_template'=>'email_template',
                                    'ashram_id'=>$idd
                                  )
                               );

			$this->db->where("ashram_id",0);
			$default_currencies=$this->db->get("currencies");

			foreach ($default_currencies->result() as $default_currency_row)
			{
				$this->db->insert('currencies',
                                array(
                                		'ashram_id'=>$idd,
                                		'currency'=>$default_currency_row->currency,
                                		'symbol'=>$default_currency_row->symbol,
                                		'min'=>$default_currency_row->min,
                                		'max'=>$default_currency_row->max,
                                		'color'=>$default_currency_row->color,
                                		'order'=>$default_currency_row->order
                                	)
                               );
			}

			//Create mail track tables

			$emailDb=$this->load->database("emails",true,false);
			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_payments_".$idd."_usd` (
						  `id` int(11) NOT NULL AUTO_INCREMENT,
						  `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `date` datetime NOT NULL,
						  `sent_on` datetime DEFAULT NULL,
						  `sent_by` int(11) DEFAULT '0',
						  `mail_que_id` int(11) DEFAULT '0',
						  `delivered` int(11) DEFAULT '0',
						  `bounced` int(4) NOT NULL DEFAULT 0,
						  `viewed` int(11) DEFAULT '0',
						  `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
						  `user_id` int(11) DEFAULT '0',
						  `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
						  `resent` int(11) DEFAULT '0',
						  `resent_id` int(11) NOT NULL DEFAULT '0',
						  `type` int(11) DEFAULT '0',
						  `mail_track_id` int(11) DEFAULT '0',
						  `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `debug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `reads` int(11) NOT NULL DEFAULT '0',
						  `clicked` int(11) DEFAULT '0',
						  `priority` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY(`id`)
						) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

						");

			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_payments_".$idd."_inr` (
						  `id` int(11) NOT NULL AUTO_INCREMENT,
						  `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `date` datetime NOT NULL,
						  `sent_on` datetime DEFAULT NULL,
						  `sent_by` int(11) DEFAULT '0',
						  `mail_que_id` int(11) DEFAULT '0',
						  `delivered` int(11) DEFAULT '0',
						  `bounced` int(4) NOT NULL DEFAULT 0,
						  `viewed` int(11) DEFAULT '0',
						  `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
						  `user_id` int(11) DEFAULT '0',
						  `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
						  `resent` int(11) DEFAULT '0',
						  `resent_id` int(11) NOT NULL DEFAULT '0',
						  `type` int(11) DEFAULT '0',
						  `mail_track_id` int(11) DEFAULT '0',
						  `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `debug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `reads` int(11) NOT NULL DEFAULT '0',
						  `clicked` int(11) DEFAULT '0',
						  `priority` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY(`id`)
						) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_tx_failing_email_report_".$idd."_usd` (
						  `id` int(11) NOT NULL AUTO_INCREMENT,
						  `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `date` datetime NOT NULL,
						  `sent_on` datetime DEFAULT NULL,
						  `sent_by` int(11) DEFAULT '0',
						  `mail_que_id` int(11) DEFAULT '0',
						  `delivered` int(11) DEFAULT '0',
						  `bounced` int(4) NOT NULL DEFAULT 0,
						  `viewed` int(11) DEFAULT '0',
						  `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
						  `user_id` int(11) DEFAULT '0',
						  `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
						  `resent` int(11) DEFAULT '0',
						  `resent_id` int(11) NOT NULL DEFAULT '0',
						  `type` int(11) DEFAULT '0',
						  `mail_track_id` int(11) DEFAULT '0',
						  `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `debug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `reads` int(11) NOT NULL DEFAULT '0',
						  `clicked` int(11) DEFAULT '0',
						  `priority` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY(`id`)
						) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

						");

			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_tx_failing_email_report_".$idd."_inr` (
						  `id` int(11) NOT NULL AUTO_INCREMENT,
						  `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `date` datetime NOT NULL,
						  `sent_on` datetime DEFAULT NULL,
						  `sent_by` int(11) DEFAULT '0',
						  `mail_que_id` int(11) DEFAULT '0',
						  `delivered` int(11) DEFAULT '0',
						  `bounced` int(4) NOT NULL DEFAULT 0,
						  `viewed` int(11) DEFAULT '0',
						  `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
						  `user_id` int(11) DEFAULT '0',
						  `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
						  `resent` int(11) DEFAULT '0',
						  `resent_id` int(11) NOT NULL DEFAULT '0',
						  `type` int(11) DEFAULT '0',
						  `mail_track_id` int(11) DEFAULT '0',
						  `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `debug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `reads` int(11) NOT NULL DEFAULT '0',
						  `clicked` int(11) DEFAULT '0',
						  `priority` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY(`id`)
						) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_orders_no_tx_email_report_".$idd."_usd` (
                          `id` int(11) NOT NULL AUTO_INCREMENT,
                          `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
                          `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
                          `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                          `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                          `date` datetime NOT NULL,
                          `sent_on` datetime DEFAULT NULL,
                          `sent_by` int(11) DEFAULT '0',
                          `mail_que_id` int(11) DEFAULT '0',
                          `delivered` int(11) DEFAULT '0',
                          `bounced` int(4) NOT NULL DEFAULT 0,
                          `viewed` int(11) DEFAULT '0',
                          `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
                          `user_id` int(11) DEFAULT '0',
                          `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                          `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
                          `resent` int(11) DEFAULT '0',
                          `resent_id` int(11) NOT NULL DEFAULT '0',
                          `type` int(11) DEFAULT '0',
                          `mail_track_id` int(11) DEFAULT '0',
                          `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
                          `debug` mediumtext COLLATE utf8mb4_unicode_ci,
                          `reads` int(11) NOT NULL DEFAULT '0',
                          `clicked` int(11) DEFAULT '0',
                          `priority` int(11) NOT NULL DEFAULT '0',
                          PRIMARY KEY(`id`)
                        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

                $emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_orders_no_tx_email_report_".$idd."_inr` (
                          `id` int(11) NOT NULL AUTO_INCREMENT,
                          `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
                          `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
                          `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                          `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                          `date` datetime NOT NULL,
                          `sent_on` datetime DEFAULT NULL,
                          `sent_by` int(11) DEFAULT '0',
                          `mail_que_id` int(11) DEFAULT '0',
                          `delivered` int(11) DEFAULT '0',
                          `bounced` int(4) NOT NULL DEFAULT 0,
                          `viewed` int(11) DEFAULT '0',
                          `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
                          `user_id` int(11) DEFAULT '0',
                          `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                          `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
                          `resent` int(11) DEFAULT '0',
                          `resent_id` int(11) NOT NULL DEFAULT '0',
                          `type` int(11) DEFAULT '0',
                          `mail_track_id` int(11) DEFAULT '0',
                          `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
                          `debug` mediumtext COLLATE utf8mb4_unicode_ci,
                          `reads` int(11) NOT NULL DEFAULT '0',
                          `clicked` int(11) DEFAULT '0',
                          `priority` int(11) NOT NULL DEFAULT '0',
                          PRIMARY KEY(`id`)
                        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

                if( (isset($_POST['is_poojas_report_email']) && $_POST['is_poojas_report_email']==1) || 
                	(isset($_POST['is_donations_report_email']) && $_POST['is_donations_report_email']==1) || 
                	(isset($_POST['is_store_report_email']) && $_POST['is_store_report_email']==1) || 
                	(isset($_POST['is_subscriptions_report_email']) && $_POST['is_subscriptions_report_email']==1) 
            	)
                {
                	$this->createMailTrackTableForServiceByAshram('sevakarta_reports', $idd);
                }
                

			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_newsletter_a_".$idd."` (
			                `id` int(11) NOT NULL AUTO_INCREMENT,
			                `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
			                `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			                `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			                `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
			                `date` datetime NOT NULL,
			                `sent_on` datetime DEFAULT NULL,
			                `sent_by` int(11) DEFAULT '0',
			                `newsletter_id` int(11) NOT NULL DEFAULT '0',
			                `delivered` int(11) NOT NULL DEFAULT '0',
			                `bounced` int(4) NOT NULL DEFAULT 0,
			                `viewed` int(11) DEFAULT '0',
			                `status` int(11) DEFAULT '0',
			                `fail_reason` mediumtext COLLATE utf8mb4_unicode_ci,
			                `user_id` int(11) DEFAULT '0',
			                `resent` int(11) DEFAULT '0',
			                `resent_id` int(11) NOT NULL DEFAULT '0',
			                `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
			                `reads` int(11) NOT NULL DEFAULT '0',
			                `clicked` int(11) NOT NULL DEFAULT '0',
			                `debug` text COLLATE utf8mb4_unicode_ci,
			                PRIMARY KEY (`id`)
			            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

						");

			$smsDb=$this->load->database("sms",true,false);
			$smsDb->query("CREATE TABLE IF NOT EXISTS `sms_track_newsletter_a_".$idd."` (
							  `id` int(11) NOT NULL AUTO_INCREMENT,
							  `to` mediumtext COLLATE utf8mb4_unicode_ci,
							  `date` datetime NOT NULL,
							  `sent_on` datetime DEFAULT NULL,
							  `sent_by` int(11) DEFAULT '0',
							  `newsletter_id` int(11) NOT NULL DEFAULT '0',
							  `status` int(11) DEFAULT '0',
							  `fail_reason` mediumtext COLLATE utf8mb4_unicode_ci,
							  `user_id` int(11) DEFAULT '0',
							  `username` VARCHAR(200) NULL,
							  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `resent` int(11) DEFAULT '0',
							  `resent_id` int(11) NOT NULL DEFAULT '0',
							  `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
							  PRIMARY KEY (`id`)
							) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

						");

			$smsDb->query("CREATE TABLE IF NOT EXISTS `sms_track_payments_".$idd."_inr` (
							  `id` int(11) NOT NULL AUTO_INCREMENT,
							  `to` mediumtext COLLATE utf8mb4_unicode_ci,
							  `date` datetime NOT NULL,
							  `user_id` int(11) NOT NULL,
							  `username` VARCHAR(200) NULL,
							  `message_id` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `sent_on` datetime NOT NULL,
							  `status` int(11) NOT NULL DEFAULT '0',
							  `fail_reason` text COLLATE utf8mb4_unicode_ci,
							  `resent` int(11) NOT NULL DEFAULT '0',
							  `resent_id` int(11) NOT NULL DEFAULT '0',
							  PRIMARY KEY (`id`)
							) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
						");
			
			$smsDb->query("CREATE TABLE IF NOT EXISTS `sms_track_payments_".$idd."_usd` (
							  `id` int(11) NOT NULL AUTO_INCREMENT,
							  `to` mediumtext COLLATE utf8mb4_unicode_ci,
							  `date` datetime NOT NULL,
							  `user_id` int(11) NOT NULL,
							  `username` VARCHAR(200) NULL,
							  `message_id` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `sent_on` datetime NOT NULL,
							  `status` int(11) NOT NULL DEFAULT '0',
							  `fail_reason` text COLLATE utf8mb4_unicode_ci,
							  `resent` int(11) NOT NULL DEFAULT '0',
							  `resent_id` int(11) NOT NULL DEFAULT '0',
							  PRIMARY KEY (`id`)
							) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

						");

			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_subs_card_exp_alerts_".$idd."_inr` (
						  `id` int(11) NOT NULL AUTO_INCREMENT,
						  `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `date` datetime NOT NULL,
						  `sent_on` datetime DEFAULT NULL,
						  `sent_by` int(11) DEFAULT '0',
						  `mail_que_id` int(11) DEFAULT '0',
						  `delivered` int(11) DEFAULT '0',
						  `bounced` int(4) NOT NULL DEFAULT 0,
						  `viewed` int(11) DEFAULT '0',
						  `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
						  `user_id` int(11) DEFAULT '0',
						  `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
						  `resent` int(11) DEFAULT '0',
						  `resent_id` int(11) NOT NULL DEFAULT '0',
						  `type` int(11) DEFAULT '0',
						  `mail_track_id` int(11) DEFAULT '0',
						  `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `debug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `reads` int(11) NOT NULL DEFAULT '0',
						  `clicked` int(11) DEFAULT '0',
						  `priority` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY(`id`)
						) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_subs_card_exp_alerts_".$idd."_usd` (
						  `id` int(11) NOT NULL AUTO_INCREMENT,
						  `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `date` datetime NOT NULL,
						  `sent_on` datetime DEFAULT NULL,
						  `sent_by` int(11) DEFAULT '0',
						  `mail_que_id` int(11) DEFAULT '0',
						  `delivered` int(11) DEFAULT '0',
						  `bounced` int(4) NOT NULL DEFAULT 0,
						  `viewed` int(11) DEFAULT '0',
						  `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
						  `user_id` int(11) DEFAULT '0',
						  `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
						  `resent` int(11) DEFAULT '0',
						  `resent_id` int(11) NOT NULL DEFAULT '0',
						  `type` int(11) DEFAULT '0',
						  `mail_track_id` int(11) DEFAULT '0',
						  `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `debug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `reads` int(11) NOT NULL DEFAULT '0',
						  `clicked` int(11) DEFAULT '0',
						  `priority` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY(`id`)
						) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

			$this->createAshram80gYearNote($idd);
		}
		else
		{
			$updateData = array(
                            	'name' => $this->general_model->filtertext(trim($_POST["name"])),
                            	'alias_name' => $this->general_model->filtertext(trim($_POST["alias_name"])),
								'show_alias_name_as_ashram_name'=>$this->input->post('show_alias_name_as_ashram_name'),
								'address' => $this->general_model->filtertext(trim($_POST["address"])),
								'description' => $this->general_model->filtertext(trim($_POST["description"])),
								'country_id' => $_POST["country_id"],
								'country_name'=>$countryData->country_name,
								'state_name' => $this->general_model->filtertext(trim($_POST["state_name"])),
								'city' => $this->general_model->filtertext(trim($_POST["city"])),
								'contact_person' => $this->general_model->filtertext(trim($_POST["contact_person"])),
								'contact_email' => $this->general_model->filtertext(trim($_POST["contact_email"])),
								'contact_phone' => $this->general_model->filtertext(trim($_POST["contact_phone"])),
								'slug'=>$slug,
								'is_public_display'=>$this->input->post('is_public_display'),
								'is_pan_required_for_inr'=>$is_pan_required_for_inr,
								'declaration_type'=>$declaration_type,
								'gift_inr_templates'=>$gift_inr_templates,
								'gift_usd_templates'=>$gift_usd_templates,
								'is_poojas_report_email'=>$this->input->post('is_poojas_report_email'),
								'poojas_report_emails'=>$this->input->post('poojas_report_emails'),
								'is_donations_report_email'=>$this->input->post('is_donations_report_email'),
								'donations_report_emails'=>$this->input->post('donations_report_emails'),
								'is_store_report_email'=>$this->input->post('is_store_report_email'),
								'store_report_emails'=>$this->input->post('store_report_emails'),
								'is_subscriptions_report_email'=>$this->input->post('is_subscriptions_report_email'),
								'subscriptions_report_emails'=>$this->input->post('subscriptions_report_emails'),
								'modified_on'=>date("Y:m:d H:i:s")
							);
			$this->db->where('id', $id);
			$q=$this->db->update($this->tableName, $updateData);

			//Update Ashram Name to trust accounts associated with this ashram
			$this->ashrams_trust_accounts_model->updateAshramNameToAssociatedTrustsOfAshram($id);


			//Clear Cart data if is_public_display is 0
			if($this->input->post('is_public_display') == 0)
			{
				$this->load->model("orders/orders_model");
				$this->orders_model->emptyCartData(date('Y-m-d'),$id,0,0);
			}

			if( (isset($_POST['is_poojas_report_email']) && $_POST['is_poojas_report_email']==1) || 
            	(isset($_POST['is_donations_report_email']) && $_POST['is_donations_report_email']==1) || 
            	(isset($_POST['is_store_report_email']) && $_POST['is_store_report_email']==1) || 
            	(isset($_POST['is_subscriptions_report_email']) && $_POST['is_subscriptions_report_email']==1) 
        	)
            {
            	$this->createMailTrackTableForServiceByAshram('sevakarta_reports', $id);
            }

			$idd=$id;
		}

		if($idd>0)
		{
			foreach ($GLOBALS['currencies'] as $currency)
			{
				if(isset($_POST['currency']) && in_array($currency['currency'], $_POST['currency']))
				{
					$this->currencies_model->update(strtolower($currency['currency']),$idd,1);
				}
				else
				{
					$this->currencies_model->update(strtolower($currency['currency']),$idd,0);
				}
			}
		}

		if($id)
		{
			$ashramDetails = $this->ashramData($id);
			if($ashramDetails->image!='' && !isset($_POST['imgupl']))
			{
				$this->db->where("id",$id);
				$this->db->update($this->tableName,array('image'=>''));
				$path=aws_s3_base_url."/images/ashrams/ashram_images/".$ashramDetails->image;
				if(file_exists($path))
					unlink($path);
				$thumbPath=aws_s3_base_url."/images/ashrams/ashram_images/thumb_".$ashramDetails->image;
				if(file_exists($thumbPath))
					unlink($thumbPath);
			}
		}

		if(isset($_FILES['ashram_image']))
		if($_FILES['ashram_image']['name']!='')
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$name=$_FILES['ashram_image']['name'];
			$ext=pathinfo ($_FILES['ashram_image']['name'],PATHINFO_EXTENSION);			
			
			$newName="ashram_".$idd."_".substr(md5(mt_rand()), 0, 16).".".$ext;
			$tempPath=$_FILES['ashram_image']['tmp_name'];
			$tempName=basename($_FILES['ashram_image']['tmp_name']);
			$thumbName="thumb_".$newName;
			$thumbPath=str_replace($tempName, $thumbName, $tempPath);
			$this->general_model->create_thumb_150($tempPath,$thumbPath);
			
			$image = new SimpleImage();
			$image->load($tempPath);
			$img_width=$image->getWidth();
	    	$img_height=$image->getHeight();
	    	$ratio=$img_width/$img_height;
	      
			if($ratio>=1)
			{
				if($img_width>800)
					$image->resizeToWidth(800);
			}
			else
			{
				if($img_height>800)
					$image->resizeToHeight(800);
			}
			$image->save($tempPath);
			
			$amazonUri="images/ashrams/ashram_images/";
			$amazonUriThumb="images/ashrams/ashram_images/thumb_".$newName;
			$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newName,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());

			$this->db->where("id",$idd);
			$this->db->update($this->tableName,array('image'=>$newName));
			
		}

		if($q)
			return $idd;
		else
			return 0;
	}

	public function createMailTrackTableForServiceByAshram($service = '', $ashramId=0)
	{
		if($ashramId>0 && trim($service)!='')
		{
			$emailDb=$this->load->database("emails",true,false);
			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_".$service."_".$ashramId."` (
	                          `id` int(11) NOT NULL AUTO_INCREMENT,
	                          `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
	                          `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
	                          `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                          `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                          `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
	                          `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
	                          `date` datetime NOT NULL,
	                          `sent_on` datetime DEFAULT NULL,
	                          `sent_by` int(11) DEFAULT '0',
	                          `mail_que_id` int(11) DEFAULT '0',
	                          `delivered` int(11) DEFAULT '0',
	                          `bounced` int(4) NOT NULL DEFAULT 0,
	                          `viewed` int(11) DEFAULT '0',
	                          `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
	                          `user_id` int(11) DEFAULT '0',
	                          `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
	                          `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
	                          `resent` int(11) DEFAULT '0',
	                          `resent_id` int(11) NOT NULL DEFAULT '0',
	                          `type` int(11) DEFAULT '0',
	                          `mail_track_id` int(11) DEFAULT '0',
	                          `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
	                          `debug` mediumtext COLLATE utf8mb4_unicode_ci,
	                          `reads` int(11) NOT NULL DEFAULT '0',
	                          `clicked` int(11) DEFAULT '0',
	                          `priority` int(11) NOT NULL DEFAULT '0',
	                          PRIMARY KEY(`id`)
	                        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

			$serviceSlug = $service."_".$ashramId;
			$email_setting_check = $this->db->select("id")->from("email_settings")->where("service_slug",$serviceSlug)->get();
	        if($email_setting_check->num_rows() == 0)
	        {
	             $this->db->insert('email_settings',
	              array(
	                  'service_slug'=>$serviceSlug,
	                  'smtp_host'=>base_domain,
	                  'smtp_port'=>'587',
	                  'email_template'=>'email_template',
	                  'ashram_name'=>"",
	                  "from_email"=>"noreply-".$serviceSlug,
	                  "from_name"=>"SGS Ashrama - Sevakarta Reports",
	                  "signature"=>"Kind Regards,<br>SGS Ashrama Tech Team<br>",
	                  'ashram_id'=>0
	                )
	             );
	        }
		}
	}

	public function savePage()
	{
		$ashramId=$this->session->userdata("ashramId");
		$this->db->where('id', $this->session->userdata("ashramId"));
		$q=$this->db->update($this->tableName,
                            array
                            	(
                            		'content' => $this->general_model->filtertext(trim($_POST["content"]))
								)
							);

		$this->load->helper("simple_html_dom");
		$dom=new simple_html_dom();
		$tempContent=trim($_POST['content']);
		$contentDom=$dom->load($tempContent);
		$images=$contentDom->find('img');
		if(count($images))
		{
			if($ashramId)
			{
				$existingImages=$this->ashrampage_images_model->getImagesByAshramId($ashramId);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$eArray[$eimage->filename]=$eimage->id;
				}
				$editorImages=[];
				foreach ($images as $img_dom) 
				{
					$pathText=$img_dom->attr['src'];
					if(preg_match('/amazon/i',$pathText))
					{
						$editorImages[basename($pathText)]=basename($pathText);
					}
				}
				$diff=array_diff_key($eArray,$editorImages);
				//$keys=array_keys($diff);

				if(count($diff))
				{
					foreach($diff as $ikey)
					$this->ashrampage_images_model->deleteImage($ashramId,$ikey);
				}

			}

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="content/ashrams/".$this->session->userdata("ashramId")."/";
			foreach ($images as $img_dom) 
			{
				$pathText=$img_dom->attr['src'];
				if(preg_match('/amazon/i',$pathText))
					continue;

				$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
				if(file_exists($path))
				{
					$fname=basename($path);
					$newFileName=$ashramId."_".$fname;
					$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
					$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
					unlink($path);

					$imageData=array('filename' => $newFileName,
									'ashram_id' =>$ashramId
									);
					$this->ashrampage_images_model->insert($imageData);
				}
			}
			$this->db->where("id",$ashramId);
			$this->db->update($this->tableName,array("content"=>$tempContent));
		}
		else
		{
			$existingImages=$this->ashrampage_images_model->getImagesByAshramId($ashramId);
			$eArray=[];
			foreach ($existingImages as $eimage)
			{
				$this->ashrampage_images_model->deleteImage($ashramId,$eimage->id);
			}
		}
	}

	public function checkName($name,$id)
	{
		$error=0;

		$slug=strtolower(url_title($name));

		$this->db->where("name",$name);
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		$this->db->where("slug",$slug);
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}
		return $error;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		/*if($excelData->page_number==2)
		{
			$objPHPExcel=$this->eventsExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}*/

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Contact Person");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Public Display");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if($reportrow->is_public_display == 0)
			{
				$reportrow->is_public_display = "No";
			} 
			else 
			{
				$reportrow->is_public_display = "Yes";
			}

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_person);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->is_public_display);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}


	public function getOnlyActivePoojaItemsAshramList()
	{
		$this->db->select("a.*");
		$this->db->from($this->tableName." as a");
		$this->db->join("poojas as p","p.ashram_id = a.id");

		if(!$this->currentUser)
		{
			$this->db->where("a.is_public_display",1);
			$this->db->where("p.is_public_display",1);
		}
		
		if($this->currentUser && $this->currentUser->roles !=1 && $this->currentUser->roles !=3 && $this->currentUser->roles !=4 && $this->currentUser->roles !=7 && $this->currentUser->roles !=6 && $this->currentUser->roles !=8 && $this->currentUser->roles !=9)
		{
			$this->db->where("a.is_public_display",1);
			$this->db->where("p.is_public_display",1);
		}
		$this->db->where("p.status",1);
		$this->db->order_by("a.sort_order",'asc');
		$this->db->group_by('a.id');
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}

	public function getOnlyActiveDonationItemsAshramList()
	{
		$this->db->select("a.*");
		$this->db->from($this->tableName." as a");
		$this->db->join("donations as d","d.ashram_id = a.id");

		if(!$this->currentUser)
		{
			$this->db->where("a.is_public_display",1);
			$this->db->where("d.is_public_display",1);
		}
		
		if($this->currentUser && $this->currentUser->roles !=1 && $this->currentUser->roles !=3 && $this->currentUser->roles !=4 && $this->currentUser->roles !=7 && $this->currentUser->roles !=6 && $this->currentUser->roles !=8 && $this->currentUser->roles !=9)
		{
			$this->db->where("a.is_public_display",1);
			$this->db->where("d.is_public_display",1);
		}
		$this->db->where("d.status",1);
		$this->db->order_by("a.sort_order",'asc');
		$this->db->group_by('a.id');
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}

	public function getOnlyActiveSubscriptionItemsAshramList()
	{
		$this->db->select("a.*");
		$this->db->from($this->tableName." as a");
		$this->db->join("subscriptions as s","s.ashram_id = a.id");

		if(!$this->currentUser)
		{
			$this->db->where("a.is_public_display",1);
			$this->db->where("s.is_public_display",1);
		}
		
		if($this->currentUser && $this->currentUser->roles !=1 && $this->currentUser->roles !=3 && $this->currentUser->roles !=4 && $this->currentUser->roles !=7 && $this->currentUser->roles !=6 && $this->currentUser->roles !=8 && $this->currentUser->roles !=9)
		{
			$this->db->where("a.is_public_display",1);
			$this->db->where("s.is_public_display",1);
		}
		$this->db->where("s.status",1);
		$this->db->order_by("a.sort_order",'asc');
		$this->db->group_by('a.id');
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}

	public function getOnlyActiveStoreItemsAshramList()
	{
		$this->db->select("a.*");
		$this->db->from($this->tableName." as a");
		$this->db->join("store as s","s.ashram_id = a.id");

		if(!$this->currentUser)
		{
			$this->db->where("a.is_public_display",1);
			$this->db->where("s.is_public_display",1);
		}
		
		if($this->currentUser && $this->currentUser->roles !=1 && $this->currentUser->roles !=3 && $this->currentUser->roles !=4 && $this->currentUser->roles !=7 && $this->currentUser->roles !=6 && $this->currentUser->roles !=8 && $this->currentUser->roles !=9)
		{
			$this->db->where("a.is_public_display",1);
			$this->db->where("s.is_public_display",1);
		}
		$this->db->where("s.status",1);
		$this->db->order_by("a.sort_order",'asc');
		$this->db->group_by('a.id');
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}

	public function getAshram80gByAshramIdAndYear($ashram_id, $ashram_80g_year)
	{
		$this->db->where("ashram_id",$ashram_id);
		$this->db->where('ashram_80g_year',$ashram_80g_year);
		$q=$this->db->get('ashram_80g_years_note');
		return $q->row();
	}

	public function createAshram80gYearNote($ashram_id, $ashram_80g_note="")
	{
		if($ashram_id>0)
		{
			$user_id= 0;
			if($this->session->userdata('loggedIn'))
			{
				if($this->session->userdata('id'))
					$user_id=$this->session->userdata('admin_data')->id;
				else
					$user_id=$this->session->userdata('user_data')->id;
			}
			$yearData = [];
            $y=date("Y");
            $y = ($y+1);
            for($i=2016;$i<=$y;$i++)
            {
                if(date("Y") == $i && date('m')>=4)
                {
                    $inrstartdate = $i."-".financial_year_start_month_date;
                    $inrstartdateStr = date("jS M Y", strtotime($inrstartdate));
                    $inrenddate = ($i+1)."-".financial_year_end_month_date;
                    $inrenddateStr = date("jS M Y", strtotime($inrenddate));
                    $yearData[$inrstartdate."_to_".$inrenddate] = $inrstartdateStr." - ".$inrenddateStr;
                }
                else
                {
                    $inrstartdate = ($i-1)."-".financial_year_start_month_date;
                    $inrstartdateStr = date("jS M Y", strtotime($inrstartdate));
                    $inrenddate = ($i)."-".financial_year_end_month_date;
                    $inrenddateStr = date("jS M Y", strtotime($inrenddate));
                    $yearData[$inrstartdate."_to_".$inrenddate] = $inrstartdateStr." - ".$inrenddateStr;
                }
            }
            $ashramData = $this->ashramData($ashram_id);
            if(!empty($ashramData))
            {
            	foreach($yearData as $key => $thisYear)
            	{
            		$this->db->where("ashram_id",$ashramData->id);
					$this->db->where("ashram_80g_year",$key);
					$q=$this->db->get('ashram_80g_years_note');
					$checkYear80gExists = $q->result();
					if(empty($checkYear80gExists))
					{
	            		$ashram80gYearData = [
	            								"ashram_id"=>$ashramData->id,
	            								"ashram_80g_year"=>$key,
	            								"ashram_80g_note"=>$ashram_80g_note,
	            								"created_by"=>$user_id,
	            								"created_on"=>date('Y-m-d H:i:s')
	            							];
	            		$this->db->insert('ashram_80g_years_note', $ashram80gYearData);
	            	}
            	}
            }
		}
	}

	public function updateAshram80gNote($ashram_id,$ashram_80g_year,$ashram_80g_note)
	{
		$user_id= 0;
		if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
				$user_id=$this->session->userdata('admin_data')->id;
			else
				$user_id=$this->session->userdata('user_data')->id;
		}

		$checkYearNote = $this->getAshram80gByAshramIdAndYear($ashram_id, $ashram_80g_year);
		if(empty($checkYearNote))
		{
			$ashramData = $this->ashramData($ashram_id);
            if(!empty($ashramData))
            {
				$ashram80gYearData = [
	    								"ashram_id"=>$ashramData->id,
	    								"ashram_80g_year"=>$ashram_80g_year,
	    								"ashram_80g_note"=>$ashram_80g_note,
	    								"created_by"=>$user_id,
	    								"created_on"=>date('Y-m-d H:i:s')
	    							];
	    		$this->db->insert('ashram_80g_years_note', $ashram80gYearData);
	    		$lastInsertedId = $this->db->insert_id();
	    	}
		}
		else
		{
			$this->db->where("ashram_id",$ashram_id);
			$this->db->where("ashram_80g_year",$ashram_80g_year);
			$this->db->update('ashram_80g_years_note',array('ashram_80g_note'=>$ashram_80g_note, "modified_by"=>$user_id, "modified_on"=>date('Y-m-d H:i:s')));
		}

		
	}


	public function ashram80gYearsDataByAshramId($ashram_id)
	{
		$this->db->where("ashram_id",$ashram_id);
		$this->db->order_by("ashram_80g_year","desc");
		$q=$this->db->get("ashram_80g_years_note");
		return $q->result();
	}

	public function updateAshramYearEndStatement($ashram_id)
	{
		$updateData = array();
		if(isset($_POST['trust_name_inr']))
		{
			$updateData['trust_name_inr'] = $this->general_model->filtertext(trim($_POST["trust_name_inr"]));
		}
		if(isset($_POST['trust_name_usd']))
		{
			$updateData['trust_name_usd'] = $this->general_model->filtertext(trim($_POST["trust_name_usd"]));
		}
		if(isset($_POST['trust_address_inr']))
		{
			$updateData['trust_address_inr'] = $this->general_model->filtertext(trim($_POST["trust_address_inr"]));
		}
		if(isset($_POST['trust_address_usd']))
		{
			$updateData['trust_address_usd'] = $this->general_model->filtertext(trim($_POST["trust_address_usd"]));
		}
		if(isset($_POST['year_end_statement_text_inr']))
		{
			$updateData['year_end_statement_text_inr'] = $this->general_model->filtertext(trim($_POST["year_end_statement_text_inr"]));
		}
		if(isset($_POST['year_end_statement_text_usd']))
		{
			$updateData['year_end_statement_text_usd'] = $this->general_model->filtertext(trim($_POST["year_end_statement_text_usd"]));
		}

		if(!empty($updateData))
		{
			$this->db->where('id', $ashram_id);
			$q=$this->db->update($this->tableName, $updateData);
		}

		if($ashram_id)
		{
			$ashramDetails = $this->ashramData($ashram_id);
			if($ashramDetails->year_end_statement_image_inr!='' && !isset($_POST['imgupl_inr']))
			{
				$this->db->where("id",$ashram_id);
				$this->db->update($this->tableName,array('year_end_statement_image_inr'=>''));
				$path=aws_s3_base_url."/images/ashrams/ashram_images/".$ashramDetails->year_end_statement_image_inr;
				if(file_exists($path))
					unlink($path);
				$thumbPath=aws_s3_base_url."/images/ashrams/ashram_images/thumb_".$ashramDetails->year_end_statement_image_inr;
				if(file_exists($thumbPath))
					unlink($thumbPath);
			}
			if($ashramDetails->year_end_statement_image_usd!='' && !isset($_POST['imgupl_usd']))
			{
				$this->db->where("id",$ashram_id);
				$this->db->update($this->tableName,array('year_end_statement_image_usd'=>''));
				$path=aws_s3_base_url."/images/ashrams/ashram_images/".$ashramDetails->year_end_statement_image_usd;
				if(file_exists($path))
					unlink($path);
				$thumbPath=aws_s3_base_url."/images/ashrams/ashram_images/thumb_".$ashramDetails->year_end_statement_image_usd;
				if(file_exists($thumbPath))
					unlink($thumbPath);
			}
		}


		if(isset($_FILES['year_end_statement_image_inr']))
		if($_FILES['year_end_statement_image_inr']['name']!='')
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$name=$_FILES['year_end_statement_image_inr']['name'];
			$ext=pathinfo ($_FILES['year_end_statement_image_inr']['name'],PATHINFO_EXTENSION);			
			
			$newName="ashram_year_end_statement_inr_".$ashram_id."_".substr(md5(mt_rand()), 0, 16).".".$ext;
			$tempPath=$_FILES['year_end_statement_image_inr']['tmp_name'];
			$tempName=basename($_FILES['year_end_statement_image_inr']['tmp_name']);
			$thumbName="thumb_".$newName;
			$thumbPath=str_replace($tempName, $thumbName, $tempPath);
			$this->general_model->create_thumb_150($tempPath,$thumbPath);
			
			$image = new SimpleImage();
			$image->load($tempPath);
			$img_width=$image->getWidth();
	    	$img_height=$image->getHeight();
	    	$ratio=$img_width/$img_height;
	      
			if($ratio>=1)
			{
				if($img_width>800)
					$image->resizeToWidth(800);
			}
			else
			{
				if($img_height>800)
					$image->resizeToHeight(800);
			}
			$image->save($tempPath);
			
			$amazonUri="images/ashrams/ashram_images/";
			$amazonUriThumb="images/ashrams/ashram_images/thumb_".$newName;
			$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newName,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());

			$this->db->where("id",$ashram_id);
			$this->db->update($this->tableName,array('year_end_statement_image_inr'=>$newName));
		}

		if(isset($_FILES['year_end_statement_image_usd']))
		if($_FILES['year_end_statement_image_usd']['name']!='')
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$name=$_FILES['year_end_statement_image_usd']['name'];
			$ext=pathinfo ($_FILES['year_end_statement_image_usd']['name'],PATHINFO_EXTENSION);			
			
			$newName="ashram_year_end_statement_usd_".$ashram_id."_".substr(md5(mt_rand()), 0, 16).".".$ext;
			$tempPath=$_FILES['year_end_statement_image_usd']['tmp_name'];
			$tempName=basename($_FILES['year_end_statement_image_usd']['tmp_name']);
			$thumbName="thumb_".$newName;
			$thumbPath=str_replace($tempName, $thumbName, $tempPath);
			$this->general_model->create_thumb_150($tempPath,$thumbPath);
			
			$image = new SimpleImage();
			$image->load($tempPath);
			$img_width=$image->getWidth();
	    	$img_height=$image->getHeight();
	    	$ratio=$img_width/$img_height;
	      
			if($ratio>=1)
			{
				if($img_width>800)
					$image->resizeToWidth(800);
			}
			else
			{
				if($img_height>800)
					$image->resizeToHeight(800);
			}
			$image->save($tempPath);
			
			$amazonUri="images/ashrams/ashram_images/";
			$amazonUriThumb="images/ashrams/ashram_images/thumb_".$newName;
			$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newName,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());

			$this->db->where("id",$ashram_id);
			$this->db->update($this->tableName,array('year_end_statement_image_usd'=>$newName));
		}
	}
	
}
?>