<?PHP
class Ashram_newsletters_Model extends CI_Model 
{
	var $tableName="ashram_newsletters";
	var $emailDb='';
	var $smsDb='';
	function __construct() 
	{
        parent::__construct();
        $this->emailDb=$this->load->database("emails",true,false);
        $this->smsDb=$this->load->database("sms",true,false);
    }
	public function newsletterData($id)
	{
		$this->db->where("id",$id);
		$query = $this->db->get($this->tableName);
		return $query->row();
	}
	public function listNewsletters($excel=0)
	{
		$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$query1->where("ashram_id",$this->session->userdata("ashramId"));

		$preData="Ashram Name: ".$ashramData->name;

		$preData.="\nSearch Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nStatus: ";

		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(1,2)))
		{
			$query1->where("status",$_POST['status']);
			if($_POST['status']==1)
			{
				$preData.="Created";
			}
			else
			{
				$preData.="Sent";
			}
		}

		$preData.="\nType: ";

		if(isset($_POST['type']) && is_numeric($_POST['type']) && in_array($_POST['type'],array(1,2)))
		{
			$query1->where("type",$_POST['type']);
			if($_POST['type']==1)
			{
				$preData.="Email";
			}
			if($_POST['type']==2)
			{
				$preData.="SMS";
			}
		}

		/*if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(created_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(created_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
		}*/

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('created_on',$_POST['dir']);
				else
					$query1->order_by('created_on',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ashrams/ashram_newsletters_model",$sql,$this->currentUser,"default",$_POST,"All Newsletters",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('created_on',$dir);
		}
		else
		{
			$query1->order_by('created_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['created_on']));
			if($rtn['data'][$c]['sent_on'])
				$rtn['data'][$c]['sent_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['sent_on']));
			else
				$rtn['data'][$c]['sent_on']="N/A";
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function save($id)
	{
		$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));

		$gender='';
		if(isset($_POST['gender']) && !empty($_POST['gender']))
		{
			$gender=implode(",",$_POST['gender']);
		}
		$userids='';
		if(is_array($this->input->post("userids")))
		{
			$userids=implode(",",$this->input->post("userids"));
		}
		else
		{
			$userids=$this->input->post("userids");
		}

		$pooja_ids='';
		$donation_ids='';
		$subscription_ids='';
		$store_ids='';
		$pooja_categories='';
		$donation_categories='';
		$subscription_categories='';
		$store_categories='';
		$pooja_from_date='';
		$pooja_to_date='';
		$donation_from_date='';
		$donation_to_date='';
		$subscription_from_date='';
		$subscription_to_date='';
		$store_from_date='';
		$store_to_date='';
		if(isset($_POST['pooja_ids']) && is_array($_POST['pooja_ids']) && !empty($_POST['pooja_ids']))
		{
			$pooja_ids=implode(",",$_POST['pooja_ids']);
		}
		if(isset($_POST['donation_ids']) && is_array($_POST['donation_ids']) && !empty($_POST['donation_ids']))
		{
			$donation_ids=implode(",",$_POST['donation_ids']);
		}
		if(isset($_POST['subscription_ids']) && is_array($_POST['subscription_ids']) && !empty($_POST['subscription_ids']))
		{
			$subscription_ids=implode(",",$_POST['subscription_ids']);
		}
		if(isset($_POST['store_ids']) && is_array($_POST['store_ids']) && !empty($_POST['store_ids']))
		{
			$store_ids=implode(",",$_POST['store_ids']);
		}

		if(isset($_POST['pooja_categories']) && is_array($_POST['pooja_categories']) && !empty($_POST['pooja_categories']))
		{
			$pooja_categories=implode(",",$_POST['pooja_categories']);
		}
		if(isset($_POST['donation_categories']) && is_array($_POST['donation_categories']) && !empty($_POST['donation_categories']))
		{
			$donation_categories=implode(",",$_POST['donation_categories']);
		}
		if(isset($_POST['subscription_categories']) && is_array($_POST['subscription_categories']) && !empty($_POST['subscription_categories']))
		{
			$subscription_categories=implode(",",$_POST['subscription_categories']);
		}
		if(isset($_POST['store_categories']) && is_array($_POST['store_categories']) && !empty($_POST['store_categories']))
		{
			$store_categories=implode(",",$_POST['store_categories']);
		}

		if(isset($_POST['pooja_from_date']) && $_POST['pooja_from_date']!="")
		{
			$pooja_from_date=date("Y-m-d",strtotime($_POST['pooja_from_date']));
		}
		if(isset($_POST['pooja_to_date']) && $_POST['pooja_to_date']!="")
		{
			$pooja_to_date=date("Y-m-d",strtotime($_POST['pooja_to_date']));
		}
		if(isset($_POST['donation_from_date']) && $_POST['donation_from_date']!="")
		{
			$donation_from_date=date("Y-m-d",strtotime($_POST['donation_from_date']));
		}
		if(isset($_POST['donation_to_date']) && $_POST['donation_to_date']!="")
		{
			$donation_to_date=date("Y-m-d",strtotime($_POST['donation_to_date']));
		}
		if(isset($_POST['subscription_from_date']) && $_POST['subscription_from_date']!="")
		{
			$subscription_from_date=date("Y-m-d",strtotime($_POST['subscription_from_date']));
		}
		if(isset($_POST['subscription_to_date']) && $_POST['subscription_to_date']!="")
		{
			$subscription_to_date=date("Y-m-d",strtotime($_POST['subscription_to_date']));
		}
		if(isset($_POST['store_item_from_date']) && $_POST['store_item_from_date']!="")
		{
			$store_from_date=date("Y-m-d",strtotime($_POST['store_item_from_date']));
		}
		if(isset($_POST['store_item_to_date']) && $_POST['store_item_to_date']!="")
		{
			$store_to_date=date("Y-m-d",strtotime($_POST['store_item_to_date']));
		}

		$email_content='';
		$sms_message='';
		if($this->input->post("type")==1)
			$email_content=$this->general_model->filtertext(trim($_POST["content"]));

		if($this->input->post("type")==2)
			$sms_message=str_replace("\r\n","\n",$this->input->post("message"));

		if($this->input->post("type")==3)
		{
			$email_content=$this->general_model->filtertext(trim($_POST["content"]));
			$sms_message=str_replace("\r\n","\n",$this->input->post("message"));
		}

		if(!$id)
		{
			
			$q=$this->db->insert($this->tableName,
                                array(
                                	'subject' =>$this->general_model->filtertext(trim($_POST["subject"])),
									'email_content' =>$email_content,
									'sms_message' =>$sms_message,
									'created_on' => date("Y:m:d H:i:s"),
									'created_by'=>$this->currentUser->id,
									'field_country'=>$_POST['country'],
									'field_age_from'=>$_POST['age_from'],
									'field_age_to'=>$_POST['age_to'],
									'field_gender'=>$gender,
									'ashram_id'=>$this->session->userdata("ashramId"),
									'field_pooja_ids'=>$pooja_ids,
									'field_donation_ids'=>$donation_ids,
									'field_subscription_ids'=>$subscription_ids,
									'field_store_ids'=>$store_ids,
									'field_pooja_categories'=>$pooja_categories,
									'field_donation_categories'=>$donation_categories,
									'field_subscription_categories'=>$subscription_categories,
									'field_store_categories'=>$store_categories,
									'field_pooja_from_date'=>$pooja_from_date,
									'field_pooja_to_date'=>$pooja_to_date,
									'field_donation_from_date'=>$donation_from_date,
									'field_donation_to_date'=>$donation_to_date,
									'field_subscription_from_date'=>$subscription_from_date,
									'field_subscription_to_date'=>$subscription_to_date,
									'field_store_from_date'=>$store_from_date,
									'field_store_to_date'=>$store_to_date,
									'field_userids'=>$userids,
									'type'=>$this->input->post("type")
								)
								);
			$idd=$this->db->insert_id();
			$nid="ANL-".date("Ymd")."-".$idd;
			$this->db->where('id', $idd);
			$q=$this->db->update($this->tableName,
                                array("unique_id"=>$nid));
		}
		else
		{
			$this->db->where('id', $id);
			$q=$this->db->update($this->tableName,
                                array(
                                	'subject' =>$this->general_model->filtertext(trim($_POST["subject"])),
									'email_content' =>$email_content,
									'sms_message' =>$sms_message,
									'modified_on' => date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id,
									'field_country'=>$_POST['country'],
									'field_age_from'=>$_POST['age_from'],
									'field_age_to'=>$_POST['age_to'],
									'field_gender'=>$gender,
									'field_pooja_ids'=>$pooja_ids,
									'field_donation_ids'=>$donation_ids,
									'field_subscription_ids'=>$subscription_ids,
									'field_store_ids'=>$store_ids,
									'field_pooja_categories'=>$pooja_categories,
									'field_donation_categories'=>$donation_categories,
									'field_subscription_categories'=>$subscription_categories,
									'field_store_categories'=>$store_categories,
									'field_pooja_from_date'=>$pooja_from_date,
									'field_pooja_to_date'=>$pooja_to_date,
									'field_donation_from_date'=>$donation_from_date,
									'field_donation_to_date'=>$donation_to_date,
									'field_subscription_from_date'=>$subscription_from_date,
									'field_subscription_to_date'=>$subscription_to_date,
									'field_store_from_date'=>$store_from_date,
									'field_store_to_date'=>$store_to_date,
									'field_userids'=>$userids,
									'type'=>$this->input->post("type")
								)
							);
			
			$idd=$id;
		}

		$this->load->helper("simple_html_dom");
		$dom=new simple_html_dom();
		$tempContent=trim($_POST['content']);
		$contentDom=$dom->load($tempContent);
		$images=$contentDom->find('img');
		if(count($images))
		{
			if($id)
			{
				$existingImages=$this->ashram_newsletter_images_model->getImagesByNewsletterId($id);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$eArray[$eimage->filename]=$eimage->id;
				}
				$editorImages=[];
				foreach ($images as $img_dom) 
				{
					$pathText=$img_dom->attr['src'];
					if(preg_match('/amazon/i',$pathText))
					{
						$editorImages[basename($pathText)]=basename($pathText);
					}
				}
				$diff=array_diff_key($eArray,$editorImages);
				//$keys=array_keys($diff);

				if(count($diff))
				{
					foreach($diff as $ikey)
					$this->ashram_newsletter_images_model->deleteImage($id,$ikey);
				}

			}

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="content/newsletter/";
			foreach ($images as $img_dom)
			{
				$pathText=$img_dom->attr['src'];
				if(preg_match('/amazon/i',$pathText))
					continue;

				$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
				if(file_exists($path))
				{
					/*$this->load->helper("image");
					$image = new SimpleImage();
					$image->processImage($path,$path);*/

					$fname=basename($path);
					$newFileName=$idd."_".$fname;
					$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
					$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
					unlink($path);

					$imageData=array('filename' => $newFileName,
									'newsletter_id' =>$idd,
									'created_on' =>date("Y:m:d H:i:s")
									);
					$this->ashram_newsletter_images_model->insert($imageData);
					//$imageCount++;
				}
			}
			$this->db->where("id",$idd);
			$this->db->update($this->tableName,array("email_content"=>$tempContent));
		}
		else
		{
			if($id)
			{
				$existingImages=$this->ashram_newsletter_images_model->getImagesByNewsletterId($id);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					//$eArray[$eimage->filename]=$eimage->id;
					$this->ashram_newsletter_images_model->deleteImage($id,$eimage->id);
				}
			}
		}

		if($q) return $idd;
		else return 0;
	}

	public function getNewsletterParticipants($id)
	{
		$participants = array();
		$newsletterData=$this->newsletterData($id);
		if(empty($newsletterData))
		{
			goto stepend;
		}
		$userIdsArray=$this->getNewsletterUsers($id);

		if(in_array($newsletterData->type, [2,3]))//SMS
		{
			$countries=$this->locations_model->getCountries(true);
		}
		
		$this->db->select("*,DATE_FORMAT( NOW( ) ,  '%Y' ) - DATE_FORMAT( dob,  '%Y' ) - ( DATE_FORMAT( NOW( ) ,  '00-%m-%d' ) < DATE_FORMAT( dob,  '00-%m-%d' ) ) AS age");
		if($newsletterData->field_country!='')
		{
			$this->db->where("country_id",$newsletterData->field_country);
		}
		
		if($newsletterData->field_gender!='')
		{
			$this->db->where_in("gender",$newsletterData->field_gender);
		}
		if($newsletterData->field_userids!='')
		{
			$fuserids=explode(",",$newsletterData->field_userids);
			if(!empty($userIdsArray))
				$userIdsArray=array_intersect($userIdsArray,$fuserids);
			else
				$userIdsArray=$fuserids;
		}

		if($newsletterData->field_age_from)
		{
			$this->db->having("age >=",$newsletterData->field_age_from);
			$this->db->having("age <=",$newsletterData->field_age_to);
		}
		if(!empty($userIdsArray))
		{
			$this->db->where_in("u.id",$userIdsArray);
		}
		$this->db->where("deleted",0);
		$this->db->where("u.status",1);
		$this->db->where("n.receive_newsletters",1);
		$this->db->where("admin",0);
		$this->db->where("n.ashram_id",$this->session->userdata("ashramId"));
		$this->db->from("ashram_members as n");
		$this->db->join("users as u",'u.id=n.user_id');

		$usersList=$this->db->get();

		$email_cnt=0;
		$sms_cnt=0;
		$sentEmails=array();
		$sentSMSs=array();
		if($usersList->num_rows())
		{
			foreach($usersList->result() as $recipient)
			{
				if(in_array($newsletterData->type, [1,3]))//Email
				{					
					if($recipient->email_verified==1 && !in_array($recipient->email,$sentEmails))
			    	{
						$sentEmails[]=$recipient->email;
						$email_cnt++;
			    	}
				}
				if(in_array($newsletterData->type, [2,3]))
				{
					if($recipient->phoneno!="" && $recipient->country_id!="" && !in_array($countries[$recipient->country_id]->isd_code.$recipient->phoneno,$sentSMSs))
			    	{
			    		if(!isset($countries[$recipient->country_id]))
							continue;
						$recipient_to=$countries[$recipient->country_id]->isd_code.$recipient->phoneno;
						$sentSMSs[]=$recipient_to;
						$sms_cnt++;
			    	}
				}
			}
			$participants['participantsEmails'] = $sentEmails;
			$participants['totalParticipantsEmails'] = $email_cnt;
			$participants['participantsSmss'] = $sentSMSs;
			$participants['totalParticipantsSmss'] = $sms_cnt;
		}
		stepend:
		return $participants;
	}

	public function getNewsletterUsers($id)
	{
		$userIdsArray=array();

		$newsletterData=$this->newsletterData($id);

		$categoryPoojaIds = array();
		if($newsletterData->field_pooja_categories!='')
		{
			$pooja_categories=array_filter(explode(",",$newsletterData->field_pooja_categories));

			$this->db->select('id,pooja_name');
			$this->db->where_in("category",$pooja_categories);
			$this->db->order_by("status","desc");
			$this->db->order_by("pooja_name","asc");
			$q=$this->db->get('poojas');
			$categoryPoojas=$q->result_array();
			if(!empty($categoryPoojas))
			{
				$categoryPoojaIds = array_column($categoryPoojas, 'id');
			}
		}

		$categoryDonationIds = array();
		if($newsletterData->field_donation_categories!='')
		{
			$donation_categories=array_filter(explode(",",$newsletterData->field_donation_categories));

			$this->db->select('id,donation_name');
			$this->db->where_in("category",$donation_categories);
			$this->db->order_by("status","desc");
			$this->db->order_by("donation_name","asc");
			$q=$this->db->get('donations');
			$categoryDonations=$q->result_array();
			if(!empty($categoryDonations))
			{
				$categoryDonationIds = array_column($categoryDonations, 'id');
			}
		}

		$categorySubscriptionIds = array();
		if($newsletterData->field_subscription_categories!='')
		{
			$subscription_categories=array_filter(explode(",",$newsletterData->field_subscription_categories));

			$this->db->select('id,subscription_name');
			$this->db->where_in("category",$subscription_categories);
			$this->db->order_by("status","desc");
			$this->db->order_by("subscription_name","asc");
			$q=$this->db->get('subscriptions');
			$categorySubscriptions=$q->result_array();
			if(!empty($categorySubscriptions))
			{
				$categorySubscriptionIds = array_column($categorySubscriptions, 'id');
			}
		}

		$categoryStoreIds = array();
		if($newsletterData->field_store_categories!='')
		{
			$store_categories=array_filter(explode(",",$newsletterData->field_store_categories));

			$this->db->select('id,item_name');
			$this->db->where_in("category",$store_categories);
			$this->db->order_by("status","desc");
			$this->db->order_by("item_name","asc");
			$q=$this->db->get('store');
			$categoryStores=$q->result_array();
			if(!empty($categoryStores))
			{
				$categoryStoreIds = array_column($categoryStores, 'id');
			}
		}

		if($newsletterData->field_pooja_ids=="" && !empty($categoryPoojaIds))
		{
			$newsletterData->field_pooja_ids = implode(',', $categoryPoojaIds);
		}
		if($newsletterData->field_pooja_ids!="" && !empty($categoryPoojaIds))
		{
			$newsletterData->field_pooja_ids = $newsletterData->field_pooja_ids.','.implode(',', $categoryPoojaIds);
		}
		if($newsletterData->field_pooja_ids!='' || ($newsletterData->field_pooja_from_date!='' && $newsletterData->field_pooja_from_date!='0000-00-00') || ($newsletterData->field_pooja_to_date!='' && $newsletterData->field_pooja_to_date!='0000-00-00'))
		{
			$this->db->from("order_items as oi");
			$this->db->join("orders as o","oi.order_id=o.id","left");
			$this->db->where("o.order_type",1);
			if($newsletterData->field_pooja_ids!='')
			{
				$pooja_ids=array_filter(explode(",",$newsletterData->field_pooja_ids));
				$this->db->where_in("oi.item_id",$pooja_ids);
			}
			if($newsletterData->field_pooja_from_date!='' && $newsletterData->field_pooja_from_date!='0000-00-00')
			{
				$this->db->where("date(o.date) >=",date("Y-m-d",strtotime($newsletterData->field_pooja_from_date)));
			}
			if($newsletterData->field_pooja_to_date!='' && $newsletterData->field_pooja_to_date!='0000-00-00')
			{
				$this->db->where("date(o.date) <=",date("Y-m-d",strtotime($newsletterData->field_pooja_to_date)));
			}
			$this->db->where("o.payment_status!=",0);
			$this->db->where("o.is_cancelled!=",1);
			$this->db->group_by("user_id");
			$pq=$this->db->get()->result();

			foreach ($pq as $pq_row)
			{
				if(!in_array($pq_row->user_id,$userIdsArray))
					$userIdsArray[]=$pq_row->user_id;
			}
		}

		if($newsletterData->field_donation_ids=="" && !empty($categoryDonationIds))
		{
			$newsletterData->field_donation_ids = implode(',', $categoryDonationIds);
		}
		if($newsletterData->field_donation_ids!="" && !empty($categoryDonationIds))
		{
			$newsletterData->field_donation_ids = $newsletterData->field_donation_ids.','.implode(',', $categoryDonationIds);
		}
		if($newsletterData->field_donation_ids!='' || ($newsletterData->field_donation_from_date!='' && $newsletterData->field_donation_from_date!='0000-00-00') || ($newsletterData->field_donation_to_date!='' && $newsletterData->field_donation_to_date!='0000-00-00'))
		{
			$this->db->from("order_items as oi");
			$this->db->join("orders as o","oi.order_id=o.id","left");
			$this->db->where("o.order_type",2);
			if($newsletterData->field_donation_ids!='')
			{
				$donation_ids=array_filter(explode(",",$newsletterData->field_donation_ids));
				$this->db->where_in("oi.item_id",$donation_ids);
			}
			if($newsletterData->field_donation_from_date!='' && $newsletterData->field_donation_from_date!='0000-00-00')
			{
				$this->db->where("date(o.date) >=",date("Y-m-d",strtotime($newsletterData->field_donation_from_date)));
			}
			if($newsletterData->field_donation_to_date!='' && $newsletterData->field_donation_to_date!='0000-00-00')
			{
				$this->db->where("date(o.date) <=",date("Y-m-d",strtotime($newsletterData->field_donation_to_date)));
			}
			$this->db->where("oi.subscription",0);
			$this->db->where("o.payment_status!=",0);
			$this->db->where("o.is_cancelled!=",1);
			$this->db->group_by("user_id");
			$pq=$this->db->get()->result();

			foreach ($pq as $pq_row)
			{
				if(!in_array($pq_row->user_id,$userIdsArray))
					$userIdsArray[]=$pq_row->user_id;
			}
		}

		if($newsletterData->field_subscription_ids=="" && !empty($categorySubscriptionIds))
		{
			$newsletterData->field_subscription_ids = implode(',', $categorySubscriptionIds);
		}
		if($newsletterData->field_subscription_ids!="" && !empty($categorySubscriptionIds))
		{
			$newsletterData->field_subscription_ids = $newsletterData->field_subscription_ids.','.implode(',', $categorySubscriptionIds);
		}
		if($newsletterData->field_subscription_ids!='' || ($newsletterData->field_subscription_from_date!='' && $newsletterData->field_subscription_from_date!='0000-00-00') || ($newsletterData->field_subscription_to_date!='' && $newsletterData->field_subscription_to_date!='0000-00-00'))
		{
			$this->db->from("order_items as oi");
			$this->db->join("orders as o","oi.order_id=o.id","left");
			$this->db->where("o.order_type",4);
			if($newsletterData->field_subscription_ids!='')
			{
				$subscription_ids=array_filter(explode(",",$newsletterData->field_subscription_ids));
				$this->db->where_in("oi.item_id",$subscription_ids);
			}
			if($newsletterData->field_subscription_from_date!='' && $newsletterData->field_subscription_from_date!='0000-00-00')
			{
				$this->db->where("date(o.date) >=",date("Y-m-d",strtotime($newsletterData->field_subscription_from_date)));
			}
			if($newsletterData->field_subscription_to_date!='' && $newsletterData->field_subscription_to_date!='0000-00-00')
			{
				$this->db->where("date(o.date) <=",date("Y-m-d",strtotime($newsletterData->field_subscription_to_date)));
			}
			$this->db->where("oi.subscription",1);
			$this->db->where("oi.status!=",0);
			$this->db->where("oi.status!=",2);
			$this->db->where("o.is_cancelled!=",1);
			$this->db->group_by("user_id");
			$pq=$this->db->get()->result();

			foreach ($pq as $pq_row)
			{
				if(!in_array($pq_row->user_id,$userIdsArray))
					$userIdsArray[]=$pq_row->user_id;
			}
		}

		if($newsletterData->field_store_ids=="" && !empty($categoryStoreIds))
		{
			$newsletterData->field_store_ids = implode(',', $categoryStoreIds);
		}
		if($newsletterData->field_store_ids!="" && !empty($categoryStoreIds))
		{
			$newsletterData->field_store_ids = $newsletterData->field_store_ids.','.implode(',', $categoryStoreIds);
		}
		if($newsletterData->field_store_ids!='' || ($newsletterData->field_store_from_date!='' && $newsletterData->field_store_from_date!='0000-00-00') || ($newsletterData->field_store_to_date!='' && $newsletterData->field_store_to_date!='0000-00-00'))
		{
			$this->db->from("order_items as oi");
			$this->db->join("orders as o","oi.order_id=o.id","left");
			$this->db->where("o.order_type",3);
			if($newsletterData->field_store_ids!='')
			{
				$store_ids=array_filter(explode(",",$newsletterData->field_store_ids));
				$this->db->where_in("oi.item_id",$store_ids);
			}
			if($newsletterData->field_store_from_date!='' && $newsletterData->field_store_from_date!='0000-00-00')
			{
				$this->db->where("date(o.date) >=",date("Y-m-d",strtotime($newsletterData->field_store_from_date)));
			}
			if($newsletterData->field_store_to_date!='' && $newsletterData->field_store_to_date!='0000-00-00')
			{
				$this->db->where("date(o.date) <=",date("Y-m-d",strtotime($newsletterData->field_store_to_date)));
			}
			$this->db->where("o.payment_status!=",0);
			$this->db->where("o.is_cancelled!=",1);
			$this->db->group_by("user_id");
			$pq=$this->db->get()->result();

			foreach ($pq as $pq_row)
			{
				if(!in_array($pq_row->user_id,$userIdsArray))
					$userIdsArray[]=$pq_row->user_id;
			}
		}
		return $userIdsArray;
	}

	public function sendNewsletter($id)
	{
		$newsletterData=$this->newsletterData($id);
		if(in_array($newsletterData->type, [2,3]))//SMS
		{
			$countries=$this->locations_model->getCountries(true);
		}

		$userIdsArray=$this->getNewsletterUsers($id);
		
		$this->db->select("*,DATE_FORMAT( NOW( ) ,  '%Y' ) - DATE_FORMAT( dob,  '%Y' ) - ( DATE_FORMAT( NOW( ) ,  '00-%m-%d' ) < DATE_FORMAT( dob,  '00-%m-%d' ) ) AS age");
		if($newsletterData->field_country!='')
		{
			$this->db->where("country_id",$newsletterData->field_country);
		}
		
		if($newsletterData->field_gender!='')
		{
			$this->db->where_in("gender",$newsletterData->field_gender);
		}
		if($newsletterData->field_userids!='')
		{
			$fuserids=explode(",",$newsletterData->field_userids);
			if(!empty($userIdsArray))
				$userIdsArray=array_intersect($userIdsArray,$fuserids);
			else
				$userIdsArray=$fuserids;
		}

		if($newsletterData->field_age_from)
		{
			$this->db->having("age >=",$newsletterData->field_age_from);
			$this->db->having("age <=",$newsletterData->field_age_to);
		}
		if(!empty($userIdsArray))
		{
			$this->db->where_in("u.id",$userIdsArray);
		}
		$this->db->where("deleted",0);
		$this->db->where("u.status",1);
		$this->db->where("n.receive_newsletters",1);
		$this->db->where("admin",0);
		$this->db->where("n.ashram_id",$this->session->userdata("ashramId"));
		$this->db->from("ashram_members as n");
		$this->db->join("users as u",'u.id=n.user_id');

		$usersList=$this->db->get();

		$email_cnt=0;
		$sms_cnt=0;
		$sentEmails=array();
		$sentSMSs=array();
		if($usersList->num_rows())
		{
			$this->session->set_flashdata("newsletter_subject", $newsletterData->subject);
			

			$sent=0;
			
			$fail=0;
			foreach($usersList->result() as $recipient)
			{
				if(in_array($newsletterData->type, [1,3]))//Email
				{					
					if($GLOBALS['site_settings']['email_service']==1 && $recipient->email_verified==1 && !in_array($recipient->email,$sentEmails))
			    	{
			    		$nData=array('mail_to' => $recipient->email,
										'mail_subject' => "[Newsletter] - ".$newsletterData->subject,
										'date' => date("Y:m:d H:i:s"),
										'newsletter_id' => $newsletterData->id,
										'user_id' => $recipient->id
									);
						$this->emailDb->insert('mail_track_newsletter_a_'.$this->session->userdata("ashramId"),$nData);
						$sent_id=$this->emailDb->insert_id();
						$sentEmails[]=$recipient->email;
						$email_cnt++;
			    	}
				}
				if(in_array($newsletterData->type, [2,3]))
				{
					if($GLOBALS['site_settings']['sms_service']==1 && $recipient->phoneno!="" && $recipient->country_id!="" && !in_array($countries[$recipient->country_id]->isd_code.$recipient->phoneno,$sentSMSs))
			    	{
			    		if(!isset($countries[$recipient->country_id]))
							continue;
						$recipient_to=$countries[$recipient->country_id]->isd_code.$recipient->phoneno;
						$nData=array('to' => $recipient_to,
											'date' => date("Y:m:d H:i:s"),
											'newsletter_id' => $newsletterData->id,
											'user_id' => $recipient->id
										);
						$this->smsDb->insert('sms_track_newsletter_a_'.$this->session->userdata("ashramId"),$nData);
						$sent_id=$this->smsDb->insert_id();
						$sentSMSs[]=$countries[$recipient->country_id]->isd_code.$recipient->phoneno;
						$sms_cnt++;
			    	}
				}
			}
			$flashresponse = "";
			if($email_cnt>0)
			{
				$flashresponse = "Email's Sent: ".$email_cnt;
			}
			if($email_cnt>0 && $sms_cnt>0)
			{
				$flashresponse = ", ";
			}
			if($sms_cnt>0)
			{
				$flashresponse = "SMS's Sent: ".$sms_cnt;
			}
			$this->session->set_flashdata("newsletter_recipients", $flashresponse);
		}
		else
			$this->session->set_flashdata("newsletter_recipients_no",1);

		$this->db->where("id",$id);
		$this->db->update($this->tableName,
									array(
										'sent_on' =>date("Y:m:d H:i:s"),
										'status'=>2,
										'total_email_recipients'=>$email_cnt,
										'total_sms_recipients'=>$sms_cnt,
									)
								);
		return 20;
	}
	public function delete($id,$newsletterData)
	{
		$existingImages=$this->ashram_newsletter_images_model->getImagesByNewsletterId($id);
		$eArray=[];
		foreach ($existingImages as $eimage)
		{
			$this->ashram_newsletter_images_model->deleteImage($id,$eimage->id);
		}
		$this->db->where("id",$id);
		$query = $this->db->delete($this->tableName);
		if($query) return 1;
		else return 0;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Newsletter ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email Subject");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email Content");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SMS Message");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"To (Email IDs)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"To (SMSs)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Created");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Sent");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Filter - By Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Filter - By Gender");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Filter - By Age");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->unique_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->subject);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->email_content)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->sms_message);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,abs($reportrow->total_email_recipients));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,abs($reportrow->total_sms_recipients));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));
			if($reportrow->sent_on!='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->sent_on)));
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			
			$status="Created";
			if($reportrow->status==2)
				$status="Sent";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			if($reportrow->field_country=='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			else
			{
				$countryData=$this->locations_model->getCountryByCode($reportrow->field_country);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countryData->country_name);
			}

			if($reportrow->field_gender=='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->field_gender);

			if($reportrow->field_age_from=='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->field_age_from." to ".$reportrow->field_age_to." Yrs");
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function stopNewsletterByNewsletterId($newsletter_id)
	{
		$newsletterData=$this->newsletterData($newsletter_id);
		if(!empty($newsletterData))
		{
			$this->db->where('id', $newsletter_id);
			$q=$this->db->update('ashram_newsletters',array("is_stopped"=>'1'));
		}
	}
}
?>