<?PHP
class Ashram_calendar_Model extends CI_Model 
{
	var $tableName="ashram_calendar";
	public function __construct()
	{
		parent::__construct();
	}
	public function getCount()
	{
		return $this->db->where('ashram_id',$this->currentUser->ashram_id)->get($this->tableName)->num_rows();
	}
	public function calendarData($id)
	{
		$this->db->where("id",$id);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}
	public function getYearMonths($ashramId)
	{
		$this->db->select("year,month");
		$this->db->where("ashram_id",$ashramId);
		$this->db->group_by("year, month");
		$this->db->order_by("year","desc");
		$this->db->order_by("month","asc");
		$q=$this->db->get($this->tableName);
		$result['years']=array();
		$result['months']=array();
		foreach ($q->result() as $row)
		{
			if(!in_array($row->year,$result['years']))
			{
				$result['years'][]=$row->year;
			}
			$result['months'][$row->year][]=$row->month;
		}
		return $result;
	}

	public function listPublic($ashramId)
	{
		$years=$this->getYearMonths($ashramId);
		$i=0;
		$query1=$this->db;
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("start_date,end_date,event_name,description");
		}
		$query1->from($this->tableName);
		$this->db->where("ashram_id",$ashramId);
		
		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->like('event_name',trim($_POST['search_text']));
		}


		if(isset($_POST['year']) && is_numeric($_POST['year']))
		{
			$query1->where("year",$_POST['year']);
		}
		else
		{
			if(count($years['years']))
				$query1->where("year",$years[0]->year);
			else
				$query1->where("year",0);
		}

		if(isset($_POST['month']) && is_numeric($_POST['month']))
		{
			$query1->where("month",$_POST['month']);
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('start_date','asc');

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_date']=date("d M Y",strtotime($rtn['data'][$c]['end_date']));
			$rtn['data'][$c]['start_day']=date("l",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_day']=date("l",strtotime($rtn['data'][$c]['end_date']));
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function listAdmin($excel=0)
	{
		$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$query1->where("ashram_id",$this->session->userdata("ashramId"));


		$preData="Ashram Name: ".$ashramData->name;

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(start_date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(start_date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('start_date',$_POST['dir']);
				else
					$query1->order_by('start_date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ashrams/ashram_calendar_model",$sql,$this->currentUser,"default",$_POST,"All Calendar Events",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('start_date',$dir);
		}
		else
		{
			$query1->order_by('start_date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_date']=date("d M Y",strtotime($rtn['data'][$c]['end_date']));
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id)
	{
		$this->db->where("id",$id);
		$q=$this->db->delete($this->tableName);
		return $q;
	}
	public function save($id)
	{		
		if(!$id)
		{
			$q=$this->db->insert($this->tableName,
                                array(
                                	'event_name' => $this->general_model->filtertext(trim($_POST["event_name"])),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'start_date' => date("Y:m:d H:i:s",strtotime($_POST["start_date"])),
									'end_date' => date("Y:m:d H:i:s",strtotime($_POST["end_date"])),
									'year'=>date("Y",strtotime($_POST["start_date"])),
									'month'=>abs(date("m",strtotime($_POST["start_date"]))),
									'created_on'=>date("Y:m:d H:i:s"),
									'created_by'=>$this->currentUser->id,
									'modified_on'=>date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id,
									'ashram_id'=>$this->session->userdata("ashramId")
								)
								);
			$idd=$this->db->insert_id();
			
			
		}
		else
		{
			
			$this->db->where('id', $id);
			$q=$this->db->update($this->tableName,
                                array(
                                	'event_name' => $this->general_model->filtertext(trim($_POST["event_name"])),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'start_date' => date("Y:m:d H:i:s",strtotime($_POST["start_date"])),
									'end_date' => date("Y:m:d H:i:s",strtotime($_POST["end_date"])),
									'year'=>date("Y",strtotime($_POST["start_date"])),
									'month'=>abs(date("m",strtotime($_POST["start_date"]))),
									'modified_on'=>date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id
								)
								);
			$idd=$id;
		}
		if($q)
			return $idd;
		else
			return 0;
	}

	/*public function listPublic()
	{
		$i=0;
		$query1=$this->db;
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && 
			isset($_POST['wild']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']) && 
			in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			if($_POST['wild']=='contains')
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
			else if($_POST['wild']=='starts')
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
			else if($_POST['wild']=='ends')
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
		}

		$preData.="\nCalendar Type: ";
		if(isset($_POST['type']) && is_numeric($_POST['type']) && in_array($_POST['type'],array(1,2,3)))
		{
			if($_POST['type']==1)
			{
				$query1->where("swamiji",1);
				$preData.="Swamiji Calendar";
			}
			if($_POST['type']==2)
			{
				$query1->where("balaswamiji",1);
				$preData.="Bala Swamiji Calendar";
			}
			if($_POST['type']==3)
			{
				$query1->where("dattapeetham",1);
				$preData.="Datta Peetham Calendar";
			}
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(start_date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(start_date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('start_date',$dir);
		}
		else
		{
			$query1->order_by('start_date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_date']=date("d M Y",strtotime($rtn['data'][$c]['end_date']));
			$sno++;
			$c++;
		}
		return $rtn;
	}*/

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Calendar Event");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"From Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"To Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->event_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->start_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->end_date)));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>