<?PHP
#Author : Baji shaik
#Created On : 20th Oct 2018
require_once APPPATH. '/third_party/stripe_package/init.php';
class Stripe_webhook_model extends CI_Model 
{
    var $tableName="";
    var $year_table = "";
    var $archivesDb = "";
    public function __construct()
    {
        parent::__construct();
        $this->year_table = date("Y");
        $this->tableName = 'stripe_webhook_'.$this->year_table;
        $this->archivesDb = $this->load->database("data_archives",true,false);
        if ($this->archivesDb->table_exists($this->tableName) )
        {

        }
        else
        {
            // table does not exist
            $new_table = "CREATE TABLE IF NOT EXISTS `".$this->tableName."` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `transaction_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
              `customer_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
              `subscription_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
              `data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
              `amount` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
              `created_on` datetime NOT NULL,
              `status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
              PRIMARY KEY (`id`)
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
              $this->archivesDb->query($new_table);
        }
    }

    public function savehookData($array)
    {
        $savedata = $this->archivesDb->insert($this->tableName,$array);
        return $this->archivesDb->insert_id();
    }

    public function createStripeSubscription($trustData,$cartItems,$currency,$customer)
    {
        
        \Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
        try
        {
            $error = 0;
            foreach ($cartItems as $key => $value) 
            {
                $frequency = $value['options']['frequency'];
                $period = $value['options']['period'];
                $recurring_amount = $value['options']['price_'.$currency]*100;
                $onetime_amount = $value['options']['onetime_charge_'.$currency]*100;
                
                if($period == 'days')
                {
                    $period='day';
                }
                if($period == 'weeks')
                {
                    $period='week';
                }
                if($period == 'months')
                {
                    $period='month';
                }
                if($period == 'years')
                {
                    $period='year';
                }
                if($frequency > 0)
                {
                    $frequency = $frequency;
                }
                else
                {
                    $frequency = 1;
                }

                $product = \Stripe\Product::create([
                    'name' => $value['name'],
                    'type' => 'service',
                    'images' => [
                        $value['options']['image_path'],
                    ]
                ]);

                if($onetime_amount > 0)
                {
                    $price = \Stripe\Price::create([
                        'product' => $product->id,
                        'unit_amount' => $onetime_amount,
                        'currency' => $currency,
                    ]);
                    $lineItemsArray[]= array("price"=>$price->id,'quantity' => 1);
                }

                $price = \Stripe\Price::create([
                    'product' => $product->id,
                    'unit_amount' => $recurring_amount,
                    'currency' => $currency,
                    'recurring' => [
                    'interval' => $period,
                    'interval_count'=>$frequency,
                    ],
                ]);
                $lineItemsArray[]= array("price"=>$price->id,'quantity' => 1);
            }
        }
        catch(\Stripe\Exception\CardException $e) 
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\RateLimitException $e) 
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\InvalidRequestException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\AuthenticationException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\ApiConnectionException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\ApiErrorException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }

        $array = array();
        if($error == 1)
        {
            $array["status_message"] = $error_message;
            $array["status"] = "error";
        }
        else
        {
            $array["status"] = "success";
            $array["line_items"] = $lineItemsArray;
            $array["onetime_charge"] = $onetime_amount;
        }
        return $array;
    }

    public function createStripeSession($currency,$email,$trustData,$cartType,$cartItems,$amount,$reference,$customData,$userId,$ashram_id,$partial=0,$ref_url=null)
    {
        //Get trust details
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashram_id,$cartType);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        if(strtolower($currency) == "inr")
            $country = "IN";
        else
            $country = "US";
        $trustData = $trustsArray[$currency];
        \Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
        if(!empty($partial) && $partial== 1 && $ref_url!= "")
        {
            try
            {
                //Get stripe customer details
                if(!empty($this->getCustomerId($email,$trustData,$country)))
                    $customer = $this->getCustomerId($email,$trustData,$country);
                else
                {
                    //If Stripe customer details not found then create stripr customer
                    $newCustomer = $this->createStripeCustomer($email,$trustData,$country);
                    $customer = $newCustomer["customer"]->id;
                }

                //Set amount
                if($amount > 0)
                    $amount = $amount*100;

                //Set item name
                if($cartType == 1)
                {
                    $itemName = "Poojas Offline Order(s) Payment";
                }
                else if($cartType == 2)
                {
                    $itemName = "Donations Offline Order(s) Payment";
                }
                else if($cartType == 3)
                {
                    $itemName = "Store Items Offline Order(s) Payment";
                }
                else if($cartType == 4)
                {
                    $itemName = "Subscriptions Offline Order(s) Payment";
                }

                $error=0;
                $session = \Stripe\Checkout\Session::create([
                    'payment_method_types' => ['card'],
                    'line_items' => [[
                        'name' => $itemName,
                        'amount' => $amount,
                        'currency' => $currency,
                        'quantity' => 1,
                      ]],
                    'mode' => 'payment',
                    "customer"=>$customer,
                    'client_reference_id'=>$reference,
                    'success_url' => base_url."stripe/capture?session_id={CHECKOUT_SESSION_ID}",
                    'cancel_url' => $ref_url,
                ]);
            }
            catch(\Stripe\Exception\CardException $e) 
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }
            catch (\Stripe\Exception\RateLimitException $e) 
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }
            catch (\Stripe\Exception\InvalidRequestException $e)
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }
            catch (\Stripe\Exception\AuthenticationException $e)
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }
            catch (\Stripe\Exception\ApiConnectionException $e)
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }
            catch (\Stripe\Exception\ApiErrorException $e)
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }

            $array = array();
            if($error == 1)
            {
                $array["status_message"] = $error_message;
                $array["status"] = "error";
            }
            else
            {
                $array["status"] = "success";
                $array["session"] = $session;

                $this->load->model("stripe_orders_sessions_model");
                if($amount > 0)
                    $amount = $amount/100;
                
                $this->stripe_orders_sessions_model->setTempInfo($userId,$customData,$amount,$currency,$reference,$session->id,$ashram_id,$cartType);
            }
        }
        else
        {
            //Set cancel redirect url
            if($cartType == 1)
            {
                $cancelUrl = base_url."poojas/checkout?ashram_id=".$ashram_id."&currency=".$currency;
            }
            else if($cartType == 2)
            {
                $cancelUrl = base_url."donations/checkout?ashram_id=".$ashram_id."&currency=".$currency;
            }
            else if($cartType == 3)
            {
                $cancelUrl = base_url."store/checkout?ashram_id=".$ashram_id."&currency=".$currency;
            }
            else if($cartType == 4)
            {
                $cancelUrl = base_url."subscriptions/checkout?ashram_id=".$ashram_id."&currency=".$currency;
            }
            try
            {
                //Get stripe customer details
                if(!empty($this->getCustomerId($email,$trustData,$country)))
                    $customer = $this->getCustomerId($email,$trustData,$country);
                else
                {
                    //If Stripe customer details not found then create stripr customer
                    $newCustomer = $this->createStripeCustomer($email,$trustData,$country);
                    $customer = $newCustomer["customer"]->id;
                }

                $qynty = 1;
                foreach ($cartItems as $key => $value) 
                {
                    $unit_amount = $value['options']['price_'.$currency]*100;
                    $lineItemsArray[]= array("price_data"=>array("unit_amount"=>$unit_amount,"currency"=>$currency,"product_data"=>array("name"=>$value['name'],"images"=>array($value['options']['image_path']))),"quantity"=>$value["qty"]);

                    $qynty++;
                }
                if($cartType == 4)
                {
                    //If order is a subscription order create stripe subscription for each order items
                    $subLineItems = $this->createStripeSubscription($trustData,$cartItems,$currency,$customer);
                    $is_appji_order = 0;
                    foreach ($cartItems as $key_1 => $value_1)
                    {
                        if(!empty($value_1['options']['is_appji_subscription']) && $value_1['options']['is_appji_subscription'] == 1)
                        {
                            $is_appji_order = 1;
                            break;
                        }

                    }
                    if($subLineItems["status"] == "error")
                    {
                        $apiReturn['error_msg']=$subLineItems["status_message"];
                        header('Content-Type: application/json');
                        echo json_encode($apiReturn);
                        exit();
                    }
                    else
                    {
                        $lineItemsArray = $subLineItems["line_items"];
                        $error=0;
                        if((!empty($is_appji_order) && $is_appji_order == 1) || (empty($subLineItems["onetime_charge"]) || $subLineItems["onetime_charge"] == 0))
                        {
                            $session = \Stripe\Checkout\Session::create([
                                'payment_method_types' => ['card'],
                                'line_items' => [$lineItemsArray],
                                'mode' => 'subscription',
                                "customer"=>$customer,
                                'client_reference_id'=>$reference,
                                'success_url' => base_url."stripe/capture?session_id={CHECKOUT_SESSION_ID}",
                                'cancel_url' => $cancelUrl,
                            ]);
                        }
                        else
                        {
                            $session = \Stripe\Checkout\Session::create([
                            'payment_method_types' => ['card'],
                            'line_items' => [$lineItemsArray],
                            'mode' => 'subscription',
                            'subscription_data'=> [
                                'trial_end'=>strtotime($value['options']['result_date'])
                                //This value has to be always 2 days delay
                            ],
                            "customer"=>$customer,
                            'client_reference_id'=>$reference,
                            'success_url' => base_url."stripe/capture?session_id={CHECKOUT_SESSION_ID}",
                            'cancel_url' => $cancelUrl,
                        ]);
                        }
                    }
                }
                else
                {
                    $error=0;
                    $session = \Stripe\Checkout\Session::create([
                        'payment_method_types' => ['card'],
                        'line_items' => [$lineItemsArray],
                        'mode' => 'payment',
                        "customer"=>$customer,
                        'client_reference_id'=>$reference,
                        'success_url' => base_url."stripe/capture?session_id={CHECKOUT_SESSION_ID}",
                        'cancel_url' => $cancelUrl,
                    ]);
                }
            }
            catch(\Stripe\Exception\CardException $e) 
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }
            catch (\Stripe\Exception\RateLimitException $e) 
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }
            catch (\Stripe\Exception\InvalidRequestException $e)
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }
            catch (\Stripe\Exception\AuthenticationException $e)
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }
            catch (\Stripe\Exception\ApiConnectionException $e)
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }
            catch (\Stripe\Exception\ApiErrorException $e)
            {
                $error = 1;
                $error_message=$e->getError()->message;
            }

            $array = array();
            if($error == 1)
            {
                $array["status_message"] = $error_message;
                $array["status"] = "error";
            }
            else
            {
                $array["status"] = "success";
                $array["session"] = $session;

                $this->load->model("stripe_orders_sessions_model");
                if($amount > 0)
                    $amount = $amount/100;
                
                $this->stripe_orders_sessions_model->setTempInfo($userId,$customData,$amount,$currency,$reference,$session->id,$ashram_id,$cartType);
            }
        }
        return $array;
    }

    public function createcardUpdateSession($currency,$customer_id,$subscription_id,$ashram_id,$cartType,$ref_url)
    {
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashram_id,$cartType);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        $trustData = $trustsArray[$currency];
        \Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
        try
        {
            $error=0;
            $session = \Stripe\Checkout\Session::create([
                'payment_method_types' => ['card'],
                'mode' => 'setup',
                'customer' => $customer_id,
                'setup_intent_data' => [
                'metadata' => [
                        'customer_id' => $customer_id,
                        'subscription_id' => $subscription_id,
                    ],
                ],
                'success_url' => base_url."stripe/changeCustomerCreditCard?session_id={CHECKOUT_SESSION_ID}",
                'cancel_url' => $ref_url,
            ]);
        }
        catch(\Stripe\Exception\CardException $e) 
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\RateLimitException $e) 
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\InvalidRequestException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\AuthenticationException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\ApiConnectionException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\ApiErrorException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }

        $array = array();
        if($error == 1)
        {
            $array["status_message"] = $error_message;
            $array["status"] = "error";
        }
        else
        {
            $array["status"] = "success";
            $array["session"] = $session;

            $this->load->model("stripe_orders_sessions_model");
            $this->stripe_orders_sessions_model->update_payments_session($session->id,$subscription_id);
        }
        return $array;
    }

    public function createStripeCustomer($email,$trustData,$country)
    {
        \Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
        try
        {
            $error = 0;
            $customer = \Stripe\Customer::create(array(
                "email" => $email,
                'address' => [
                    'country' => $country,
                ],
            ));
        }
        catch(\Stripe\Exception\CardException $e) 
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\RateLimitException $e) 
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\InvalidRequestException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\AuthenticationException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\ApiConnectionException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }
        catch (\Stripe\Exception\ApiErrorException $e)
        {
            $error = 1;
            $error_message=$e->getError()->message;
        }

        $array = array();
        if($error == 1)
        {
            $array["status_message"] = $error_message;
            $array["status"] = "error";
        }
        else
        {
            $array["status"] = "success";
            $array["customer"] = $customer;
        }
        return $array;
    }

    public function getCustomerId($email,$trustData,$country)
    {
        \Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
        $last_customer = NULL;
        $email = $email;
        while (true) 
        {
            $customers = \Stripe\Customer::all(array("limit" => 100, "starting_after" => $last_customer));
            foreach ($customers->autoPagingIterator() as $customer) 
            {
                if ($customer->email == $email) {
                    $customerIamLookingFor = $customer;
                    break 2;
                }
            }
            if (!$customers->has_more) {
                break;
            }
            $last_customer = end($customers->data);
        }
        if(!empty($customerIamLookingFor))
        {
            if(!empty($customerIamLookingFor->address) && !empty($customerIamLookingFor->address->country))
            {
                if($customerIamLookingFor->address->country == $country)
                {
                    return $customerIamLookingFor->id;
                }
            }
        }
    }

    public function createTempOrders($reference,$razorpay_note_reference)
    {
        // Get temp payment info by reference id
        $tempInfo=$this->payment_model->getTempInfo($reference);
        
        if(!empty($tempInfo))
        {
            $amount=$tempInfo->amount;
            $uid=$tempInfo->user_id;
            $currency=$tempInfo->currency;
            //Get custom data(form data, cart data) from temp payment info
            $customData=unserialize($tempInfo->data);

            $orderId=0;
            if(isset($customData['order_id']))
                $orderId=$customData['order_id'];

            $payment_id = "";
            //Get trust data By cart type
            $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($customData['formData']['ashram_id'],$customData['cart_type']);
            $trustsArray=array();
            foreach ($trusts as $trustData)
            {
                $trustsArray[$trustData->currency]=$trustData;
            }
            //Get trust details for the selected currency
            $trustData=$trustsArray[$tempInfo->currency];

            if(isset($customData['cartData']))
            {
                // Generate temp transaction number
                $transaction=new stdClass();
                $transaction->tx=$temptx=substr(hash('sha256', mt_rand() . microtime()), 0, 20);
                $payment_id = $transaction->tx;
                $temp_payment_id = $payment_id;
                $tempIpn=new stdClass();
                $tempIpn->status='initiated';
                $tempIpn->amount=$amount;

                //Create Temporary Order
                $this->temp_payments_model->createTransactionTemp($payment_id,$tempInfo->user_id,$reference,'initiated',null,$orderId);
                // Update temp payment info table
                $this->temp_payments_model->tempInfoUpdateTxTemp($reference,$payment_id,$amount);
                //Now get all details from temp transaction table by transaction id
                $transactionRecord=$this->temp_payments_model->getTransactionTemp($payment_id);

                // Create temp order
                $orderId=$this->temp_payments_model->processPurchaseTemp($reference,$transaction,$tempInfo,$tempIpn);
                if($orderId)
                {
                    //Update stripe reference number to orders_temp table
                    $this->temp_payments_model->updateStripeTempReference($orderId,$razorpay_note_reference);
                    $tempInfo = json_encode($tempInfo);
                    //Update temp payment info and application reference to orders_temp table
                    $this->temp_payments_model->updateTempPaymentInfo($orderId,$tempInfo,$reference);
                }
                //Create Temporary Order
            }
            return array("order_id"=>$orderId,"payment_id"=>$payment_id);
        }
    }

    public function createSubRow($data)
    {
        $this->db->insert("subscription_payments",$data);
    }

    public function updateNumPayments($item_id,$payment_number)
    {
        $this->db->where("id",$item_id);
        $this->db->update("order_items",
            array("num_of_payments"=>$payment_number)
        );

        $this->archivesDb->where("order_item_id",$item_id);
        $this->archivesDb->update("stripe_subscriptions",
            array("total_payments_count"=>$payment_number)
        );
    }
}