<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH. '/third_party/stripe_package/init.php';
class Stripe_subscriptions_model extends CI_Model {

    /**
     * @name string TABLE_NAME Holds the name of the table in use by this model
     */
    const TABLE_NAME = 'stripe_subscriptions';
    var $archivesDb = "";
    /**
     * @name string PRI_INDEX Holds the name of the tables' primary index used in this model
     */
    const PRI_INDEX = 'id';

    /**
     * Retrieves record(s) from the database
     *
     * @param mixed $where Optional. Retrieves only the records matching given criteria, or all records if not given.
     *                      If associative array is given, it should fit field_name=>value pattern.
     *                      If string, value will be used to match against PRI_INDEX
     * @return mixed Single record if ID is given, or array of results
     */

    public function __construct()
    {
        parent::__construct();
        $this->archivesDb = $this->load->database("data_archives",true,false);
    }

    public function get($where = NULL) 
    {
        $this->archivesDb->select('*');
        $this->archivesDb->from(self::TABLE_NAME);
        $this->archivesDb->where('id', $where);
        $result = $this->archivesDb->get()->result();
        if ($result) 
        {
            return $resul;
        }
        else 
        {
            return false;
        }
    }

    /**
     * Inserts new data into database
     *
     * @param Array $data Associative array with field_name=>value pattern to be inserted into database
     * @return mixed Inserted row ID, or false if error occured
     */
    public function insert($data)
    {
        if ($this->archivesDb->insert(self::TABLE_NAME, $data))
        {
            return $this->archivesDb->insert_id();
        }
        else
        {
            return false;
        }
    }

    public function getSubscription($subscription_id)
    {
        $query = $this->archivesDb->select('completed_payments_count,total_payments_count,order_id,item_id,order_item_id')->from('stripe_subscriptions')->where('stripe_subscription_id',$subscription_id)->get();
        return $query;
    }

    public function getStripeCustomerId($orderId)
    {
        $query = $this->archivesDb->select('customer_id')->from(self::TABLE_NAME)->where('order_id',$orderId)->get();
        if($query->num_rows() > 0)
        {
            return $query->result()[0]->customer_id;
        }
        else
        {
            return false;
        }
    }

    public function getSubscriptionData($orderItemId=0,$orderId=0)
    {
        $query = $this->archivesDb->select('*')->from(self::TABLE_NAME)->where(['order_item_id'=>$orderItemId,'order_id'=>$orderId])->get();
        if($query->num_rows() > 0)
        {
            return $query->result()[0];
        }
        else
        {
            return false;
        }
    }

    public function updateStripesubId($updateData,$sub_id)
    {
        $this->archivesDb->where("stripe_subscription_id",$sub_id);
        $this->archivesDb->update(self::TABLE_NAME,$updateData);
    }

    public function updateOrderItemSubscription($id,$subscriptionProfileId,$itemData)
    {
        if($itemData->subscription_id=='')
        {
            $updateData['subscription_id']=$subscriptionProfileId;
            $updateData['status']=1;
        }
        $this->db->where("id",$id);
        $this->db->update("order_items",$updateData);
    }

    public function getStripeTrustDetails($ashramId,$currency,$orderType)
    {
        if($ashramId)
        {
            $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$orderType);
            $trustsArray=array();
            foreach ($trusts as $trustData)
            {
                $trustsArray[$trustData->currency]=$trustData;
            }
            $trustData=$trustsArray[$currency];
            return $trustData;
        }
        return false;
    }

    public function stripesubscriptionCancel($orderData,$itemData)
    {
        $this->load->model('orders/order_log_model');
        if($itemData->subscription_id)
        {
            $trustData = $this->getStripeTrustDetails($orderData['order']->ashram_id,$orderData['order']->currency,$orderData['order']->order_type);

            \Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
            $subscription = \Stripe\Subscription::retrieve($itemData->subscription_id);
            $cancel = $subscription->cancel();

            if($cancel['status'] == 'canceled')
            {
                $this->archivesDb->where('stripe_subscription_id',$itemData->subscription_id);
                $this->archivesDb->update('stripe_subscriptions',array('status'=>'Canceled','canceled_on'=>date('Y-m-d')));
            
                $this->db->where("id",$itemData->id);
                $this->db->update("order_items",array("status"=>2));
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public function getSubPaymentNumber($orderItemId,$paymentDate)
    {
        $this->db->select("payment_number,id as subscription_payment_id");
        $this->db->from("subscription_payments");
        $this->db->where("payment_date",$paymentDate);
        $this->db->where('order_item_id',$orderItemId);
        $query=$this->db->get();
        return $query;
    }

    public function updatesubscriptions($paymentnumber,$tx,$item_order_id,$amount,$currency,$subscription_id,$stripearray)
    {
        $this->load->model('payment_model');
        $this->load->model('locations_model');
        $this->load->model('orders/orders_model');
        
        $this->db->select("*,oi.id as id");
        $this->db->from("order_items as oi");
        $this->db->join("orders as o","o.id=oi.order_id");
        $this->db->where("subscription",1);
        $this->db->where('oi.id',$item_order_id);
        $items=$this->db->get()->result();
        foreach ($items as $orderItem)
        {
            $db_debug = $this->db->db_debug;
            $this->db->db_debug = false;
            
            $insertData=array(
                "order_id"=>$orderItem->order_id,
                "order_item_id"=>$orderItem->id,
                "profile_id"=>$subscription_id,
                "date"=>date("Y-m-d H:i:s"),
                "tx"=>$tx,
                "payment_mode"=>"stripe",
                "amount"=>abs($amount),
                "status"=>8
            );

            $this->db->where(array('payment_number'=>$paymentnumber,'order_item_id'=>$orderItem->id,'order_id'=>$orderItem->order_id));
            $this->db->update('subscription_payments',$insertData);
            $paymentId = "";
            $lastpaymentId = $this->db->select('id')->from('subscription_payments')->where(array('payment_number'=>$paymentnumber,'order_item_id'=>$orderItem->id,'order_id'=>$orderItem->order_id))->get();
            if($lastpaymentId->num_rows() > 0)
            {
                $lastpaymentIds = $lastpaymentId->result()[0]->id;
                $paymentId=$lastpaymentIds;
            }
            $mapData = array('tx'=>$tx,'subscription_payment_id'=>$paymentId,'created'=>date('Y-m-d H:i:s'));

            $subscriptionMapResults = $this->db->select("id")->from("subscription_payments_transaction_map")->where("tx",$tx)->get();
            if($subscriptionMapResults->num_rows() > 0)
            {

            }
            else
            {
                $this->db->insert("subscription_payments_transaction_map",$mapData);
                $this->db->db_debug = true;
                $tData = $this->payment_model->createTransaction($tx,$orderItem->user_id,'','paid',null,$orderItem->order_id);
                $this->payment_model->updateOrderTotalPaid($orderItem->order_id,$amount,$tx);
                $this->payment_model->populateTransactionReport($tx);
                $countryData=$this->locations_model->getCountryByCode($orderItem->country);
                $updateTxArray= array(
                    "t_status"=>1,
                    //'data'=>serialize($stripearray),
                    'modified_on'=>date("Y:m:d H:i:s"),
                    "order_item_id"=>$orderItem->id,
                    'amount'=>abs($amount),
                    'currency'=>$currency,
                    'payment_mode'=>'stripe',
                    'created_on'=>date("Y-m-d H:i:s"),
                    'note'=>"Payment for ".$orderItem->item_name,
                    "payment_number"=>$paymentnumber,
                    "ashram_id"=>$orderItem->ashram_id,
                    "trust_id"=>$orderItem->trust_id,
                    'firstname'=>$orderItem->firstname,
                    'lastname'=>$orderItem->lastname,
                    'city'=>$orderItem->city,
                    'state'=>$orderItem->state,
                    'country'=>$orderItem->country,
                    'email'=>$orderItem->email,
                    'phone'=>$orderItem->phone,
                    'country_isd_code'=>$countryData->isd_code,
                    'subscription'=>1
                );
                //$this->payment_model->updateTx($tx,$updateTxArray);
                $tData = array_merge($tData,$updateTxArray);
                //saving transaction table 
		        $this->payment_model->saveTransaction($tData);
                //saving payment response into archives database
                $this->payment_model->savingPaymentResponse($tx,$stripearray,$orderItem->user_id,"stripe",$orderItem->order_id);

                if(($tx != "") && ($amount > 0))
                {
                    $this->payment_model->updateOrderItemRows($orderItem->order_id,$amount,$tx);
                }

                $this->order_log_model->log($orderItem->order_id,"Subscription \"".$orderItem->item_name."\" Amount paid for Payment# ".$paymentnumber.", Transaction ID: ".$tx);

                $this->orders_model->sendTransactionReceiptEmail($orderItem->order_id,$tx);
                $this->orders_model->sendSubscriptionPaymentEmail($orderItem->order_id,$orderItem->id,$paymentId,0);
                $this->orders_model->sendSubscriptionPaymentEmailBCC($orderItem->order_id,$orderItem->id,$paymentId);
            }

        }
    }

    public function updateReactivatesubscriptions($txnid,$item_order_id,$item_id,$amount,$currency,$stripearray){
        $this->load->model('payment_model');
        $this->load->model('orders/orders_model');

        $this->db->select("*,oi.id as id");
        $this->db->from("order_items as oi");
        $this->db->join("orders as o","o.id=oi.order_id");
        $this->db->where("subscription",1);
        $this->db->where('oi.id',$item_order_id);
        $items=$this->db->get()->result();

        foreach ($items as $orderItem)
        {
            //echo "in loop";
            if(!$txnid)
            $txnid = "stripe".date("YmdHisu");
            
            $tData = $this->payment_model->createTransaction($txnid,$orderItem->user_id,'','approved',null,$orderItem->order_id);
            $updateTxArray= array(
                "t_status"=>1,
                //'data'=>serialize($stripearray),
                'modified_on'=>date("Y:m:d H:i:s"),
                'amount'=>abs($amount),
                'currency'=>$currency,
                'ashram_id'=>$orderItem->ashram_id,
                "trust_id"=>$orderItem->trust_id,
                'payment_mode'=>'stripe',
                'created_on'=>date("Y-m-d H:i:s"),
                'note'=>"Set up Fee for ReActivation : ".$orderItem->item_name,
            );
            //$this->payment_model->updateTx($txnid,$updateTxArray);
            $tData = array_merge($tData,$updateTxArray);
            //saving transaction table 
		    $this->payment_model->saveTransaction($tData);
            //saving payment response into archives database
            $this->payment_model->savingPaymentResponse($txnid,$stripearray,$orderItem->user_id,"stripe",$orderItem->order_id);
            $this->orders_model->sendTransactionReceiptEmail($orderItem->order_id,$txnid);
        }
    }

    public function paymentFail($tx,$subscription_id,$order_item_id,$order_id,$amount,$currency,$razorpayarray,$payment_date)
    {
        $this->load->model('locations_model');
        $this->db->select('id,payment_number')->from('subscription_payments')->where(array('order_item_id'=>$order_item_id,'order_id'=>$order_id,"payment_date"=>$payment_date));
        $this->db->group_start();
        $this->db->where("status",1);
        $this->db->or_where("status",0);
        $this->db->group_end();
        $this->db->order_by('id','asc');
        $lastpaymentId = $this->db->get();
        if($lastpaymentId->num_rows() > 0)
        {
            $resdata = $lastpaymentId;
            $lastpayId=$resdata->result()[0]->id;
            $paynum=$resdata->result()[0]->payment_number;
            $mapData = array('subscription_payment_id'=>$lastpayId,'created'=>date('Y-m-d H:i:s'),'tx'=>$tx);
            $this->db->insert("subscription_payments_transaction_map",$mapData);

        }
        if($lastpayId)
        {
            $this->db->select("*,oi.id as id");
            $this->db->from("order_items as oi");
            $this->db->join("orders as o","o.id=oi.order_id");
            $this->db->where("subscription",1);
            $this->db->where('oi.id',$order_item_id);
            $items=$this->db->get()->result();
            foreach ($items as $orderItem)
            {

                $db_debug = $this->db->db_debug;
                $this->db->db_debug = false;
                
                $this->updatetxsub($lastpayId,$tx,$amount,$subscription_id);

                $tData = $this->payment_model->createTransaction($tx,$orderItem->user_id,'','failure',null,$orderItem->order_id);
                $countryData=$this->locations_model->getCountryByCode($orderItem->country);
                $updateTxArray= array(
                    "order_item_id"=>$orderItem->id,
                    "t_status"=>2,
                    //'data'=>serialize($razorpayarray),
                    'modified_on'=>date("Y:m:d H:i:s"),
                    'amount'=>abs($amount),
                    'currency'=>$currency,
                    'payment_mode'=>'razorpay',
                    'firstname'=>$orderItem->firstname,
                    'lastname'=>$orderItem->lastname,
                    'city'=>$orderItem->city,
                    'state'=>$orderItem->state,
                    'country'=>$orderItem->country,
                    'email'=>$orderItem->email,
                    'phone'=>$orderItem->phone,
                    'country_isd_code'=>$countryData->isd_code,
                    'created_on'=>date("Y-m-d H:i:s"),
                    'note'=>"Payment for ".$orderItem->item_name." Failed from razorpay Gateway",
                    "payment_number"=>$paynum,
                    "ashram_id"=>$orderItem->ashram_id,
                    "trust_id"=>$orderItem->trust_id,
                    'subscription'=>1
                );
                //$this->payment_model->updateTx($tx,$updateTxArray);
                $tData = array_merge($tData,$updateTxArray);
                //saving transaction table 
		        $this->payment_model->saveTransaction($tData);
                //saving payment response into archives database
                $this->payment_model->savingPaymentResponse($tx,$razorpayarray,$orderItem->user_id,"stripe",$orderItem->order_id);
                $this->db->db_debug = true;

                $this->order_log_model->log($orderItem->order_id,"Subscription \"".$orderItem->item_name."\" Failed from razorpay Gateway for Payment# ".$paynum." , Transaction ID: ".$tx);
                $this->orders_model->sendSubscriptionPaymentFailEmail($orderItem->order_id,$orderItem->id,$lastpayId,$tx);
                $this->orders_model->sendSubscriptionPaymentFailEmailBCC($orderItem->order_id,$orderItem->id,$lastpayId,$tx);
            }
        }
    }
}   