<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Stripe_orders_sessions_Model extends CI_Model 
{
    function __construct() 
	{
	    parent::__construct();
    }

    public function setTempInfo($userID,$data,$amount,$currency,$reference,$session_id,$ashram_id,$cartType)
    {
    	$ref=$reference;
    	while(1)
    	{
    		$this->db->where("temp_reference_id",$ref);
    		$qref=$this->db->get("stripe_orders_sessions");
    		if($qref->num_rows()==0)
    		{
    			break;
    		}
    		$ref=random_string('alnum',12);
    	}

    	$dataArray=array(
    		'user_id'=>$userID,
    		"order_data"=>serialize($data),
    		"amount"=>$amount,
    		"order_type"=>$cartType,
    		"ashram_id"=>$ashram_id,
    		'currency'=>$currency,
    		'temp_reference_id'=>$ref,
    		'created_on'=>date("Y:m:d H:i:s"),
    		'stripe_session_id'=>$session_id
    		);
    	$this->db->insert("stripe_orders_sessions",$dataArray);
    	$this->logaction->log($this->service,"Temp Payment Info",serialize($this->db->last_query()));
    	return $ref;
    }

    public function getTempInfo($reference,$flag=0)
    {
    	$this->db->where("stripe_session_id",$reference);
    	$this->db->where("status",1);
    	$q=$this->db->get("stripe_orders_sessions");

    	if($flag==1)
    	{
    		$this->db->where("stripe_session_id",$reference);
    		$this->db->update("stripe_orders_sessions",array("status"=>0));
    	}
    	return $q->row();
    }

    public function getTempInfoByTx($tx,$flag=0)
    {
    	$this->db->where("transaction_id",$tx);
    	$q=$this->db->get("temp_payment_info");

    	if($flag==1)
    	{
    		$this->db->where("transaction_id",$tx);
    		$this->db->update("temp_payment_info",array("status"=>1));
    	}
    	return $q->row();
    }

    public function saveCardDetails($dataArray)
    {
    	$this->db->insert("stripe_subscriptions_payment_details",$dataArray);
    }

	public function update_payments_session($session_id,$subId)
	{
		$updateData = array("session_id"=>$session_id);
		$this->db->where("subscription_id",$subId);
		$this->db->update("stripe_subscriptions_payment_details",$updateData);
	}
	public function updateCardDetails($method_data,$subId)
	{
		$method_data["session_id"] = "";
		$this->db->where("subscription_id",$subId);
		$this->db->update("stripe_subscriptions_payment_details",$method_data);
	}

	public function getPaymentDetails($session_id)
	{
		$this->db->where("session_id",$session_id);
		$q = $this->db->get("stripe_subscriptions_payment_details")->row();
		return $q;
	}
}
?>