<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class SMS_model extends CI_Model
{
	var $tableName="sms_track_";
	var $smsDb='';
	public function __construct()
	{
		parent::__construct();
		$this->smsDb=$this->load->database("sms",true,false);
	}
	public function trackSMS($serviceSlug,$userId,$messageId,$number,$message,$status=1,$error='',$resent=0,$resent_id=0,$username='')
	{
		if($GLOBALS['site_settings']['sms_service']==0)
    	{
    		return true;
    	}
		$data=array(
				'user_id' => $userId,
				'username'=>$username,
				'message_id' => $messageId,
				'message' => $message,
				'to' => $number,
				'sent_on'=>date("Y:m:d H:i:s"),
				'date'=>date("Y:m:d H:i:s"),
				'status'=>$status,
				'fail_reason'=>$error,
				'resent'=>$resent,
				'resent_id'=>$resent_id
				);
		$this->smsDb->insert($this->tableName.$serviceSlug,$data);
		return $this->smsDb->insert_id();
	}

	public function listsms($serviceSlug,$excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$i=0;
		if($excel==0)
			$this->smsDb->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$this->smsDb->select("*");
		}
		$this->smsDb->from($this->tableName.$serviceSlug);
		
		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nSearch Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
			isset($_POST['search_col']) && in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$this->smsDb->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$this->smsDb->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$this->smsDb->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$this->smsDb->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		if(preg_match("/inr/i",$serviceSlug))
		{
			$preData.="\nPayments: ";
			$preData.=" INR ";
		}
		else if(preg_match("/usd/i",$serviceSlug))
		{
			$preData.="\nPayments: ";
			$preData.=" USD ";
		}
		
		$preData.="\nStatus: ";
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1,2)))
		{
			$this->smsDb->where("status",$_POST['status']);
			if($_POST['status']==0)
			{
				$preData.="Pending";
			}
			if($_POST['status']==1)
			{
				$preData.="Sent";
			}
			if($_POST['status']==2)
			{
				$preData.="Failed";
			}
		}

		// $preData.="\nViewed: ";
		if(isset($_POST['viewed']) && is_numeric($_POST['viewed']) && in_array($_POST['viewed'],array(0,1)))
		{
			$this->smsDb->where("viewed",$_POST['viewed']);
			// if($_POST['viewed']==0)
			// 	$preData.="No";
			// else
			// 	$preData.="Yes";
		}
		$preData.="\nFrom Date: ";
		if(isset($_POST['date_col']) && in_array($_POST['date_col'],array('date','sent_on')) &&
			isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$this->smsDb->where("date(".$_POST['date_col'].") >=",date("Y:m:d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date']." (".$GLOBALS['current_acl']['excel_columns'][$_POST['date_col']].")";
		}
		$preData.="\nTo Date: ";
		if(isset($_POST['date_col']) && in_array($_POST['date_col'],array('date','sent_on')) &&
			isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$this->smsDb->where("date(".$_POST['date_col'].") <=",date("Y:m:d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date']." (".$GLOBALS['current_acl']['excel_columns'][$_POST['date_col']].")";
		}
		
		$preData.="\nResent: ";
		if(isset($_POST['resent']) && is_numeric($_POST['resent']) && in_array($_POST['resent'],array(0,1)))
		{
			$this->smsDb->where("resent",$_POST['resent']);
			if($_POST['resent']==0)
				$preData.="No";
			else
				$preData.="Yes";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$this->smsDb->order_by($_POST['order_by'],$_POST['dir']);
				else
					$this->smsDb->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$this->smsDb->order_by('date',$_POST['dir']);
				else
					$this->smsDb->order_by('date',"desc");
			}
			$sql=$this->smsDb->get_compiled_select();

			$slug_title_part='';
			if(preg_match("/payments_/i",$serviceSlug))
			{
				$slug_title_part="Orders";
			}
			else if(preg_match("/payments/i",$serviceSlug))
			{
				$slug_title_part="Payments";
			}
			else
			{
				$this->breadcrumb[$serviceSlug]['titlepart'];
			}
			$requestResp=$this->excel_exports_model->makeRequest($serviceSlug,"model","sms_model",$sql,$this->currentUser,"sms",$_POST,$slug_title_part." - All SMS",$preData);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $this->smsDb->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}
		
		$dir='desc';
		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];
		
		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$this->smsDb->order_by($col_name,$dir);
			else
				$this->smsDb->order_by('date',$dir);
		}
		else
		{
			$this->smsDb->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			$start=abs($_POST['start']);
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']))
		{
			$length=abs($_POST['length']);
		}


		$this->smsDb->limit($length,$start);

		$rtn['data']=$this->smsDb->get()->result_array();
		//echo $this->smsDb->last_query();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if($row['date'])
				$rtn['data'][$c]['date']=date("d M Y h:i A",strtotime($row['date']));
			else
				$rtn['data'][$c]['date']='-';
			$rtn['data'][$c]['DT_RowId']=10;
			if($rtn['data'][$c]['sent_on'])
				$rtn['data'][$c]['sent_on']=date("d M Y h:i A",strtotime($row['sent_on']));
			else
				$rtn['data'][$c]['sent_on']="N/A";

			$rtn['data'][$c]['message']=nl2br($row['message']);
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function getSMSByID($serviceSlug,$id)
	{
		try
		{
			$db_debug = $this->smsDb->db_debug;
			$this->smsDb->db_debug = false;
			$this->smsDb->where("id",$id);
			$r=$this->smsDb->get("sms_track_".$serviceSlug);
			$this->smsDb->db_debug = $db_debug;
			if($r)
			{
				return $r->row();
			}
		}
		catch(Exception $e)
		{
			return array();
		}
	}

	public function resendSMS($serviceSlug,$id)
	{
		if($GLOBALS['site_settings']['sms_service']==0)
    	{
    		return true;
    	}
		$smsData=$this->getSMSByID($serviceSlug,$id);
		if(!empty($smsData))
		{
			if($smsData->status==0)
			{
				$data['flag']=0;
				$data['msg']="SMS in pending state cannot be resent";
				return $data;
			}
			$userData=[];
			$guest=1;
			$country_id="";
			if($smsData->user_id!=0)
			{
				$userData=$this->userutil->getUserMetaData($smsData->user_id);
				if($userData['userid'])
				{
					$userData=$userData['userdata'];
					$country_id = $userData->country_id;
					$guest=0;
				}
			}

			$this->load->library("sms");

			$sendResponse=$this->sms->sendSMSNoTrack(
									$smsData->to,
									$smsData->message,
									$country_id
								);

			$queueID=$this->trackSMS(
										$serviceSlug,
										$smsData->user_id,
										$sendResponse['smsid'],
										$smsData->to,
										$smsData->message,
										$sendResponse['flag'],
										$sendResponse['flag']? '':$sendResponse['msg'],
										1,
										$smsData->id
									);
			$this->logaction->log($serviceSlug,"SMS re-sent to  ".$smsData->to." | ID: ".$queueID);
			$data['flag']=1;
			$data['msg']="SMS re-sent to '".$smsData->to."' successfully";
			return $data;
		}
		else
		{
			$data['flag']=0;
			$data['msg']="Invalid request";
			return $data;
		}
	}
	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->smsDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Message");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"To");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Created");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Sent");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Message ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Resent?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->message);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->to);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			if($reportrow->sent_on!='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->sent_on)));
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->message_id);

			$status="Pending";
			if($reportrow->status==1)
				$status="Sent";
			if($reportrow->status==2)
				$status="Failed";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);

			$resent="No";
			if($reportrow->resent==1)
				$resent="Yes";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resent);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>