<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Refunds_history_model extends CI_Model 
{
	var $tableName = "";
	var $searchAliasNames2 = [
								"refund_date" => "Refund Date",
								"started_on" => "Tx Initiated",
								"created_on" => "Tx Processed",
								"modified_on" => "Tx Modified",
							];
	var $auth_check = "";
	var $payment_success_statuses ="";

    function __construct()
	{
        parent::__construct();
        $this->tableName = "refunds_history";
        $this->payment_success_statuses = array('success','Success','approved','completed','captured','paid','Release Payment');
        $this->auth_check = $this->load->database("sso_auth",true,false);
    }
    public function saveHistory($txData,$orderData,$refundData,$refund_flag,$offline = 0,$refund_message,$refund_id="")
	{
		$ref_response 	= json_encode($refundData,JSON_FORCE_OBJECT);
		$currency 		= strtolower($txData->currency);
		$payment_source = "Online";
		$fail_reason 	= "";
		if($refund_id == "")
		{
			$refund_id 		= "N/A";
		}
		
		if($offline == 1)
		{
			$ref_response 	= "Offline";
			$payment_source = "Offline";
			$refund_id = $refund_id;
		}
		if($refund_flag == 0)
		{
			$fail_reason 	= $refund_message;
			$refund_id 		= "N/A";
		}
		else
		{
			if($offline == 1)
			{
				$ref_response 	= "Offline";
				$payment_source = "Offline";
				$refund_id = $refund_id;
			}
			else
			{
				if(strtolower($txData->payment_mode) == "paypal")
				{
					if(!empty($refundData['PNREF']))
						$refund_id = $refundData['PNREF'];
					else
						$refund_id = substr(hash('sha256', mt_rand() . microtime()), 0, 10);
				}
				else if(strtolower($txData->payment_mode) == "payu")
				{
					$refund_id 		= $refundData->result;
				}
				else if(strtolower($txData->payment_mode) == "razorpay")
				{
					if(!empty($refundData->id))
						$refund_id 		= $refundData->id;
					else
						$refund_id 		= "N/A";
				}
				else if(strtolower($txData->payment_mode) == "stripe")
				{
					if(!empty($refundData->id))
						$refund_id 		= $refundData->id;
					else
						$refund_id 		= "N/A";
				}
			}
		}
		if((!empty($refundData) || !empty($fail_reason)) && !empty($txData) && !empty($orderData))
		{
			$this->db->insert($this->tableName,array
						(
							"ashram_id"				=>	$txData->ashram_id,
							"trust_id"				=>	$txData->trust_id,
							"order_id"				=>	$orderData['order']->id,
							"order_number"			=>	$orderData['order']->order_number,
							"payment_source"		=>	$payment_source,
							"order_item_id"			=>	$txData->order_item_id,
							"tx"					=>	$txData->tx,
							"transaction_id"		=>	$txData->id,
							"refund_id"				=>	$refund_id,
							"refund_success_flag"	=>	$refund_flag,
							"gateway_fail_reason"	=>	$fail_reason,
							"refund_date"			=>	date("Y-m-d"),
							"order_type"			=>	$orderData['order']->order_type,
							"payment_mode"			=>	$txData->payment_mode,
							"amount"				=>	$txData->amount,
							"currency"				=>	$currency,
							"refunded_by"			=>	$this->currentUser->id,
							"user_id"				=>	$orderData['order']->user_id,
							"created_at"			=>	date("Y-m-d H:i:s"),
							"ip_address"			=>	$_SERVER['REMOTE_ADDR'],
							"response"				=> 	$ref_response
						));
			if($refund_id)
				return $refund_id;
		}
		else
		{
			return false;
		}
	}

	/**
	 * [listAdminRefundTransactions description]
	 * @param  integer $excel [description]
	 * @return [type]         [description]
	 */
	public function listAdminRefundTrans($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(rh.id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("rh.*,ts.payment_mode,ts.status as payment_status,ts.started_on,ts.created_on,ts.modified_on,ts.firstname,ts.lastname,ts.city,ts.state,ts.email,ts.country_isd_code,ts.phone,ts.note,ts.country,ts.refund_mode,is_manual_payment,is_foreign_payment, ts.userid, usr.username");
		}

		$query1->from($this->tableName . " As rh");
		$query1->join("transaction as ts","ts.id = rh.transaction_id");
		$query1->join("users as usr",'usr.id=ts.userid');
		if($this->session->userdata("ashramId"))
		{
			$query1->where("rh.ashram_id",$this->session->userdata("ashramId"));
		}
		$preData="";
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			if($_POST['search_col'] == "tx" || $_POST['search_col'] == "order_id" || $_POST['search_col'] == "email"
			|| $_POST['search_col'] == "firstname" || $_POST['search_col'] == "lastname" || $_POST['search_col'] == "city" || $_POST['search_col'] == "state")
			{
				$search_col = "ts.".$_POST['search_col'];
			}
			else
			{
				$search_col = $_POST['search_col'];
			}
			$query1->like($search_col,trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like($search_col,trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like($search_col,trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($search_col,trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='' && isset($_POST['search_col2']))
		{
			if(in_array($_POST['search_col2'],$GLOBALS['current_acl']['search_columns']))
			{
				$query1->where("date(ts.".$_POST['search_col2'].") >=",date("Y-m-d",strtotime($_POST['from_date'])));
				$preData.=$_POST['from_date'];
				if(isset($this->searchAliasNames2[$_POST['search_col2']]) && ($this->searchAliasNames2[$_POST['search_col2']]!=''))
				{
					$preData.=" (".$this->searchAliasNames2[$_POST['search_col2']].")";
				}
			}
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='' && isset($_POST['search_col2']))
		{
			if(in_array($_POST['search_col2'],$GLOBALS['current_acl']['search_columns']))
			{
				$query1->where("date(ts.".$_POST['search_col2'].") <=",date("Y-m-d",strtotime($_POST['to_date'])));
				$preData.=$_POST['to_date'];
				if(isset($this->searchAliasNames2[$_POST['search_col2']]) && ($this->searchAliasNames2[$_POST['search_col2']]!=''))
				{
					$preData.=" (".$this->searchAliasNames2[$_POST['search_col2']].")";
				}
			}
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("rh.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		$preData.="\nPayment Source:";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			if($_POST['payment_mode']=='paypal')
			{
				$query1->where("rh.payment_mode",'paypal');
				$preData.=" Paypal";
			}
			else if($_POST['payment_mode']=='stripe')
			{
				$query1->where("rh.payment_mode",'stripe');
				$preData.=" Stripe";
			}
			else if($_POST['payment_mode']=='razorpay')
			{
				$query1->where("rh.payment_mode",'razorpay');
				$preData.=" Razorpay";
			}
			else if($_POST['payment_mode']=='authorize.net')
			{
				$query1->where("rh.payment_mode",'authorize.net');
				$preData.=" Authorize.net";
			}
			else if($_POST['payment_mode']=='payu')
			{
				$query1->where("rh.payment_mode",'payu');
				$preData.=" PayU";
			}
			else if($_POST['payment_mode']=='cash')
			{
				$query1->where("rh.payment_mode",'cash');
				$preData.=" Cash";
			}
			else if($_POST['payment_mode']=='cc')
			{
				$query1->where("rh.payment_mode",'cc');
				$preData.=" CC";
			}
			else if($_POST['payment_mode']=='dc')
			{
				$query1->where("rh.payment_mode",'dc');
				$preData.=" DC";
			}
			else if($_POST['payment_mode']=='cheque')
			{
				$query1->where("rh.payment_mode",'cheque');
				$preData.=" Cheque";
			}
			else if($_POST['payment_mode']=='mo')
			{
				$query1->where("rh.payment_mode",'mo');
				$preData.=" MO";
			}
			else if($_POST['payment_mode']=='cashiers_check')
			{
				$query1->where("rh.payment_mode",'cashiers_check');
				$preData.=" Cashiers Check";
			}
			else
			{
				$query1->where("rh.payment_mode",'');
			}
		}
		else
		{
			$preData.=" All Payment Source";
		}

		$preData.="\nRefund Mode:";
		if(isset($_POST['refund_mode']) && in_array($_POST['refund_mode'],array("Offline","Online")))
		{
			$query1->where("rh.payment_source",$_POST['refund_mode']);
			$preData.=" ".$_POST['refund_mode'];
		}
		else
		{
			$preData.=" All Modes";
		}

		$preData.="\nRefund Source:";
		if(isset($_POST['refund_source']) && $_POST['refund_source']!='')
		{
			$query1->where("ts.refund_mode",$_POST['refund_source']);
			$preData.=" ".ucfirst($_POST['refund_source']);
		}
		else
		{
			$preData.=" All Payment Source";
		}

		$preData.="\nRefund Status:";
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1)))
		{
			if($_POST['status']==1)
			{
				$query1->where("refund_success_flag",1);
				$preData.=" Success";
			}
			else if($_POST['status']==0)
			{
				$query1->where("refund_success_flag",0);
				$preData.=" Failed";
			}
		}
		else
		{
			$preData.=" All status";
		}


		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by("id",$_POST['dir']);
				else
					$query1->order_by("id",'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('id',$_POST['dir']);
				else
					$query1->order_by('id',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","refunds_history_model",$sql,$this->currentUser,"default",$_POST,"All Refund Transactions",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('id',$dir);
		}
		else
		{
			$query1->order_by('id',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['started_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['started_on']));
			$rtn['data'][$c]['modified_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['modified_on']));
			if($row['created_on'])
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['created_on']));
			else
				$rtn['data'][$c]['created_on']='NA';

			$rtn['data'][$c]['refund_date']=date("d M Y",strtotime($rtn['data'][$c]['refund_date']));

			$rtn['data'][$c]['amount_num']=abs($row['amount']);
			if(empty($row['amount']))
			{
				$row['amount']=0;
			}
			if($row['currency']=='usd')
				$rtn['data'][$c]['amount']="<span style='color:red; font-weight:bold;'>".strtoupper($row['currency'])." ".$row['amount']."</span>";
			else
				$rtn['data'][$c]['amount']="<span style='font-weight:bold;'>".strtoupper($row['currency'])." ".$row['amount']."</span>";

			$rtn['data'][$c]['note'] = nl2br($rtn['data'][$c]['note']);

			$rtn['data'][$c]['firstname']=$row['firstname']." ".$row['lastname']."<br>".
											$row['city']."<br>".
											$row['state'].", ".$row['country']."<br>".
											"<span style='font-weight:bold;'>".$row['email']."</span><br>".
											"<span style='font-weight:bold; color:red;'>+".$row['country_isd_code']." ".$row['phone']."</span>";
			$sno++;
			$c++;
		}
		return $rtn;
	}

	/**
	 * [listAdminRefundTransactions description]
	 * @param  integer $excel [description]
	 * @return [type]         [description]
	 */
	public function listAdminRefundReplaceLogs($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(logs.id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}

		$query1->from("order_items_refund_replace_logs as logs");
		if($this->session->userdata("ashramId"))
		{
			$query1->where("logs.ashram_id",$this->session->userdata("ashramId"));
		}
		$preData="";
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$search_col = $_POST['search_col'];
			$query1->like($search_col,trim($_POST['search_text']));
			$preData.='"'.$_POST['search_text'].'"';
		}
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(logs.created_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(logs.created_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("logs.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		$preData.="\nSeva Type: ";
		if(isset($_POST['cart_type']) && $_POST['cart_type']!='')
		{
			$query1->where("logs.cart_type",$_POST['cart_type']);
			if($_POST['cart_type'] == 1)
			{
				$preData.="Poojas";
			}
			if($_POST['cart_type'] == 2)
			{
				$preData.="Donations";
			}
			if($_POST['cart_type'] == 3)
			{
				$preData.="Store";
			}
			if($_POST['cart_type'] == 4)
			{
				$preData.="Subscriptions";
			}
		}
		else
		{
			$preData.="All Seva Types";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by("id",$_POST['dir']);
				else
					$query1->order_by("id",'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('id',$_POST['dir']);
				else
					$query1->order_by('id',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","refunds_history_model",$sql,$this->currentUser,"default",$_POST,"All Items Refund Replace Logs",$preData,2);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('id',$dir);
		}
		else
		{
			$query1->order_by('id',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['created_on']));
			

			if($row['currency']=='usd')
				$rtn['data'][$c]['amount']="<span style='color:red; font-weight:bold;'>".strtoupper($row['currency'])." ".$row['amount']."</span>";
			else
				$rtn['data'][$c]['amount']="<span style='font-weight:bold;'>".strtoupper($row['currency'])." ".$row['amount']."</span>";
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function getSubscriptionPaymentId($tx)
	{
		if(empty($tx)) return array();
		$this->db->where("tx",$tx);
		return $this->db->get("subscription_payments")->row();
	}

	public function updateRefundsHistory($tx,$updateData)
	{
		$this->db->where("tx",$tx);
		$this->db->update("refunds_history",$updateData);
	}

	public function updateOrderItems($order_id)
	{
		$orderData=$this->orders_model->orderData($order_id);
		if($orderData['order']->payment_status == "0")
		{
			$updateData = array("status"=>0);
			$this->db->where("order_id",$order_id);
			$this->db->where("subscription",0);
			$this->db->update("order_items",$updateData);
		}
	}

	public function attach_items_to_order($orderData,$orderId,$customData,$reference,$batchId,$amount,$bgcolor)
	{
		$order_id = $orderId;
		$original_total_price = $orderData["order"]->original_total_price + $amount;
		$this->load->model("user/users_model");
		$sso_user_id = $this->users_model->getSSOUserID($orderData["order"]->user_id);
		$currency = strtolower($orderData["order"]->currency);
		$seq=0;
		foreach ($customData['cartData'] as $itemData)
		{
			$friend_or_otherarr = [];
			$friend_or_otherarr[1] = '';
			$friend_or_otherarr[2] = '';
			$friend_or_otherarr[3] = '';
			$friend_or_otherarr[4] = '';
			$friend_or_otherarr[5] = '';
			$friend_or_otherarr[6] = '';
			$friend_or_otherarr[7] = '';
			$friend_or_otherarr[8] = '';
			$friend_or_otherarr[9] = '';
			$friend_or_otherarr[10] = '';
			$pooja_on_swamiji = 0;
			$pooja_on_teertha_swamiji = 0;
			$is_from_appji = 'No';
			$link_token = '';
			$appji_member_name = '';
			$appji_member_email = '';
			$seq++;
			$priceCol="price_".$currency;
			$onetimeChargeCol="onetime_charge_".$currency;

			$nameoffamilytype = "";
			$selectedfamilymembers = "";
			$itemData['options']['family_member_details'] = '';
			// Set family member details for every order item
			if($customData['cart_type']==1 && !isset($itemData['options']['pooja_on_family_type']))
			{
				if(isset($itemData['options']['max_family_members']) && $itemData['options']['max_family_members'] != 'All family members')
				{
					$itemData['options']['pooja_on_family_type'] = 3;
				}
				else
				{
					$itemData['options']['pooja_on_family_type'] = 2;
				}
			}

			if($customData['cart_type']==2 && !isset($itemData['options']['donation_on_family_type']))
			{
				if($this->session->userdata("donationCartAshramIdSelection")==appji_ashram_id)
            	{
            		$cartItem['options']['donation_on_family_type'] = 13;
            	}
				else if(isset($itemData['options']['max_family_members']) && $itemData['options']['max_family_members'] != 'All family members')
				{
					$itemData['options']['donation_on_family_type'] = 7;
				}
				else
				{
					$itemData['options']['donation_on_family_type'] = 6;
				}
			}

			if($customData['cart_type']==4 && !isset($itemData['options']['subscription_on_family_type']))
			{
				if($this->session->userdata("subscriptionCartAshramIdSelection")==appji_ashram_id)
            	{
            		$itemData['options']['subscription_on_family_type'] = 14;
            	}
				else
				{
					$itemData['options']['subscription_on_family_type'] = 10;
				}
			}

			if(isset($itemData['options']['pooja_on_family_type']) && in_array($itemData['options']['pooja_on_family_type'],[0,1,2,3,8]))
			{
				if($itemData['options']['pooja_on_family_type'] == 0)
				{
					$pooja_on_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Ganapathy Sachchidananda Swamiji";
					$nameoffamilytype = 0;
				}
				if($itemData['options']['pooja_on_family_type'] == 1)
				{
					$pooja_on_teertha_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Datta Vijayananda Teertha Swamiji";
					$nameoffamilytype = 1;
				}
				if($itemData['options']['pooja_on_family_type'] == 2)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							$thisnote .= $thisdonr['donor_name']."\r\n";
							if($selectedfamilymembers == '')
							{
								$selectedfamilymembers .= $thisdonr['donor_id'];
							} else {
								$selectedfamilymembers .= ','.$thisdonr['donor_id'];
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 2;
				}
				if($itemData['options']['pooja_on_family_type'] == 3)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							if(isset($itemData['options']['pooja_on_family_members']) && !empty($itemData['options']['pooja_on_family_members']) && in_array($thisdonr['donor_id'], $itemData['options']['pooja_on_family_members']))
							{
								$thisnote .= $thisdonr['donor_name']."\r\n";
								if($selectedfamilymembers == '')
								{
									$selectedfamilymembers .= $thisdonr['donor_id'];
								} else {
									$selectedfamilymembers .= ','.$thisdonr['donor_id'];
								}
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 3;
				}
				if($itemData['options']['pooja_on_family_type'] == 8)
				{
					$itemData['options']['family_member_details'] = '';
					for($othercount=1;$othercount<=10;$othercount++)
					{
						if(isset($itemData['options']['other_name'.$othercount]) && $itemData['options']['other_name'.$othercount]!='')
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							$itemData['options']['family_member_details'] .= trim($itemData['options']['other_name'.$othercount]);
							$friend_or_otherarr[$othercount] = trim($itemData['options']['other_name'.$othercount]);
						}
					}
					if(isset($itemData['options']['other_names']) && !empty($itemData['options']['other_names']))
					{
						$optionsOtherName = array();
						$optionsOtherNameKey = 1;
						foreach($itemData['options']['other_names'] as $thisName)
						{
							$optionsOtherName[$optionsOtherNameKey] = $thisName;
							$optionsOtherNameKey++;
						}
						for($othercount=1;$othercount<=10;$othercount++)
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							if(isset($optionsOtherName[$othercount]))
							{
								$itemData['options']['family_member_details'] .= trim($optionsOtherName[$othercount]);
								$friend_or_otherarr[$othercount] = trim($optionsOtherName[$othercount]);
							}
						}
					}
					$nameoffamilytype = 8;
				}
			}


			if(isset($itemData['options']['donation_on_family_type']) && in_array($itemData['options']['donation_on_family_type'],[4,5,6,7,9,13]))
			{
				if($itemData['options']['donation_on_family_type'] == 4)
				{
					$pooja_on_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Ganapathy Sachchidananda Swamiji";
					$nameoffamilytype = 4;
				}
				if($itemData['options']['donation_on_family_type'] == 5)
				{
					$pooja_on_teertha_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Datta Vijayananda Teertha Swamiji";
					$nameoffamilytype = 5;
				}
				if($itemData['options']['donation_on_family_type'] == 6)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->where('is_hidden',0);
					$donorquery->order_by('donor_name','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							$thisnote .= $thisdonr['donor_name']."\r\n";
							if($selectedfamilymembers == '')
							{
								$selectedfamilymembers .= $thisdonr['donor_id'];
							} else {
								$selectedfamilymembers .= ','.$thisdonr['donor_id'];
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 6;
				}
				if($itemData['options']['donation_on_family_type'] == 7)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							if(in_array($thisdonr['donor_id'], $itemData['options']['donation_on_family_members']))
							{
								$thisnote .= $thisdonr['donor_name']."\r\n";
								if($selectedfamilymembers == '')
								{
									$selectedfamilymembers .= $thisdonr['donor_id'];
								} else {
									$selectedfamilymembers .= ','.$thisdonr['donor_id'];
								}
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 7;
				}
				if($itemData['options']['donation_on_family_type'] == 9)
				{
					$itemData['options']['family_member_details'] = '';
					for($othercount=1;$othercount<=10;$othercount++)
					{
						if(isset($itemData['options']['other_name'.$othercount]) && $itemData['options']['other_name'.$othercount]!='')
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							$itemData['options']['family_member_details'] .= trim($itemData['options']['other_name'.$othercount]);
							$friend_or_otherarr[$othercount] = trim($itemData['options']['other_name'.$othercount]);
						}
					}
					if(isset($itemData['options']['other_names']) && !empty($itemData['options']['other_names']))
					{
						$optionsOtherName = array();
						$optionsOtherNameKey = 1;
						foreach($itemData['options']['other_names'] as $thisName)
						{
							$optionsOtherName[$optionsOtherNameKey] = $thisName;
							$optionsOtherNameKey++;
						}
						for($othercount=1;$othercount<=10;$othercount++)
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							if(isset($optionsOtherName[$othercount]))
							{
								$itemData['options']['family_member_details'] .= trim($optionsOtherName[$othercount]);
								$friend_or_otherarr[$othercount] = trim($optionsOtherName[$othercount]);
							}
						}
					}
					$nameoffamilytype = 9;
				}
				if($itemData['options']['donation_on_family_type'] == 13)
				{
					$itemData['options']['family_member_details'] = '';
					if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
					{
						$itemData['options']['family_member_details'] = $itemData['options']['appji_member_name'];
					}
					if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
					{
						$itemData['options']['family_member_details'] .=  "\r\n".$itemData['options']['appji_member_email'];
					}
					$nameoffamilytype = 13;
				}
			}

			if(isset($itemData['options']['subscription_on_family_type']) && in_array($itemData['options']['subscription_on_family_type'],[10,11,12,14]))
			{
				if($itemData['options']['subscription_on_family_type'] == 10)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							if($thisdonr['donor_id']==$itemData['options']['subscription_on_family_member'])
							{
								$thisnote .= $thisdonr['donor_name']."\r\n";
								if($selectedfamilymembers == '')
								{
									$selectedfamilymembers .= $thisdonr['donor_id'];
									$itemData['options']['donor_id'] = $thisdonr['donor_id'];
								} else {
									$selectedfamilymembers .= ','.$thisdonr['donor_id'];
									$itemData['options']['donor_id'] = $thisdonr['donor_id'];
								}
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 10;
				}
				if($itemData['options']['subscription_on_family_type'] == 11)
				{
					$pooja_on_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Ganapathy Sachchidananda Swamiji";
					$nameoffamilytype = 11;
				}
				if($itemData['options']['subscription_on_family_type'] == 12)
				{
					$pooja_on_teertha_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Datta Vijayananda Teertha Swamiji";
					$nameoffamilytype = 12;
				}
				if($itemData['options']['subscription_on_family_type'] == 14)
				{
					$itemData['options']['family_member_details'] = '';
					if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
					{
						$itemData['options']['family_member_details'] = $itemData['options']['appji_member_name'];
					}
					if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
					{
						$itemData['options']['family_member_details'] .=  "\r\n".$itemData['options']['appji_member_email'];
					}
					$nameoffamilytype = 14;
				}
			}

			
			if($customData['cart_type']==1)
			{
				$shipDomestic="shipping_domestic_".$currency;
				$shipInternational="shipping_international_".$currency;
				$shippingPrice=0;
				$prasadam_status = 0;
				if($this->input->post('prasadam_not_required') && $this->input->post('prasadam_not_required') == 1)
				{
					$prasadam_status = 1;
				}
				if(isset($itemData['options']['shipping']) && $itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						if($itemData['options']['shipping_address']['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
					}
					else
                	{
                		if($info['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
                	}
				}
				$pitru_paksha_pooja = 0;
				$pitru_paksha_deceased_person_name = '';
				if(isset($itemData['options']['pitru_paksha_pooja']) && $itemData['options']['pitru_paksha_pooja']==1)
				{
					$pitru_paksha_pooja = 1;
					if(isset($itemData['options']['pitru_paksha_deceased_person_name']) && $itemData['options']['pitru_paksha_deceased_person_name']!='')
					{
						$itemData['options']['family_member_details'] = $itemData['options']['pitru_paksha_deceased_person_name'];
						$pitru_paksha_deceased_person_name = $itemData['options']['pitru_paksha_deceased_person_name'];
					}
					else
					{
						$itemData['options']['family_member_details'] = 'NA';
					}

					$selectedfamilymembers = '';
				}
				$is_poornaphala_seva = 0;
				$poornaphala_tie_by = '';
				if(isset($itemData['options']['is_poornaphala_seva']) && $itemData['options']['is_poornaphala_seva']==1)
				{
					$is_poornaphala_seva = 1;
					$itemData['options']['poornaphala_tie_by'] = 'Priest will tie Poornaphala';
					if($this->session->userdata('poojaPoornaphalaTieBy'))
					{
						foreach ($this->session->userdata('poojaPoornaphalaTieBy') as $key => $value) 
						{
							if($key == $itemData['rowid'])
							{
								if($value != '')
								{
									$itemData['options']['poornaphala_tie_by'] = $value;
									$poornaphala_tie_by = $value;
								}
							}
						}
					}
				}
				$max_family_members = 'All family members';
				if(isset($itemData['options']['max_family_members']) && $itemData['options']['max_family_members']>0)
				{
					$max_family_members = $itemData['options']['max_family_members'];
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								'price'=>$itemData['options'][$priceCol],
								'start_date'=>$itemData['options']['start_date'],
								'end_date'=>$itemData['options']['end_date'],
								'time_from'=>$itemData['options']['time_from'],
								'time_to'=>$itemData['options']['time_to'],
								'schedule_dates' =>$itemData['options']['result_date'],
								'options' =>serialize($itemData['options']),
								'prasadam_not_required'=>$prasadam_status,
								"batch_id"=>$batchId,
								//'shipping'=>$itemData['options']['shipping'],
								//'shipping_price'=>$shippingPrice,
								'pooja_on_swamiji'=>$pooja_on_swamiji,
								"background_color"=>$bgcolor,
								'category'=>$itemData['options']['category'],
								'sequence'=>$seq,
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'personal_note'=>$itemData['options']['personal_note'],
								'family_member_details'=>$itemData['options']['family_member_details'],
								'pitru_paksha_pooja'=>$pitru_paksha_pooja,
								'pitru_paksha_deceased_person_name'=>$pitru_paksha_deceased_person_name,
								'is_poornaphala_seva'=>$is_poornaphala_seva,
								'poornaphala_tie_by'=>$poornaphala_tie_by,
								'name_of_family_type'=>$nameoffamilytype,
								'pooja_on_teertha_swamiji'=>$pooja_on_teertha_swamiji,
								'family_members'=>$selectedfamilymembers,
								'max_family_members'=>$max_family_members,
								"newly_attached_item"=>1,
								'friend_or_other_1'=>$friend_or_otherarr[1],
								'friend_or_other_2'=>$friend_or_otherarr[2],
								'friend_or_other_3'=>$friend_or_otherarr[3],
								'friend_or_other_4'=>$friend_or_otherarr[4],
								'friend_or_other_5'=>$friend_or_otherarr[5],
								'friend_or_other_6'=>$friend_or_otherarr[6],
								'friend_or_other_7'=>$friend_or_otherarr[7],
								'friend_or_other_8'=>$friend_or_otherarr[8],
								'friend_or_other_9'=>$friend_or_otherarr[9],
								'friend_or_other_10'=>$friend_or_otherarr[10],
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);

				if(isset($itemData['options']['shipping']) && $itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						$orderItem['shipping_address1']=$itemData['options']['shipping_address']['address1'];
						$orderItem['shipping_address2']=$itemData['options']['shipping_address']['address2'];
						$orderItem['shipping_address3']=$itemData['options']['shipping_address']['address3'];
						$orderItem['shipping_city']=$itemData['options']['shipping_address']['city'];
						$orderItem['shipping_state']=$itemData['options']['shipping_address']['state'];
						$orderItem['shipping_country_name']=$itemData['options']['shipping_address']['country_name'];
						$orderItem['shipping_country']=$itemData['options']['shipping_address']['country'];
					}
					else
					{
						$countryData=$this->locations_model->getCountryByCode($info['country']);
						$orderItem['shipping_address1']=trim($info['address1']);
						$orderItem['shipping_address2']=trim($info['address2']);
						$orderItem['shipping_address3']=trim($info['address3']);
						$orderItem['shipping_city']=trim($info['city']);
						$orderItem['shipping_state']=trim($info['state']);
						$orderItem['shipping_country_name']=$countryData->country_name;
						$orderItem['shipping_country']=trim($info['country']);
					}
				}
			}
			else if($customData['cart_type']==2)
			{
				$max_family_members = 'All family members';
				if(isset($itemData['options']['max_family_members']) && $itemData['options']['max_family_members']>0)
				{
					$max_family_members = $itemData['options']['max_family_members'];
				}
				if(isset($itemData['options']['is_appji_donation']) && $itemData['options']['is_appji_donation']>0)
				{
					$is_from_appji = $itemData['options']['is_appji_donation'];
				}
				if(isset($itemData['options']['appji_link_token']) && $itemData['options']['appji_link_token']!='')
				{
					$link_token = $itemData['options']['appji_link_token'];
				}
				if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
				{
					$appji_member_name = $itemData['options']['appji_member_name'];
				}
				if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
				{
					$appji_member_email = $itemData['options']['appji_member_email'];
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								'price'=>$itemData['options'][$priceCol],
								'schedule_dates' =>$itemData['options']['result_date'],
								'options' =>serialize($itemData['options']),
								'sequence'=>$seq,
								'category'=>$itemData['options']['category'],
								'family_member_details'=>$itemData['options']['family_member_details'],
								'personal_note'=>$itemData['options']['personal_note'],
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'donor_id'=>$itemData['options']['donor_id'],
								'assign_pet'=>$itemData['options']['assign_pet'],
								'name_of_family_type'=>$nameoffamilytype,
								'pooja_on_teertha_swamiji'=>$pooja_on_teertha_swamiji,
								'family_members'=>$selectedfamilymembers,
								'pooja_on_swamiji'=>$pooja_on_swamiji,
								"background_color"=>$bgcolor,
								"batch_id"=>$batchId,
								"newly_attached_item"=>1,
								'max_family_members'=>$max_family_members,
								'friend_or_other_1'=>$friend_or_otherarr[1],
								'friend_or_other_2'=>$friend_or_otherarr[2],
								'friend_or_other_3'=>$friend_or_otherarr[3],
								'friend_or_other_4'=>$friend_or_otherarr[4],
								'friend_or_other_5'=>$friend_or_otherarr[5],
								'friend_or_other_6'=>$friend_or_otherarr[6],
								'friend_or_other_7'=>$friend_or_otherarr[7],
								'friend_or_other_8'=>$friend_or_otherarr[8],
								'friend_or_other_9'=>$friend_or_otherarr[9],
								'friend_or_other_10'=>$friend_or_otherarr[10],
								'is_from_appji'=>$is_from_appji,
								'link_token'=>$link_token,
								'appji_member_name'=>$appji_member_name,
								'appji_member_email'=>$appji_member_email,
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);
				if($itemData['options']['subscription']==1)
				{
					$orderItem['status']=0;
				}
			}
			else if($customData['cart_type']==3) //Store Item
			{
				$shipDomestic="shipping_domestic_".$currency;
				$shipInternational="shipping_international_".$currency;
				$shippingPrice=0;
				if($itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						if($itemData['options']['shipping_address']['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
					}
					else
                	{
                		if($info['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
                	}
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								"newly_attached_item"=>1,
								"batch_id"=>$batchId,
								"background_color"=>$bgcolor,
								'price'=>$itemData['options'][$priceCol],
								'family_member_details'=>isset($itemData['options']['family_member_details']) ? $itemData['options']['family_member_details'] : '',
								'personal_note'=>$itemData['options']['personal_note'],
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'shipping'=>$itemData['options']['shipping'],
								'shipping_price'=>$shippingPrice,
								'options' =>serialize($itemData['options']),
								'category'=>$itemData['options']['category'],
								'sequence'=>$seq,
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);
				if($itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						$orderItem['shipping_address1']=$itemData['options']['shipping_address']['address1'];
						$orderItem['shipping_address2']=$itemData['options']['shipping_address']['address2'];
						$orderItem['shipping_address3']=$itemData['options']['shipping_address']['address3'];
						$orderItem['shipping_city']=$itemData['options']['shipping_address']['city'];
						$orderItem['shipping_state']=$itemData['options']['shipping_address']['state'];
						$orderItem['shipping_country_name']=$itemData['options']['shipping_address']['country_name'];
						$orderItem['shipping_country']=$itemData['options']['shipping_address']['country'];
					}
					else
					{
						$countryData=$this->locations_model->getCountryByCode($info['country']);
						$orderItem['shipping_address1']=trim($info['address1']);
						$orderItem['shipping_address2']=trim($info['address2']);
						$orderItem['shipping_address3']=trim($info['address3']);
						$orderItem['shipping_city']=trim($info['city']);
						$orderItem['shipping_state']=trim($info['state']);
						$orderItem['shipping_country_name']=$countryData->country_name;
						$orderItem['shipping_country']=trim($info['country']);
					}
				}
				if(isset($itemData['options']['gift_friend_email']))
				{
					$orderItem['gift_friend_email']=$itemData['options']['gift_friend_email'];
				}
				if(isset($itemData['options']['gift_friend_name']))
				{
					$orderItem['gift_friend_name']=$itemData['options']['gift_friend_name'];
				}
			}
			$q=$this->db->insert('order_items',$orderItem);

			$itemId=$this->db->insert_id();

			if($customData['cart_type']==1 || $customData['cart_type']==2 || $customData['cart_type']==4)
			{
				$itemDates=array_filter(explode(",",$itemData['options']['result_date']));
				foreach($itemDates as $itemDate)
				{
					$this->db->insert("order_items_dates",
									  	array(
											  'order_id'=>$order_id,
											  'order_item_id'=>$itemId,
											  'date'=>date("Y:m:d H:i:s",strtotime($itemDate))
											  )
									);
				}
			}
			else
			{
				$orgItem=unserialize($itemData['options']['item_data']);
				$dFiles=$orgItem['files'];
				if(!empty($dFiles))
				{
					foreach ($dFiles as $fileData)
					{
						$this->db->insert("order_items_files",
											array(
													'order_item_id'=>$itemId,
													'order_id'=>$order_id,
													'filename'=>$fileData->filename,
													'title'=>$fileData->title,
													'description'=>$fileData->description,
													'size'=>$fileData->size,
													'file_id'=>$fileData->id
												)
										);
					}
				}
			}
			$item_names[] = $itemData['name'];
			$item_ids[] = $itemId;
		}

		$this->db->where("order_id",$order_id);
		$this->db->update("order_items",
							array("order_type"=>$customData['cart_type'])
						);

		//Delete cart
		$this->db->where("reference_id",$reference);
		$this->db->delete("cart_data");

		$this->sendItemsAttachedEmail($order_id,$batchId);

		if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
			{
				$user_id=$this->session->userdata('admin_data')->id;
				$username = $this->session->userdata('admin_data')->username;
			}
			else
			{
				$user_id=$this->session->userdata('user_data')->id;
				$username = $this->session->userdata('user_data')->username;
			}
		}
		if(isset($customData['cart_type']) && $customData['cart_type']==3)
		{
			$this->order_log_model->log($order_id,"Order Modified\nItems attached to order",$user_id,$username);
		}
		else
		{
			$this->order_log_model->log($order_id,"Order Modified\nItems attached to order",$user_id,$username);
		}
		$this->db->where("id",$orderData["order"]->id);
		$this->db->update("orders",array("original_total_price"=>$original_total_price));
		$item_names = implode(",", $item_names);
		$item_ids = implode(",", $item_ids);
		return array("item_names"=>$item_names,"item_ids"=>$item_ids);
	}

	public function sendRefundItemsEmail($id,$batchId,$newItems)
	{
		$orderData=$this->orderData($id,$batchId,0,1);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
			return 1;
		}
		if($orderData['order']->is_manual_payment==1)
			return 0;

		$data['orderData']=$orderData;
		$data ['donors'] = [];
      	if($orderData['order']->user_id!='')
      	{
      		$this->load->model("user/users_model");
			$sso_user_id = $this->users_model->getSSOUserID($orderData['order']->user_id);
			$this->load->model("subscriptions/donors_model");
			$data ['donors'] = $this->donors_model->getUserDonorsWithFullData($sso_user_id);
      	}
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_order_refund_details",$data,true);
		if($orderData['order']->order_type==3)
			$subject=$orderData['order']->ashram_name.' - Order Modification Details (Items Refunded) for Order ID: '.$orderData['order']->order_number;
		else
			$subject=$orderData['order']->ashram_name.' - '.$sevsOrGift.' Modification Details (Items Refunded) for - '.$sevsOrGift.' ID: '.$orderData['order']->order_number;
		$this->email_extension->sendOrdersMail(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);
		return 1;
	}

	public function orderData($id,$batchId,$newItems,$refundmail=0)
	{
		$this->db->where("id",$id);
		$q=$this->db->get("orders");
		$result['order']=$q->row();
		$result['order_items']=array();
		$result['order_items_files']=array();
		if($q->num_rows())
		{
			if(!empty($refundmail) && $refundmail == 1)
			{
				$this->db->select("*");
				$this->db->where("order_id",$id);
				$this->db->where("batch_id",$batchId);
				$this->db->from("order_items_refund_replace_logs as oi");
				$items=$this->db->get();
				$result['order_items']=$items->result();
			}
			else
			{
				$this->db->select("*,oi.id as id,oi.id as order_item_id,p.id as pet_id");
				$this->db->where("order_id",$id);
				$this->db->where("newly_attached_item",$newItems);
				$this->db->where("batch_id",$batchId);
				$this->db->from("order_items as oi");
				$this->db->join("pets as p","p.id=oi.pet_id","left");
				$items=$this->db->get();
				$result['order_items']=$items->result();
			}
			$this->db->where("order_id",$id);
			$items=$this->db->get("order_log");
			$result['order_log']=$items->result();

			$this->db->where("order_id",$id);
			$items=$this->db->get("order_items_files");
			if($items->num_rows())
			{
				$result['order_items_files']=$items->result();
				foreach ($result['order_items_files'] as $fileData)
				{
					$this->db->where("file_id",$fileData->id);
					$tempD=$this->db->get("order_items_downloads")->result();
					$result['order_items_downloads'][$fileData->id]=$tempD;
				}
			}

			$this->db->where("order_id",$id);
			$payflow_card=$this->db->get("subscription_profiles_payflow")->row();
			
			$this->db->where("order_id",$id);
			$stripe_card=$this->db->get("stripe_subscriptions_payment_details")->row();
			$result['payflow_card']=$payflow_card;
			$result['stripe_card']=$stripe_card;
		}
		return $result;
	}

	public function sendItemsAttachedEmail($orderId,$batchId)
	{
		$orderData=$this->orderData($orderId,$batchId,1);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
			return 1;
		}
		if($orderData['order']->is_manual_payment==1)
			return 0;

		$data['orderData']=$orderData;
		$data ['donors'] = [];
      	if($orderData['order']->user_id!='')
      	{
      		$this->load->model("user/users_model");
			$sso_user_id = $this->users_model->getSSOUserID($orderData['order']->user_id);
			$this->load->model("subscriptions/donors_model");
			$data ['donors'] = $this->donors_model->getUserDonorsWithFullData($sso_user_id);
      	}
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_order_modification_details",$data,true);
		if($orderData['order']->order_type==3)
			$subject=$orderData['order']->ashram_name.' - Order Modification Details (New Items Replaced) for Order ID: '.$orderData['order']->order_number;
		else
			$subject=$orderData['order']->ashram_name.' - '.$sevsOrGift.' Modification Details (New Items Replaced) for - '.$sevsOrGift.' ID: '.$orderData['order']->order_number;
		$this->email_extension->sendOrdersMail(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);
		return 1;
	}

	public function update_order_total($order_id,$updateData)
	{
		$this->db->where("id",$order_id);
		$this->db->update("orders",$updateData);
	}

	//Update Transaction if order is one time payment and not subscription Item
	public function updateoneTimeTx($refund_id,$id,$status,$note,$paymentMode,$txnid,$txData,$orderData,$txUpdateData = array())
    {
    	if(!empty($txUpdateData) && count($txUpdateData) > 0)
    	{
    		$txUpdateData = $txUpdateData;
    	}
    	else
    	{
    		$txUpdateData['refund_reference']=$refund_id;
			$txUpdateData['refund_date']=date("Y-m-d");
			$txUpdateData['refund_mode']=$paymentMode;
    	}
		$this->db->where("id",$id);
		$this->db->update("transaction",$txUpdateData);

		if(in_array(strtolower($status), ['refund','refunded']))
		{
			$tx_note=$note."\n <b>".date("d M Y h:i A")."</b> (".$status.")";
			$created_txid=$this->createOnetimeTransaction($orderData,$txData->amount,$paymentMode,$tx_note,$status,$txnid,$refund_id,0,0,$txData->created_on);
			if($created_txid && $txData->trust_id>0)
			{
				$this->db->where("id",$created_txid);
				$this->db->update("transaction",array( "trust_id"=>$txData->trust_id) );
			}
		}
		else
		{
			$this->db->where("id",$id);
			$this->db->update("transaction",array( "status"=>$status, "note"=>$note."\n <b>".date("d M Y h:i A")."</b> (".$status.")", "payment_mode"=>$paymentMode ));
		}

		foreach ($orderData['order_items'] as $item)
		{
			$this->orders_model->calculateOrderItemDue($txData->order_id,$item->id);
		}

		if($txData->is_manual_payment==0)
		{
			$this->load->model("orders/transaction_model");
			$txData=$this->transaction_model->getTransactionByID($id);
			$this->sendPaymentRefundEmail($txData->order_id,$txData);
		}

		$this->db->where("id",$txData->order_id);
		$this->db->update("orders",array("fully_refunded"=>1));

		if($txData->currency=='inr')
    	{
    		$tableName = "tx_report_inr_";
    		$monthOfCreated = date("m",strtotime($txData->created_on));
    		$yearOfCreated = date("Y",strtotime($txData->created_on));
    		if($monthOfCreated>=4)
    		{
    			$tableName .= $yearOfCreated."-".financial_year_start_month_date;
                $tableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
    		}
    		else
    		{
    			$tableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
                $tableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
    		}
    	}
    	else
    	{
    		$tableName = "tx_report_usd_".date("Y",strtotime($txData->created_on));
    	}
    	$tableName = str_replace("-","_",$tableName);
    	$reports_db=$this->load->database("reports",true,false);
    	$reports_db->where("tx",$txnid);
        $record_exist=$reports_db->get($tableName);
        if($record_exist->num_rows() > 0)
        {
        	$record_exist = $record_exist->row();
        	$reports_db->where("id",$record_exist->id);
			$reports_db->delete($tableName);
        }

		return 1;
    }

    public function getordertotalpaid($orderId)
    {
    	$this->load->model("orders/transaction_model");
		$transactions=$this->transaction_model->getTransactionsByOrder($orderId,1);
		$paidAmount=0;
		$subscriptions=0;
		$pendingNum=0;
		foreach ($transactions as $transaction)
		{
			if(in_array(strtolower($transaction->status),$this->payment_success_statuses))
			{
				if($transaction->subscription==1 && $transaction->flag==0)
				{
					if($subscriptions==0)
					{
						$paidAmount+=$transaction->amount;
						$subscriptions++;		
					}
				}
				else
					$paidAmount+=$transaction->amount;
			}
			else
			{
				if($transaction->payment_mode=='cheque' && $transaction->status!='bounced')
				{
					$paidAmount+=$transaction->amount;
					$pendingNum++;
				}
			}
		}
		return $paidAmount;
    }

    public function getordertotalrefunded($orderId)
    {
    	$refundedAmount=0;
    	$subscriptions=0;
		$q = $this->db->select("*")->from("transaction")->where("order_id",$orderId)->where_in("status",array("Refunded"))->get();
		if($q->num_rows() > 0)
		{
			$transactions = $q->result();
			foreach ($transactions as $transaction) 
			{
				if($transaction->subscription==1 && $transaction->flag==0)
				{
					if($subscriptions==0)
					{
						$refundedAmount+=$transaction->amount;
						$subscriptions++;		
					}
				}
				else
					$refundedAmount+=$transaction->amount;
			}
		}
		return $refundedAmount;
    }

    public function createManualRefundTx($refundId,$txData,$amount,$orderAmount,$orderRefundedAmount,$updateOrders=0)
    {
    	$sql = "SHOW COLUMNS FROM transaction";
		$q = $this->db->query($sql);
		$data = array();
		foreach ($q->result() as $reportrow)
		{
			if($reportrow->Field != "id")
			{
				$a = $reportrow->Field;
				$fieldValue = $txData->$a;
				$data[$reportrow->Field] = $fieldValue;
			}
		}
		$tx_refunded_amount = $txData->refunded_amount + $amount;
		$data["status"] = "Refunded";
		$data["tx"] = $refundId;
		$data["amount"] = $amount;
		$data["refund_reference"] = $txData->tx;
		$data["created_on"] = date("Y-m-d h:i:s");
		//$data["date"] = date("Y-m-d h:i:s");
		$data["refunded_amount"] = $tx_refunded_amount;
		if(!empty($this->input->post("tx_note")))
			$data["note"] = $this->input->post("tx_note");
		else
			$data["note"] = "Partially refunded transaction amount: ".$amount."<br>Reference TX ID: ".$txData->tx."<br>Refunded on: ".date("d M Y h:i A");

		$this->db->insert("transaction",$data);
		$id = $this->db->insert_id();
		$this->db->where("id",$id);
		$this->db->update("transaction", array(
										"payment_mode"=>$this->input->post("payment_mode"),
										"is_manual_payment"=>empty($this->input->post("is_manual_payment"))?0:$this->input->post("is_manual_payment"),
										"is_foreign_payment"=>empty($this->input->post("is_foreign_payment"))?0:$this->input->post("is_foreign_payment"),
										"manual_receipt_number"=>empty($this->input->post("manual_receipt_number"))?null:$this->input->post("manual_receipt_number"),
										"manual_receipt_date"=>empty($this->input->post("manual_receipt_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("manual_receipt_date"))),
										"offline_number"=>empty($this->input->post("offline_number"))?null:$this->input->post("offline_number"),
										"offline_bank"=>empty($this->input->post("offline_bank"))?null:$this->input->post("offline_bank"),
										"offline_date"=>empty($this->input->post("offline_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("offline_date"))),
										"foreign_currency"=>empty($this->input->post("foreign_currency"))?0:$this->input->post("foreign_currency"),
										"foreign_amount"=>empty($this->input->post("foreign_amount"))?0:$this->input->post("foreign_amount"),
										"realized_amount"=>empty($this->input->post("realized_amount"))?0:$this->input->post("realized_amount"),
										"order_item_id"=>$txData->order_item_id?$txData->order_item_id:0
									));

		if($updateOrders == 1)
		{
			$totalPrice = $orderAmount - $amount;
			$refundedAmount = $orderRefundedAmount+$amount;

			$this->db->where("id",$txData->order_id);
			$this->db->update("orders",array("partially_refunded"=>1,"total_price"=>$totalPrice,"total_refunded_amount"=>$refundedAmount));
		}
		if($txData->currency=='inr')
    	{
    		$tableName = "tx_report_inr_";
    		$monthOfCreated = date("m",strtotime($txData->created_on));
    		$yearOfCreated = date("Y",strtotime($txData->created_on));
    		if($monthOfCreated>=4)
    		{
    			$tableName .= $yearOfCreated."-".financial_year_start_month_date;
                $tableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
    		}
    		else
    		{
    			$tableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
                $tableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
    		}
    	}
    	else
    	{
    		$tableName = "tx_report_usd_".date("Y",strtotime($txData->created_on));
    	}
    	$tableName = str_replace("-","_",$tableName);
    	$this->orders_model->createNewTransactionReportTable($tableName);

    	$reports_db=$this->load->database("reports",true,false);
    	$reports_db->where("tx",$txData->tx);
        $record_exist=$reports_db->get($tableName);
        if($record_exist->num_rows() > 0)
        {
        	$record_exist = $record_exist->row();
        	$r_totalPrice = $record_exist->amount - $amount;
        	$reports_db->where("id",$record_exist->id);
			$reports_db->update($tableName,array("amount"=>$r_totalPrice));
        }
    }

    public function createRefundTx($refundId,$txData,$amount,$orderAmount,$orderRefundedAmount,$updateOrders=0)
    {
    	$sql = "SHOW COLUMNS FROM transaction";
		$q = $this->db->query($sql);
		$data = array();
		foreach ($q->result() as $reportrow)
		{
			if($reportrow->Field != "id")
			{
				$a = $reportrow->Field;
				$fieldValue = $txData->$a;
				$data[$reportrow->Field] = $fieldValue;
			}
		}
		$tx_refunded_amount = $txData->refunded_amount + $amount;
		$data["status"] = "Refunded";
		$data["tx"] = $refundId;
		$data["amount"] = $amount;
		$data["refund_reference"] = $txData->tx;
		$data["created_on"] = date("Y-m-d h:i:s");
		//$data["date"] = date("Y-m-d h:i:s");
		$data["refunded_amount"] = $tx_refunded_amount;
		$data["note"] = "Partially refunded transaction amount: ".$amount."<br>Reference TX ID: ".$txData->tx."<br>Refunded on: ".date("d M Y h:i A");

		$this->db->insert("transaction",$data);
		$id = $this->db->insert_id();

		if(!empty($this->input->post("tx_status")))
		{
			$this->db->where("id",$id);
			$this->db->update("transaction", array(
										"payment_mode"=>$this->input->post("payment_mode"),
										"is_manual_payment"=>empty($this->input->post("is_manual_payment"))?0:$this->input->post("is_manual_payment"),
										"is_foreign_payment"=>empty($this->input->post("is_foreign_payment"))?0:$this->input->post("is_foreign_payment"),
										"manual_receipt_number"=>empty($this->input->post("manual_receipt_number"))?null:$this->input->post("manual_receipt_number"),
										"manual_receipt_date"=>empty($this->input->post("manual_receipt_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("manual_receipt_date"))),
										"offline_number"=>empty($this->input->post("offline_number"))?null:$this->input->post("offline_number"),
										"offline_bank"=>empty($this->input->post("offline_bank"))?null:$this->input->post("offline_bank"),
										"offline_date"=>empty($this->input->post("offline_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("offline_date"))),
										"foreign_currency"=>empty($this->input->post("foreign_currency"))?0:$this->input->post("foreign_currency"),
										"foreign_amount"=>empty($this->input->post("foreign_amount"))?0:$this->input->post("foreign_amount"),
										"realized_amount"=>empty($this->input->post("realized_amount"))?0:$this->input->post("realized_amount"),
										"order_item_id"=>$txData->order_item_id?$txData->order_item_id:0
									));
		}
		if($updateOrders == 1)
		{
			$totalPrice = $orderAmount - $amount;
			$refundedAmount = $orderRefundedAmount+$amount;

			$this->db->where("id",$txData->order_id);
			$this->db->update("orders",array("partially_refunded"=>1,"total_price"=>$totalPrice,"total_refunded_amount"=>$refundedAmount));
		}
		if($txData->currency=='inr')
    	{
    		$tableName = "tx_report_inr_";
    		$monthOfCreated = date("m",strtotime($txData->created_on));
    		$yearOfCreated = date("Y",strtotime($txData->created_on));
    		if($monthOfCreated>=4)
    		{
    			$tableName .= $yearOfCreated."-".financial_year_start_month_date;
                $tableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
    		}
    		else
    		{
    			$tableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
                $tableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
    		}
    	}
    	else
    	{
    		$tableName = "tx_report_usd_".date("Y",strtotime($txData->created_on));
    	}
    	$tableName = str_replace("-","_",$tableName);
    	$this->orders_model->createNewTransactionReportTable($tableName);

    	$reports_db=$this->load->database("reports",true,false);
    	$reports_db->where("tx",$txData->tx);
        $record_exist=$reports_db->get($tableName);
        if($record_exist->num_rows() > 0)
        {
        	$record_exist = $record_exist->row();
        	$r_totalPrice = $record_exist->amount - $amount;
        	$reports_db->where("id",$record_exist->id);
			$reports_db->update($tableName,array("amount"=>$r_totalPrice));
        }
    }

    public function createSystemTx($refundId,$txData,$amount,$status)
    {
    	$sql = "SHOW COLUMNS FROM transaction";
		$q = $this->db->query($sql);
		$data = array();
		foreach ($q->result() as $reportrow)
		{
			if($reportrow->Field != "id")
			{
				$a = $reportrow->Field;
				$fieldValue = $txData->$a;
				$data[$reportrow->Field] = $fieldValue;
			}
		}
		$data["status"] = $status;
		$data["tx"] = $refundId;
		$data["system_generated"] = 1;
		$data["amount"] = $amount;
		$data["refund_reference"] = $txData->tx;
		$data["payment_mode"] = "system";
		$data["created_on"] = date("Y-m-d h:i:s");
		if($status == "paid")
		{
			$data["note"] = "Paid transaction amount: ".$amount."<br>Reference TX ID: ".$txData->tx."<br>Charged on: ".date("d M Y h:i A");
		}
		else
		{
			$data["note"] = "Partially refunded transaction amount: ".$amount."<br>Reference TX ID: ".$txData->tx."<br>Refunded on: ".date("d M Y h:i A");
		}

		$this->db->insert("transaction",$data);
    }

    public function getOrderOriginalTX($orderId)
    {
    	$q = $this->db->select("*")->from("transaction")->where("order_id",$orderId)->where_in("status",array("completed",'success','release payment','Release Payment','approved','captured','cash_pending','paid'))->order_by("id","asc")->limit(1)->get();
		if($q->num_rows() > 0)
		{
			$transactions = $q->row();
			return $transactions;
		}
    }

    public function remove_order_items_dates($order_item_id,$date)
    {
    	$date = date("Y-m-d",strtotime($date));
    	$this->db->where("order_item_id",$order_item_id);
    	$this->db->where("date",$date);
		$this->db->delete("order_items_dates");
    }

    public function update_order_item_flags($fully_refunded,$refunded_amount,$order_item_id,$final_dates,$batchId,$item_replaced,$updatedQuantity,$backgroundcolor)
    {
    	$updateData = array("fully_refunded"=>$fully_refunded,"item_modified"=>1,"refunded_amount"=>$refunded_amount,"batch_id"=>$batchId,"newly_attached_item"=>0);
    	if(!empty($final_dates))
    		$updateData["schedule_dates"] = $final_dates;
    	else
    		$updateData["schedule_dates"] = "";

    	if($fully_refunded == 1)
    		$updateData["status"] = 0;

    	if($item_replaced == 1)
    		$updateData["item_replaced"] = 1;

    	$updateData["updated_quantity"] = $updatedQuantity;
    	$updateData["background_color"] = $backgroundcolor;

    	$this->db->where("id",$order_item_id);
		$this->db->update("order_items",$updateData);
    }

    public function order_items_dates_log($data)
    {
    	$this->db->insert("order_items_dates_log",$data);
    }

    public function order_items_refund_replace_logs($data)
    {
    	$this->db->insert("order_items_refund_replace_logs",$data);
    }

    public function updatesubscriptionMap($tx,$refund_id,$order_id,$order_item_id)
    {
    	$lastpaymentId = $this->db->select('id,payment_number')->from('subscription_payments')->where(array('order_item_id'=>$order_item_id,'order_id'=>$order_id,'status'=>103,'tx'=>$refund_id,"order_id"=>$order_id))->get();
        if($lastpaymentId->num_rows() > 0)
        {
            $resdata = $lastpaymentId;
            $lastpayId=$resdata->result()[0]->id;
        }
    	$mapData = array('subscription_payment_id'=>$lastpayId,'created'=>date('Y-m-d H:i:s'),'tx'=>$refund_id);
        $this->db->insert("subscription_payments_transaction_map",$mapData);
    }

    //Update Transaction if order is one time payment and for subscription Item
    public function updateSubscriptionTx($refund_id,$paymentStatus,$note,$paymentMode,$txnid,$txData,$orderData,$txUpdateData = array())
	{
		$payment=$this->getSubscriptionPaymentId($txnid);
		$success_flag = 0;
		if($paymentStatus=='refund')
		{
			$ref_ref = !empty($txUpdateData['refund_reference'])?$txUpdateData['refund_reference']:$refund_id;
			$updateData['status']=103;
			$updateData['tx']=$ref_ref;
			$updateData['date']=date("Y-m-d H:i:s");
			$this->db->where("id",$payment->id);
			$this->db->where("status",8);
			$this->db->where("tx",$txnid);
			$this->db->update("subscription_payments",$updateData);
			$success_flag = 1;
		}
		if($success_flag == 1)
		{

			$this->updatesubscriptionMap($txnid,$refund_id,$payment->order_id,$payment->order_item_id);

			$tx_note=$note."\n <b>".date("d M Y h:i A")."</b> (".$paymentStatus.")";
			$created_txid=$this->createTransaction($orderData,$txData->amount,$paymentMode,$tx_note,$paymentStatus,$payment->tx,$txUpdateData,$refund_id,$payment->order_item_id,$payment->payment_number,$txData->created_on);


			$refund_mode = "Online";
			if(!empty($txUpdateData) && count($txUpdateData) > 0)
	    	{
	    		$refund_mode = "Offline";
	    	}
			$this->updateRefundsHistory($payment->tx,array("transaction_id"=>$created_txid,"payment_source"=>$refund_mode));
			foreach ($orderData['order_items'] as $item)
			{
				$this->orders_model->calculateOrderItemDue($item->order_id,$item->id);
			}

			if($txData->is_manual_payment==0)
			{
				$txData=$this->getTransactionById($created_txid);
				$this->sendSubscriptionPaymentRefundEmail($payment->order_id,$payment->order_item_id,$txData,$payment->id);
			}

			if($txData->currency=='inr')
	    	{
	    		$tableName = "tx_report_inr_";
	    		$monthOfCreated = date("m",strtotime($txData->created_on));
	    		$yearOfCreated = date("Y",strtotime($txData->created_on));
	    		if($monthOfCreated>=4)
	    		{
	    			$tableName .= $yearOfCreated."-".financial_year_start_month_date;
	                $tableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
	    		}
	    		else
	    		{
	    			$tableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
	                $tableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
	    		}
	    	}
	    	else
	    	{
	    		$tableName = "tx_report_usd_".date("Y",strtotime($txData->created_on));
	    	}

	    	$tableName = str_replace("-","_",$tableName);
        	$this->orders_model->createNewTransactionReportTable($tableName);

	    	$reports_db=$this->load->database("reports",true,false);
	    	$reports_db->where("tx",$txData->tx);
	        $record_exist=$reports_db->get($tableName);
	        if($record_exist->num_rows() > 0)
	        {
	        	$record_exist = $record_exist->row();
	        	$this->db->where("id",$record_exist->id);
				$this->db->delete($tableName);
	        }

			return 1;
		}
	}

	public function sendPaymentRefundEmail($orderId,$txData)
	{
		$orderData=$this->orders_model->orderData($orderId);
		if(empty($orderId) || empty($txData))
		{
			return 0;
		}
		
		$data['orderData']=$orderData;
		$data['txData']=$txData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_payment_refund_status",$data,true);
		$subject=$orderData['order']->ashram_name.' - Transaction update for '.$orderData['order']->order_number." has been Refunded";
		$this->email_extension->sendMailGuest(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1);

		$this->load->library("sms");
		$message=
				display_site_name."\n".
				"Payment update:\n".
				"Seva ID: ".$orderData['order']->order_number."\n".
				"Refund Date: ".date("d M Y",strtotime($txData->refund_date))."\n".
				"Amount: ".strtoupper($txData->currency). " " .$txData->amount."\n".
				"Payment Mode: ".ucfirst($txData->refund_mode)."\n".
				"Tx: ".$txData->refund_reference."\n".
				"Tx Status: Refunded"."\n".
				""
				;
		$this->sms->sendSMS(
								'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
								$data['countryData']->isd_code.$orderData['order']->phone,
								$message,
								1,
								$orderData['order']->user_id,
								$orderData['order']->username,
								$data['countryData']->isd_code
							);
		return 1;
	}

	public function getRemovedItemDates($item_id)
	{
		$q = $this->db->select("original_dates")->from("order_items_refund_replace_logs")->where("order_item_id",$item_id)->get();
		if($q->num_rows() > 0)
		{
			$r = $q->result_array();
			$val_array = array();
			foreach ($r as $key => $value) 
			{
				$val_array[] = $value["original_dates"];
			}
			$val_string = implode(",", $val_array);
			return $val_string;
		}
		return false;
	}

	public function sendSubscriptionPaymentRefundEmail($orderId,$order_item_id,$txData,$payment_id)
	{
		$orderData=$this->orders_model->orderData($orderId);
		if(empty($orderId) || empty($txData))
		{
			return 0;
		}
		
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		$paymentData=$this->subscription_payments_model->getById($payment_id);
		if(empty($paymentData) || $paymentData->order_id!=$orderId || $paymentData->order_item_id!=$order_item_id)
		{
			return 0;
		}

		$data['orderData']=$orderData;
		$data['txData']=$txData;
		$data['itemData']=$orderItem;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_subscription_payment_refund_status",$data,true);
		$subject=$subject=$orderData['order']->ashram_name.' - Payment Notification - Subscription payment for '.$orderItem->item_name;
		$this->email_extension->sendMailGuest(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1);

		$this->load->library("sms");
		$message=
				display_site_name."\n".
				"Payment update:\n".
				"Subscription: ".$orderItem->item_name."\n".
				"Seva ID: ".$orderData['order']->order_number."\n".
				"Refund Date: ".date("d M Y",strtotime($txData->refund_date))."\n".
				"Amount: ".strtoupper($txData->currency). " " .$txData->amount."\n".
				"Payment Mode: ".ucfirst($txData->refund_mode)."\n".
				"Tx: ".$txData->refund_reference."\n".
				"Tx Status: Refunded"."\n".
				""
				;
		$this->sms->sendSMS(
								'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
								$data['countryData']->isd_code.$orderData['order']->phone,
								$message,
								1,
								$orderData['order']->user_id,
								$orderData['order']->username,
								$data['countryData']->isd_code
							);
		return 1;
	}

	//Create Transaction as a new record if tx is subscription payment
	public function createTransaction($orderData,$amount,$payment_mode,$note='',$payment_status,$txnid,$txUpdateData,$refund_id,$order_item_id=0,$payment_number=0,$trans_date)
    {
    	$ref_ref = !empty($txUpdateData['refund_reference'])?$txUpdateData['refund_reference']:$refund_id;
		$ref_date = !empty($txUpdateData['refund_date'])?date("Y-m-d",strtotime($txUpdateData['refund_date'])):date("Y-m-d");
		$ref_mode = !empty($txUpdateData['refund_mode'])?$txUpdateData['refund_mode']:$payment_mode;
    	$countryData=$this->locations_model->getCountryByCode($orderData['order']->country);

    	if(isset($_SERVER['REMOTE_ADDR']))
    		$remote_addr=$_SERVER['REMOTE_ADDR'];
    	else
    		$remote_addr="127.0.0.1";

    	$q=$this->db->insert('transaction',
					              array(
					              	'started_on' => date("Y:m:d H:i:s"),
					              	// 'date' => $trans_date,
					                'tx' =>  $ref_ref,
					                'userid' =>$orderData['order']->user_id,
					                'status'=>$payment_status,
					                't_status'=>2,
									'order_id'=>$orderData['order']->id,
									'amount'=>$amount,
									'payment_mode'=>$payment_mode,
									'currency'=>$orderData['order']->currency,
									'created_on'=>date("Y:m:d H:i:s"),
									'ashram_id'=>$orderData['order']->ashram_id,
									'firstname'=>$orderData['order']->firstname,
									'lastname'=>$orderData['order']->lastname,
									'city'=>$orderData['order']->city,
									'state'=>$orderData['order']->state,
									'country'=>$orderData['order']->country,
									'email'=>$orderData['order']->email,
									'phone'=>$orderData['order']->phone,
									'country_isd_code'=>$countryData->isd_code,
									'note'=>$note,
									"order_item_id"=>$order_item_id,
									"payment_number"=>$payment_number,
									'subscription'=>1,
									'ip_address'=>$remote_addr,
									'refund_reference'=>$txnid,
									'refund_date'=>$ref_date,
									'refund_mode'=>$ref_mode
					            )
              				);
    	return $this->db->insert_id();
    }

    //Create Transaction as a new record if tx is onetime payment
	public function createOnetimeTransaction($orderData,$amount,$payment_mode,$note='',$payment_status,$txnid,$refund_id,$order_item_id=0,$payment_number=0,$trans_date)
    {
    	$ref_ref = !empty($txUpdateData['refund_reference'])?$txUpdateData['refund_reference']:$refund_id;
		$ref_date = !empty($txUpdateData['refund_date'])?date("Y-m-d",strtotime($txUpdateData['refund_date'])):date("Y-m-d");
		$ref_mode = !empty($txUpdateData['refund_mode'])?$txUpdateData['refund_mode']:$payment_mode;
    	$countryData=$this->locations_model->getCountryByCode($orderData['order']->country);

    	if(isset($_SERVER['REMOTE_ADDR']))
    		$remote_addr=$_SERVER['REMOTE_ADDR'];
    	else
    		$remote_addr="127.0.0.1";

    	$q=$this->db->insert('transaction',
					              array(
					              	'started_on' => date("Y:m:d H:i:s"),
					                'tx' =>  $ref_ref,
					                'userid' =>$orderData['order']->user_id,
					                'status'=>$payment_status,
					                't_status'=>2,
									'order_id'=>$orderData['order']->id,
									'amount'=>$amount,
									'payment_mode'=>$payment_mode,
									'currency'=>$orderData['order']->currency,
									'created_on'=>date("Y:m:d H:i:s"),
									'ashram_id'=>$orderData['order']->ashram_id,
									'firstname'=>$orderData['order']->firstname,
									'lastname'=>$orderData['order']->lastname,
									'city'=>$orderData['order']->city,
									'state'=>$orderData['order']->state,
									'country'=>$orderData['order']->country,
									'email'=>$orderData['order']->email,
									'phone'=>$orderData['order']->phone,
									'country_isd_code'=>$countryData->isd_code,
									'note'=>$note,
									"order_item_id"=>$order_item_id,
									"payment_number"=>$payment_number,
									'subscription'=>0,
									'ip_address'=>$remote_addr,
									'refund_reference'=>$txnid,
									'refund_date'=>$ref_date,
									'refund_mode'=>$ref_mode,
									'tx_username' =>$orderData['order']->username,
					                'tx_pan_number' =>$orderData['order']->order_pan_number,
					                'tx_aadhaar_number' =>$orderData['order']->order_aadhaar_number,
					                'tx_tin_number' =>$orderData['order']->order_tin_number,
					                'tx_passport_number' =>$orderData['order']->order_passport_number,
					                'tx_voter_epic_number' =>$orderData['order']->order_voter_epic_number,
					                'tx_driving_license_number' =>$orderData['order']->order_driving_license_number,
					                'tx_ration_card_number' =>$orderData['order']->order_ration_card_number,
					                'tx_order_type'=>$orderData['order']->order_type,
									'tx_order_date'=>date('Y-m-d', strtotime($orderData['order']->date)),
									'tx_order_number'=>$orderData['order']->order_number,
									'address1'=>$orderData['order']->address1,
									'address2'=>$orderData['order']->address2,
									'address3'=>$orderData['order']->address3,
									'zipcode'=>$orderData['order']->zipcode,
									'refunded_amount'=>$amount,
					            )
              				);
    	return $this->db->insert_id();
    }

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->excelReportRefundReplaceLogs($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refund ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refund Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refund Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refund Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refund Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$trans_status=0;
			if(preg_grep('/'.$reportrow->payment_status.'/i', array('failure','aborted','failed','user cancelled')))
				$trans_status=0;

			if(preg_grep('/'.$reportrow->payment_status.'/i', array('completed','approved','success')))
				$trans_status=1;

			if(in_array($reportrow->payment_status,array('initiated')))
				$trans_status=2;

			$alpha="A";
			$txnote = "";
			if($reportrow->note != "")
			{
				$txnote = strip_tags($reportrow->note);
			}
			$refund_status = "Refund Failed";
			if($reportrow->refund_success_flag == 1)
			{
				$refund_status = "Refund Success";
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->tx);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refund_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refund_date);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_source);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$refund_status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->started_on)));
			$emailalpha=$alpha++;
			$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			$objPHPExcel->getActiveSheet()->SetCellValue($emailalpha.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->getStyle($emailalpha.$i)->applyFromArray($styleArray);
			$phonealpha=$alpha++;
			$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			$objPHPExcel->getActiveSheet()->SetCellValue($phonealpha.$i,"+".$reportrow->country_isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->getStyle($phonealpha.$i)->applyFromArray($styleArray);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
			$amountalpha=$alpha++;

			if($reportrow->currency=='usd')
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			}
			else
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($amountalpha.$i,strtoupper($reportrow->currency)." ".$reportrow->amount);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$txnote);
			$objPHPExcel->getActiveSheet()->getStyle($amountalpha.$i)->applyFromArray($styleArray);
			


			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function excelReportRefundReplaceLogs($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Batch ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refund / Replace");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Replaced Items");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Removed Dates");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Currency");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refund TX ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Reference TX");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created On");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$cart_type = "Poojas";
			if($reportrow->cart_type == 1)
			{
				$cart_type = "Poojas";
			}
			if($reportrow->cart_type == 2)
			{
				$cart_type = "Donations";
			}
			if($reportrow->cart_type == 3)
			{
				$cart_type = "Store";
			}
			if($reportrow->cart_type == 4)
			{
				$cart_type = "Subscriptions";
			}
			$refund_status = "Refunded";
			if($reportrow->refund_flag == 1 && $reportrow->replace_flag == 0)
			{
				$refund_status = "Refunded";
			}
			if($reportrow->refund_flag == 1 && $reportrow->replace_flag == 1)
			{
				$refund_status = "Refunded and Replaced";
			}
			if($reportrow->refund_flag == 0 && $reportrow->replace_flag == 1)
			{
				$refund_status = "Replaced";
			}
			$original_items_names = "N/A";
			if(!empty($reportrow->original_items_names))
			{
				$original_items_names = $reportrow->original_items_names;
			}
			$replaced_items_names = "N/A";
			if(!empty($reportrow->replaced_items_names))
			{
				$replaced_items_names = $reportrow->replaced_items_names;
			}
			$original_transaction_id = "N/A";
			if(!empty($reportrow->original_transaction_id))
			{
				$original_transaction_id = $reportrow->original_transaction_id;
			}
			$refund_id = "N/A";
			if(!empty($reportrow->refund_id))
			{
				$refund_id = $reportrow->refund_id;
			}
			$alpha="A";
			$txnote = "";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$cart_type);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->batch_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$original_items_names);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$refund_status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$replaced_items_names);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->original_dates);
			if($reportrow->currency=='usd')
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			}
			else
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->amount);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$original_transaction_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$refund_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function getTransactionById($id='')
    {
		$this->db->where("id",$id);
		$transaction=$this->db->get("transaction");
		return $transaction->row();
    }
}