<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH. '/third_party/razorpay/Razorpay.php';
use Razorpay\Api\Api;
class Razorpay_webhook_model extends CI_Model 
{

    /**
     * @name string TABLE_NAME Holds the name of the table in use by this model
     */
    var $year_table = "";
    var $archivesDb = "";
    var $tableName="";
    public function __construct()
    {
        parent::__construct();
        $this->year_table = date("Y");
        $this->tableName = 'razorpay_webhook_'.$this->year_table;
        $this->archivesDb = $this->load->database("data_archives",true,false);
        if ($this->archivesDb->table_exists($this->tableName) )
        {

        }
        else
        {
            // table does not exist
            $new_table = "CREATE TABLE IF NOT EXISTS `".$this->tableName."` (
                      `id` int(11) NOT NULL AUTO_INCREMENT,
                      `transaction_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `customer_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `email` varchar(150) CHARACTER SET utf8mb4 DEFAULT NULL,
                      `phone` varchar(20) CHARACTER SET utf8mb4 DEFAULT NULL,
                      `subscription_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `data` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `amount` FLOAT COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `currency` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `paid_count` int(4) DEFAULT NULL,
                      `plan_id` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `created_on` datetime NOT NULL,
                      `event_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `capture_flag` INT(2) NOT NULL DEFAULT '1',
                      `order_id` INT(11) NOT NULL DEFAULT '0',
                      PRIMARY KEY (`id`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
            $this->archivesDb->query($new_table);
        }
    }
    /**
     * @name string PRI_INDEX Holds the name of the tables' primary index used in this model
     */
    const PRI_INDEX = 'id';

    /**
     * Retrieves record(s) from the database
     *
     * @param mixed $where Optional. Retrieves only the records matching given criteria, or all records if not given.
     *                      If associative array is given, it should fit field_name=>value pattern.
     *                      If string, value will be used to match against PRI_INDEX
     * @return mixed Single record if ID is given, or array of results
     */
    public function get($where = NULL) 
    {
        $this->archivesDb->select('*');
        $this->archivesDb->from($this->tableName);
        $this->archivesDb->where('id', $where);
        $result = $this->archivesDb->get()->result();
        if ($result) 
        {
            return $result;
        }
        else 
        {
            return false;
        }
    }

    public function updatesubscriptions($paymentnumber,$tx,$item_order_id,$item_id,$amount,$currency,$subscription_id,$stripearray)
    {
        $this->load->model('payment_model');
        $this->load->model('locations_model');
        $this->load->model('orders/orders_model');
        
        $this->db->select("*,oi.id as id");
        $this->db->from("order_items as oi");
        $this->db->join("orders as o","o.id=oi.order_id");
        $this->db->where("subscription",1);
        $this->db->where('oi.id',$item_order_id);
        $items=$this->db->get()->result();
        foreach ($items as $orderItem)
        {
            if(!$tx)
            $tx = "rzp".date("YmdHisu");

            $db_debug = $this->db->db_debug;
            $this->db->db_debug = false;
            
            $insertData=array(
                "order_id"=>$orderItem->order_id,
                "order_item_id"=>$orderItem->id,
                "profile_id"=>$subscription_id,
                "date"=>date("Y-m-d H:i:s"),
                "tx"=>$tx,
                "payment_mode"=>"razorpay",
                "amount"=>abs($amount),
                "status"=>8,
                "payment_number"=>$paymentnumber,
            );

            $this->db->where(array('payment_number'=>$paymentnumber,'order_item_id'=>$orderItem->id,'order_id'=>$orderItem->order_id));
            $this->db->update('subscription_payments',$insertData);
            $paymentId = "";
            $lastpaymentId = $this->db->select('id')->from('subscription_payments')->where(array('payment_number'=>$paymentnumber,'order_item_id'=>$orderItem->id,'order_id'=>$orderItem->order_id))->get();
            if($lastpaymentId->num_rows() > 0)
            {
                $lastpaymentIds = $lastpaymentId->result()[0]->id;
                $paymentId=$lastpaymentIds;
            }
            $mapData = array('tx'=>$tx,'subscription_payment_id'=>$paymentId,'created'=>date('Y-m-d H:i:s'));
            $this->db->insert("subscription_payments_transaction_map",$mapData);
            $this->db->db_debug = true;
            $tData = $this->payment_model->createTransaction($tx,$orderItem->user_id,'','paid',null,$orderItem->order_id);
            $this->payment_model->updateOrderTotalPaid($orderItem->order_id,$amount,$tx);
            $this->payment_model->populateTransactionReport($tx);
            $countryData=$this->locations_model->getCountryByCode($orderItem->country);
            $updateTxArray= array(
                "t_status"=>1,
                //'data'=>serialize($stripearray),
                'modified_on'=>date("Y:m:d H:i:s"),
                "order_item_id"=>$orderItem->id,
                'amount'=>abs($amount),
                'currency'=>$currency,
                'payment_mode'=>'razorpay',
                'created_on'=>date("Y-m-d H:i:s"),
                'note'=>"Payment for ".$orderItem->item_name,
                "payment_number"=>$paymentnumber,
                "ashram_id"=>$orderItem->ashram_id,
                'firstname'=>$orderItem->firstname,
                'lastname'=>$orderItem->lastname,
                'city'=>$orderItem->city,
                'state'=>$orderItem->state,
                'country'=>$orderItem->country,
                'email'=>$orderItem->email,
                'phone'=>$orderItem->phone,
                'country_isd_code'=>$countryData->isd_code,
                'subscription'=>1
            );
            $tData = array_merge($tData,$updateTxArray);
            //saving transaction table 
			$this->payment_model->saveTransaction($tData);
            //saving payment response into archives database
			$this->payment_model->savingPaymentResponse($tx,$stripearray,$orderItem->user_id,"razorpay",$orderItem->order_id);

            if(($tx != "") && ($amount > 0))
            {
                $this->payment_model->updateOrderItemRows($orderItem->order_id,$amount,$tx);
            }

            $this->order_log_model->log($orderItem->order_id,"Subscription \"".$orderItem->item_name."\" Amount paid for Payment# ".$paymentnumber.", Tx ID: ".$tx);

            $this->orders_model->sendTransactionReceiptEmail($orderItem->order_id,$tx);
            $this->orders_model->sendSubscriptionPaymentEmail($orderItem->order_id,$orderItem->id,$paymentId,0);
            $this->orders_model->sendSubscriptionPaymentEmailBCC($orderItem->order_id,$orderItem->id,$paymentId);
        }
    }

    public function subscriptionCancelledHookEvent($subscription_id)
    {
        $this->archivesDb->where('razorpay_subscription_id',$subscription_id);
        $this->archivesDb->update('razorpay_subscriptions',array('status'=>'Canceled','canceled_on'=>date('Y-m-d')));
    }

    public function updatefailedsubscriptions($paymentnumber,$tx,$item_order_id,$item_id,$amount,$currency,$subscription_id,$stripearray,$attempts)
    {
        $this->load->model('payment_model');
        $this->load->model('orders/orders_model');
        
        $this->db->select("*,oi.id as id");
        $this->db->from("order_items as oi");
        $this->db->join("orders as o","o.id=oi.order_id");
        $this->db->where("subscription",1);
        $this->db->where('oi.id',$item_order_id);
        $items=$this->db->get()->result();
        foreach ($items as $orderItem)
        {
            if(!$tx)
            $tx = "rzp".date("YmdHisu");

            $db_debug = $this->db->db_debug;
            $this->db->db_debug = false;
            
            $insertData=array(
                "order_id"=>$orderItem->order_id,
                "order_item_id"=>$orderItem->id,
                "profile_id"=>$subscription_id,
                "date"=>date("Y-m-d H:i:s"),
                'payment_mode'=>'razorpay',
                "retry_status"=>$attempts,
                "status"=>1,
                "payment_number"=>$paymentnumber,
            );

            $this->db->where(array('payment_number'=>$paymentnumber,'order_item_id'=>$orderItem->id,'order_id'=>$orderItem->order_id));
            $this->db->update('subscription_payments',$insertData);
            $this->db->db_debug = true;
        }
    }

    public function paymentFail($tx,$subscription_id,$order_item_id,$order_id,$amount,$currency,$razorpayarray,$payment_date)
    {
        $this->load->model('locations_model');
        $this->db->select('id,payment_number')->from('subscription_payments')->where(array('order_item_id'=>$order_item_id,'order_id'=>$order_id,"payment_date"=>$payment_date));
        $this->db->group_start();
        $this->db->where("status",1);
        $this->db->or_where("status",0);
        $this->db->group_end();
        $this->db->order_by('id','asc');
        $lastpaymentId = $this->db->get();
        if($lastpaymentId->num_rows() > 0)
        {
            $resdata = $lastpaymentId;
            $lastpayId=$resdata->result()[0]->id;
            $paynum=$resdata->result()[0]->payment_number;
            $mapData = array('subscription_payment_id'=>$lastpayId,'created'=>date('Y-m-d H:i:s'),'tx'=>$tx);
            $this->db->insert("subscription_payments_transaction_map",$mapData);

        }
        if($lastpayId)
        {
            $this->db->select("*,oi.id as id");
            $this->db->from("order_items as oi");
            $this->db->join("orders as o","o.id=oi.order_id");
            $this->db->where("subscription",1);
            $this->db->where('oi.id',$order_item_id);
            $items=$this->db->get()->result();
            foreach ($items as $orderItem)
            {

                $db_debug = $this->db->db_debug;
                $this->db->db_debug = false;
                
                $this->updatetxsub($lastpayId,$tx,$amount,$subscription_id);

                $tData = $this->payment_model->createTransaction($tx,$orderItem->user_id,'','failure',null,$orderItem->order_id);
                $countryData=$this->locations_model->getCountryByCode($orderItem->country);
                $updateTxArray= array(
                    "order_item_id"=>$orderItem->id,
                    "t_status"=>2,
                    //'data'=>serialize($razorpayarray),
                    'modified_on'=>date("Y:m:d H:i:s"),
                    'amount'=>abs($amount),
                    'currency'=>$currency,
                    'payment_mode'=>'razorpay',
                    'firstname'=>$orderItem->firstname,
                    'lastname'=>$orderItem->lastname,
                    'city'=>$orderItem->city,
                    'state'=>$orderItem->state,
                    'country'=>$orderItem->country,
                    'email'=>$orderItem->email,
                    'phone'=>$orderItem->phone,
                    'country_isd_code'=>$countryData->isd_code,
                    'created_on'=>date("Y-m-d H:i:s"),
                    'note'=>"Payment for ".$orderItem->item_name." Failed from razorpay Gateway",
                    "payment_number"=>$paynum,
                    "ashram_id"=>$orderItem->ashram_id,
                    'subscription'=>1
                );
                $tData = array_merge($tData,$updateTxArray);
                //$this->payment_model->updateTx($tx,$updateTxArray);
                 //saving transaction table 
			    $this->payment_model->saveTransaction($tData);
                //saving payment response into archives database
			    $this->payment_model->savingPaymentResponse($tx,$razorpayarray,$orderItem->user_id,"razorpay",$orderItem->order_id);
                $this->db->db_debug = true;

                $this->order_log_model->log($orderItem->order_id,"Subscription \"".$orderItem->item_name."\" Failed from razorpay Gateway for Payment# ".$paynum." , Tx ID: ".$tx);
                $this->orders_model->sendSubscriptionPaymentFailEmail($orderItem->order_id,$orderItem->id,$lastpayId,$tx);
                $this->orders_model->sendSubscriptionPaymentFailEmailBCC($orderItem->order_id,$orderItem->id,$lastpayId,$tx);
            }
        }
    }

    public function updatetxsub($sub_payment_id,$tx,$amount,$subscription_id)
    {
        $this->db->where(array('id'=>$sub_payment_id));
        $insertData = array('tx'=>$tx,'amount'=>$amount,'status'=>1,"profile_id"=>$subscription_id,
                "date"=>date("Y-m-d H:i:s"),
                'payment_mode'=>'razorpay');
        $this->db->update('subscription_payments',$insertData);
    }

    public function getAshramID($subscription_id)
    {
        $query = $this->archivesDb->select('*')->from('razorpay_subscriptions')->where('razorpay_subscription_id',$subscription_id)->get();
        if($query->num_rows() > 0)
        {
            return $query->result()[0]->ashram_id;
        }
        return false;
    }

    public function checksubscription($paid_count,$tx,$amount,$currency,$subscription_id,$body)
    {
        $query = $this->archivesDb->select('*')->from('razorpay_subscriptions')->where('razorpay_subscription_id',$subscription_id)->get();

        if($query->num_rows() > 0){
            $this->updatesubscriptions($paid_count,$tx,$query->result()[0]->order_item_id,$query->result()[0]->item_id,$amount,$currency,$subscription_id,$body);
            return 1;
        }
    }

    public function updatesubscriptionOneTime($tx,$item_order_id,$item_id,$amount,$currency,$subscription_id,$stripearray)
    {
        $this->load->model('payment_model');
        $this->load->model('orders/orders_model');
        $this->load->model('locations_model');
        $this->db->select("*,oi.id as id");
        $this->db->from("order_items as oi");
        $this->db->join("orders as o","o.id=oi.order_id");
        $this->db->where("subscription",1);
        $this->db->where('oi.id',$item_order_id);
        $items=$this->db->get()->result();
        foreach ($items as $orderItem)
        {
            //echo "in loop";
            if(!$tx)
            $tx = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
            
            $this->load->model('razorpay_subscriptions_model','razorpay_subscriptions');
            $serveraddr = $this->razorpay_subscriptions->getServerAddress($orderItem->order_id);
            if($serveraddr)
                $serveraddr = $serveraddr;
            else
                $serveraddr = $_SERVER['REMOTE_ADDR'];
            $tData = $this->payment_model->createTransaction($tx,$orderItem->user_id,'','paid',null,$orderItem->order_id);
            $this->payment_model->updateOrderTotalPaid($orderItem->order_id,$amount,$tx);
            $this->payment_model->populateTransactionReport($tx);
            $countryData=$this->locations_model->getCountryByCode($orderItem->country);
            $updateTxArray= array(
                "t_status"=>1,
                //'data'=>serialize($stripearray),
                'modified_on'=>date("Y:m:d H:i:s"),
                'amount'=>abs($amount),
                'currency'=>$currency,
                'payment_mode'=>'razorpay',
                'ip_address'=>$serveraddr,
                'created_on'=>date("Y-m-d H:i:s"),
                'firstname'=>$orderItem->firstname,
                'lastname'=>$orderItem->lastname,
                'city'=>$orderItem->city,
                'state'=>$orderItem->state,
                'country'=>$orderItem->country,
                'email'=>$orderItem->email,
                'phone'=>$orderItem->phone,
                'country_isd_code'=>$countryData->isd_code,
                'note'=>"One Time Setup Fee for ".$orderItem->item_name,
                "ashram_id"=>$orderItem->ashram_id,
            );
            $this->order_log_model->log($orderItem->order_id,"Subscription \"".$orderItem->item_name."\" One time payment charged.");
            //$this->payment_model->updateTx($tx,$updateTxArray);
            $tData = array_merge($tData,$updateTxArray);
             //saving transaction table 
			$this->payment_model->saveTransaction($tData);
            //saving payment response into archives database
			$this->payment_model->savingPaymentResponse($tx,$stripearray,$orderItem->user_id,"razorpay",$orderItem->order_id);

            $this->orders_model->sendTransactionReceiptEmail($orderItem->order_id,$tx);
            $this->orders_model->sendTransactionReceiptEmailBcc($orderItem->order_id,$tx);
        }
    }

    public function checksubscriptionOnetime($paid_count,$tx,$amount,$currency,$subscription_id,$body)
    {

        $query = $this->archivesDb->select('*')->from('razorpay_subscriptions')->where('razorpay_subscription_id',$subscription_id)->get();
        if($query->num_rows() > 0)
        {
            $this->updatesubscriptionOneTime($tx,$query->result()[0]->order_item_id,$query->result()[0]->item_id,$amount,$currency,$subscription_id,$body);
        }
    }

    public function save($data)
    {
        $this->archivesDb->insert($this->tableName,$data);
    }

    public function checktriggeredEvent($event,$tx)
    {
        $q = $this->archivesDb->select('id')->from($this->tableName)->where(['event_type'=>$event['event_type'],'status'=>$event['status'],'transaction_id'=>$tx])->get();
        if($q->num_rows() > 0)
        {
            return false;
        }
        else
        {
            return true;
        }
    }

    public function updateOrderItemStatus($orderItemId,$status)
    {
        $this->db->where("id",$orderItemId);
        $this->db->update("order_items",array("status"=>$status));
    }

    public function updatecaptureFlag($transaction_id)
    {
        $this->archivesDb->where("transaction_id",$transaction_id);
        $this->archivesDb->update($this->tableName,array("capture_flag"=>1));
    }

    public function updatecaptureFlagZero($transaction_id)
    {
        $this->archivesDb->where("transaction_id",$transaction_id);
        $this->archivesDb->update($this->tableName,array("capture_flag"=>0));
    }

    public function createTempOrders($reference,$razorpay_note_reference)
    {
        // Get temp payment info by reference id
        $tempInfo=$this->payment_model->getTempInfo($reference);
        
        if(!empty($tempInfo))
        {
            $amount=$tempInfo->amount;
            $uid=$tempInfo->user_id;
            $currency=$tempInfo->currency;
            //Get custom data(form data, cart data) from temp payment info
            $customData=unserialize($tempInfo->data);

            $orderId=0;
            if(isset($customData['order_id']))
                $orderId=$customData['order_id'];

            $payment_id = "";
            //Get trust data By cart type
            $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($customData['formData']['ashram_id'],$customData['cart_type']);
            $trustsArray=array();
            foreach ($trusts as $trustData)
            {
                $trustsArray[$trustData->currency]=$trustData;
            }
            //Get trust details for the selected currency
            $trustData=$trustsArray[$tempInfo->currency];

            if(isset($customData['cartData']))
            {
                // Generate temp transaction number
                $transaction=new stdClass();
                $transaction->tx=$temptx=substr(hash('sha256', mt_rand() . microtime()), 0, 20);
                $payment_id = $transaction->tx;
                $temp_payment_id = $payment_id;
                $tempIpn=new stdClass();
                $tempIpn->status='initiated';
                $tempIpn->amount=$amount;

                //Create Temporary Order
                $this->temp_payments_model->createTransactionTemp($payment_id,$tempInfo->user_id,$reference,'initiated',null,$orderId);
                // Update temp payment info table
                $this->temp_payments_model->tempInfoUpdateTxTemp($reference,$payment_id,$amount);
                // Now get all details from temp transaction table by transaction id
                $transactionRecord=$this->temp_payments_model->getTransactionTemp($payment_id);

                // Create temp order
                $orderId=$this->temp_payments_model->processPurchaseTemp($reference,$transaction,$tempInfo,$tempIpn);
                if($orderId)
                {
                    //Update razorpay reference number to orders_temp table
                    $this->temp_payments_model->updateTempReference($orderId,$razorpay_note_reference);
                    $tempInfo = json_encode($tempInfo);
                    //Update temp payment info and application reference to orders_temp table
                    $this->temp_payments_model->updateTempPaymentInfo($orderId,$tempInfo,$reference);
                }
                //Create Temporary Order
            }
            return array("order_id"=>$orderId,"payment_id"=>$payment_id);
        }
    }

    public function updateOrerID($tx)
    {
        $this->db->where("tx",$tx);
        $transaction=$this->db->get("transaction");
        $trans_row = $transaction->row();
        if(!empty($trans_row))
        {
            $table = "razorpay_webhook_".date("Y");
            $orderId = $trans_row->order_id;
            $this->archivesDb->where("transaction_id",$tx);
            $this->archivesDb->update($table,array("order_id"=>$orderId));
        }
        return true;
    }

    public function getTodaysevents()
    {
        $this->archivesDb->select('*');
        $this->archivesDb->from($this->tableName);
        $this->archivesDb->where('created_on >= DATE_SUB(NOW(),INTERVAL 10 MINUTE)');
        $this->archivesDb->group_start();
        $this->archivesDb->where('status','authorized');
        $this->archivesDb->or_where('capture_flag',0);
        $this->archivesDb->or_where('order_id',0);
        $this->archivesDb->group_end();
        $this->archivesDb->group_by('transaction_id');
        $result = $this->archivesDb->get()->result_array();
        if ($result) 
        {
            return $result;
        }
        else 
        {
            return false;
        }
    }

    public function checkTransactionAmounts()
    {
        $this->db->select('t.*,o.ashram_id');
        $this->db->from("transaction as t");
        $this->db->join("orders as o","o.id = t.order_id");
        $this->db->where('t.payment_mode','razorpay');
        $this->db->where('t.status','captured');
        $this->db->where('t.amount',NULL);
        $this->db->where('t.order_item_id',0);
        $this->db->where('t.subscription',0);
        $result = $this->db->get()->result();
        if ($result) 
        {
            foreach ($result as $key => $value) 
            {
                $this->archivesDb->select('*');
                $this->archivesDb->from($this->tableName);
                $this->archivesDb->where('order_id',$value->order_id);
                $this->archivesDb->where('status','captured');
                $this->archivesDb->where('amount>',0);
                $result1 = $this->archivesDb->get()->row();
                if ($result1) 
                {
                    $this->db->where("tx",$value->tx);
                    $this->db->where("order_id",$value->order_id);
                    $this->db->update("transaction",array("amount"=>$result1->amount,"ashram_id"=>$value->ashram_id));
                    if($result1->amount > 0)
                    {
                        $this->orders_model->update_no_transactions($value->order_id);
                        $this->orders_model->sendTransactionReceiptEmail($value->order_id,$value->tx);
                        $this->orders_model->sendTransactionReceiptEmailBcc($value->order_id,$value->tx);

                        log_message("error","Amount updated for order ".$value->order_id);
                    }
                }
            }
        }
        else 
        {
            return false;
        }
    }

    public function captureEvents()
    {
        $todaysEvents = $this->getTodaysevents();
        if(!empty($todaysEvents))
            foreach ($todaysEvents as $key => $value) 
            {
                if(!empty($value["data"]))
                {
                    $hookData = json_decode($value["data"]);
                    $payment_entity = $hookData->payload->payment->entity;

                    if(!empty($payment_entity->notes->reference))
                        $hook_data_reference = $payment_entity->notes->reference;
                    else
                        $hook_data_reference = "";

                    $temp_order = $this->temp_payments_model->getOrderDataTempRazorpay($hook_data_reference);
                    if(!empty($temp_order))
                    {
                        $payment_id = $value["transaction_id"];
                        $tempInfo=json_decode($temp_order["temp_payment_info"]);
                        $customData=unserialize($tempInfo->data);

                        //Get trust data
                        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($temp_order['ashram_id'],$temp_order['order_type']);
                        $trustsArray=array();
                        foreach ($trusts as $trustData)
                        {
                            $trustsArray[$trustData->currency]=$trustData;
                        }
                        $trustData=$trustsArray[$tempInfo->currency];
                        //Get trust data

                        $api = new Api($trustData->razorpay_key, $trustData->razorpay_secret);
                        try
                        {
                            $payment = $api->payment->fetch($payment_id);
                            $application_transactionData = $this->payment_model->getTransaction($payment_id);
                            if($payment["status"] == "captured")
                            {
                                if(!empty($application_transactionData) && !empty($application_transactionData->order_id) && $application_transactionData->order_id != 0)
                                {
                                    continue;
                                }
                                else
                                {
                                    $return  = $this->makeOrder($payment_id,$payment,$customData,$temp_order,$tempInfo,$hook_data_reference,"captured");
                                }
                            }
                            else if($payment["status"] == "authorized")
                            {
                                $payment  = $payment->capture(array('amount'=>($temp_order['total_price']*100)));
                                if($payment)
                                    $return  = $this->makeOrder($payment_id,$payment,$customData,$temp_order,$tempInfo,$hook_data_reference,"authorized");
                            }
                            else if($payment["status"] == "refunded")
                            {
                                $amount = $payment['amount']/100;
                                if(!empty($application_transactionData) && !empty($application_transactionData->order_id) && $application_transactionData->order_id != 0 && $amount != 5 && $amount != 0)
                                {
                                    //$return  = $this->updateOrderCancelFlag($application_transactionData->order_id,$amount);
                                }
                            }
                            else if($payment["status"] == "failed")
                            {
                                $amount = $payment['amount']/100;
                                if(!empty($application_transactionData) && !empty($application_transactionData->order_id) && $application_transactionData->order_id != 0 && $amount != 5 && $amount != 0)
                                {
                                    $return  = $this->updateOrderCancelFlag($application_transactionData->order_id,$amount);
                                }
                            }
                        }
                        catch(Exception $e)
                        {
                            exit;
                        }
                    }
                }
            }
        else
        {
            echo "No events found at ".date("d M Y H:i:s");
        }
    }

    public function updateOrderCancelFlag($order_id,$gateway_amount)
    {
        $orderData=$this->orders_model->orderData($order_id);
        if(!empty($orderData['order']) && ($orderData['order']->total_price == $gateway_amount))
        {
            $updateData = array(
                                "is_cancelled"=>1,
                                "cancel_reason"=>"Amount got refunded from gateway level while cron initiated on ".date("d M Y H i"),
                                "cancelled_on"=>date("Y-m-d H:i:s"),
                                "paid"=>0,
                                "total_paid"=>0
                                );
            $this->db->where(array('id'=>$order_id));
            $this->db->update('orders',$updateData);
            return true;
        }
    }

    public function checkSimilarOrder($amount,$user_id,$cartType,$currency,$tempHashId)
    {
        $q = $this->db->select("id,cart_hash_data")->from("orders")->where("total_price",$amount)->where("user_id",$user_id)->where("order_type",$cartType)->where("currency",$currency)->where("date >= DATE_SUB(NOW(),INTERVAL 1 HOUR)")->get();
        if($q->num_rows() > 0)
        {
            $r = $q->result_array();
            foreach ($r as $key => $value) 
            {
                if($value["cart_hash_data"] == $tempHashId)
                {
                    return "duplicate";
                    break;
                }
            }
        }
    }
    public function makeOrder($payment_id,$payment,$customData,$temp_order,$tempInfo,$reference,$eventStatus="authorized")
    {
        $amount = $payment['amount']/100;
        $txnid=$payment_id;
        $isTranresponseUpdate = false;

        $checkDuplicate = $this->checkSimilarOrder($amount,$tempInfo->user_id,$temp_order['order_type'],$temp_order['currency'],$temp_order["cart_hash_data"]);
        if(!empty($checkDuplicate) && $checkDuplicate == "duplicate" && $eventStatus == "authorized")
        {
            // log_message("error","Duplicate order not placed ".$temp_order['id']);
            log_message("error","Duplicate order not placed for razorpay reconciliation order process Temp Order ID: ".$temp_order['id']);
            $this->temp_payments_model->deleteTempOrder($temp_order["id"]);
            $this->temp_payments_model->deleteTempOrderItems($temp_order["id"]);
            $this->temp_payments_model->deleteTempTx($temp_order["id"]);
            return true;
        }
        if($eventStatus=="captured")
        {
            log_message("error","Duplicate order is placing for razorpay reconciliation order process Temp Order ID: ".$temp_order['id']." as razorpay transaction is already captured.");
        }
        $orderId=0;
        if(isset($customData['order_id']))
            $orderId=$customData['order_id'];

        $transaction=new stdClass();
        $transaction->tx=$payment_id;
        $payment_id = $payment_id;
        $tempIpn=new stdClass();
        $tempIpn->status='captured';
        $tempIpn->amount=$amount;
        $subscription_id = $this->razorpay_subscriptions_model->getSubscriptionId($temp_order["id"]);
        
        $tData =  $this->payment_model->createTransaction($payment_id,$tempInfo->user_id,$temp_order['application_reference'],'captured',null,$orderId);
        $tData = $this->payment_model->tempInfoUpdateTx($temp_order['application_reference'],$payment_id,$amount,$tData);
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($customData['formData']['ashram_id'],$customData['cart_type']);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        //Get trust details for the selected currency
        $trustData=$trustsArray[$tempInfo->currency];
        $api = new Api($trustData->razorpay_key, $trustData->razorpay_secret);
        try {
            if($subscription_id)
                $payment  = $api->payment->fetch($payment_id)->capture(array('amount'=>($amount)));
            else
                $payment  = $api->payment->fetch($payment_id);
        }
        catch(Exception $e) {
            exit;
        }
         //saving transaction table 
		$this->payment_model->saveTransaction($tData);
        //saving payment response into archives database
		$this->payment_model->savingPaymentResponse($payment_id,$payment,$tempInfo->user_id,"razorpay",$orderId);

        if(isset($customData['cartData']))
        {
            $orderId=$this->payment_model->processPurchase($temp_order['application_reference'],$transaction,$tempInfo,$tempIpn);
            $this->temp_payments_model->reconsilationLog($orderId,$payment_id);
            $orderData=$this->orders_model->orderData($orderId);

            $this->payment_model->updateTXIP($temp_order['application_reference'],$temp_order["id"],$orderId);
            $us_userData=unserialize($tempInfo->user_data);
            if($temp_order["order_type"]!=4)
            {
                $this->order_log_model->log($orderId,
                "Paid amount: ".strtoupper($tempInfo->currency)." ".$tempInfo->amount."\nRazorpay\nTx ID:".$txnid,$tempInfo->user_id,$us_userData->username);
                $this->orders_model->sendTransactionReceiptEmail($orderId,$transaction->tx);
            }
            else
            {
                if($amount>0)
                {
                    if($temp_order["order_type"]!=4)
                        $this->order_log_model->log($orderId,"One time payment item(s) charged.");
                    else
                        $this->order_log_model->log($orderId,"Subscription One time payment charged.");
                }
            }
        }
        else
        {
            $this->orders_model->calculateDue($orderId);
            $this->orders_model->sendTransactionReceiptEmail($orderId,$payment_id);
        }

        $transactionRecord=$this->payment_model->getTransaction($payment_id);
        if($subscription_id)
        {
            $transactionAmounts=array();
            $has_subscription=0;
            $orderId = $transactionRecord->order_id;
            $orderData=$this->orders_model->orderData($orderId);
            foreach ($orderData['order_items'] as $itemData) 
            {
                if($orderData['order']->order_type==4 && $itemData->subscription==1)
                {
                    $transactionAmounts[]=array(
                        "amount"=>$itemData->price*$itemData->quantity,
                        "onetime_charge"=>$itemData->onetime_charge,
                        "num_of_payments"=>$itemData->num_of_payments,
                        "subscription"=>1,
                        "itemData"=>$itemData,
                        "startDate"=>$itemData->schedule_dates,
                        "user_id"=>$orderData['order']->user_id
                    );
                    $has_subscription=1;
                }
                else
                {
                    $amount+=$itemData->quantity*($itemData->price+$itemData->shipping_price);
                    $transactionAmounts[]=array(
                        "amount"=>$amount,
                        "subscription"=>0
                    );
                }
            }

            foreach ($transactionAmounts as $transactionDetail)
            {
                if(isset($transactionDetail['subscription']) && $transactionDetail['subscription']==1)
                {

                    $this->transaction_model->updateDetails($payment_id,array("order_item_id"=>$transactionDetail['itemData']->id));
                    
                    $this->razorpay_subscriptions_model->updatesubscription($subscription_id,$orderId,$transactionDetail['itemData']->order_item_id,$transactionDetail['itemData']->item_id);
                    
                    $this->razorpay_subscriptions_model->updateOrderItemSubscription($transactionDetail['itemData']->order_item_id,$subscription_id,$transactionDetail['itemData'],1);
                    $return['redirect_url']=$transactionRecord->redirect_url;
                    $return['subscription_id']=$subscription_id;
                    $return['reference']=$reference;
                    $return['order_id']=$transactionRecord->order_id;
                    $return['f_flag']=0;
                }
            }
            if($amount > 0 && $transactionRecord->amount > 0)
            {
                $this->orders_model->sendTransactionReceiptEmail($return['order_id'],$payment_id);
                $this->orders_model->sendTransactionReceiptEmailBcc($orderId,$payment_id);
            }
        }
        else
        {
            $return['redirect_url']=$transactionRecord->redirect_url;
            $return['reference']=$reference;
            $return['order_id']=$transactionRecord->order_id;
            $return['f_flag']=0;
        }
        $completeOrder = $this->orders_model->orderDataTemp($temp_order['id']);
        foreach ($completeOrder['order_items'] as $c_itemData)
        {
            foreach ($orderData['order_items'] as $n_itemData) 
            {
                if($c_itemData->item_id == $n_itemData->item_id)
                {
                    $updateData = array(
                                'family_member_details'=>$c_itemData->family_member_details,
                                'personal_note'=>$c_itemData->personal_note,
                                'have_personal_note'=>$c_itemData->have_personal_note,
                                'name_of_family_type'=>$c_itemData->name_of_family_type,
                                'pooja_on_teertha_swamiji'=>$c_itemData->pooja_on_teertha_swamiji,
                                'family_members'=>$c_itemData->family_members,
                                'pooja_on_swamiji'=>$c_itemData->pooja_on_swamiji,
                                'max_family_members'=>$c_itemData->max_family_members,
                                'friend_or_other_1'=>$c_itemData->friend_or_other_1,
                                'friend_or_other_2'=>$c_itemData->friend_or_other_2,
                                'friend_or_other_3'=>$c_itemData->friend_or_other_3,
                                'friend_or_other_4'=>$c_itemData->friend_or_other_4,
                                'friend_or_other_5'=>$c_itemData->friend_or_other_5,
                                'friend_or_other_6'=>$c_itemData->friend_or_other_6,
                                'friend_or_other_7'=>$c_itemData->friend_or_other_7,
                                'friend_or_other_8'=>$c_itemData->friend_or_other_8,
                                'friend_or_other_9'=>$c_itemData->friend_or_other_9,
                                'friend_or_other_10'=>$c_itemData->friend_or_other_10);
                    $this->db->where("id",$n_itemData->id);
                    $this->db->update("order_items",$updateData);
                }
            }
        }
        $this->temp_payments_model->deleteTempOrder($temp_order["id"]);
        $this->temp_payments_model->deleteTempOrderItems($temp_order["id"]);
        $this->temp_payments_model->deleteTempTx($temp_order["id"]);
        return $return;
    }

    public function makeOrderForCapturedButTransactionNotCreated($payment_id,$payment,$customData,$temp_order,$tempInfo,$reference,$eventStatus="authorized")
    {
        $amount = $payment['amount']/100;
        $txnid=$payment_id;
        $isTranresponseUpdate = false;

        $checkDuplicate = $this->checkSimilarOrder($amount,$tempInfo->user_id,$temp_order['order_type'],$temp_order['currency'],$temp_order["cart_hash_data"]);
        if(!empty($checkDuplicate) && $checkDuplicate == "duplicate" && $eventStatus == "authorized")
        {
            // log_message("error","Duplicate order not placed ".$temp_order['id']);
            log_message("error","Duplicate order not placed for razorpay reconciliation order process Temp Order ID: ".$temp_order['id']);
            $this->temp_payments_model->deleteTempOrder($temp_order["id"]);
            $this->temp_payments_model->deleteTempOrderItems($temp_order["id"]);
            $this->temp_payments_model->deleteTempTx($temp_order["id"]);
            return true;
        }
        $orderId=0;
        if(isset($customData['order_id']))
            $orderId=$customData['order_id'];

        $transaction=new stdClass();
        $transaction->tx=$payment_id;
        $payment_id = $payment_id;
        $tempIpn=new stdClass();
        $tempIpn->status='captured';
        $tempIpn->amount=$amount;
        $subscription_id = $this->razorpay_subscriptions_model->getSubscriptionId($temp_order["id"]);
        
        $tData =  $this->payment_model->createTransaction($payment_id,$tempInfo->user_id,$temp_order['application_reference'],'captured',null,$orderId);
        $tData = $this->payment_model->tempInfoUpdateTx($temp_order['application_reference'],$payment_id,$amount,$tData);

        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($customData['formData']['ashram_id'],$customData['cart_type']);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        //Get trust details for the selected currency
        $trustData=$trustsArray[$tempInfo->currency];
        // echo '<pre>'; print_r($trustData); die();
        $api = new Api($trustData->razorpay_key, $trustData->razorpay_secret);
        try {
            if($subscription_id)
                $payment  = $api->payment->fetch($payment_id)->capture(array('amount'=>($amount)));
            else
                $payment  = $api->payment->fetch($payment_id);
        }
        catch(Exception $e) {
            exit;
        }
        // echo '<pre>'; print_r($tData); die();
         //saving transaction table 
        $this->payment_model->saveTransaction($tData);
        //saving payment response into archives database
        $this->payment_model->savingPaymentResponse($payment_id,$payment,$tempInfo->user_id,"razorpay",$orderId);

        if(isset($customData['cartData']))
        {
            $orderId=$this->payment_model->processPurchase($temp_order['application_reference'],$transaction,$tempInfo,$tempIpn);
            $this->temp_payments_model->reconsilationLog($orderId,$payment_id);
            $orderData=$this->orders_model->orderData($orderId);

            $this->payment_model->updateTXIP($temp_order['application_reference'],$temp_order["id"],$orderId);
            $us_userData=unserialize($tempInfo->user_data);
            if($temp_order["order_type"]!=4)
            {
                $this->order_log_model->log($orderId,
                "Paid amount: ".strtoupper($tempInfo->currency)." ".$tempInfo->amount."\nRazorpay\nTx ID:".$txnid,$tempInfo->user_id,$us_userData->username);
                $this->orders_model->sendTransactionReceiptEmail($orderId,$transaction->tx);
            }
            else
            {
                if($amount>0)
                {
                    if($temp_order["order_type"]!=4)
                        $this->order_log_model->log($orderId,"One time payment item(s) charged.");
                    else
                        $this->order_log_model->log($orderId,"Subscription One time payment charged.");
                }
            }
        }
        else
        {
            $this->orders_model->calculateDue($orderId);
            $this->orders_model->sendTransactionReceiptEmail($orderId,$payment_id);
        }

        $transactionRecord=$this->payment_model->getTransaction($payment_id);
        if($subscription_id)
        {
            $transactionAmounts=array();
            $has_subscription=0;
            $orderId = $transactionRecord->order_id;
            $orderData=$this->orders_model->orderData($orderId);
            foreach ($orderData['order_items'] as $itemData) 
            {
                if($orderData['order']->order_type==4 && $itemData->subscription==1)
                {
                    $transactionAmounts[]=array(
                        "amount"=>$itemData->price*$itemData->quantity,
                        "onetime_charge"=>$itemData->onetime_charge,
                        "num_of_payments"=>$itemData->num_of_payments,
                        "subscription"=>1,
                        "itemData"=>$itemData,
                        "startDate"=>$itemData->schedule_dates,
                        "user_id"=>$orderData['order']->user_id
                    );
                    $has_subscription=1;
                }
                else
                {
                    $amount+=$itemData->quantity*($itemData->price+$itemData->shipping_price);
                    $transactionAmounts[]=array(
                        "amount"=>$amount,
                        "subscription"=>0
                    );
                }
            }

            foreach ($transactionAmounts as $transactionDetail)
            {
                if(isset($transactionDetail['subscription']) && $transactionDetail['subscription']==1)
                {

                    $this->transaction_model->updateDetails($payment_id,array("order_item_id"=>$transactionDetail['itemData']->id));
                    
                    $this->razorpay_subscriptions_model->updatesubscription($subscription_id,$orderId,$transactionDetail['itemData']->order_item_id,$transactionDetail['itemData']->item_id);
                    
                    $this->razorpay_subscriptions_model->updateOrderItemSubscription($transactionDetail['itemData']->order_item_id,$subscription_id,$transactionDetail['itemData'],1);
                    $return['redirect_url']=$transactionRecord->redirect_url;
                    $return['subscription_id']=$subscription_id;
                    $return['reference']=$reference;
                    $return['order_id']=$transactionRecord->order_id;
                    $return['f_flag']=0;
                }
            }
            if($amount > 0 && $transactionRecord->amount > 0)
            {
                $this->orders_model->sendTransactionReceiptEmail($return['order_id'],$payment_id);
                $this->orders_model->sendTransactionReceiptEmailBcc($orderId,$payment_id);
            }
        }
        else
        {
            $return['redirect_url']=$transactionRecord->redirect_url;
            $return['reference']=$reference;
            $return['order_id']=$transactionRecord->order_id;
            $return['f_flag']=0;
        }
        $completeOrder = $this->orders_model->orderDataTemp($temp_order['id']);
        foreach ($completeOrder['order_items'] as $c_itemData)
        {
            foreach ($orderData['order_items'] as $n_itemData) 
            {
                if($c_itemData->item_id == $n_itemData->item_id)
                {
                    $updateData = array(
                                'family_member_details'=>$c_itemData->family_member_details,
                                'personal_note'=>$c_itemData->personal_note,
                                'have_personal_note'=>$c_itemData->have_personal_note,
                                'name_of_family_type'=>$c_itemData->name_of_family_type,
                                'pooja_on_teertha_swamiji'=>$c_itemData->pooja_on_teertha_swamiji,
                                'family_members'=>$c_itemData->family_members,
                                'pooja_on_swamiji'=>$c_itemData->pooja_on_swamiji,
                                'max_family_members'=>$c_itemData->max_family_members,
                                'friend_or_other_1'=>$c_itemData->friend_or_other_1,
                                'friend_or_other_2'=>$c_itemData->friend_or_other_2,
                                'friend_or_other_3'=>$c_itemData->friend_or_other_3,
                                'friend_or_other_4'=>$c_itemData->friend_or_other_4,
                                'friend_or_other_5'=>$c_itemData->friend_or_other_5,
                                'friend_or_other_6'=>$c_itemData->friend_or_other_6,
                                'friend_or_other_7'=>$c_itemData->friend_or_other_7,
                                'friend_or_other_8'=>$c_itemData->friend_or_other_8,
                                'friend_or_other_9'=>$c_itemData->friend_or_other_9,
                                'friend_or_other_10'=>$c_itemData->friend_or_other_10);
                    $this->db->where("id",$n_itemData->id);
                    $this->db->update("order_items",$updateData);
                }
            }
        }
        $this->temp_payments_model->deleteTempOrder($temp_order["id"]);
        $this->temp_payments_model->deleteTempOrderItems($temp_order["id"]);
        $this->temp_payments_model->deleteTempTx($temp_order["id"]);
        return $return;
    }

    public function failed_payments_report()
    {
        $yesterdayDate = date('Y-m-d',strtotime("-1 days"));
        $q = $this->archivesDb->select("id,transaction_id,customer_id,email,phone,subscription_id,amount,currency,paid_count,plan_id,created_on,event_type,status,order_id")->from("razorpay_webhook_".date("Y"))->where("DATE_FORMAT(created_on,'%Y-%m-%d')",$yesterdayDate)->where_in("status",array("failed","failure"))->group_by("transaction_id")->order_by("created_on","desc")->get();
        if($q->num_rows() > 0)
        {
            $service_slug = 'razorpay_failed_transactions';
            $this->db->like("service_slug",$service_slug);
            $settings=$this->db->get('email_settings')->row();

            if(!empty($settings))
            {
                $emails = razorpay_failed_tx_report_emails;
                
                $data['failed_trans'] = $q->result_array();
                $data["failed_date"]  = date("d M Y, l",strtotime($yesterdayDate));
                
                $subject  = "Failed Transaction from razorpay, Date: ".date("d M Y, l",strtotime($yesterdayDate));
                $content=$this->load->view("orders/public/_email_razorpay_failed_transactions",$data,true);
                foreach ($emails as $key1 => $value1) 
                {
                    $viewData['name']="Admin";
                    $viewData['body']=$content;
                    $viewData['signature']=nl2br($settings->signature);
                    $content=$this->load->view("common/templates/email_template",$viewData,true);

                    $sender = '"'.$settings->from_name.'"<'.$settings->from_email.email_domain.'>';
                    $ses_bcc = "";
                    $messageID='';
                    $sesResult = $this->ses->SendSESMail(0,$sender,$value1,$subject,$content,$ses_bcc,"razorpay_failed_transactions");
                }
            }
        }
    }

    public function updateReconciliationReport($data=array(), $paymentGateway = '')
    {   
        $reportsDb=$this->load->database("reports",true,false);
        $checkTableName = "";
        $transdate  = "";
        if($data['created_on']!='')
        {
            $transdate  = date('Y-m-d', strtotime($data['created_on']));
        }
        if(strtolower($data['currency'])=='inr' && $transdate!='')
        {
            $checkTableName="tx_reconciliation_report_".strtolower($data['currency'])."_";
            $monthOfCreated = date("m",strtotime($transdate));
            $yearOfCreated = date("Y",strtotime($transdate));
            if($monthOfCreated>=4)
            {
                $checkTableName .= $yearOfCreated."-".financial_year_start_month_date;
                $checkTableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
            }
            else
            {
                $checkTableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
                $checkTableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
            }
        }
        else if(strtolower($data['currency'])=='usd' && $transdate!='')
        {
            $checkTableName="tx_reconciliation_report_".strtolower($data['currency'])."_".date('Y');
        }

        $checkTableName = str_replace("-","_",$checkTableName);

        if($checkTableName !="" && $reportsDb->table_exists($checkTableName) )
        {

        }
        else if($checkTableName !="")
        {
            $reportsDb->query("CREATE TABLE IF NOT EXISTS `".$checkTableName."` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `ashram_id` int(11) DEFAULT '0',
                `trust_id` int(11) DEFAULT '0',
                `seva_date` date DEFAULT NULL,
                `seva_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `seva_number` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `tx_date` datetime DEFAULT NULL,
                `tx_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `tx_amount` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `gateway_tx_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `gateway_tx_amount` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `gateway_tx_date` datetime DEFAULT NULL,
                `seva_total` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `currency` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `payment_gateway` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `payment_mode` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `transaction_status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `gateway_status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `user_id` int(10) NOT NULL DEFAULT 0,
                `username` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `user_full_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `user_phone` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `country_isd_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                `is_no_transactions` ENUM('1','0') NOT NULL DEFAULT '0',
                PRIMARY KEY(`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
        }
        if($checkTableName !="")
        {
            $updatadata = [
                            'payment_gateway' => $paymentGateway,
                            'gateway_tx_id' => isset($data['transaction_id']) ? $data['transaction_id']: "",
                            'gateway_tx_amount' => isset($data['amount']) ? $data['amount']: "",
                            'gateway_tx_date' => isset($data['created_on']) ? $data['created_on']: date('Y-m-d H:i:s'),
                            'gateway_status' => isset($data['status']) ? $data['status']: "",
                            'currency' => isset($data['currency']) ? strtolower($data['currency']): "",
                        ];
            $wherecheck = "(gateway_tx_id='".trim($data['transaction_id'])."' or tx_id = '".trim($data['transaction_id'])."')";
            $results = $reportsDb->select('*')->from($checkTableName)->where($wherecheck)->get()->row_array();
            if(isset($results['id']) && isset($results['id'])>0)
            {
                $reportsDb->where('id', $results['id']);
                $reportsDb->update($checkTableName,$updatadata);
            }
            else
            {
                $reportsDb->insert($checkTableName,$updatadata);
            }
        }
    }
}