<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

require_once APPPATH. '/third_party/razorpay/Razorpay.php';
use Razorpay\Api\Api;

class Razorpay_subscriptions_model extends CI_Model 
{
    var $archivesDb = "";
    /**
     * @name string TABLE_NAME Holds the name of the table in use by this model
     */
    const TABLE_NAME = 'razorpay_subscriptions';
    public function __construct()
    {
        parent::__construct();
        $this->archivesDb = $this->load->database("data_archives",true,false);
    }

    /**
     * @name string PRI_INDEX Holds the name of the tables' primary index used in this model
     */
    const PRI_INDEX = 'id';

    /**
     * Retrieves record(s) from the database
     *
     * @param mixed $where Optional. Retrieves only the records matching given criteria, or all records if not given.
     *                      If associative array is given, it should fit field_name=>value pattern.
     *                      If string, value will be used to match against PRI_INDEX
     * @return mixed Single record if ID is given, or array of results
     */
    public function get($where = NULL) {
        $this->archivesDb->select('*');
        $this->archivesDb->from(self::TABLE_NAME);
        $this->archivesDb->where('id', $where);
        $result = $this->archivesDb->get()->result();
        if ($result) {
            return $resul;
        } else {
            return false;
        }
    }

    public function getServerAddress($order_id){
        $q = $this->archivesDb->select('ip_address')->from('transaction')->where(['order_id'=>$order_id,'status'=>'approved'])->get();
        if($q->num_rows()>0){
            $r = $q->result()[0]->ip_address;
            return $r;
        } else {
            return false;
        }
    }

    /**
     * Inserts new data into database
     *
     * @param Array $data Associative array with field_name=>value pattern to be inserted into database
     * @return mixed Inserted row ID, or false if error occured
     */
    public function insert($data) {
        if ($this->archivesDb->insert(self::TABLE_NAME, $data)) {
            return $this->archivesDb->insert_id();
        } else {
            return false;
        }
    }

    public function getCustomerId($orderId){
        $query = $this->archivesDb->select('customer_id')->from(self::TABLE_NAME)->where('order_id',$orderId)->get();
        if($query->num_rows() > 0){
            return $query->result()[0]->customer_id;
        } else {
            return false;
        }
    }

    public function getSubscriptionData($orderItemId=0,$orderId=0){
        $query = $this->archivesDb->select('*')->from(self::TABLE_NAME)->where(['order_item_id'=>$orderItemId,'order_id'=>$orderId])->get();
        if($query->num_rows() > 0){
            return $query->result()[0];
        } else {
            return false;
        }
    }

    public function updateOrderItemSubscription($id,$subscriptionProfileId,$itemData,$status)
    {
        if($itemData->subscription_id=='')
        {
            $updateData['subscription_id']=$subscriptionProfileId;
            $updateData['status']=$status;
        }
        $this->db->where("id",$id);
        $res = $this->db->update("order_items",$updateData);
        return 1;
        
    }

    public function RazorpaysubscriptionCancel($orderData,$itemData,$ashram_id,$currency)
    {
        $this->load->model('orders/order_log_model');
        if($itemData->subscription_id){

            $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashram_id,4);
            $trustsArray=array();
            foreach ($trusts as $trustData)
            {
                $trustsArray[$trustData->currency]=$trustData;
            }
            $trustData=$trustsArray[$currency];
            try{
                $api = new Api($trustData->razorpay_key, $trustData->razorpay_secret);

                $cancel = $api->subscription->fetch($itemData->subscription_id)->cancel();

                if($cancel->status == "cancelled")
                {
                    $this->archivesDb->where('razorpay_subscription_id',$itemData->subscription_id);
                    $this->archivesDb->update('razorpay_subscriptions',array('status'=>'Canceled','canceled_on'=>date('Y-m-d')));
                    return 1;
                }
                return 0;
            } catch(Exception $e){
                return 0;
            }
        }
        return 0;
    }

    public function subscription_cancel($orderId=0,$subscription_id,$ashram_id,$order_type,$currency,$orderItemId=0)
    {

        if(is_numeric($orderId) && $orderId && is_numeric($orderItemId) && $orderItemId)
        {

            $orderData=$this->orders_model->orderData($orderId);
            
            $itemData=$this->orders_model->itemData($orderItemId,$orderId);
            $result=$this->RazorpaysubscriptionCancel($orderData,$itemData,$ashram_id,$currency);
            if($result==1)
            {
                return 0;
            }
            else
            {
                return 1;
            }
        }
        exit();
    }

    public function createSubscription($ref)
    {
        $this->load->model('razorpay_customers_model','razorpaycustomers');
        $tempInfo=$this->payment_model->getTempInfo($ref);
        $customData=unserialize($tempInfo->data);
        $f_price_inr = "";
        foreach($customData['cartData'] as $key=>$val)
        {
            $subcheck = $val['options']['subscription'];
            $price_fixed = $val['options']['is_price_fixed'];
            $f_price_inr = $val['options']['price_inr'];
            $subscription_id = $val['id'];
            $resultd = $val['options']['result_date'];
            $psymentsc = $val['options']['num_of_payments'];
        }
        if($subcheck == 1)
        {
            $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($customData['formData']['ashram_id'],$customData['cart_type']);
            $trustsArray=array();
            foreach ($trusts as $trustData)
            {
                $trustsArray[$trustData->currency]=$trustData;
            }
            $trustData=$trustsArray[$tempInfo->currency];
            $api = new Api($trustData->razorpay_key, $trustData->razorpay_secret);
            
            $this->load->model('ashrams/subscriptions_model');
            $subscriptionData=$this->subscriptions_model->subscriptionData($subscription_id);
            if(!empty($subscriptionData->is_price_fixed) && $subscriptionData->is_price_fixed==1)
            {
                $final_price_inr = $subscriptionData->price_inr;
            }
            else
            {
                $final_price_inr = $f_price_inr;
            }
            $customer_id = $this->razorpaycustomers->getUpdateCustomer($this->input->post('email'),$customData['formData']['ashram_id'],$tempInfo->currency);
            if($customer_id == "error")
                return "0";
            if($subscriptionData->expiration_method==1)
            {
                $api_request_params['TERM']=$psymentsc;
            }
            if($subscriptionData->period=='days')
            {
                $api_request_params['PAYPERIOD']='daily';
            }
            if($subscriptionData->period=='weeks')
            {
                $api_request_params['PAYPERIOD']='weekly';
            }
            if($subscriptionData->period=='months')
            {
                $api_request_params['PAYPERIOD']='monthly';
            }
            if($subscriptionData->period=='years')
            {
                $api_request_params['PAYPERIOD']='yearly';
            }
            $interval = $subscriptionData->frequency;
            $numofPayments = $psymentsc;
            try{
                $plan = $api->plan->create(array('period' => $api_request_params['PAYPERIOD'], 'interval' => $interval, 'item' => array('name' => $subscriptionData->subscription_name, 'description' => $subscriptionData->subscription_name, 'amount' => $final_price_inr * 100, 'currency' => strtoupper($tempInfo->currency))));
                if($subscriptionData->onetime_charge_inr > 0)//Success
                {
                    $subscription  = $api->subscription->create(array('plan_id' => $plan->id, 'customer_notify' => 1, 'customer_id' =>'', 'total_count' => $numofPayments, 'start_at' => strtotime($resultd),'addons' => array(array('item' => array('name' => "setup fee for subscription: ".$subscriptionData->subscription_name, 'amount' => $subscriptionData->onetime_charge_inr *100, 'currency' => 'INR')))));
                    $jsonsub = json_encode($subscription);

                    $subscriptiondata = array('razorpay_subscription_id'=>$subscription->id,'created_on'=>date('Y-m-d H:i:s'),'user_id'=>$tempInfo->user_id,'payment_and_subscription_info'=>$jsonsub,'total_payments_count'=>$numofPayments,'completed_payments_count'=>1,'customer_id'=>$customer_id,'status'=>"Started/Activated",'plan_id'=>$plan->id,'currency'=>$tempInfo->currency,'amount'=>$final_price_inr,'ashram_id'=>$customData['formData']['ashram_id']);
                    $this->razorpaysubscriptions->insert($subscriptiondata);

                }
                else
                {
                    $subscription  = $api->subscription->create(array('plan_id' => $plan->id, 'customer_notify' => 1, 'customer_id' =>'', 'total_count' => $numofPayments, 'start_at' => strtotime($resultd)));
                    $jsonsub = json_encode($subscription);
                    $subscriptiondata = array('razorpay_subscription_id'=>$subscription->id,'created_on'=>date('Y-m-d H:i:s'),'user_id'=>$tempInfo->user_id,'payment_and_subscription_info'=>$jsonsub,'total_payments_count'=>$numofPayments,'completed_payments_count'=>1,'customer_id'=>$customer_id,'status'=>"Started/Activated",'plan_id'=>$plan->id,'currency'=>$tempInfo->currency,'amount'=>$final_price_inr,'ashram_id'=>$customData['formData']['ashram_id']);
                    $this->razorpaysubscriptions->insert($subscriptiondata);
                }
            } catch(Exception $e){
                return "0";
            }
            return $subscription->id;
        } else {
            return "2";
        }
    }

    public function updatesubscription($subscription_id = null,$orderId,$orderItemId,$ItemId)
    {
        if($subscription_id)
        {
            $updateData['order_id']=$orderId;
            $updateData['order_item_id']=$orderItemId;
            $updateData['item_id']=$ItemId;
        }
        $this->archivesDb->where("razorpay_subscription_id",$subscription_id);
        $this->archivesDb->update("razorpay_subscriptions",$updateData);
    }

    public function updateTempOrder($subscription_id,$tempOrderId)
    {
        if(!empty($subscription_id) && !empty($tempOrderId))
        {
            $updateData['temp_order_id']=$tempOrderId;
        }
        $this->archivesDb->where("razorpay_subscription_id",$subscription_id);
        $this->archivesDb->update("razorpay_subscriptions",$updateData);
    }

    public function getSubscriptionId($temp_order_id)
    {
        if(!empty($temp_order_id))
        {
            $this->archivesDb->where("temp_order_id",$temp_order_id);
            $data = $this->archivesDb->get("razorpay_subscriptions");
            if(!empty($data))
            {
                $data1 = $data->row();
                if(!empty($data1))
                    return $data1->razorpay_subscription_id;
                else
                    return false;
            }
        }
        return false;
    }

    public function checkSubscription($razorpay_subscription_id)
    {
        if(!empty($razorpay_subscription_id))
        {
            $this->archivesDb->where("razorpay_subscription_id",$razorpay_subscription_id);
            $data = $this->archivesDb->get("razorpay_subscriptions");
            return $data;
        }
        return false;
    }

    public function getAshramId($customerId)
    {
        $q = $this->archivesDb->select('ashram_id')->from('razorpay_subscriptions')->where('customer_id',$customerId)->get();
        if($q->num_rows() > 0){
            $r = $q->result()[0]->ashram_id;
            return $r;
        } else {
            return false;
        }
    }
}   