<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH. '/third_party/razorpay/Razorpay.php';
use Razorpay\Api\Api;
class Razorpay_customers_model extends CI_Model 
{
	protected $tableName="";
    var $archivesDb = "";
    function __construct() 
	{
	    parent::__construct();
        $this->archivesDb = $this->load->database("data_archives",true,false);
    }

    public function getUpdateCustomer($email,$ashramId,$currency){
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,4);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        $trustData=$trustsArray[$currency];

        $data = $this->checkRazorpayCustomer($email,$trustData->razorpay_key,$trustData->razorpay_secret);

        if($data['status'] == "error"){
            return '0';
        } else {
            $customer_id = $data['customer_id'];
            return $customer_id;
        }
    }

    public function getCustomerCard($id){
    	$query = $this->archivesDb->select('razorpay_customer_id')->from($this->tableName)->where(['id'=>$id])->get();
    	if($query->num_rows() > 0){
    		$result = $query->result()[0]->razorpay_customer_id;
    		return $result;
    	} else {
    		return FALSE;
    	}
    }

    public function CreateUpdateCustomer($data){
    	$query = $this->archivesDb->insert($this->tableName,$data);
    	$customer_id=$this->archivesDb->insert_id();
    	if($customer_id){
    		return true;
    	} else {
    		return FALSE;
    	}
    }

    public function checkRazorpayCustomer($email,$idKey,$secretkey){
        try{
            $url = "https://$idKey:$secretkey@api.razorpay.com/v1/customers";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,  $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            if(!$response = curl_exec($ch)) 
            { 
                $error = trigger_error(curl_error($ch)); 
                return array('status'=>'error');
            }
            $result = json_decode($response);
            $error = isset($result->error)?"1":"0";
            if($error == "1"){
                return array('status'=>'error');
            }

            if($error == "0" && $result->items){
                foreach($result->items as $key=>$val){
                    if($val->email == $email){
                        return array("customer_id"=> $val->id,'status'=>"success/check",'email'=>$email);
                    } 
                }
                $api = new api($idKey,$secretkey);
                $customer = $api->customer->create(array('name' => $this->input->post("firstname")." ".$this->input->post("lastname"),'contact'=>$this->input->post("phone"), 'email' => $this->input->post("email"))); // Creates customer
                return array("customer_id"=> $customer->id,'status'=>"success/check",'email'=>$email);
            } else {
                return array('status'=>'error');
            }
        } catch(Exception $e){
            return array('status'=>'error','email'=>$email);
        }
    }

    public function checkDBCustomer($data,$key,$secret){
        if($data['status'] == "success/check"){
            $q = $this->archivesDb->select('razorpay_customer_id')->from('razorpay_customers')->where(array('razorpay_customer_id'=>$data['customer_id'],'email'=>$data['email']))->get();
            if($q->num_rows() > 0){
                return $q->result()[0]->razorpay_customer_id;
            } else {
                $razorpay_customer_data = array('user_id'=>1,'email'=>$this->input->post("email"),'username'=>$this->input->post("firstname"),'created_on'=>date('Y-m-d H:i:s'),'razorpay_customer_id'=>$data['customer_id']);
                $this->CreateUpdateCustomer($razorpay_customer_data);
                return $data['customer_id'];
            }
        } else {
            try{
                $api = new api($key,$secret);
                $customer = $api->customer->create(array('name' => $this->input->post("firstname")." ".$this->input->post("lastname"),'contact'=>$this->input->post("phone"), 'email' => $this->input->post("email"))); // Creates customer

                $razorpay_customer_data = array('user_id'=>1,'email'=>$this->input->post("email"),'username'=>$this->input->post("firstname"),'created_on'=>date('Y-m-d H:i:s'),'razorpay_customer_id'=>$customer->id);

                $this->razorpaycustomers->CreateUpdateCustomer($razorpay_customer_data);

                $customer_id = $customer->id;
                return $customer_id;
            } catch(Exception $e){
                return "error";
            }
        }

    }
}