<?PHP
class Quick_links_Model extends CI_Model {

	public $tableName="quick_links";
	var $siteServivcesDb = "";
    function __construct()
    {
        parent::__construct();
        $this->siteServivcesDb = $this->load->database("site_services",true,false);
    }
    function linkData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$query = $this->siteServivcesDb->get($this->tableName);
		return $query->row();
	}
    public function listAll()
    {
    	$this->siteServivcesDb->order_by("order","asc");
    	return $this->siteServivcesDb->get($this->tableName)->result();
    }

    public function listAdmin()
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);

		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),"after");
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),'before');
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
			} */
		}

		if(isset($_POST['type']) && is_numeric($_POST['type']))
		{
			$query1->where("type",$_POST['type']);
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('order',$dir);
		}
		else
		{
			$query1->order_by('order',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;

			if($rtn['data'][$c]['include_base_url'])
			{
				$rtn['data'][$c]['link']=base_url.$row['link'];
			}
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function updateOrder($id,$value)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array('order'=>$value));
	}

	public function save($id)
	{
		$include_base_url=0;
		if(isset($_POST['include_base_url']))
			$include_base_url=1;

		if($id==0)
        {
			$data=array(
						"include_base_url"=>$include_base_url,
						'title'=>$this->general_model->filtertext(trim($_POST['title'])),
						'description'=>$this->general_model->filtertext(trim($_POST['description'])),
						'link'=>$this->general_model->filtertext(trim($_POST['link'])),
						'order'=>0
						);
			$this->siteServivcesDb->insert($this->tableName,$data);
			$idd=$this->siteServivcesDb->insert_id();
		}
		else
		{
			$this->siteServivcesDb->where("id",$id);
            $query = $this->siteServivcesDb->update($this->tableName,
                                array(
                                "include_base_url"=>$include_base_url,
								'title'=>$this->general_model->filtertext(trim($_POST['title'])),
								'description'=>$this->general_model->filtertext(trim($_POST['description'])),
								'link'=>$this->general_model->filtertext(trim($_POST['link'])),
                                ));
            $idd=$id;
		}
		if($idd)
			return $idd;
		else
			return 0;
	}

	function delete($id,$messageData)
	{
		$this->siteServivcesDb->where("id",$id);
		$query = $this->siteServivcesDb->delete($this->tableName);
		if($query) return 1;
		else return 0;
	}

	public function listPublicSearchQuickLinks()
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		
		if(isset($_POST['search_text']) && $_POST['search_text']!='')
		{
			$query1->group_start();
			$query1->like("title",trim($_POST['search_text']));
			$query1->or_like("description",$_POST['search_text']);
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('title','asc');
		$query1->group_by('id');

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if($rtn['data'][$c]['include_base_url'])
				$rtn['data'][$c]['link']=base_url.$row['link'];
			$sno++;
			$c++;
		}
		return $rtn;
	}
}
?>