<?PHP
class Pets_model extends CI_Model 
{
	var $tableName="pets";
	public function __construct()
	{
		parent::__construct();
	}
	public function getAll()
	{
		$q=$this->db->get($this->tableName)->result();
		$result=array();
		foreach ($q as $row)
		{
			$result[$row->id]=$row;
		}
		return $result;
	}
	public function getCount()
	{
		return $this->db->get($this->tableName)->num_rows();
	}
	public function petData($id)
	{
		$this->db->where("id",$id);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}

	public function donorsByIds($ids)
	{
		$this->db->where_in("id",$ids);
		$q=$this->db->get($this->tableName)->result();

		$result=array();
		foreach ($q as $row)
		{
			$result[$row->id]=$row;
		}
		return $result;
	}

	public function listAdmin($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}

		$query1->from($this->tableName);

		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			//$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nPhoto status: ";
		if(isset($_POST['photo_status']) && is_numeric($_POST['photo_status']) && in_array($_POST['photo_status'],array(0,1)))
		{
			if($_POST['photo_status']==1)
			{
				$query1->where("pet_photo !=",'');
				$preData.="With Photo";
			}
			else
			{
				$query1->where("pet_photo",'');
				$preData.="Without Photo";
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('pet_name',$_POST['dir']);
				else
					$query1->order_by('pet_name',"asc");
			}
			$sql=$query1->get_compiled_select();
			$requestResp=$this->excel_exports_model->makeRequest('default',"model","pets_model",$sql,$this->currentUser,"default",$_POST,"All Pets",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('pet_name',$dir);
		}
		else
		{
			$query1->order_by('pet_name',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			if($row['pet_photo']!='')
				$rtn['data'][$c]['pet_photo']=aws_s3_base_url."pets/thumb_".$row['pet_photo'];
			else
				$rtn['data'][$c]['pet_photo']=aws_s3_base_url."images/site_assets/global_site_images/no-image.png";
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function save($id,$petData)
	{
		if(!$id)
		{
			$q=$this->db->insert($this->tableName,
                                array(
                                	'pet_name' => $this->general_model->filtertext(trim($_POST["pet_name"])),
                                	'pet_species' => $this->general_model->filtertext(trim($this->input->post("pet_species"))),
                                	'pet_type' => $this->general_model->filtertext(trim($this->input->post("pet_type"))),
                                	'pet_serial_number' => $this->general_model->filtertext(trim($this->input->post("pet_serial_number"))),
                                	'pet_description' => $this->general_model->filtertext(trim($this->input->post("pet_description"))),
									'created_by'=>$this->currentUser->username,
									'created_on'=>date("Y:m:d H:i:s"),
									'modified_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$this->db->insert_id();
		}
		else
		{
			$this->db->where("id",$id);
			$q=$this->db->update($this->tableName,
                                array(
                                	'pet_name' => $this->general_model->filtertext(trim($_POST["pet_name"])),
                                	'pet_species' => $this->general_model->filtertext(trim($this->input->post("pet_species"))),
                                	'pet_type' => $this->general_model->filtertext(trim($this->input->post("pet_type"))),
                                	'pet_serial_number' => $this->general_model->filtertext(trim($this->input->post("pet_serial_number"))),
                                	'pet_description' => $this->general_model->filtertext(trim($this->input->post("pet_description"))),
                                	'modified_by'=>$this->currentUser->username,
									'modified_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$id;
		}

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		if($id)
		{
			if(($petData->pet_photo!='' && !isset($_POST['pet_imgupl'])) || 
				($petData->pet_photo!='' && isset($_FILES['pet_profile_image']) && $_FILES['pet_profile_image']['name']!='') )
			{
				$this->db->where("id",$idd);
				$this->db->update($this->tableName,array('pet_photo'=>''));
				
				$uname=strtolower($userData->username);
				$first_letter=$uname[0];
				$userId=$userData->id;

				$amazonUri="pets/".$petData->pet_photo;
				$amazonUriThumb="pets/thumb_".$petData->pet_photo;
				$amazonUriThumb50="pets/thumb50_".$petData->pet_photo;
				$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
				$this->s3->deleteObject(aws_s3_bucket_name,$amazonUriThumb);
				$this->s3->deleteObject(aws_s3_bucket_name,$amazonUriThumb50);
			}
		}

		if(isset($_FILES['pet_profile_image']))
		if($_FILES['pet_profile_image']['name']!='')
		{
			$this->load->helper('image');
			$name=$_FILES['pet_profile_image']['name'];
			$pre=explode(".",$name);
			$ncnt=count($pre);
			$ext=$pre[$ncnt-1];
			
			$filename="pet_".$idd."_".substr(md5(mt_rand()), 0, 16).".".$ext;
			
			$path="/tmp/".$filename;
			$tpath="/tmp/thumb_".$filename;
			$tpath50="/tmp/thumb50_".$filename;
			
			
			move_uploaded_file($_FILES['pet_profile_image']['tmp_name'],$path);
			
			$this->general_model->create_thumb_150($path,$tpath);
			$this->general_model->create_thumb50($path,$tpath50);


			$amazonUri="pets/".$filename;
			$amazonUriThumb="pets/thumb_".$filename;
			$amazonUriThumb50="pets/thumb50_".$filename;

			$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($tpath,aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($tpath50,aws_s3_bucket_name,$amazonUriThumb50,S3::ACL_PUBLIC_READ, array(), array());

			unlink($path);
			unlink($tpath);
			unlink($tpath50);
			
			$this->db->where("id",$idd);
			$this->db->update($this->tableName,array('pet_photo'=>$filename));
		}
		return $idd;
	}

	public function delete($id,$petData)
	{
		$this->db->where("id",$id);
		$this->db->delete($this->tableName);

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		$amazonUri="pets/".$petData->pet_photo;
		$amazonUriThumb="pets/thumb_".$petData->pet_photo;
		$amazonUriThumb50="pets/thumb50_".$petData->pet_photo;
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUriThumb);
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUriThumb50);
		return 1;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Serial No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Species");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pet_serial_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pet_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pet_species);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pet_type);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>