<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Paypal_Model extends CI_Model 
{
	protected $apiEndpointURL = 'https://pilot-payflowpro.paypal.com';
	protected $reportingApiEndpointURL = 'https://payments-reports.paypal.com/test-reportingengine';

	protected $cardTypes=array(
								0=>"Visa",
								1=>"Master Card",
								2=>"Discover",
								3=>"American Express",
								4=>"Diner's Club",
								5=>"JCB"
							);

	var $newCardTypes = array();

    function __construct() 
	{
	    parent::__construct();
	    $this->newCardTypes=array(
								0=>"visa",
								1=>"mastercard",
								2=>"discover",
								3=>"amex",
								4=>"diners_club",
								5=>"jcb"
							);
    }

    public function authorizeCard($trustData,$acct,$exp,$cvv2,$formData)
    {
    	if(empty($formData['address2']))
    		$address2 = $formData['address1'];
    	else
    		$address2 = $formData['address2'];
    	
    	$api_request_params = array (
		    			// API Data
		    			'USER' => $trustData->payflow_user,
		    			'VENDOR' => $trustData->payflow_vendor,
		    			'PARTNER' => $trustData->payflow_partner,
		    			'PWD' => $trustData->payflow_pwd,
		    			'TRXTYPE' => 'A',
		    			'TENDER' => 'C',
						'ACCT' => $acct,
		    			'EXPDATE' => $exp,
		    			'CVV2' => $cvv2,
		    			'BILLTOEMAIL' => $formData['email'],
		    			'BILLTOFIRSTNAME'=> substr(preg_replace('/[^A-Za-z0-9 ]/', '',$formData['firstname']),0,30),
		    			'BILLTOLASTNAME'=> substr(preg_replace('/[^A-Za-z0-9 ]/', '',$formData['lastname']),0,30),
		    			'BILLTOSTREET'=> substr(preg_replace('/[^A-Za-z0-9 ]/', '',$formData['address1']),0,30),
		    			'BILLTOSTREET2'=> substr(preg_replace('/[^A-Za-z0-9 ]/', '',$address2),0,30),
		    			'BILLTOCITY'=> substr(preg_replace('/[^A-Za-z0-9 ]/', '',$formData['city']),0,20),
		    			'AMT' => 0,
		    			"VERBOSITY"=>"HIGH"
		    	);
    	$nvp = $this->toNVP($api_request_params);
    	$result = $this->runCurl($trustData->payflow_url, $nvp);
    	$result_array = array();
		parse_str($result, $result_array);
		$this->payflow_logs_model->log($result_array,"Authorize card");
		return $result_array;
    }

    public function processOneTimePayment($reference,$creditCardData)
    {
    	$apiReturn['flag']=0;
    	$saveCard=0;
		$isTranresponseUpdate = false;
		$tempInfo=$this->payment_model->getTempInfo($reference);
		if(!empty($tempInfo))
		{
			
			$amount=$tempInfo->amount;
			$uid=$tempInfo->user_id;
			$currency=$tempInfo->currency;
			$customData=unserialize($tempInfo->data);

			//Get trust data
			$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($customData['formData']['ashram_id'],$customData['cart_type']);
	    	$trustsArray=array();
	    	foreach ($trusts as $trustData)
	    	{
	    		$trustsArray[$trustData->currency]=$trustData;
	    	}
	    	$trustData=$trustsArray[$tempInfo->currency];
			//Get trust data

	    	//==========Load encryption library=============//

	    	$this->load->library('encryption');

			$this->encryption->initialize(
			        array(
			                'cipher' => 'aes-256',
			                'mode' => 'cbc',
			                'key' => file_get_contents("../app_configs/aes_key")
			        )
			);

	    	//==========Load encryption library=============//

			$data['reference']=$reference;
    		$customData=unserialize($tempInfo->data);
    		
    		$credit_card_check = "";
        	$creditCardData = "";
			if(isset($customData['formData']["credit_card_id"]) && $customData['formData']["credit_card_id"] != "")
			{
				$creditCardData=$this->credit_cards_model->getCard($customData['formData']["credit_card_id"]);
				if(empty($creditCardData))
				{
					$credit_card_check = 1;
				}
			}
			else
			{
				$credit_card_check = "";
			}

    		$orderId=0;
    		if(isset($customData['order_id']))
    			$orderId=$customData['order_id'];

    		if(isset($customData['cartData']))
			{
	    		$transaction=new stdClass();
	            $transaction->tx=$temptx=substr(hash('sha256', mt_rand() . microtime()), 0, 20);
	            $payment_id = $transaction->tx;
	            $temp_payment_id = $payment_id;
	            $tempIpn=new stdClass();
	            $tempIpn->status='approved';
	            $tempIpn->amount=$amount;

	            //Create Temporary Order
	            $this->temp_payments_model->createTransactionTemp($payment_id,$tempInfo->user_id,$reference,'approved',null,$orderId);
	            $this->temp_payments_model->tempInfoUpdateTxTemp($reference,$payment_id,$amount);
	            $transactionRecord=$this->temp_payments_model->getTransactionTemp($payment_id);
	            $orderId=$this->temp_payments_model->processPurchaseTemp($reference,$transaction,$tempInfo,$tempIpn);
	            //Create Temporary Order
	        }
	        else
	        {
	        	if(empty($customData['formData']['address2']))
		    		$address2 = $customData['formData']['address1'];
		    	else
		    		$address2 = $customData['formData']['address2'];

		    	if(empty($credit_card_check) && !empty($creditCardData) && isset($customData['formData']["credit_card_id"]) && $customData['formData']["credit_card_id"] != "")
		    	{
		    		$api_request_params = array (
		    			// API Data
		    			'USER' => $trustData->payflow_user,
		    			'VENDOR' => $trustData->payflow_vendor,
		    			'PARTNER' => $trustData->payflow_partner,
		    			'PWD' => $trustData->payflow_pwd,
		    			'TRXTYPE' => 'S',
		    			'TENDER' => 'C',
		    			'ORIGID'=>$creditCardData->payflow_pnref,
		    			'AMT' => $amount,
		    			'COMMENT1' => $reference,
		    			"VERBOSITY"=>"HIGH"
		    		);
		    	}
		    	else
		    	{
		    		$api_request_params = array (
		    			// API Data
		    			'USER' => $trustData->payflow_user,
		    			'VENDOR' => $trustData->payflow_vendor,
		    			'PARTNER' => $trustData->payflow_partner,
		    			'PWD' => $trustData->payflow_pwd,
		    			'TRXTYPE' => 'S',
		    			'TENDER' => 'C',
		    			'ACCT' => $customData['formData']['card_number'],
		    			'EXPDATE' => str_replace("/","",$customData['formData']['card_expiry']),
		    			'CVV2' => $customData['formData']['card_cvv'],
		    			'AMT' => $amount,
		    			//'BILLTOFIRSTNAME' => $customData['formData']['card_name'],
		    			'BILLTOEMAIL' => $customData['formData']['email'],
		    			'BILLTOFIRSTNAME'=> substr(preg_replace('/[^A-Za-z0-9 ]/', '',$customData['formData']['firstname']),0,30),
		    			'BILLTOLASTNAME'=> substr(preg_replace('/[^A-Za-z0-9 ]/', '',$customData['formData']['lastname']),0,30),
		    			'BILLTOSTREET'=> substr(preg_replace('/[^A-Za-z0-9 ]/', '',$customData['formData']['address1']),0,30),
		    			'BILLTOSTREET2'=> substr(preg_replace('/[^A-Za-z0-9 ]/', '',$address2),0,30),
		    			'BILLTOCITY'=> substr(preg_replace('/[^A-Za-z0-9 ]/', '',$customData['formData']['city']),0,20),
		    			//'BILLTOZIP'=> substr(preg_replace('/[^0-9]/', '',$customData['formData']['zipcode']),0,9),
		    			'COMMENT1' => $reference,
		    			"VERBOSITY"=>"HIGH"
		    		);
		    	}
	        	
	    		$nvp = $this->toNVP($api_request_params);
		    	$result = $this->runCurl($trustData->payflow_url, $nvp);
		    	$authorize_result = array();
	    		parse_str($result, $authorize_result);

	    		$this->payflow_logs_model->log($authorize_result,"Partial payment");

	    		if($authorize_result['RESULT']==0)//Success
		    	{
		    		if(empty($credit_card_check) && empty($creditCardData) && !empty($customData['formData']['save_credit_card']) && $customData['formData']['save_credit_card'] == 1)
		    		{
		    			$card_type = $this->getCardBrand($customData['formData']['card_number']);
			    		foreach ($this->newCardTypes as $key => $value) 
			    		{
			    			if($value == $card_type)
			    			{
			    				$card_type = $key;
			    				break;
			    			}
			    		}
		    			$this->saveCreditCard($customData['formData']['card_number'],$customData['formData']['card_name'],$customData['formData']['card_expiry'],$card_type,$authorize_result['PNREF'],$tempInfo->user_id);
		    		}

		    		$tData = $this->payment_model->createTransaction($authorize_result['PNREF'],$tempInfo->user_id,$reference,'approved',null,$orderId);
		    		
					if(isset($customData['cartData']))
		    		{
		    			$tData = $this->payment_model->tempInfoUpdateTx($reference,$authorize_result['PNREF'],0,$tData);
		    			$this->transaction_model->setNote($authorize_result['PNREF'],"Authorization transaction");
		    		}
		    		else
		    		{
		    			$tData = $this->payment_model->tempInfoUpdateTx($reference,$authorize_result['PNREF'],$amount,$tData);
		    			$this->transaction_model->setNote($authorize_result['PNREF'],"<b>".date("d M Y h:i A")."</b> (Paid)\n"."Partial payment");
		    		}
					//saving transaction table 
					$this->payment_model->saveTransaction($tData);
					//saving payment response into archives database
					$this->payment_model->savingPaymentResponse($authorize_result['PNREF'],$authorize_result,$tempInfo->user_id,"paypal",$orderId);
					$isTranresponseUpdate = true;
					$transaction=new stdClass();
					$transaction->tx=$authorize_result['PNREF'];
					$tempIpn=new stdClass();
					$tempIpn->status='approved';
					$tempIpn->amount=$amount;


					if(isset($customData['cartData']))
					{
						//saving payment response into archives database
						if(!$isTranresponseUpdate)
							$this->payment_model->savingPaymentResponse($authorize_result['PNREF'],$authorize_result,$tempInfo->user_id,"paypal",$orderId);

						$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
					}
					else
					{
						$this->orders_model->sendTransactionReceiptEmail($orderId,$authorize_result['PNREF']);
					}

					$transactionRecord=$this->payment_model->getTransaction($authorize_result['PNREF']);
					$apiReturn['redirect_url']=$transactionRecord->redirect_url;
					$apiReturn['order_id']=$orderId=$transactionRecord->order_id;
					$apiReturn['tx']=$authorize_result['PNREF'];

		    		$apiReturn['flag']=1;

		    		if(!isset($customData['cartData']))
		    		{
		    			$this->orders_model->calculateDue($orderId);
		    		}
		    		$this->payment_model->updateOrderTotalPaid($orderId,$amount,$authorize_result['PNREF']);
		    		$this->payment_model->populateTransactionReport($authorize_result['PNREF']);
		    		return $apiReturn; //Success
		    	}
		    	else
		    	{
		    		$txnid=substr(hash('sha256', mt_rand() . microtime()), 0, 20);
		    		$tData = $this->payment_model->createTransaction($txnid,$tempInfo->user_id,$reference,'failure',"Error Code:".$authorize_result['RESULT']." - Msg: ".$authorize_result['RESPMSG'],$orderId);
		    		$tData = $this->payment_model->tempInfoUpdateTx($reference,$txnid,0,$tData);
					//saving transaction table 
					$this->payment_model->saveTransaction($tData);
					//saving payment response into archives database
					$this->payment_model->savingPaymentResponse($txnid,$authorize_result,$tempInfo->user_id,"paypal",$orderId);
					$isTranresponseUpdate = true;

		    		$this->logaction->log($this->service,"PayPal Payflow error response - Error Code:".$authorize_result['RESULT']." - Msg: ".$authorize_result['RESPMSG']);
		    		$apiReturn['error_msg']=$authorize_result['RESPMSG'];
		    		return $apiReturn;
		    	}
	        }

			if(isset($customData['cartData']))
			{
				$this->logaction->log($this->service,"Making API request - Ref:".$reference.", to PayPal");
				$transactionAmounts=array();
				$amount=0;
				$has_subscription=0;
				$temp_order_id = $orderId;
				$temp_order_created = 1;
				$only_subscriptions = 0;
				$orderData=$this->orders_model->orderDataTemp($orderId);
				foreach ($orderData['order_items'] as $itemData)
				{
					if($orderData['order']->order_type==4 && $itemData->subscription==1)
					{
						$transactionAmounts[]=array(
													"amount"=>$itemData->price*$itemData->quantity,
													"onetime_charge"=>$itemData->onetime_charge,
													"subscription"=>1,
													"itemData"=>$itemData,
													"startDate"=>$itemData->schedule_dates,
													"user_id"=>$orderData['order']->user_id
												);
						$has_subscription=1;
					}
					else
					{
						$amount+=$itemData->quantity*($itemData->price+$itemData->shipping_price);
						$only_subscriptions = 1;
					}
				}
				if($has_subscription==0)
				{
					$transactionAmounts[]=array( "amount"=>$amount, "subscription"=>0 );
				}

				if($has_subscription==1 && $orderData['order']->order_type==4)
				{
					//================Store card & Payment references=============//
					if(empty($credit_card_check) && !empty($creditCardData) && isset($customData['formData']["credit_card_id"]) && $customData['formData']["credit_card_id"] != "")
			    	{
			    		$pnref = $creditCardData->payflow_pnref;
						$card_expiry_month = $creditCardData->card_expiry_month;
						$card_expiry_year = $creditCardData->card_expiry_year;

						$payment_string=$creditCardData->card_number."\n".
		    						$creditCardData->card_expiry."\n".
	    							$creditCardData->card_name."\n".
									date("dmYHis");
						$encrypted_payment_string=$this->encryption->encrypt($payment_string);
					}
					else
					{
						$expiry_dates = explode("/", $customData['formData']['card_expiry']);
						$card_expiry_month = "";
						$card_expiry_year = "";

						if(!empty($expiry_dates[0]))
							$card_expiry_month = $expiry_dates[0];

						if(!empty($expiry_dates[1]))
						{
							if($expiry_dates[1] == "00")
								$card_expiry_year = "30".$expiry_dates[1];
							else
								$card_expiry_year = "20".$expiry_dates[1];
						}

						$payment_string=$customData['formData']['card_number']."\n".
		    						str_replace("/","",$customData['formData']['card_expiry'])."\n".
	    							$customData['formData']['card_name']."\n".
									date("dmYHis");
						$encrypted_payment_string=$this->encryption->encrypt($payment_string);
					}

					$profileData=array(
										//"profile_id"=>$result_array['PROFILEID'],
										"payment_info"=>$encrypted_payment_string,
										"card_expiry_month"=>$card_expiry_month,
										"card_expiry_year"=>$card_expiry_year,
										"created_on"=>date("Y:m:d H:i:s"),
										"updated_on"=>date("Y:m:d H:i:s"),
										"order_id"=>$orderId,
										"user_id"=>$orderData['order']->user_id
									);
					$this->db->insert("subscription_profiles_payflow",$profileData);
					$s_pay_flow_profile_id = $this->db->insert_id();

					//================Store card & Payment references=============//
				}
				foreach ($transactionAmounts as $transactionDetail)
				{
					$credit_card_save_ref = "";
					if(isset($transactionDetail['subscription']) && $transactionDetail['subscription']==1)
					{
						if(!$transactionDetail['onetime_charge'])
			    		{
			    			if(empty($credit_card_check) && !empty($creditCardData) && isset($customData['formData']["credit_card_id"]) && $customData['formData']["credit_card_id"] != "")
					    	{
				    			$pnref = $creditCardData->payflow_pnref;
				    		}
				    		else
				    		{
				    			$authorize_result=$this->authorizeCard($trustData,$customData['formData']['card_number'],str_replace("/","",$customData['formData']['card_expiry']),$customData['formData']['card_cvv'],$customData['formData']);
				    			$pnref = $authorize_result['PNREF'];
				    		}
			    			$api_request_params = array (
				    			// API Data
				    			'USER' => $trustData->payflow_user,
				    			'VENDOR' => $trustData->payflow_vendor,
				    			'PARTNER' => $trustData->payflow_partner,
				    			'PWD' => $trustData->payflow_pwd,
				    			'TRXTYPE' => 'R',
				    			'TENDER' => 'C',
				    			'START'=>date("mdY",strtotime($transactionDetail['startDate'])),
				    			'TERM'=>'0',
				    			'ORIGID'=>$pnref,
				    			'AMT' => $transactionDetail['amount'],
				    			'EMAIL' => $customData['formData']['email'],
				    			'COMMENT1' => $reference,
				    			"VERBOSITY"=>"HIGH",
				    			'FREQUENCY'=>$transactionDetail['itemData']->frequency,
				    			'PROFILENAME'=>$transactionDetail['itemData']->item_name." - ".$transactionDetail['itemData']->id,
				    			'ACTION'=>'A'
				    		);
				    		$credit_card_save_ref = $pnref;
			    		}
			    		else
			    		{
			    			if(empty($credit_card_check) && !empty($creditCardData) && isset($customData['formData']["credit_card_id"]) && $customData['formData']["credit_card_id"] != "")
					    	{
				    			$api_request_params = array (
					    			// API Data
					    			'USER' => $trustData->payflow_user,
					    			'VENDOR' => $trustData->payflow_vendor,
					    			'PARTNER' => $trustData->payflow_partner,
					    			'PWD' => $trustData->payflow_pwd,
					    			'TRXTYPE' => 'R',
					    			'TENDER' => 'C',
					    			'START'=>date("mdY",strtotime($transactionDetail['startDate'])),
					    			'TERM'=>'0',
					    			'ORIGID'=>$creditCardData->payflow_pnref,
					    			'AMT' => $transactionDetail['amount'],
					    			'EMAIL' => $customData['formData']['email'],
					    			'COMMENT1' => $reference,
					    			"VERBOSITY"=>"HIGH",
					    			'FREQUENCY'=>$transactionDetail['itemData']->frequency,
					    			'PROFILENAME'=>$transactionDetail['itemData']->item_name." - ".$transactionDetail['itemData']->id,
					    			'ACTION'=>'A'
					    		);
				    		}
				    		else
				    		{
				    			$api_request_params = array (
					    			// API Data
					    			'USER' => $trustData->payflow_user,
					    			'VENDOR' => $trustData->payflow_vendor,
					    			'PARTNER' => $trustData->payflow_partner,
					    			'PWD' => $trustData->payflow_pwd,
					    			'TRXTYPE' => 'R',
					    			'TENDER' => 'C',
					    			'ACCT' => $customData['formData']['card_number'],
					    			'EXPDATE' => str_replace("/","",$customData['formData']['card_expiry']),
					    			'START'=>date("mdY",strtotime($transactionDetail['startDate'])),
					    			'TERM'=>'0',
					    			'AMT' => $transactionDetail['amount'],
					    			'BILLTOFIRSTNAME' => $customData['formData']['card_name'],
					    			'EMAIL' => $customData['formData']['email'],
					    			'BILLTOEMAIL' => $customData['formData']['email'],
					    			'COMMENT1' => $reference,
					    			"VERBOSITY"=>"HIGH",
					    			'FREQUENCY'=>$transactionDetail['itemData']->frequency,
					    			'PROFILENAME'=>$transactionDetail['itemData']->item_name." - ".$transactionDetail['itemData']->id,
					    			'ACTION'=>'A'
					    		);
				    		}
			    		}
						
			    		if($transactionDetail['onetime_charge'])
			    		{
			    			$api_request_params['OPTIONALTRX']="S";
			    			$api_request_params['OPTIONALTRXAMT']=$transactionDetail['onetime_charge'];
			    		}
			    		if($transactionDetail['itemData']->expiration_method==1)
			    		{
			    			$api_request_params['TERM']=$transactionDetail['itemData']->num_of_payments;
			    		}

			    		if($transactionDetail['itemData']->period=='days')
			    		{
			    			$api_request_params['PAYPERIOD']='DAYS';
			    		}
			    		if($transactionDetail['itemData']->period=='weeks')
			    		{
			    			$api_request_params['PAYPERIOD']='WEEK';
			    		}
			    		if($transactionDetail['itemData']->period=='months')
			    		{
			    			$api_request_params['PAYPERIOD']='MONT';
			    		}
			    		if($transactionDetail['itemData']->period=='years')
			    		{
			    			$api_request_params['PAYPERIOD']='YEAR';
			    		}

			    		$nvp = $this->toNVP($api_request_params);
				    	$result = $this->runCurl($trustData->payflow_url, $nvp);
				    	$result_array = array();
			    		parse_str($result, $result_array);
			    		$this->payflow_logs_model->log($result_array,"Subscription profile creation");
			    		if(!empty($result_array['TRXPNREF']))
			    		{
			    			$payment_id = $result_array['TRXPNREF'];
			    		}
			    		else if(!empty($result_array['PNPNREF']))
			    		{
			    			$payment_id = $result_array['PNPNREF'];
			    		}
			    		else
			    		{
			    			$payment_id = $temp_payment_id;
			    		}
			    		$credit_card_save_ref = $payment_id;
			    		if($result_array['RESULT']==0)//Success
				    	{
				    		$this->temp_payments_model->deleteTempOrder($temp_order_id);
				    		$this->temp_payments_model->deleteTempOrderItems($temp_order_id);
				    		$this->temp_payments_model->deleteTempTransaction($temp_payment_id);
				    		//Delete Temp orders and temp transaction before creating original order and original transaction
				    		$tData = $this->payment_model->createTransaction($payment_id,$tempInfo->user_id,$reference,'approved',null,$orderId);
				    		$tData = $this->payment_model->tempInfoUpdateTx($reference,$payment_id,$transactionDetail['onetime_charge'],$tData);
							//saving transaction table 
							$this->payment_model->saveTransaction($tData);
							//saving payment response into archives database
							$this->payment_model->savingPaymentResponse($payment_id,$result_array,$tempInfo->user_id,"paypal",$orderId);
				    		$transaction=new stdClass();
							$transaction->tx=$payment_id;
							$tempIpn=new stdClass();
							$tempIpn->status='approved';
							$tempIpn->amount=$transactionDetail['onetime_charge'];
					    	$orderId=$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
					    	$transactionRecord=$this->payment_model->getTransaction($payment_id);
				    		$this->transaction_model->updateDetails($payment_id,array("order_item_id"=>$transactionRecord->order_item_id));
				    		$this->payment_model->updatePayFlowTransaction($payment_id,$result_array);
				    		$this->payment_model->updateOrderTotalPaid($orderId,$transactionDetail['onetime_charge'],$payment_id);
				    		$this->payment_model->populateTransactionReport($payment_id);
				    		if($transactionDetail['onetime_charge'])
				    		{
					    		$this->orders_model->sendTransactionReceiptEmail($orderId,$payment_id);
					    		$this->orders_model->sendTransactionReceiptEmailBcc($orderId,$payment_id);
					    	}
					    	if(empty($result_array['ACCT']))
					    		$result_array['ACCT'] = substr($customData['formData']['card_number'], -4);

					    	if(empty($result_array['EXPDATE']))
					    		$result_array['EXPDATE'] = str_replace("/","",$customData['formData']['card_expiry']);

					    	if(empty($result_array['CARDTYPE']))
					    	{
					    		$card_type = $this->getCardBrand($customData['formData']['card_number']);
					    		foreach ($this->newCardTypes as $key => $value) 
					    		{
					    			if($value == $card_type)
					    			{
					    				$card_type = $key;
					    				break;
					    			}
					    		}
					    		$result_array['CARDTYPE'] = $card_type;
					    	}
					    	
					    	if(empty($result_array['TRANSTIME']))
					    		$result_array['TRANSTIME'] = date("dmYHis");

					    	if(empty($credit_card_check) && empty($creditCardData) && !empty($customData['formData']['save_credit_card']) && $customData['formData']['save_credit_card'] == 1)
				    		{
				    			$this->saveCreditCard($customData['formData']['card_number'],$customData['formData']['card_name'],$customData['formData']['card_expiry'],$result_array['CARDTYPE'],$credit_card_save_ref,$tempInfo->user_id);
				    		}

				    		if(empty($credit_card_check) && !empty($creditCardData) && isset($customData['formData']["credit_card_id"]) && $customData['formData']["credit_card_id"] != "")
			    			{
			    				$result_array['ACCT'] = $creditCardData->card_number;
								$result_array['EXPDATE'] = $creditCardData->card_expiry;
								$result_array['CARDTYPE'] = $creditCardData->card_type;
						    	$this->updateSubscriptionProfileID($creditCardData->card_name,$payment_id,$result_array,$orderId,$s_pay_flow_profile_id);
						    }
						    else
						    {
						    	$this->updateSubscriptionProfileID($customData['formData']['card_name'],$payment_id,$result_array,$orderId,$s_pay_flow_profile_id);
						    }
					    	$original_transactionAmounts=array();
					    	$original_orderData=$this->orders_model->orderData($orderId);
							foreach ($original_orderData['order_items'] as $original_itemData)
							{
								if($original_orderData['order']->order_type==4 && $original_itemData->subscription==1)
								{
									$original_transactionAmounts[]=array( "itemData"=>$original_itemData );
								}
							}
							foreach ($original_transactionAmounts as $original_transactionDetail)
							{
								$this->orders_model->updateSubscription($original_transactionDetail['itemData']->order_item_id,$result_array,$original_transactionDetail['itemData']);
							}
							$apiReturn['redirect_url']=$transactionRecord->redirect_url;
							$apiReturn['order_id']=$orderId=$transactionRecord->order_id;
							$apiReturn['tx']=$payment_id;
				    		$apiReturn['flag']=1;
						}
						else
						{
							$orderData = $this->temp_payments_model->getOrderDataTemp($temp_order_id);
							$apiReturn['error_msg']=$result_array['RESPMSG'];
							$orderData["response_message"] = $result_array['RESPMSG'];
							$this->temp_payments_model->createFailedOrder($orderData);
							//Delete Temp orders and temp transaction after creating Failed Order
							$this->temp_payments_model->deleteTempOrder($temp_order_id);
				    		$this->temp_payments_model->deleteTempOrderItems($temp_order_id);
				    		$this->temp_payments_model->deleteTempTransaction($payment_id);
						}
					}
					else
					{
						if(empty($credit_card_check) && !empty($creditCardData) && isset($customData['formData']["credit_card_id"]) && $customData['formData']["credit_card_id"] != "")
				    	{
				    		$api_request_params = array (
				    			// API Data
				    			'USER' => $trustData->payflow_user,
				    			'VENDOR' => $trustData->payflow_vendor,
				    			'PARTNER' => $trustData->payflow_partner,
				    			'PWD' => $trustData->payflow_pwd,
				    			'TRXTYPE' => 'S',
				    			'TENDER' => 'C',
				    			'ORIGID'=>$creditCardData->payflow_pnref,
				    			'AMT' => $transactionDetail['amount'],
				    			'COMMENT1' => $reference,
				    			"VERBOSITY"=>"HIGH"
				    		);
				    	}
				    	else
				    	{
							$api_request_params = array (
				    			// API Data
				    			'USER' => $trustData->payflow_user,
				    			'VENDOR' => $trustData->payflow_vendor,
				    			'PARTNER' => $trustData->payflow_partner,
				    			'PWD' => $trustData->payflow_pwd,
				    			'TRXTYPE' => 'S',
				    			'TENDER' => 'C',
				    			'ACCT' => $customData['formData']['card_number'],
				    			'EXPDATE' => str_replace("/","",$customData['formData']['card_expiry']),
				    			'CVV2' => $customData['formData']['card_cvv'],
				    			'AMT' => $transactionDetail['amount'],
				    			'BILLTOFIRSTNAME' => $customData['formData']['card_name'],
				    			'BILLTOEMAIL' => $customData['formData']['email'],
				    			'COMMENT1' => $reference,
				    			"VERBOSITY"=>"HIGH"
				    		);
						}
			    		$nvp = $this->toNVP($api_request_params);
				    	$result = $this->runCurl($trustData->payflow_url, $nvp);
				    	$result_array = array();
			    		parse_str($result, $result_array);
			    		$this->payflow_logs_model->log($result_array,"Normal payment");
			    		if($result_array['RESULT']==0)//Success
				    	{

				    		if(empty($credit_card_check) && empty($creditCardData) && !empty($customData['formData']['save_credit_card']) && $customData['formData']['save_credit_card'] == 1)
				    		{
				    			$card_type = $this->getCardBrand($customData['formData']['card_number']);
					    		foreach ($this->newCardTypes as $key => $value) 
					    		{
					    			if($value == $card_type)
					    			{
					    				$card_type = $key;
					    				break;
					    			}
					    		}
				    			$this->saveCreditCard($customData['formData']['card_number'],$customData['formData']['card_name'],$customData['formData']['card_expiry'],$card_type,$result_array['PNREF'],$tempInfo->user_id);
				    		}
				    		$this->temp_payments_model->deleteTempOrder($orderId);
				    		$this->temp_payments_model->deleteTempOrderItems($orderId);
				    		$this->temp_payments_model->deleteTempTransaction($payment_id);
				    		//Delete Temp orders and temp transaction before creating original order and original transaction
				    		$payment_id = $result_array['PNREF'];
				    		$tData = $this->payment_model->createTransaction($result_array['PNREF'],$tempInfo->user_id,$reference,'approved',null,$orderId);
				    		$tData = $this->payment_model->tempInfoUpdateTx($reference,$result_array['PNREF'],$transactionDetail['amount'],$tData);
							//saving transaction table 
							$this->payment_model->saveTransaction($tData);
							//saving payment response into archives database
							$this->payment_model->savingPaymentResponse($result_array['PNREF'],$result_array,$tempInfo->user_id,"paypal",$orderId);
				    		//$orderId=$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
				    		$this->payment_model->updatePayFlowTransaction($result_array['PNREF'],$result_array);
				    		$transaction=new stdClass();
							$transaction->tx=$result_array['PNREF'];
							$tempIpn=new stdClass();
							$tempIpn->status='approved';
							$tempIpn->amount=$amount;
							$orderId=$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
							$transactionRecord=$this->payment_model->getTransaction($payment_id);
							$this->orders_model->sendTransactionReceiptEmail($orderId,$result_array['PNREF']);
							$apiReturn['redirect_url']=$transactionRecord->redirect_url;
							$apiReturn['order_id']=$orderId=$transactionRecord->order_id;
							$apiReturn['tx']=$result_array['PNREF'];
				    		$apiReturn['flag']=1;
						}
						else
						{
							$orderData = $this->temp_payments_model->getOrderDataTemp($orderId);
							$apiReturn['error_msg']=$result_array['RESPMSG'];
							$orderData["response_message"] = $result_array['RESPMSG'];
							$this->temp_payments_model->createFailedOrder($orderData);
							//Delete Temp orders and temp transaction after creating Failed Order
							$this->temp_payments_model->deleteTempOrder($orderId);
				    		$this->temp_payments_model->deleteTempOrderItems($orderId);
				    		$this->temp_payments_model->deleteTempTransaction($payment_id);
						}
					}
				}
			}
			return $apiReturn;
		}
		else
		{
			$this->logaction->log($this->service,"Direct payment method - Invalid Ref:".$reference."  - redirected back");
			return $apiReturn;
		}
    }

    public function saveCreditCard($card_number,$card_name,$card_expiry,$card_type,$pnref,$uid)
    {
    	////****Save Card*****////
		$lastFourDigits=substr( $card_number,-4);
		$this->load->model("credit_cards_model");
		if(!$this->credit_cards_model->cardExist($lastFourDigits,$uid))
		{
			$this->credit_cards_model->saveCard(
												$uid,
												$lastFourDigits,
												str_replace("/","",$card_expiry),
												$card_name,
												$card_type,
												$pnref
											);
		}
		////****Save Card*****////
    }

    public static function getCardBrand($pan, $include_sub_types = false)
	{
		/*$cardtype=$this->paypal_model->getCardBrand("4012888888881881",true);
        echo $cardtype;
        exit;*/
	    //maximum length is not fixed now, there are growing number of CCs has more numbers in length, limiting can give false negatives atm

	    //these regexps accept not whole cc numbers too
	    //visa
	    $visa_regex = "/^4[0-9]{0,}$/";
	    $vpreca_regex = "/^428485[0-9]{0,}$/";
	    $postepay_regex = "/^(402360|402361|403035|417631|529948){0,}$/";
	    $cartasi_regex = "/^(432917|432930|453998)[0-9]{0,}$/";
	    $entropay_regex = "/^(406742|410162|431380|459061|533844|522093)[0-9]{0,}$/";
	    $o2money_regex = "/^(422793|475743)[0-9]{0,}$/";

	    // MasterCard
	    $mastercard_regex = "/^(5[1-5]|222[1-9]|22[3-9]|2[3-6]|27[01]|2720)[0-9]{0,}$/";
	    $maestro_regex = "/^(5[06789]|6)[0-9]{0,}$/";
	    $kukuruza_regex = "/^525477[0-9]{0,}$/";
	    $yunacard_regex = "/^541275[0-9]{0,}$/";

	    // American Express
	    $amex_regex = "/^3[47][0-9]{0,}$/";

	    // Diners Club
	    $diners_regex = "/^3(?:0[0-59]{1}|[689])[0-9]{0,}$/";

	    //Discover
	    $discover_regex = "/^(6011|65|64[4-9]|62212[6-9]|6221[3-9]|622[2-8]|6229[01]|62292[0-5])[0-9]{0,}$/";

	    //JCB
	    $jcb_regex = "/^(?:2131|1800|35)[0-9]{0,}$/";

	    //ordering matter in detection, otherwise can give false results in rare cases
	    if (preg_match($jcb_regex, $pan)) {
	        return "jcb";
	    }

	    if (preg_match($amex_regex, $pan)) {
	        return "amex";
	    }

	    if (preg_match($diners_regex, $pan)) {
	        return "diners_club";
	    }

	    //sub visa/mastercard cards
	    if ($include_sub_types) {
	        if (preg_match($vpreca_regex, $pan)) {
	            return "v-preca";
	        }
	        if (preg_match($postepay_regex, $pan)) {
	            return "postepay";
	        }
	        if (preg_match($cartasi_regex, $pan)) {
	            return "cartasi";
	        }
	        if (preg_match($entropay_regex, $pan)) {
	            return "entropay";
	        }
	        if (preg_match($o2money_regex, $pan)) {
	            return "o2money";
	        }
	        if (preg_match($kukuruza_regex, $pan)) {
	            return "kukuruza";
	        }
	        if (preg_match($yunacard_regex, $pan)) {
	            return "yunacard";
	        }
	    }

	    if (preg_match($visa_regex, $pan)) {
	        return "visa";
	    }

	    if (preg_match($mastercard_regex, $pan)) {
	        return "mastercard";
	    }

	    if (preg_match($discover_regex, $pan)) {
	        return "discover";
	    }

	    if (preg_match($maestro_regex, $pan)) 
	    {
	        if ($pan[0] == '5') { //started 5 must be mastercard
	            return "mastercard";
	        }
	        return "maestro"; //maestro is all 60-69 which is not something else, thats why this condition in the end

	    }

	    return "unknown"; //unknown for this system
	}

    public function updateSubscriptionProfileID($card_name,$payment_id,$result_array,$order_id,$payflow_id)
    {
    	if(!empty($order_id) && !empty($payflow_id))
		{
			$payment_string=$result_array['ACCT']."\n".
						$result_array['EXPDATE']."\n".
						$result_array['CARDTYPE']."\n".
						$card_name."\n".
						$payment_id."\n".
						$result_array['TRANSTIME'];
			$encrypted_payment_string=$this->encryption->encrypt($payment_string);
			$this->db->where("id",$payflow_id);
			$this->db->update("subscription_profiles_payflow",array("order_id"=>$order_id,"payment_info"=>$encrypted_payment_string));
		}
    }
    

    public function subscriptionInquiry($profileId,$ashramId,$cartType,$currency)
    {
    	//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$cartType);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[$currency];
		//Get trust data
		
    	$api_request_params = array (
		    			// API Data
		    			'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
		    			'TRXTYPE' => 'R',
		    			'ACTION'=>'I',
		    			'ORIGPROFILEID'=>$profileId,
		    	);
    	$nvp = $this->toNVP($api_request_params);
    	$result = $this->runCurl($trustData->payflow_url, $nvp);
    	$result_array = array();
		parse_str($result, $result_array);
		//$this->payflow_logs_model->log($result_array,"Subscription cancellation");
		return $result_array;
    }

    public function changeCard($trustData,$authorize_result,$profileId)
    {
		if($authorize_result['RESULT']==0)
		{
    		$api_request_params = array (
		    			'USER' => $trustData->payflow_user,
		    			'VENDOR' => $trustData->payflow_vendor,
		    			'PARTNER' => $trustData->payflow_partner,
		    			'PWD' => $trustData->payflow_pwd,
		    			'ORIGPROFILEID'=>$profileId,
		    			'TRXTYPE' => 'R',
		    			'TENDER' => 'C',
		    			'ACTION'=>'M',
		    			'ORIGID'=>$authorize_result['PNREF'],
		    			"VERBOSITY"=>"HIGH"
		    	);
	    	$nvp = $this->toNVP($api_request_params);
	    	$result = $this->runCurl($trustData->payflow_url, $nvp);
	    	$result_array = array();
			parse_str($result, $result_array);
			$this->payflow_logs_model->log($result_array,"Change card");
			return $result_array;
		}
		else
			return 0;
    }

    public function cancelSubscription($profileId,$ashramId,$cartType,$currency)
    {
    	//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$cartType);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[$currency];
		//Get trust data
		
    	$api_request_params = array (
		    			// API Data
		    			'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
		    			'TRXTYPE' => 'R',
		    			'ACTION'=>'C',
		    			'ORIGPROFILEID'=>$profileId,
		    	);
    	$nvp = $this->toNVP($api_request_params);
    	$result = $this->runCurl($trustData->payflow_url, $nvp);
    	$result_array = array();
		parse_str($result, $result_array);
		$this->payflow_logs_model->log($result_array,"Subscription cancellation");
		return $result_array;
    }

    public function activateSubscription($profileId,$ashramId,$cartType,$currency,$nextPaymentDate)
    {
    	//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$cartType);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[$currency];
		//Get trust data

    	$api_request_params = array (
		    			// API Data
		    			'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
		    			'TRXTYPE' => 'R',
		    			'ACTION'=>'R',
		    			'START'=>date("mdY",strtotime($nextPaymentDate)),
		    			'ORIGPROFILEID'=>$profileId,
		    	);
    	$nvp = $this->toNVP($api_request_params);
    	$result = $this->runCurl($trustData->payflow_url, $nvp);
    	$result_array = array();
		parse_str($result, $result_array);
		$this->payflow_logs_model->log($result_array,"Subscription activation");
		return $result_array;
    }

    public function retrySubscriptionPayment($profileId,$ashramId,$cartType,$currency,$paymentNumber)
    {
    	//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$cartType);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[$currency];
		//Get trust data

    	$api_request_params = array (
		    			// API Data
		    			'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
		    			'TRXTYPE' => 'R',
                        'ACTION'=>'P',
		    			'PAYMENTNUM'=>$paymentNumber,
		    			'ORIGPROFILEID'=>$profileId,
		    	);
    	$nvp = $this->toNVP($api_request_params);
    	$result = $this->runCurl($trustData->payflow_url, $nvp);
    	$result_array = array();
		parse_str($result, $result_array);
		$this->payflow_logs_model->log($result_array,"Subscription activation");
		return $result_array;
    }

    private function runCurl($api_endpoint, $nvp)
    {
    	$curl = curl_init();
    	curl_setopt($curl, CURLOPT_VERBOSE, 1);
    	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
    	//curl_setopt($curl, CURLOPT_TIMEOUT, 30);
    	curl_setopt($curl, CURLOPT_URL, $api_endpoint);
    	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    	curl_setopt($curl, CURLOPT_POSTFIELDS, $nvp);
    	$result = curl_exec($curl);
    	//echo curl_error($curl);
    	// close
    	curl_close($curl);
    	return $result;
    }

    private function toNVP($array) {
    	$i = 0;
    	$nvp = "";
    	foreach($array as $key => $val) {
    		if($i != 0) {
    			$nvp .= "&";
    		}
    		$nvp .= $key . '=' . $val;
    		$i++;
    	}
    	return $nvp;
    }

    public function subscriptionPayments($profileId,$ashramId,$cartType,$currency)
    {
    	//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$cartType);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[$currency];
		//Get trust data
    	$api_request_params = array
    			(
                        'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
                        'ORIGPROFILEID'=>$profileId,
                        'PAYMENTHISTORY'=>'Y',
                        'TRXTYPE' => 'R',
                        'ACTION'=>'I',
                        "VERBOSITY"=>"HIGH"
                );
        $nvp = $this->toNVP($api_request_params);
        $result = $this->runCurl($trustData->payflow_url, $nvp);
        $result_array = array();
        parse_str($result, $result_array);

        $this->payflow_logs_model->log($result_array,"Subscription read");
        return $result_array;
    }

    public function expireSubscription($profileId,$ashramId,$cartType,$currency)
    {
    	//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$cartType);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[$currency];
		//Get trust data
    	$api_request_params = array
    			(
                        'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
                        'ORIGPROFILEID'=>$profileId,
                        'PAYMENTHISTORY'=>'Y',
                        'TRXTYPE' => 'R',
                        'ACTION'=>'I',
                        "VERBOSITY"=>"HIGH"
                );
        $nvp = $this->toNVP($api_request_params);
        $result = $this->runCurl($trustData->payflow_url, $nvp);
        $result_array = array();
        parse_str($result, $result_array);

        $this->payflow_logs_model->log($result_array,"Subscription expiration");

        return $result_array;
    }

    public function recurringBillingReport($startDate,$endDate,$currency)
    {
        //Get trust data
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId(7,4);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        $trustData=$trustsArray[$currency];
        //Get trust data
        $api_request_params = array
                (
                        'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
                        'TRXTYPE' => 'R',
                        'ACTION'=>'I',
                        // 'TENDER'=>'C',
                        // 'START'=>$startDate,
                        // 'END'=>$endDate,
                        "VERBOSITY"=>"HIGH",
                        'ORIGPROFILEID'=>"",
                        // 'PAYMENTHISTORY'=>'Y',
                );
        // echo '<pre>'; print_r($api_request_params); die();
        $nvp = $this->toNVP($api_request_params);
        $result = $this->runCurl($trustData->payflow_url, $nvp);
        echo '<pre>'; print_r($result); die();
        $result_array = array();
        parse_str($result, $result_array);

        $this->payflow_logs_model->log($result_array,"Subscription read");
        return $result_array;
    }
}
?>