<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Logaction extends CI_Model 
{
	function __construct() 
	{
		parent::__construct();
	}
	
	public function log($service,$action,$query='')
	{
		$config =& get_config();
		$log_path = dirname($_SERVER['SCRIPT_FILENAME'])."/serverlogs/";
		if(isset($_SERVER['HTTP_REFERER']))
		{
		   $ref=$_SERVER['HTTP_REFERER'];
		}
		else
			$ref='';
		$sapi_type = php_sapi_name();
		$username='';
		if(substr($sapi_type, 0, 3) == 'cli' || empty($_SERVER['REMOTE_ADDR']))
		{
    		$username='System';
		}
		else
		{
			if($this->session->userdata('id'))
			{
				$userData=$this->session->userdata('admin_data');
				$username=$userData->username;
			}
			else if($this->session->userdata('user_id'))
			{
				$userData=$this->session->userdata('user_data');
				$username=$userData->username;
			}
		}
		$server_protocol="http";
		if(isset($_SERVER['SERVER_PROTOCOL']))
			$server_protocol=$_SERVER['SERVER_PROTOCOL'];

		if(php_sapi_name()=='cli')
		{
			$server_protocol='cli';
		}

		$remote_ip='';
		if(empty($_SERVER['REMOTE_ADDR']))
		{
			$remote_ip='127.0.0.1';
		}
		else
		{
			$remote_ip=$_SERVER['REMOTE_ADDR'];
		}

		$file=dirname($_SERVER['SCRIPT_FILENAME'])."/serverlogs/".date("Y-m-d")."_".base_domain."_actionlog-".$service.".csv";
		if (is_dir($log_path) && is_really_writable($log_path))
		{
			$heading = "Service~~~Username~~~Date~~~Local Date~~~Local Timezone~~~User IP~~~Server IP~~~Server Name~~~Protocol Version~~~Type~~~Referer~~~URL~~~Session ID~~~Operating System~~~Browser~~~Message~~~DB Query\n";
			$localTimeZone= date_default_timezone_get();
			$localTime=date("Y-m-d H:i:s");
			date_default_timezone_set("Asia/Kolkata");

			$message=$service."~~~".$username."~~~".date("Y-m-d H:i:s")."~~~".$localTime."~~~".$localTimeZone."~~~".$remote_ip."~~~".server_ip."~~~".server_name."~~~".$server_protocol."~~~INFO~~~".trim($ref)."~~~".current_url()."~~~".$this->session->userdata('session_id')."~~~".$this->agent->platform()."~~~".$this->agent->browser()." ".$this->agent->version()."~~~".$action."~~~".$query."\n";
			
			date_default_timezone_set($localTimeZone);

			if (!file_exists($file))
			{
				$message=$heading.$message;
			}

			if (!$fp = @fopen($file, FOPEN_WRITE_CREATE))
			{
				return false;
			}


			flock($fp, LOCK_EX);
			fwrite($fp, $message);
			flock($fp, LOCK_UN);
			fclose($fp);
			@chmod($file, FILE_READ_MODE);
		}
	}
}
?>