<?PHP
class Live_updates_Model extends CI_Model
{
	var $tableName='live_updates';
	var $siteServivcesDb = "";
	function __construct()
	{
        parent::__construct();
        $this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	function messageData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$query = $this->siteServivcesDb->get($this->tableName);
		return $query->row();
	}

	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4)
		{
			$this->siteServivcesDb->where('ashram_id',$this->currentUser->ashram_id);
		}
		$this->siteServivcesDb->select('count(id) as c');
		$this->siteServivcesDb->where_in('status',array(1));
		$q=$this->siteServivcesDb->get($this->tableName)->row();
		return $q->c;
	}
	
	public function listPublic()
	{
		$i=0;

		$query1=$this->siteServivcesDb;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		
		$query1->from($this->tableName);

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->like('message',$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
		}

		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(created_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(created_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
		}

		if(isset($_POST['type']) && is_numeric($_POST['type']))
		{
			$query1->where("type",$_POST['type']);
		}
		
		$per_page=10;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("created_on","desc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();
		$colors=array("red","blue","orange","green","purple");
		$ii=0;
		$ids=array();
		foreach ($rtn['res'] as $key=> $row) 
		{
			if($ii==5)
				$ii=0;
			$rtn['res'][$key]->color=$colors[$ii];
			$rtn['res'][$key]->message=strip_tags($row->message,"<p><u><em>");
			$rtn['res'][$key]->created_on=date("d M Y h:i A",strtotime($row->created_on));
			if($rtn['res'][$key]->type==2)
			{
				$rtn['res'][$key]->image_filename=aws_s3_base_url."content/liveupdates/".$row->image_filename;
				//$rtn['res'][$key]->image_data='data:image/jpg;base64,'.base64_encode(file_get_contents($rtn['res'][$key]->image_filename));
			}
			$ii++;
		}

		return $rtn;
	}

	public function listMessages($api=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);

		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),"after");
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),'before');
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
			} */
		}

		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(created_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(created_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
		}

		if(isset($_POST['type']) && is_numeric($_POST['type']))
		{
			$query1->where("type",$_POST['type']);
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$query1->order_by('created_on','desc');

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['image']='';
			$rtn['data'][$c]['date']=date("d M Y h:i A",strtotime($row['created_on']));
			if($rtn['data'][$c]['type']==2)
			{
				$rtn['data'][$c]['image']=aws_s3_base_url."content/liveupdates/".$row['image_filename'];
			}
			//getting notification data
			$notificationData = $this->mobileNotifications_model->getNotificationIDBasedOnService($row['id'],'liveupdates');
			$rtn['data'][$c]['notification_id'] = -1;
			if(!empty($notificationData)){
				$rtn['data'][$c]['notification_id'] = 0;
				if($notificationData->is_sent == 0){
					$rtn['data'][$c]['notification_id'] = $notificationData->id;
				}
			}
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function updateOrder($id,$value)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array('order'=>$value));
	}
	public function getAllMessages()
	{
		$this->siteServivcesDb->order_by("order",'asc');
		$this->siteServivcesDb->order_by("created_on",'desc');
		//$this->siteServivcesDb->where("type",1);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}
	public function save()
	{
		$status=0;
		$type=$_POST['type'];
		$message=$this->general_model->filtertext(trim($_POST['message']));
		if($type==1)
		{
			$data=array(
						"message"=>$message,
						"created_on"=>date("Y:m:d H:i:s"),
						'type'=>$_POST['type']
						);
			$this->one_signal->sendNotification(html_entity_decode(strip_tags("New Update - ".$message)),1,array("key"=>"liveupdates","id"=>null));
			$status=1;
		}
		if($type==2)
		{
			$fname=$_FILES['message_image']['name'];
			$ext=pathinfo ($_FILES['message_image']['name'],PATHINFO_EXTENSION);
			$newname='dattapeetham_live_update_'.substr(md5(mt_rand()), 0, 16).".".$ext;
			$tempPath=$_FILES['message_image']['tmp_name'];
			$this->load->helper("image");
			$image = new SimpleImage();
			$image->load($tempPath);
			$img_width=$image->getWidth();
	    	$img_height=$image->getHeight();
	    	$ratio=$img_width/$img_height;
	      
			if($ratio>=1)
			{
				if($img_width>600)
					$image->resizeToWidth(600);
			}
			else
			{
				if($img_height>600)
					$image->resizeToHeight(600);
			}
			$image->save($tempPath);

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$amazonUri="content/liveupdates/";
			$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());

			$data=array(
						"message"=>$this->general_model->filtertext(trim($_POST['message'])),
						"image_filename"=>$newname,
						"created_on"=>date("Y:m:d H:i:s"),
						'type'=>$_POST['type']
						);
			$this->one_signal->sendNotification(aws_s3_base_url.$amazonUri.$newname,2,array("key"=>"liveupdates","id"=>null));
			$status=1;
		}
		if($type==3)
		{
			if($this->input->post("video_type")==1)
			{
				$yApiKey=youtube_api_key;

				if(!preg_match("/www.youtube.com/",$_POST['video_url']) || !preg_match("/v=/",$_POST['video_url']))
				{
					$status=3; //Invalid video
					goto end;
				}
				$urlParts=explode("v=",$_POST['video_url']);
				$videoId=$urlParts[1];

				$url = "https://www.googleapis.com/youtube/v3/videos?id=".$videoId."&key=".$yApiKey."&part=snippet,contentDetails,statistics";
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_REFERER, base_url);
				curl_setopt($ch, CURLOPT_URL,$url);
				$output=curl_exec($ch);
				$response = json_decode($output, TRUE);
				curl_close($ch);

				if(!isset($response['items']) || count($response['items'])==0)
				{
					$status=3; //Invalid video
					goto end;
				}

				$title=$response['items'][0]['snippet']['title'];
				if(isset($response['items'][0]['snippet']['thumbnails']['high']['url']))
					$thumb=$response['items'][0]['snippet']['thumbnails']['high']['url'];
				else
					$thumb='';
				if(isset($response['items'][0]['contentDetails']['duration']))
				{
					$duration=$response['items'][0]['contentDetails']['duration'];
					$str1=str_replace("PT","",$duration);
					if(preg_match("/h/i",$str1))
					{
						$hh=explode("H",$str1);
						$hours=$hh[0];
						$mm=explode("M",$hh[1]);
						$minutes=$mm[0];
						$seconds=abs($mm[1]);

						$duration=sprintf('%02d:%02d:%02d', $hours,$minutes,$seconds);
					}
					else
					{
						$a1=explode("M",$str1);
						$minutes=$a1[0];
						$seconds=abs($a1[1]);
						$duration=sprintf('%02d:%02d', $minutes,$seconds);
					}
				}
				else
					$duration='00:00';
			}
			if($this->input->post("video_type")==2)
			{
				$vToken=vimeo_access_token;

				if(!preg_match("/vimeo.com/",$_POST['video_url']))
				{
					$status=4; //Invalid video
					goto end;
				}
				$urlParts=explode("/",$_POST['video_url']);
				$parts_num=count($urlParts);
				
				if(!is_numeric($urlParts[$parts_num-1]))
				{
					$status=4; //Invalid video
					goto end;
				}

				$videoId=$urlParts[$parts_num-1];
				$url="https://api.vimeo.com/videos/".$videoId."?fields=name,duration,pictures,description";

				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $url);
				curl_setopt($ch, CURLOPT_HTTPHEADER,
								array(
										'Authorization: Bearer '.$vToken,
										'Content-Type: application/json',
				    					'Accept: application/json'
									)
								);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				$output = curl_exec($ch);
				curl_close($ch);
				$response=json_decode($output,true);

				if(isset($response['error']))
				{
					$status=4;
					goto end;
				}

				$title=$response['name'];
			}

			$data=array(
						"message"=>$this->general_model->filtertext(trim($_POST['message'])),
						"video_url"=>$_POST['video_url'],
						"video_title"=>$title,
						"video_id"=>$videoId,
						"video_type"=>$this->input->post("video_type"),
						"created_on"=>date("Y:m:d H:i:s"),
						'type'=>$_POST['type']
						);
			$status=1;
			$this->one_signal->sendNotification(html_entity_decode(strip_tags("New Update - ".$message)),1,array("key"=>"liveupdates","id"=>null));
		}

		if($type==4)
		{
			$fname=$_FILES['update_file']['name'];
			$ext=pathinfo ($_FILES['update_file']['name'],PATHINFO_EXTENSION);
			$newname='dattapeetham_live_update_'.substr(md5(mt_rand()), 0, 16).".".$ext;
			$tempPath=$_FILES['update_file']['tmp_name'];

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$amazonUri="content/liveupdates/";
			$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());

			$data=array(
						"message"=>$this->general_model->filtertext(trim($_POST['message'])),
						"filename"=>$newname,
						"created_on"=>date("Y:m:d H:i:s"),
						'type'=>$_POST['type']
						);
			$status=1;
			$this->one_signal->sendNotification(html_entity_decode(strip_tags("New Update - ".$message)),1,array("key"=>"liveupdates","id"=>null));
		}
		$q=null;
		if($status==1)
			$q=$this->siteServivcesDb->insert($this->tableName,$data);

		end:
		if($status==1 && $q)
		{
			$insert_id = $this->siteServivcesDb->insert_id();
			//saving live updates content for notifications
			$this->mobileNotifications_model->addNotification('Live Updates',html_entity_decode(strip_tags($this->general_model->filtertext(trim($_POST['message'])))),$insert_id,'liveupdates');
			return 1;
		}
		else
		{
			return $status;
		}
	}
	/*public function addMessage($message)
	{
		$this->siteServivcesDb->insert($this->tableName,
			array(
					"message"=>$this->general_model->filtertext(trim($message)),
					"created_on"=>date("Y:m:d H:i:s"),
				));
	}*/
	function delete($id,$messageData)
	{
		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$amazonUri="content/liveupdates/".$messageData->image_filename;
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);

		$this->siteServivcesDb->where("id",$id);
		$query = $this->siteServivcesDb->delete($this->tableName);
		if($query) return 1;
		else return 0;
	}
}
?>