<?PHP
class Fifth_generation_devotees_model extends CI_Model 
{
	private $tableName="fifth_generation_devotees";
	var $miscServicesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->miscServicesDb = $this->load->database("misc_services",true,false);
	}

	function save($id)
    {
        if($id==0)
        {
        	$country_name='';
			$country_id='';
        	if($this->input->post('country_isd_code')!='')
			{
				$this->load->model("locations_model");
				$countryData=$this->locations_model->getCountryByIsd($this->input->post('country_isd_code'));
				$country_name=$countryData->country_name;
				$country_id=$countryData->country_id;
			}
            $query=$this->miscServicesDb->insert($this->tableName,
                            array(
                            	'fifth_generation' => $this->input->post('fifth_generation'),
			                    'fourth_generation' => $this->input->post('fourth_generation'),
			                    'third_generation' => $this->input->post('third_generation'),
			                    'second_generation' => $this->input->post('second_generation'),
			                    'gender' => $this->input->post('gender'),
			                    'first_generation' => $this->input->post('first_generation'),
			                    'city' => $this->input->post('city'),
			                    'state' => $this->input->post('state'),
			                    'address' => $this->input->post('address'),
			                    'country_isd_code' => $this->input->post('country_isd_code'),
			                    'country' => $country_name,
			                    'country_id' => $country_id,
			                    'phone' => $this->input->post('phone'),
			                    'email' => $this->input->post('email'),
                                'created_by'=>$this->currentUser->id,
                                'created_on'=>date("Y:m:d H:i:s"),
                            )
                            );
            $idd=$this->miscServicesDb->insert_id();
        }
        else
        {
        	$country_name='';
			$country_id='';
        	if($this->input->post('country_isd_code')!='')
			{
				$this->load->model("locations_model");
				$countryData=$this->locations_model->getCountryByIsd($this->input->post('country_isd_code'));
				$country_name=$countryData->country_name;
				$country_id=$countryData->country_id;
			}

            $this->miscServicesDb->where("id",$id);
            $query = $this->miscServicesDb->update($this->tableName,
                                array(
                                'fifth_generation' => $this->input->post('fifth_generation'),
			                    'fourth_generation' => $this->input->post('fourth_generation'),
			                    'third_generation' => $this->input->post('third_generation'),
			                    'second_generation' => $this->input->post('second_generation'),
			                    'gender' => $this->input->post('gender'),
			                    'first_generation' => $this->input->post('first_generation'),
			                    'city' => $this->input->post('city'),
			                    'state' => $this->input->post('state'),
			                    'address' => $this->input->post('address'),
			                    'country_isd_code' => $this->input->post('country_isd_code'),
			                    'country' => $country_name,
			                    'country_id' => $country_id,
			                    'phone' => $this->input->post('phone'),
			                    'email' => $this->input->post('email'),
                                'modified_on'=>date("Y:m:d H:i:s"),
                                'modified_by'=>$this->currentUser->id,
                                ));
            $idd=$id;
        }

         if(isset($_FILES['profile_image']))
         {
			if($_FILES['profile_image']['name']!='')
			{
				$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
				$this->load->helper('image');
				$name=$_FILES['profile_image']['name'];
				$pre=explode(".",$name);
				$ncnt=count($pre);
				$ext=$pre[$ncnt-1];
				
				$filename="fifth_generation_".$idd."_".substr(md5(mt_rand()), 0, 16).".".$ext;
				
				$basePath=$_SERVER['DOCUMENT_ROOT']."/images/5thgeneration/";
				if(!is_dir($basePath))
				{
					mkdir($basePath,0777,true);
				}
				$path=$basePath.$filename;
				move_uploaded_file($_FILES['profile_image']['tmp_name'],$path);
				$amazonUri="images/5thgeneration/";
				$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$filename,S3::ACL_PUBLIC_READ, array(), array());
				unlink($path);
				$update_data['photo'] = $filename;
			}
			if($update_data['photo'])
	        	$insertid = $this->update($idd,$update_data);
    	}

        if($query)
            return $idd;
        else return 0;
    }

	public function listAdmin($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		$i=0;
		$query1=$this->miscServicesDb;
		if($excel==0)
			$query1->select("count(d.id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*,d.id as did");
		}

		$query1->from($this->tableName." as d");

		$preData="Search Keywords: ";

		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			if($_POST['search_col'] == "fifth_generation")
				$search_col = "Fifth Generation Name";
			if($_POST['search_col'] == "email")
				$search_col = "Email";
			if($_POST['search_col'] == "phone")
				$search_col = "Phone";
			if($_POST['search_col'] == "city")
				$search_col = "City";

			$query1->like($_POST['search_col'],$this->miscServicesDb->escape_str(trim($_POST['search_text'])));
			$preData.=$search_col." containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->miscServicesDb->escape_str(trim($_POST['search_text'])),"after");
				$preData.= $search_col." starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->miscServicesDb->escape_str(trim($_POST['search_text'])),'before');
				$preData.= $search_col." ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->miscServicesDb->escape_str(trim($_POST['search_text'])));
				$preData.=$search_col." containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}
		
		$preData.="\nCountry: ";

		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$countryData=$this->locations_model->getCountryByIsd($_POST['country']);
			if(!empty($countryData))
			{
				$preData.=$countryData->country_code." ".$_POST['country'];
				$query1->where("country_isd_code",$_POST['country']);
			}
		}

		$preData.="\n Gender: ";
		if(isset($_POST['search_gender']) && $_POST['search_gender']!='')
		{
			$preData.=$_POST['search_gender'];
			$query1->where("gender",$_POST['search_gender']);
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']))
			{
				if(isset($_POST['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']))
					$query1->order_by('id',$_POST['dir']);
				else
					$query1->order_by('id',"asc");
			}
			$sql=$query1->get_compiled_select();
			$requestResp=$this->excel_exports_model->makeRequest('default',"model","Fifth_generation_devotees_model",$sql,$this->currentUser,"misc_services",$_POST,"All Devotees",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		//if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
		$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			$query1->order_by('id',$dir);
		}
		else
		{
			$query1->order_by('id',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		//echo $this->miscServicesDb->last_query();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			if($row['photo']!='')
				$rtn['data'][$c]['photo']=aws_s3_base_url."images/5thgeneration/".$row['photo'];
			else
				$rtn['data'][$c]['photo']=aws_s3_base_url."images/site_assets/global_site_images/no-image.png";
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function results(){
		$q = $this->miscServicesDb->select('*')->from($this->tableName)->order_by('id','desc')->get();
		if($q->num_rows() > 0){
			$r = $q->result_array();
			return array("results"=>$r,"total_records"=>$q->num_rows());
			return $r;
		} else {
			return false;
		}
	}


	public function listPublic($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		$i=0;
		$query1=$this->miscServicesDb;
		if($excel==0)
			$query1->select("count(d.id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*,d.id as did");
		}

		$query1->from($this->tableName." as d");

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			$query1->order_by('id',$dir);
		}
		else
		{
			$query1->order_by('id',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			if($row['photo']!='')
				$rtn['data'][$c]['photo']=aws_s3_base_url."images/5thgeneration/".$row['photo'];
			else
				$rtn['data'][$c]['photo']=aws_s3_base_url."images/site_assets/global_site_images/no-image.png";
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function get($id){
		$q = $this->miscServicesDb->select('*')->from($this->tableName)->where('id',$id)->get();
		if($q->num_rows() > 0){
			$r = $q->row();
			return $r;
			return $r;
		} else {
			return false;
		}
	}

	public function update($ID,$data){
		$this->miscServicesDb->where('id',$ID);
		$this->miscServicesDb->update($this->tableName,$data);
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->miscServicesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"1st Generation");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"2nd Generation");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"3rd Generation");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"4th Generation");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"5th Generation");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Gender");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$phoneno = "+".$reportrow->country_isd_code." ".$reportrow->phone;
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->first_generation);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->second_generation);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->third_generation);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->fourth_generation);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->fifth_generation);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$phoneno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function delete($id,$devoteeData)
	{
		$this->miscServicesDb->where("id",$id);
		$this->miscServicesDb->delete($this->tableName);

		if($devoteeData->photo!='')
		{
			$path=aws_s3_base_url."/images/5thgeneration/".$devoteeData->photo;
			if(file_exists($path))
				unlink($path);
		}

		return 1;
	}
}
?>