<?PHP
class failed_sms_model extends CI_Model 
{
	var $tableName="";
	var $smsDb = "";
	var $authSsoDB="";
	public function __construct()
	{
		parent::__construct();
		$this->smsDb = $this->load->database("sms",true,false);
		$this->authSsoDB=$this->load->database("sso_auth",true);
	}

	public function getSSOUserID($sms)
	{
		$this->db->select('sso_user_id,username');
		$this->db->where("phoneno",$sms);
		$q=$this->db->get("users")->row();
		if(!empty($q->sso_user_id) && $q->sso_user_id > 0)
			return array("sso_user_id"=>$q->sso_user_id,"username"=>$q->username);
		else
			return array("sso_user_id"=>"0","username"=>"");
	}

	public function checkExistFailedSMS($sms)
	{
		$this->db->select('fail_count,id,sso_user_id');
		$this->db->where("failed_sms",$sms);
		$q=$this->db->get("failed_sms");
		if($q->num_rows() > 0)
		{
			$r = $q->row();
			$b_count = $r->fail_count+1;
			return array("status"=>1,"fail_count"=>$b_count,"id"=>$r->id,"user_id"=>$r->sso_user_id);
		}
		else
		{
			return array("status"=>2,"fail_count"=>1);
		}
	}

	public function validateFailData($phoneno)
	{
		$this->db->select('fail_count,id,sso_user_id');
		$this->db->where("failed_sms",$phoneno);
		$this->db->where("fail_count>=",sms_fail_count_validation);
		$q=$this->db->get("failed_sms");
		if($q->num_rows() > 0)
		{
			$r = $q->row();
			return 1;
		}
		else
		{
			return 2;
		}
	}

	public function verifyBouncePhoneno($phoneno)
	{
		if($phoneno!='')
		{
			$this->db->where('failed_sms',$phoneno);
			$vr=$this->db->get("failed_sms");
			if($vr->num_rows())
				return 1;
			else return 0;
		}
		else
			return 0;
	}

	public function deleteFailedSMS($phoneno,$userId)
	{
		$this->db->where("failed_sms",$phoneno);
    	$this->db->delete("failed_sms");
	}

	public function saveFailedSMS($mobile_no)
	{
		$userId = $this->getSSOUserID($mobile_no);
		$userName = "";
		if($userId["sso_user_id"] > 0)
		{
			$userName = $userId["username"];
		}
		$checkRecord = $this->checkExistFailedSMS($mobile_no);

		if($checkRecord["status"] == 2)
		{
			$insertData = array(
					"failed_sms"=>$mobile_no,
					"fail_count"=>$checkRecord["fail_count"],
					"last_failed_on"=>date("Y-m-d H:i:s"),
					"sso_user_id"=>$userId["sso_user_id"],
					"user_name"=>$userName
						);
			$this->db->insert("failed_sms",$insertData);
		}
		else if($checkRecord["status"] == 1)
		{
			$updateData = array("fail_count"=>$checkRecord["fail_count"],"last_failed_on"=>date("Y-m-d H:i:s"));

			$this->db->where("failed_sms",$mobile_no);
			$this->db->update("failed_sms",$updateData);
		}
	}

	public function eventUpdate($tableName,$response)
	{
		if(!empty($tableName))
		{
			$dbObj->where("message_id",$queueID);
			$dbObj->update($tableName,$updateData);
		}
	}

	public function getFailedSMSList($excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(be.id) as c");
		step1:
		$i++;
		if($excel==1 || $i==2)
		{
			$query1->select("be.*,u.id as user_id");
		}

		$query1->from("failed_sms as be");

		$query1->join("users as u","u.sso_user_id = be.sso_user_id","left");

		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && isset($_POST['wild']) && trim($_POST['search_text'])!='')
		{
			$preData.=$_POST['search_col'];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
			$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('last_failed_on',$_POST['dir']);
				else
					$query1->order_by('last_failed_on',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","bounced_sms_model",$sql,$this->currentUser,"default",$_POST,"All Failed SMS",$preData);

			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('last_failed_on',$dir);
		}
		else
		{
			$query1->order_by('last_failed_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['last_failed_on'] = date("d M Y H:i:s",strtotime($row["last_failed_on"]));
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Failed SMS");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Fail Count");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last Failed on");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->user_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->failed_sms);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->fail_count);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y H:i:s",strtotime($reportrow->last_failed_on)));
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>