<?PHP
class Excel_exports_Model extends CI_Model 
{
	var $tableName="excel_reports";
	var $siteServicesDb='';
    function __construct()
    {
        parent::__construct();
        $this->siteServicesDb=$this->load->database("site_services",true,false);
    }
    public function makeRequest($serviceSlug,$type,$modelName,$sql,$userData,$dbGroup='default',$postData,$pageName,$preData,$pageNumber=1)
	{
		$hash=md5($sql);
		$data['flag']=0;
		$requestData=$this->getRequestByHash($hash);
		if(empty($requestData) || 1)
		{
			$this->siteServicesDb->insert($this->tableName,
						array(
								"user_id"=>!empty($userData->id)?$userData->id:0,
								"admin"=>!empty($userData->admin)?$userData->admin:"Guest",
								"service_slug"=>$serviceSlug,
								"type"=>$type,
								"model_name"=>$modelName,
								"query"=>$sql,
								"hash"=>$hash,
								"request_data"=>serialize($postData),
								"page_name"=>$pageName,
								"page_number"=>$pageNumber,
								'pre_data'=>$preData,
								"created_on"=>date("Y:m:d H:i:s"),
								//"db_name"=>$databaseName,
								"dbconnection_group"=>$dbGroup
							));
			$rId=$this->siteServicesDb->insert_id();
			$unique_id="RP-".date("Y")."-".date("m")."-".$rId;

			$this->siteServicesDb->where("id",$rId);
			$this->siteServicesDb->update($this->tableName,array("unique_id"=>$unique_id));
			
			$data['unique_id']=$unique_id;
			$data['report_id']=$rId;
			$reportFlag=$this->processReport($rId);
			$data['flag']=$reportFlag;
		}
		else
		{
			$data['flag']=2;
		}
		return $data;
	}

	public function makeAccessReportRequest($serviceSlug,$type,$modelName,$sql,$userData,$dbGroup='default',$postData,$pageName,$preData,$pageNumber=1)
	{
		$hash=md5($sql);
		$data['flag']=0;
		$requestData=$this->getRequestByHash($hash);
		if(empty($requestData) || 1)
		{
			$this->siteServicesDb->insert($this->tableName,
						array(
								"user_id"=>!empty($userData->id)?$userData->id:0,
								"admin"=>!empty($userData->admin)?$userData->admin:"Guest",
								"service_slug"=>$serviceSlug,
								"type"=>$type,
								"model_name"=>$modelName,
								"query"=>$sql,
								"hash"=>$hash,
								"request_data"=>serialize($postData),
								"page_name"=>$pageName,
								"page_number"=>$pageNumber,
								'pre_data'=>$preData,
								"created_on"=>date("Y:m:d H:i:s"),
								//"db_name"=>$databaseName,
								"dbconnection_group"=>$dbGroup
							));
			$rId=$this->siteServicesDb->insert_id();
			$unique_id="RP-".date("Y")."-".date("m")."-".$rId;

			$this->siteServicesDb->where("id",$rId);
			$this->siteServicesDb->update($this->tableName,array("unique_id"=>$unique_id));
			
			$data['unique_id']=$unique_id;
			$data['report_id']=$rId;
			$reportFlag=$this->processAccessReport($rId);
			$data['flag']=$reportFlag;
		}
		else
		{
			$data['flag']=2;
		}
		return $data;
	}

	public function getRequestById($id)
	{
		$this->siteServicesDb->where("id",$id);
		$q=$this->siteServicesDb->get($this->tableName);
		return $q->row();
	}
	public function getRequestByHash($hash)
	{
		$this->siteServicesDb->where("hash",$hash);
		$q=$this->siteServicesDb->get($this->tableName);
		return $q->row();
	}

	private function processReport($id)
	{
		$this->load->library("Excel");
		$CI =& get_instance();
		$this->siteServicesDb->where("id",$id);
		$this->siteServicesDb->where("status",0);
		$q=$this->siteServicesDb->get($this->tableName);
		$row=$q->row();

		$serviceDb=$this->load->database($row->dbconnection_group,true,false);

		$totalRows=0;
		$q=$serviceDb->query($row->query);
		$totalRows=$q->num_rows();

		$filename='';
		//$filenamezip='';
		$status=0;
		$note='';
		if($totalRows)
		{
			$postData=unserialize($row->request_data);

			$objPHPExcel = new PHPExcel();
			if($row->type=='categories')
			{
				$CI->load->model("category/categories_model");
				$objResp=$CI->categories_model->excelReport($row->service_slug,$objPHPExcel,$row->page_name);
			}
			else if($row->type=='emails')
			{
				$CI->load->model("emails_model");
				$objResp=$CI->emails_model->excelReport($row->service_slug,$objPHPExcel,$row->page_name);
			}
			else
			{
				$modelName=$row->model_name;
				$CI->load->model($modelName,"service_model");
				if($row->admin==1)
					$objResp=$CI->service_model->excelReport($row,$objPHPExcel);
				else
					$objResp=$CI->service_model->excelReportUser($row,$objPHPExcel);
			}
			
			$objWriter = new PHPExcel_Writer_Excel2007($objResp);
			$filename=strtolower(url_title($row->page_name))."_".$row->unique_id."_".date("Y_m_d_H_i_s").".xlsx";
			//$filenamezip=strtolower(url_title($row->page_name))."_".$row->unique_id."_".date("Y_m_d_H_i_s").".zip";
			$objWriter->save(excel_reports_path.$filename);
			//exec('zip -j "'.excel_reports_path.$filenamezip.'" "'.excel_reports_path.$filename.'"');
			$this->logaction->log('default',"Excel generated - ".$filename);
			//unlink(excel_reports_path.$filename);
			$status=1;
			$note="Success";
			$notificationMessage="Your excel report \"".$row->unique_id."\" is ready";
		}

		$this->siteServicesDb->where("id",$row->id);
		$this->siteServicesDb->update($this->tableName,
									array(
											"generated_on"=>date("Y:m:d H:i:s"),
											"expires_on"=>date("Y:m:d 00:00:00",strtotime("+".excel_reports_exire_period)),
											"status"=>$status,
											"notes"=>$note,
											"filename"=>$filename
										)
								);
		return $status;
		
		/*if($row->admin==0)
			$notificationLink="excelreports";
		else
			$notificationLink="myexcelreports";
		$this->notifications_model->addNotification($row->user_id,$notificationMessage,$notificationLink,"excel-reports");*/
	}

	private function processAccessReport($id)
	{
		$this->load->library("Excel");
		$CI =& get_instance();
		$this->siteServicesDb->where("id",$id);
		$this->siteServicesDb->where("status",0);
		$q=$this->siteServicesDb->get($this->tableName);
		$row=$q->row();

		$serviceDb=$this->load->database($row->dbconnection_group,true,false);

		$totalRows=0;
		$q=$serviceDb->query($row->query);
		$totalRows=$q->num_rows();

		$filename='';
		$status=0;
		$note='';
		if($totalRows)
		{
			$postData=unserialize($row->request_data);

			$objPHPExcel = new PHPExcel();
			$modelName=$row->model_name;
			$CI->load->model($modelName,"service_model");
			$objResp=$CI->service_model->excelReport($row,$objPHPExcel);
			
			$objWriter = new PHPExcel_Writer_Excel2007($objResp);
			$filename=strtolower(url_title($row->page_name))."_".$row->unique_id."_".date("Y_m_d_H_i_s").".xlsx";
			$objWriter->save(excel_reports_path.$filename);
			$this->logaction->log('default',"Excel generated - ".$filename);
			$status=1;
			$note="Success";
			$notificationMessage="Your excel report \"".$row->unique_id."\" is ready";
		}

		$this->siteServicesDb->where("id",$row->id);
		$this->siteServicesDb->update($this->tableName,
									array(
											"generated_on"=>date("Y:m:d H:i:s"),
											"expires_on"=>date("Y:m:d 00:00:00",strtotime("+".excel_reports_exire_period)),
											"status"=>$status,
											"notes"=>$note,
											"filename"=>$filename
										)
								);
		return $status;
	}

	public function processReports()
	{
		$CI =& get_instance();
		$this->siteServicesDb->where("status",0);
		$this->siteServicesDb->limit(10);
		$q=$this->siteServicesDb->get($this->tableName);
		if($q->num_rows())
		{			
			foreach ($q->result() as $row)
			{
				$serviceDb=$this->load->database($row->dbconnection_group,true,false);
				$totalRows=0;
				$q=$serviceDb->query($row->query);
				$totalRows=$q->num_rows();

				$filename='';
				//$filenamezip='';
				if($totalRows)
				{
					$postData=unserialize($row->request_data);

					$objPHPExcel = new PHPExcel();
					if($row->type=='categories')
					{
						$CI->load->model("category/categories_model");
						$objResp=$CI->categories_model->excelReport($row->service_slug,$objPHPExcel,$row->page_name);
					}
					else
					{
						$modelName=$row->model_name;
						$CI->load->model($modelName,"service_model");
						if($row->admin==1)
							$objResp=$CI->service_model->excelReport($row,$objPHPExcel);
						else
							$objResp=$CI->service_model->excelReportUser($row,$objPHPExcel);
					}
					
					$objWriter = new PHPExcel_Writer_Excel2007($objResp);
					$filename=$row->service_slug."_".strtolower(url_title($row->page_name))."_".$row->unique_id."_".date("Y_m_d_H_i_s").".xlsx";
					//$filenamezip=$row->service_slug."_".strtolower(url_title($row->page_name))."_".$row->unique_id."_".date("Y_m_d_H_i_s").".zip";
					$objWriter->save(excel_reports_path.$filename);
					//exec('zip -j "'.excel_reports_path.$filenamezip.'" "'.excel_reports_path.$filename.'"');
					$this->logaction->log($this->service,"Excel created at ".$filename);
					unlink(excel_reports_path.$filename);
					$status=1;
					$note="Success";
					$notificationMessage="Your excel report \"".$row->unique_id."\" is ready";
				}
				else
				{
					$status=2;
					$note="Empty data";
					$notificationMessage="Your excel report \"".$row->unique_id."\" failed - ".$note;
				}



				$this->logaction->log($this->service,"Report processed - ID: ".$row->unique_id." - Status: ".$status);

				$this->siteServicesDb->where("id",$row->id);
				$this->siteServicesDb->update($this->tableName,
											array(
													"generated_on"=>date("Y:m:d H:i:s"),
													"expires_on"=>date("Y:m:d 00:00:00",strtotime("+".excel_reports_exire_period)),
													"status"=>$status,
													"notes"=>$note,
													"filename"=>$filename
												)
										);

				
				if($row->admin==0)
					$notificationLink="excelreports";
				else
					$notificationLink="myexcelreports";
				$this->notifications_model->addNotification($row->user_id,$notificationMessage,$notificationLink,"excel-reports");

			}
		}
	}

	public function listDownloads()
	{
		$i=0;
		$query1=$this->db;
		$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$query1->where("user_id",$this->currentUser->id);
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns'])
		 && in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),"after");
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),'before');
			}
			else
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
			}
		}
		
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(created_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(created_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
		}
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1,2,3)))
		{
			$query1->where("status",$_POST['status']);
		}
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('created_on',$dir);
		}
		else
		{
			$query1->order_by('created_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if($this->currentUser->admin==0)
			$paginations=array(10,20);
		else
			$paginations=array(10,20,50,100);
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],$paginations))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($row['created_on']));
			if($row['generated_on']=='')
				$rtn['data'][$c]['generated_on']='NA';
			else
				$rtn['data'][$c]['generated_on']=date("d M Y h:i A",strtotime($row['generated_on']));
			if($row['expires_on']=='')
				$rtn['data'][$c]['expires_on']='NA';
			else
				$rtn['data'][$c]['expires_on']=date("d M Y h:i A",strtotime($row['expires_on']));
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		end:
		return $rtn;
	}
	public function delete($id,$reportData)
	{
		$this->db->where('id',$reportData->id);
		$this->db->delete($this->tableName);

		if($reportData->status==1)
		{
			unlink(excel_reports_path.$reportData->filename);
		}
		return 1;
	}

	public function expireReports()
	{
		$this->db->where("date(expires_on)",date("Y:m:d"));
		$this->db->where("status",1);
		$q=$this->db->get($this->tableName);
		foreach ($q->result() as $row)
		{
			$this->db->where('id',$row->id);
			$this->db->update($this->tableName,
								array(
										"status"=>3
									)
							);
			unlink(excel_reports_path.$row->filename);
			$this->logaction->log($this->service,"Report expired and deleted - ID: ".$row->unique_id);

			$notificationMessage="Your excel report \"".$row->unique_id."\" has expired";
			if($row->admin==0)
				$notificationLink="excelreports";
			else
				$notificationLink="myexcelreports";
			$this->notifications_model->addNotification($row->user_id,$notificationMessage,$notificationLink,"excel-reports");
		}
	}
}
?>