<?PHP
class Emails_sns_notifications_model extends CI_Model 
{
	var $tableName="";
	var $emailsDb = "";
	var $authSsoDB="";
	public function __construct()
	{
		parent::__construct();
		$this->emailsDb = $this->load->database("emails",true,false);
		$this->authSsoDB=$this->load->database("sso_auth",true);
	}
	
	public function saveNotifications($responseData)
	{
		$archivesDb = $this->load->database("email_debug_archives",true,false);
		$date_month = date("m");
		$date_year = date("Y");
		if(in_array($date_month, array("01","02","03","04","05","06")))
		{
			$email_note_table = "ses_sns_alerts_from_01_to_06_".$date_year;
		}
		if(in_array($date_month, array("07","08","09","10","11","12")))
		{
			$email_note_table = "ses_sns_alerts_from_04_to_06_".$date_year;
		}
		if ($archivesDb->table_exists($email_note_table) )
		{

		}
		else
		{
		  	// table does not exist
		  	$new_table = "CREATE TABLE IF NOT EXISTS `".$email_note_table."` (
			  			`id` int(11) NOT NULL AUTO_INCREMENT,
			  			`message_id` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			  			`sso_user_id` int(11) NOT NULL DEFAULT 0,
				  		`email_service` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
					  	`event_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
					  	`to_email` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
					  	`from_email` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
					  	`response_data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
					  	`created_on` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
				  		PRIMARY KEY (`id`)
						) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
			$archivesDb->query($new_table);
		}
		$mail_object = $responseData->mail;
		$queueID=$mail_object->messageId;
		$tableName="";
		if(!empty($responseData->mail->tags))
		{
			foreach ($responseData->mail->tags as $key => $value) 
			{
				if($key == "dp_email_service_table")
				{
					$tableName = $value[0];
				}
			}
		}

		if(!empty($responseData->eventType))
			$m_eventType = strtolower($responseData->eventType);
		else if(!empty($responseData->notificationType))
			$m_eventType = strtolower($responseData->notificationType);
		else
			$m_eventType = "";

		$insertQueueData = array(
								"message_id"=>$queueID,
								"email_service"=>$tableName,
								"event_type"=>$m_eventType,
								"from_email"=>$mail_object->source,
								"response_data"=>json_encode($responseData),
								"created_on"=>date("Y-m-d H:i:s",strtotime($mail_object->timestamp))
								);
		foreach ($mail_object->destination as $key => $value) 
		{
			$insertQueueData["to_email"] = $value;
			$userId = $this->getSSOUserID($value);
			$insertQueueData["sso_user_id"] = $userId["sso_user_id"];
			$archivesDb->insert($email_note_table,$insertQueueData);
		}
	}

	public function getSSOUserID($email)
	{
		$this->db->select('sso_user_id,username');
		$this->db->where("email",$email);
		$q=$this->db->get("users")->row();
		if(!empty($q->sso_user_id) && $q->sso_user_id > 0)
			return array("sso_user_id"=>$q->sso_user_id,"username"=>$q->username);
		else
			return array("sso_user_id"=>"0","username"=>"");
	}

	public function checkExistBounceMail($email)
	{
		$this->db->select('bounce_count,id,sso_user_id');
		$this->db->where("bounced_email",$email);
		$q=$this->db->get("bounced_emails");
		if($q->num_rows() > 0)
		{
			$r = $q->row();
			$b_count = $r->bounce_count+1;
			return array("status"=>1,"bounce_count"=>$r->bounce_count,"id"=>$r->id,"user_id"=>$r->sso_user_id);
		}
		else
		{
			return array("status"=>2,"bounce_count"=>1);
		}
	}

	public function validateBounceData($id)
	{
		$this->db->select('bounce_count,id,sso_user_id,bounced_email');
		$this->db->where("id",$id);
		$q=$this->db->get("bounced_emails");
		if($q->num_rows() > 0)
		{
			$r = $q->row();
			return array("status"=>1,"bounce_count"=>$r->bounce_count,"id"=>$r->id,"user_id"=>$r->sso_user_id,"bounced_email"=>$r->bounced_email);
		}
		else
		{
			return array("status"=>2,"bounce_count"=>0);
		}
	}

	public function verifyBounceEmail($email)
	{
		if($email!='')
		{
			$this->db->where('bounced_email',$email);
			$vr=$this->db->get("bounced_emails");
			if($vr->num_rows())
				return 1;
			else return 0;
		}
		else
			return 0;
	}

	public function deleteBounceEmail($email,$userId)
	{
		$this->db->where("bounced_email",$email);
    	$this->db->delete("bounced_emails");
		if($userId > 0)
		{
			$this->db->where("email",$email);
			$this->db->update("users",array("email_bounce_count"=>0));
			$this->authSsoDB->where("email",$email);
			$this->authSsoDB->update("users",array("email_bounce_count"=>0));
		}
	}

	public function saveBounceEmails($responseData)
	{
		$mail_object = $responseData->mail;
		$queueID=$mail_object->messageId;
		foreach ($mail_object->destination as $key => $value) 
		{
			$to_email = $value;
			$userId = $this->getSSOUserID($to_email);
			$userName = "";
			if($userId["sso_user_id"] > 0)
			{
				$userName = $userId["username"];
			}
			$checkRecord = $this->checkExistBounceMail($to_email);

			if($checkRecord["status"] == 2)
			{
				$b_count = 1;
				$insertData = array(
						"bounced_email"=>$to_email,
						"bounce_count"=>1,
						"last_bounced_on"=>date("Y-m-d H:i:s",strtotime($mail_object->timestamp)),
						"sso_user_id"=>$userId["sso_user_id"],
						"user_name"=>$userName
							);
				$this->db->insert("bounced_emails",$insertData);
			}
			else if($checkRecord["status"] == 1)
			{
				$b_count = $checkRecord["bounce_count"]+1;
				$updateData = array("bounce_count"=>$b_count,"last_bounced_on"=>date("Y-m-d H:i:s",strtotime($mail_object->timestamp)));

				$this->db->where("bounced_email",$to_email);
				$this->db->update("bounced_emails",$updateData);
			}

			if($userId > 0)
			{
				$this->db->where("email",$to_email);
				$this->db->update("users",array("email_bounce_count"=>$b_count));
				$this->authSsoDB->where("email",$to_email);
				$this->authSsoDB->update("users",array("email_bounce_count"=>$b_count));
			}
		}
	}

	public function eventUpdate($eventType,$response)
	{
		$tableName="";
		if(!empty($response->mail->tags))
		{
			foreach ($response->mail->tags as $key => $value) 
			{
				if($key == "dp_email_service_table")
				{
					$tableName = $value[0];
				}
			}
		}
		if(!empty($response) && !empty($eventType) && in_array($eventType,array("open","bounce","delivery","bounced","delivered","clicked","opened")) && !empty($tableName))
		{
			$mail_object = $response->mail;
			$queueID=$mail_object->messageId;
			if(!empty($queueID))
			{
				if(preg_match("/mail_track_/i",$tableName))
				{
					$dbObj=$this->emailsDb;
				}
				else
				{
					$dbObj=$this->db;
				}
				if(!$dbObj->table_exists($tableName))
				{
					return;
				}
				$dbObj->where("message_id",$queueID);
				$email_record=$dbObj->get($tableName)->row();

				if(!empty($email_record))
				{
					$updateData=array();
					if($eventType=='delivered' || $eventType=='delivery')
					{
						$updateData['delivered']=1;
					}
					if($eventType=='bounce' || $eventType=='bounced')
					{
						$updateData['bounced']=1;
					}
					if($eventType=='open' || $eventType=='opened' || $eventType=='clicked')
					{
						$updateData['viewed']=1;
						$updateData['delivered']=1;
						$updateData['reads']=($email_record->reads+1);
					}
					foreach ($updateData as $updateKey => $updateValue)
					{
						$dbObj->set($updateKey,$updateValue);
					}
					$dbObj->where("message_id",$queueID);
					$dbObj->update($tableName,$updateData);
				}
			}
		}
	}

	public function getBouncedEmailsList($excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(be.id) as c");
		step1:
		$i++;
		if($excel==1 || $i==2)
		{
			$query1->select("be.*,u.id as user_id");
		}

		$query1->from("bounced_emails as be");

		$query1->join("users as u","u.sso_user_id = be.sso_user_id","left");

		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && isset($_POST['wild']) && trim($_POST['search_text'])!='')
		{
			$preData.=$_POST['search_col'];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('last_bounced_on',$_POST['dir']);
				else
					$query1->order_by('last_bounced_on',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","emails_sns_notifications_model",$sql,$this->currentUser,"default",$_POST,"All Bounced Emails",$preData);

			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('last_bounced_on',$dir);
		}
		else
		{
			$query1->order_by('last_bounced_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['last_bounced_on'] = date("d M Y H:i:s",strtotime($row["last_bounced_on"]));
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bounced Email");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bounce Count");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last Bounced on");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->user_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounced_email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounce_count);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y H:i:s",strtotime($reportrow->last_bounced_on)));
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>