<?PHP
class Email_settings_Model extends CI_Model 
{
	var $tableName="email_settings";
	
	public function getSettingsByService($serviceSlug='')
	{
		$this->db->where("service_slug",$serviceSlug);
		return $this->db->get($this->tableName)->row();
	}
	public function getList($excel=0)
	{
		if(isset($_POST['ashram_id']) && is_numeric($_POST['ashram_id']) && $_POST['ashram_id']!=0 )
		{
			$ashramData=$this->ashrams_model->ashramData($this->input->post('ashram_id'));
		}

		$query1 = $this->db;
		$i=0;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$this->db->not_like("service_slug","satsang");
		$this->db->not_like("service_slug","newsletter_s_");
		$this->db->from($this->tableName);
		$preData="Ashram Name: N/A";
		if(isset($_POST['ashram_id']) && is_numeric($_POST['ashram_id']) && $_POST['ashram_id']!=0 )
		{
			$this->db->where("ashram_id",$this->input->post('ashram_id'));
			$preData="Ashram Name: ".$ashramData->name;
		}		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns'])
		 && in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			if($_POST['wild']=='starts')
			{
				$this->db->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),"after");
			}
			else if($_POST['wild']=='ends')
			{
				$this->db->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),'before');
			}
			else
			{
				$this->db->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('ashram_id',$_POST['dir']);
				else
					$query1->order_by('ashram_id',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","email_settings_model",$sql,$this->currentUser,"default",$_POST,"All Ashram Email Settings",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $this->db->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('service_slug',$dir);
		}
		else
		{
			$query1->order_by('service_slug',"asc");
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			$start=abs($_POST['start']);
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && 
			in_array($_POST['length'],$GLOBALS['current_acl']['per_page_options_admin']))
		{
			$length=abs($_POST['length']);
		}

		$this->db->limit($length,$start);

		$rtn['data']=$this->db->get()->result_array();
		//$rtn['q']=$this->db->last_query();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	public function getSatsangsList($excel=0)
	{
		if(isset($_POST['satsang_id']) && is_numeric($_POST['satsang_id']) && $_POST['satsang_id']!=0 )
		{
			$this->load->model('satsangs/satsangs_model');
			$satsangData=$this->satsangs_model->satsangData($this->input->post('satsang_id'));
		}

		$query1 = $this->db;
		$i=0;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$this->db->group_start();
		$this->db->like("service_slug","satsang");
		$this->db->or_like("service_slug","newsletter_s_");
		$this->db->group_end();
		$this->db->from($this->tableName);
		$preData="Satsang Name: N/A";
		if(isset($_POST['satsang_id']) && is_numeric($_POST['satsang_id']) && $_POST['satsang_id']!=0 )
		{
			$this->db->where("satsang_id",$this->input->post('satsang_id'));
			$preData="Satsang Name: ".$satsangData->name;
		}		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns'])
		 && in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			if($_POST['wild']=='starts')
			{
				$this->db->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),"after");
			}
			else if($_POST['wild']=='ends')
			{
				$this->db->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),'before');
			}
			else
			{
				$this->db->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('satsang_id',$_POST['dir']);
				else
					$query1->order_by('satsang_id',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","email_settings_model",$sql,$this->currentUser,"default",$_POST,"All Satsang Email Settings",$preData,2);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $this->db->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('service_slug',$dir);
		}
		else
		{
			$query1->order_by('service_slug',"asc");
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			$start=abs($_POST['start']);
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && 
			in_array($_POST['length'],$GLOBALS['current_acl']['per_page_options_admin']))
		{
			$length=abs($_POST['length']);
		}

		$this->db->limit($length,$start);

		$rtn['data']=$this->db->get()->result_array();
		//$rtn['q']=$this->db->last_query();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	public function updateSettings($id,$colName,$value)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array($colName=>$value));
	}
	public function update($vars)
	{
		if(isset($vars['value']) && isset($vars['pk']))
		{
			$this->db->where("id",$vars['pk']);
			$this->db->update($this->tableName,array(trim($_POST['name'])=>trim($_POST['value'])));
			return 1;
		}
		else return 0;
	}

	public function getSettingsByID($id="")
	{
		$this->db->where("id",$id);
		return $this->db->get($this->tableName)->row();
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->satsangEmailsExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Service (_ID)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SMTP Host");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SMTP UserName");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SMTP Password");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SMTP PORT");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"From Email");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"From Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Signature");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ashram_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ashram_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->service_slug);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->smtp_host);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->smtp_user);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->smtp_password);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->smtp_port);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->from_email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->from_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->signature)));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}


	public function satsangEmailsExcelReportAdmin($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Satsang ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Satsang Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Service (_ID)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SMTP Host");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SMTP UserName");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SMTP Password");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SMTP PORT");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"From Email");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"From Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Signature");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->satsang_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ashram_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->service_slug);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->smtp_host);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->smtp_user);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->smtp_password);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->smtp_port);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->from_email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->from_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->signature)));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}


	public function getAshramEmailSettingsByID($id="")
	{
		$this->db->where("id",$id);
		$this->db->group_start();
		$this->db->not_like("service_slug","satsang");
		$this->db->not_like("service_slug","newsletter_s_");
		$this->db->group_end();
		return $this->db->get($this->tableName)->row();
	}

	public function getSatsangEmailSettingsByID($id="")
	{
		$this->db->where("id",$id);
		$this->db->group_start();
		$this->db->like("service_slug","satsang");
		$this->db->or_like("service_slug","newsletter_s_");
		$this->db->group_end();
		return $this->db->get($this->tableName)->row();
	}

	/* for add / update Email Settings*/
	public function saveAshramEmailSettings($id)
	{
		if(!$id)
		{
			$ashramname = "";
			if(trim($_POST["email_setting_ashram_id"])>0)
			{
				$ashramDetails = $this->db->select('*')->from('ashrams')->where('id', trim($_POST["email_setting_ashram_id"]))->get()->row_array();
				if(isset($ashramDetails['name']) && $ashramDetails['name']!='')
				{
					$ashramname = $ashramDetails['name'];
				}
			}
			$save = $this->db->insert($this->tableName,
										array(
												'ashram_id' => trim($_POST["email_setting_ashram_id"]),
												'ashram_name' => $ashramname,
												'service_slug' => trim($_POST["email_setting_service_slug"]),
												'from_email' => trim($_POST["email_setting_from_email"]),
												'from_name' => trim($_POST["email_setting_from_name"]),
												'signature' => trim($_POST["email_setting_signature"]),
												'report_emails' => trim($_POST["email_setting_report_emails"]),
												'email_template' => 'email_template'
											)
										);
			$settingid = $this->db->insert_id();
			if($settingid)
				return $settingid;
			else
				return false;
		} else {
			$this->db->where('id', $id);
			$update=$this->db->update($this->tableName,
											array(
												'from_email' => trim($_POST["email_setting_from_email"]),
												'from_name' => trim($_POST["email_setting_from_name"]),
												'signature' => trim($_POST["email_setting_signature"]),
												'report_emails' => trim($_POST["email_setting_report_emails"])
											)
										);
			if($update)
				return $id;
			else
				return false;
		}
	}

	/* for add / update Satsang Email Settings*/
	public function saveSatsangEmailSettings($id)
	{
		if(!$id){
			$satsangname = "";
			if(trim($_POST["email_setting_satsang_id"])>0)
			{
				$satsangDetails = $this->db->select('*')->from('satsangs')->where('id', trim($_POST["email_setting_satsang_id"]))->get()->row_array();
				if(isset($satsangDetails['name']) && $satsangDetails['name']!='')
				{
					$satsangname = $satsangDetails['name'];
				}
			}
			$save = $this->db->insert($this->tableName,
										array(
												'satsang_id' => trim($_POST["email_setting_satsang_id"]),
												'ashram_name' => $satsangname,
												'service_slug' => trim($_POST["email_setting_service_slug"]),
												'from_email' => trim($_POST["email_setting_from_email"]),
												'from_name' => trim($_POST["email_setting_from_name"]),
												'signature' => trim($_POST["email_setting_signature"]),
												'report_emails' => trim($_POST["email_setting_report_emails"]),
												'email_template' => 'email_template'
											)
										);
			$settingid = $this->db->insert_id();
			if($settingid)
				return $settingid;
			else
				return false;
		} else {
			$this->db->where('id', $id);
			$update=$this->db->update($this->tableName,
											array(
												'from_email' => trim($_POST["email_setting_from_email"]),
												'from_name' => trim($_POST["email_setting_from_name"]),
												'signature' => trim($_POST["email_setting_signature"]),
												'report_emails' => trim($_POST["email_setting_report_emails"])
											)
										);
			if($update)
				return $id;
			else
				return false;
		}
	}
}
?>