<?PHP
class Email_extension_Model extends CI_Model 
{
	var $emailDb='';
	public function __construct()
	{
		parent::__construct();
		$this->emailDb=$this->load->database("emails",true,false);
		$this->load->library("SES",null,"ses");
	}

	public function validateBounceEmail($email)
	{
		$this->db->select('bounce_count,id,sso_user_id');
		$this->db->where("bounced_email",$email);
		$this->db->where("bounce_count>=",bounce_count_validation);
		$q=$this->db->get("bounced_emails");
		if($q->num_rows() > 0)
		{
			$r = $q->row();
			return 1;
		}
		else
		{
			return 2;
		}
	}
	public function getSettingsByService($serviceSlug='')
	{
		$this->db->where("service_slug",$serviceSlug);
		return $this->db->get('email_settings')->row();
	}
	public function mailTrack($serviceSlug,$userData,$mail_to,$mail_subject,$mail_content,$sent_by=0,$status,
		$resent=0,$resent_id=0,$priority=0,$guest=0,$cc='',$giftOrSeva='')
	{
		if($GLOBALS['site_settings']['email_service']==0)
    	{
    		return true;
    	}
		if($guest==1)
		{
			$userid=0;
			$username='';
		}
		else
		{
			$userid=$userData->id;
			$username=$userData->username;
		}
		$data=array('mail_to' => $mail_to,
							'mail_subject' =>$mail_subject,
							'mail_content' =>$mail_content,
							'date' =>date("Y:m:d H:i:s"),
							'sent_by'=>$sent_by,
							'status'=>$status,
							'resent'=>$resent,
							'resent_id'=>$resent_id,
							'user_id'=>$userid,
							'username'=>$username,
							'priority'=>$priority
							);
		$this->emailDb->insert('mail_track_'.$serviceSlug,$data);
		$queueID=$this->emailDb->insert_id();
		if($priority==1)
		{
			$this->sendMail($serviceSlug,$queueID,$mail_to,$mail_subject,$mail_content,$userData,$cc,$giftOrSeva);
		}
		$user_row = $this->db->select("id,username")->from("users")->where("email",$mail_to)->get();
        $user_result = $user_row->row();
        if($user_result)
        {
            $this->emailDb->where("mail_to",$mail_to);
            $this->emailDb->update('mail_track_'.$serviceSlug,array("user_id"=>$user_result->id,"username"=>$user_result->username));
        }
		return $queueID;
	}
	public function processQueue($serviceSlug)
	{
		$this->emailDb->where("status",0);
		$this->emailDb->where("bounced",0);
		$this->emailDb->order_by("date",'asc');
		$this->emailDb->limit("400");
		$mails=$this->emailDb->get('mail_track_'.$serviceSlug)->result();
		foreach($mails as $mail)
		{
			$this->sendMail($serviceSlug,$mail->id,$mail->mail_to,$mail->mail_subject,$mail->mail_content);
		}
	}
	private function sendMail($serviceSlug,$queueID,$to,$subject,$content,$userData=array(),$cc='',$giftOrSeva='')
	{
		$settings=$this->getSettingsByService($serviceSlug);

		$this->load->library('parser');

		if($this->session->userdata('user_id'))
        	$currentUser=$this->session->userdata("user_data");
       	else if($this->session->userdata('id'))
       	{
       		$currentUser=$this->session->userdata("admin_data");
       	}
       	else
       	{
       		$currentUser=array();
       	}
       	$parse_data=array();
       	if(!empty($currentUser))
       	{
			$parse_data['current_user_firstname']=$currentUser->firstname;
			$parse_data['current_user_lastname']=$currentUser->lastname;
			$parse_data['current_user_email']=$currentUser->email;
		}
		$settings->from_name=$this->parser->parse_string($settings->from_name, $parse_data,true);

		if($serviceSlug=='greetings' && !empty($userData))
		{
			$sender = '"'.$userData->firstname." ".$userData->lastname.'"<'.$settings->from_email.email_domain.'>';
			//$this->email->from("payments@dev.dattapeetham.org");
		}
		else
		{
			$sender = '"'.$settings->from_name.'"<'.$settings->from_email.email_domain.'>';
			//$this->email->from("payments@dev.dattapeetham.org");
		}
		$ses_bcc = "";
		if($cc!='')
		{
			$ses_bcc = $cc;
		}
		$debug='';
		$messageID='';
		$sent=0;

		$sesResult = $this->ses->SendSESMail($queueID,$sender,$to,$subject,$content,$ses_bcc,$serviceSlug);
		if($sesResult["sent_flag"] == 1111)
		{
			$this->emailDb->where("id",$queueID);
			$this->emailDb->update("mail_track_".$serviceSlug,
								array(
								"status"=>0,
								"sent_on"=>date("Y:m:d H:i:s"),
								"bounced"=>1
								));
			return true;
		}
		$sent = $sesResult["sent_flag"];
		$messageID = $sesResult["messageID"];
		$debug = $sesResult["debug_data"];

		$debug_success = $this->debugData($debug,$queueID,$serviceSlug);
		
		if($debug_success)
			$debug = "";
		else
			$debug = $debug;
		
		$this->emailDb->where("id",$queueID);
		$this->emailDb->update("mail_track_".$serviceSlug,
				array(
				"status"=>$sent,
				"sent_on"=>date("Y:m:d H:i:s"),
				'debug'=>$debug,
				'message_id'=>$messageID
				));
	}

	private function debugData($debug,$queueID,$serviceSlug)
	{
		if(!$debug || !$queueID || !$serviceSlug)
		{
			return false;
		}
		try
		{
			$archivesDb = $this->load->database("email_debug_archives",true,false);

			if(in_array(date('m'), array("01","02","03","04","05","06")))
			{
				$arch_table = "mail_track_".$serviceSlug."_from_01_to_06_".date('Y');
			}
			if(in_array(date('m'), array("07","08","09","10","11","12")))
			{
				$arch_table = "mail_track_".$serviceSlug."_from_07_to_12_".date('Y');
			}
			if ($archivesDb->table_exists($arch_table) )
			{
			  	//table exists some code run query
			  	$data=array('queue_id' => $queueID,
							'created_on' =>date("Y:m:d H:i:s"),
							'debug'=>$debug
						);
				$archivesDb->insert($arch_table,$data);
				$archiveID=$archivesDb->insert_id();
				if($archiveID)
					return true;
			}
			else
			{
			  	// table does not exist 
			  	// CREATE TABLE $this->emailDb.new_table LIKE old_database.old_table
			  	$new_table = "CREATE TABLE IF NOT EXISTS `".$arch_table."` (
				  	`id` bigint(20) NOT NULL AUTO_INCREMENT,
				  	`queue_id` bigint(20) NOT NULL,
				  	`created_on` datetime DEFAULT NULL,
				  	`debug` LONGTEXT DEFAULT NULL,
				  	PRIMARY KEY (`id`)
				) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;";

				$archivesDb->query($new_table);

				$data=array('queue_id' => $queueID,
							'created_on' =>date("Y:m:d H:i:s"),
							'debug'=>$debug
						);
				$archivesDb->insert($arch_table,$data);
				$archiveID=$archivesDb->insert_id();
				if($archiveID)
					return true;
			}
		}
		catch(Exception $e)
		{
			return false;
		}
	}

	public function newslettersdebugData($debug,$queueID,$serviceSlug)
	{
		if(!$debug || !$queueID || !$serviceSlug)
		{
			return false;
		}
		try
		{
			$archivesDb = $this->load->database("email_debug_archives",true,false);

			if(in_array(date('m'), array("01","02","03","04","05","06")))
			{
				$arch_table = $serviceSlug."_from_01_to_06_".date('Y');
			}
			if(in_array(date('m'), array("07","08","09","10","11","12")))
			{
				$arch_table = $serviceSlug."_from_07_to_12_".date('Y');
			}
			if ($archivesDb->table_exists($arch_table) )
			{
			  	//table exists some code run query
			  	$data=array('queue_id' => $queueID,
							'created_on' =>date("Y:m:d H:i:s"),
							'debug'=>$debug
						);
				$archivesDb->insert($arch_table,$data);
				$archiveID=$archivesDb->insert_id();
				if($archiveID)
					return true;
			}
			else
			{
			  	// table does not exist 
			  	// CREATE TABLE $this->emailDb.new_table LIKE old_database.old_table
			  	$new_table = "CREATE TABLE IF NOT EXISTS `".$arch_table."` (
				  	`id` bigint(20) NOT NULL AUTO_INCREMENT,
				  	`queue_id` bigint(20) NOT NULL,
				  	`created_on` datetime DEFAULT NULL,
				  	`debug` LONGTEXT DEFAULT NULL,
				  	PRIMARY KEY (`id`)
				) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;";

				$archivesDb->query($new_table);

				$data=array('queue_id' => $queueID,
							'created_on' =>date("Y:m:d H:i:s"),
							'debug'=>$debug
						);
				$archivesDb->insert($arch_table,$data);
				$archiveID=$archivesDb->insert_id();
				if($archiveID)
					return true;
			}
		}
		catch(Exception $e)
		{
			return false;
		}
	}

	public function getEmailByID($serviceSlug,$id)
	{
		try
		{
			$db_debug = $this->emailDb->db_debug;
			$this->emailDb->db_debug = false;
			$this->emailDb->where("id",$id);
			$r=$this->emailDb->get("mail_track_".$serviceSlug);
			$this->emailDb->db_debug = $db_debug;
			if($r)
			{
				return $r->row();
			}
		}
		catch(Exception $e)
		{
			return array();
		}
	}
	public function trackEmail($serviceSlug,$emailID,$reads)
	{
		$this->emailDb->where("id",$emailID);
		$this->emailDb->update("mail_track_".$serviceSlug,array('reads'=>$reads,'viewed'=>1));
	}
}
?>