<?PHP
class Currencies_Model extends CI_Model
{
	var $tableName='currencies';
    function __construct()
    {
        parent::__construct();
    }
    public function getByAshram($ashramId=0,$currency='')
    {
        if($currency!='')
        {
            $this->db->where("currency",$currency);
        }
        $this->db->order_by("order","asc");
    	$this->db->where("ashram_id",$ashramId);
        if($currency!='')
        {
            $res=$this->db->get($this->tableName)->result_array();
            if(!empty($res))
            return $res[0];
            else
                return array();
        }
        else
        {
    	   $clist=$this->db->get($this->tableName)->result_array();
           $currencies=array();
           foreach ($clist as $crow)
           {
                $currencies[$crow['currency']]=$crow;
           }
           return $currencies;
        }
    }
    public function add($ashramId,$currency)
    {
    	$this->db->insert($this->tableName,
    						array(
    								"ashram_id"=>$ashramId,
    								"currency"=>$GLOBALS['currencies']
    							)
    						);
    }
    public function addByAshram($ashramId)
    {
    	$this->db->where("ashram_id",0);
    	$init_currencies=$this->db->get($this->tableName)->result_array();
    	foreach ($init_currencies as $currency)
    	{
    		$this->db->insert($this->tableName,
    							array(
                                        "ashram_id"=>$ashramId,
    									"currency"=>$currency['currency'],
    									"symbol"=>$currency['symbol'],
    									"color"=>$currency['color'],
    									"min"=>$currency['min'],
    									"max"=>$currency['max'],
                                        "order"=>$currency['order']
    								)
    						);
    	}
    }

    public function update($currency,$ashramId,$action)
    {
        $global_currency=$this->getByAshram(0,$currency);
        $ashram_currency=$this->getByAshram($ashramId,$currency);
        if($action==1)
        {
            if(empty($ashram_currency))
            {
                $this->db->insert($this->tableName,
                                array(
                                        "ashram_id"=>$ashramId,
                                        "currency"=>$global_currency['currency'],
                                        "symbol"=>$global_currency['symbol'],
                                        "color"=>$global_currency['color'],
                                        "min"=>$global_currency['min'],
                                        "max"=>$global_currency['max'],
                                        "order"=>$global_currency['order']
                                    )
                            );
                return 1;
            }
            else
                return 0;
        }
        else
        {
            if(!empty($ashram_currency))
            {
                $this->db->where("currency",$currency);
                $this->db->where("ashram_id",$ashramId);
                $this->db->delete($this->tableName);
                return 1;
            }
            else
                 return 0;
        }
    }

    public function getList()
    {
        $i=0;
        $this->db->select("count(id) as c");
        step1:
        $i++;
        if($i==2)
        {
            $this->db->select("*");
        }
        $this->db->where("ashram_id",0);
        $this->db->from($this->tableName);
                
        if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
        in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns'])
         && in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
        {
            if($_POST['wild']=='starts')
            {
                $this->db->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),"after");
            }
            else if($_POST['wild']=='ends')
            {
                $this->db->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),'before');
            }
            else
            {
                $this->db->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
            }
        }

        if($i==1)
        {
            $temp_result = $this->db->get()->row();
            $rtn['recordsTotal'] = $temp_result->c;
            $rtn['recordsFiltered'] = $temp_result->c;
            goto step1;
        }

        $this->db->order_by('id',"asc");
        

        $start=0;
        $length=10;
        if(isset($_POST['start']) && is_numeric($_POST['start']))
        {
            $start=abs($_POST['start']);
        }
        if(isset($_POST['length']) && is_numeric($_POST['length']) && 
            in_array($_POST['length'],$GLOBALS['current_acl']['per_page_options_admin']))
        {
            $length=abs($_POST['length']);
        }

        $this->db->limit($length,$start);

        $rtn['data']=$this->db->get()->result_array();
        $temp=array();
        $sno=$start+1;
        $c=0;
        foreach ($rtn['data'] as $row) 
        {
            $rtn['data'][$c]=$row;
            $rtn['data'][$c]['sno']=$sno;
            $sno++;
            $c++;
        }
        $rtn['page_records']=$c;
        return $rtn;
    }
    public function updateSettings($id,$colName,$value)
    {
        $this->db->where("id",$id);
        $this->db->update($this->tableName,array($colName=>$value));
    }
}
?>